package io.fabric8.openshift.api.model.tuned.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ProfileSpecBuilder extends ProfileSpecFluent<ProfileSpecBuilder> implements VisitableBuilder<ProfileSpec,ProfileSpecBuilder>{
  public ProfileSpecBuilder() {
    this(new ProfileSpec());
  }
  
  public ProfileSpecBuilder(ProfileSpecFluent<?> fluent) {
    this(fluent, new ProfileSpec());
  }
  
  public ProfileSpecBuilder(ProfileSpecFluent<?> fluent,ProfileSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ProfileSpecBuilder(ProfileSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ProfileSpecFluent<?> fluent;
  
  public ProfileSpec build() {
    ProfileSpec buildable = new ProfileSpec(fluent.buildConfig());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}