package io.fabric8.openshift.api.model.tuned.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ProfileListBuilder extends ProfileListFluentImpl<ProfileListBuilder> implements VisitableBuilder<ProfileList,ProfileListBuilder>{
  public ProfileListBuilder() {
    this(false);
  }
  public ProfileListBuilder(Boolean validationEnabled) {
    this(new ProfileList(), validationEnabled);
  }
  public ProfileListBuilder(ProfileListFluent<?> fluent) {
    this(fluent, false);
  }
  public ProfileListBuilder(ProfileListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ProfileList(), validationEnabled);
  }
  public ProfileListBuilder(ProfileListFluent<?> fluent,ProfileList instance) {
    this(fluent, instance, false);
  }
  public ProfileListBuilder(ProfileListFluent<?> fluent,ProfileList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ProfileListBuilder(ProfileList instance) {
    this(instance,false);
  }
  public ProfileListBuilder(ProfileList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ProfileListFluent<?> fluent;
  Boolean validationEnabled;
  public ProfileList build() {
    ProfileList buildable = new ProfileList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}