package io.fabric8.openshift.api.model.tuned.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ProfileStatusBuilder extends ProfileStatusFluentImpl<ProfileStatusBuilder> implements VisitableBuilder<ProfileStatus,ProfileStatusBuilder>{
  public ProfileStatusBuilder() {
    this(false);
  }
  public ProfileStatusBuilder(Boolean validationEnabled) {
    this(new ProfileStatus(), validationEnabled);
  }
  public ProfileStatusBuilder(ProfileStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ProfileStatusBuilder(ProfileStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ProfileStatus(), validationEnabled);
  }
  public ProfileStatusBuilder(ProfileStatusFluent<?> fluent,ProfileStatus instance) {
    this(fluent, instance, false);
  }
  public ProfileStatusBuilder(ProfileStatusFluent<?> fluent,ProfileStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withBootcmdline(instance.getBootcmdline()); 
    fluent.withConditions(instance.getConditions()); 
    fluent.withStalld(instance.getStalld()); 
    fluent.withTunedProfile(instance.getTunedProfile()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ProfileStatusBuilder(ProfileStatus instance) {
    this(instance,false);
  }
  public ProfileStatusBuilder(ProfileStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withBootcmdline(instance.getBootcmdline()); 
    this.withConditions(instance.getConditions()); 
    this.withStalld(instance.getStalld()); 
    this.withTunedProfile(instance.getTunedProfile()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ProfileStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ProfileStatus build() {
    ProfileStatus buildable = new ProfileStatus(fluent.getBootcmdline(),fluent.getConditions(),fluent.getStalld(),fluent.getTunedProfile());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}