package io.fabric8.openshift.api.model.tuned.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ProfileStatusConditionBuilder extends ProfileStatusConditionFluentImpl<ProfileStatusConditionBuilder> implements VisitableBuilder<ProfileStatusCondition,ProfileStatusConditionBuilder>{
  public ProfileStatusConditionBuilder() {
    this(false);
  }
  public ProfileStatusConditionBuilder(Boolean validationEnabled) {
    this(new ProfileStatusCondition(), validationEnabled);
  }
  public ProfileStatusConditionBuilder(ProfileStatusConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public ProfileStatusConditionBuilder(ProfileStatusConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ProfileStatusCondition(), validationEnabled);
  }
  public ProfileStatusConditionBuilder(ProfileStatusConditionFluent<?> fluent,ProfileStatusCondition instance) {
    this(fluent, instance, false);
  }
  public ProfileStatusConditionBuilder(ProfileStatusConditionFluent<?> fluent,ProfileStatusCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLastTransitionTime(instance.getLastTransitionTime()); 
    fluent.withMessage(instance.getMessage()); 
    fluent.withReason(instance.getReason()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ProfileStatusConditionBuilder(ProfileStatusCondition instance) {
    this(instance,false);
  }
  public ProfileStatusConditionBuilder(ProfileStatusCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withLastTransitionTime(instance.getLastTransitionTime()); 
    this.withMessage(instance.getMessage()); 
    this.withReason(instance.getReason()); 
    this.withStatus(instance.getStatus()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ProfileStatusConditionFluent<?> fluent;
  Boolean validationEnabled;
  public ProfileStatusCondition build() {
    ProfileStatusCondition buildable = new ProfileStatusCondition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}