package io.fabric8.openshift.api.model.tuned.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ProfileStatusFluentImpl<A extends ProfileStatusFluent<A>> extends BaseFluent<A> implements ProfileStatusFluent<A>{
  public ProfileStatusFluentImpl() {
  }
  public ProfileStatusFluentImpl(ProfileStatus instance) {
    this.withBootcmdline(instance.getBootcmdline()); 
    this.withConditions(instance.getConditions()); 
    this.withStalld(instance.getStalld()); 
    this.withTunedProfile(instance.getTunedProfile()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String bootcmdline;
  private ArrayList<ProfileStatusConditionBuilder> conditions = new ArrayList<ProfileStatusConditionBuilder>();
  private Boolean stalld;
  private String tunedProfile;
  private Map<String,Object> additionalProperties;
  public String getBootcmdline() {
    return this.bootcmdline;
  }
  public A withBootcmdline(String bootcmdline) {
    this.bootcmdline=bootcmdline; return (A) this;
  }
  public Boolean hasBootcmdline() {
    return this.bootcmdline != null;
  }
  public A addToConditions(Integer index,ProfileStatusCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ProfileStatusConditionBuilder>();}
    ProfileStatusConditionBuilder builder = new ProfileStatusConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(Integer index,ProfileStatusCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ProfileStatusConditionBuilder>();}
    ProfileStatusConditionBuilder builder = new ProfileStatusConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.openshift.api.model.tuned.v1.ProfileStatusCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ProfileStatusConditionBuilder>();}
    for (ProfileStatusCondition item : items) {ProfileStatusConditionBuilder builder = new ProfileStatusConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<ProfileStatusCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ProfileStatusConditionBuilder>();}
    for (ProfileStatusCondition item : items) {ProfileStatusConditionBuilder builder = new ProfileStatusConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.openshift.api.model.tuned.v1.ProfileStatusCondition... items) {
    for (ProfileStatusCondition item : items) {ProfileStatusConditionBuilder builder = new ProfileStatusConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<ProfileStatusCondition> items) {
    for (ProfileStatusCondition item : items) {ProfileStatusConditionBuilder builder = new ProfileStatusConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<ProfileStatusConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<ProfileStatusConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      ProfileStatusConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ProfileStatusCondition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public List<ProfileStatusCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public ProfileStatusCondition buildCondition(Integer index) {
    return this.conditions.get(index).build();
  }
  public ProfileStatusCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public ProfileStatusCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public ProfileStatusCondition buildMatchingCondition(Predicate<ProfileStatusConditionBuilder> predicate) {
    for (ProfileStatusConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<ProfileStatusConditionBuilder> predicate) {
    for (ProfileStatusConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<ProfileStatusCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new ArrayList(); for (ProfileStatusCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.openshift.api.model.tuned.v1.ProfileStatusCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (ProfileStatusCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)addToConditions(new ProfileStatusCondition(lastTransitionTime, message, reason, status, type));
  }
  public ProfileStatusFluent.ConditionsNested<A> addNewCondition() {
    return new ProfileStatusFluentImpl.ConditionsNestedImpl();
  }
  public ProfileStatusFluent.ConditionsNested<A> addNewConditionLike(ProfileStatusCondition item) {
    return new ProfileStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public ProfileStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index,ProfileStatusCondition item) {
    return new ProfileStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public ProfileStatusFluent.ConditionsNested<A> editCondition(Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public ProfileStatusFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public ProfileStatusFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public ProfileStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ProfileStatusConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public Boolean getStalld() {
    return this.stalld;
  }
  public A withStalld(Boolean stalld) {
    this.stalld=stalld; return (A) this;
  }
  public Boolean hasStalld() {
    return this.stalld != null;
  }
  public String getTunedProfile() {
    return this.tunedProfile;
  }
  public A withTunedProfile(String tunedProfile) {
    this.tunedProfile=tunedProfile; return (A) this;
  }
  public Boolean hasTunedProfile() {
    return this.tunedProfile != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProfileStatusFluentImpl that = (ProfileStatusFluentImpl) o;
    if (bootcmdline != null ? !bootcmdline.equals(that.bootcmdline) :that.bootcmdline != null) return false;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (stalld != null ? !stalld.equals(that.stalld) :that.stalld != null) return false;
    if (tunedProfile != null ? !tunedProfile.equals(that.tunedProfile) :that.tunedProfile != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(bootcmdline,  conditions,  stalld,  tunedProfile,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (bootcmdline != null) { sb.append("bootcmdline:"); sb.append(bootcmdline + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (stalld != null) { sb.append("stalld:"); sb.append(stalld + ","); }
    if (tunedProfile != null) { sb.append("tunedProfile:"); sb.append(tunedProfile + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withStalld() {
    return withStalld(true);
  }
  class ConditionsNestedImpl<N> extends ProfileStatusConditionFluentImpl<ProfileStatusFluent.ConditionsNested<N>> implements ProfileStatusFluent.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(Integer index,ProfileStatusCondition item) {
      this.index = index;
      this.builder = new ProfileStatusConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new ProfileStatusConditionBuilder(this);
    }
    ProfileStatusConditionBuilder builder;
    Integer index;
    public N and() {
      return (N) ProfileStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  
}