package io.fabric8.openshift.api.model.tuned.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TunedBuilder extends TunedFluentImpl<TunedBuilder> implements VisitableBuilder<Tuned,TunedBuilder>{
  public TunedBuilder() {
    this(false);
  }
  public TunedBuilder(Boolean validationEnabled) {
    this(new Tuned(), validationEnabled);
  }
  public TunedBuilder(TunedFluent<?> fluent) {
    this(fluent, false);
  }
  public TunedBuilder(TunedFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Tuned(), validationEnabled);
  }
  public TunedBuilder(TunedFluent<?> fluent,Tuned instance) {
    this(fluent, instance, false);
  }
  public TunedBuilder(TunedFluent<?> fluent,Tuned instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public TunedBuilder(Tuned instance) {
    this(instance,false);
  }
  public TunedBuilder(Tuned instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  TunedFluent<?> fluent;
  Boolean validationEnabled;
  public Tuned build() {
    Tuned buildable = new Tuned(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}