package io.fabric8.openshift.api.model.tuned.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TunedMatchBuilder extends TunedMatchFluentImpl<TunedMatchBuilder> implements VisitableBuilder<TunedMatch,TunedMatchBuilder>{
  public TunedMatchBuilder() {
    this(false);
  }
  public TunedMatchBuilder(Boolean validationEnabled) {
    this(new TunedMatch(), validationEnabled);
  }
  public TunedMatchBuilder(TunedMatchFluent<?> fluent) {
    this(fluent, false);
  }
  public TunedMatchBuilder(TunedMatchFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TunedMatch(), validationEnabled);
  }
  public TunedMatchBuilder(TunedMatchFluent<?> fluent,TunedMatch instance) {
    this(fluent, instance, false);
  }
  public TunedMatchBuilder(TunedMatchFluent<?> fluent,TunedMatch instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLabel(instance.getLabel()); 
    fluent.withMatch(instance.getMatch()); 
    fluent.withType(instance.getType()); 
    fluent.withValue(instance.getValue()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public TunedMatchBuilder(TunedMatch instance) {
    this(instance,false);
  }
  public TunedMatchBuilder(TunedMatch instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withLabel(instance.getLabel()); 
    this.withMatch(instance.getMatch()); 
    this.withType(instance.getType()); 
    this.withValue(instance.getValue()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  TunedMatchFluent<?> fluent;
  Boolean validationEnabled;
  public TunedMatch build() {
    TunedMatch buildable = new TunedMatch(fluent.getLabel(),fluent.getMatch(),fluent.getType(),fluent.getValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}