package io.fabric8.openshift.api.model.tuned.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TunedProfileBuilder extends TunedProfileFluentImpl<TunedProfileBuilder> implements VisitableBuilder<TunedProfile,TunedProfileBuilder>{
  public TunedProfileBuilder() {
    this(false);
  }
  public TunedProfileBuilder(Boolean validationEnabled) {
    this(new TunedProfile(), validationEnabled);
  }
  public TunedProfileBuilder(TunedProfileFluent<?> fluent) {
    this(fluent, false);
  }
  public TunedProfileBuilder(TunedProfileFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TunedProfile(), validationEnabled);
  }
  public TunedProfileBuilder(TunedProfileFluent<?> fluent,TunedProfile instance) {
    this(fluent, instance, false);
  }
  public TunedProfileBuilder(TunedProfileFluent<?> fluent,TunedProfile instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withData(instance.getData()); 
    fluent.withName(instance.getName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public TunedProfileBuilder(TunedProfile instance) {
    this(instance,false);
  }
  public TunedProfileBuilder(TunedProfile instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withData(instance.getData()); 
    this.withName(instance.getName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  TunedProfileFluent<?> fluent;
  Boolean validationEnabled;
  public TunedProfile build() {
    TunedProfile buildable = new TunedProfile(fluent.getData(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}