package io.fabric8.openshift.api.model.tuned.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TunedRecommendBuilder extends TunedRecommendFluentImpl<TunedRecommendBuilder> implements VisitableBuilder<TunedRecommend,TunedRecommendBuilder>{
  public TunedRecommendBuilder() {
    this(false);
  }
  public TunedRecommendBuilder(Boolean validationEnabled) {
    this(new TunedRecommend(), validationEnabled);
  }
  public TunedRecommendBuilder(TunedRecommendFluent<?> fluent) {
    this(fluent, false);
  }
  public TunedRecommendBuilder(TunedRecommendFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TunedRecommend(), validationEnabled);
  }
  public TunedRecommendBuilder(TunedRecommendFluent<?> fluent,TunedRecommend instance) {
    this(fluent, instance, false);
  }
  public TunedRecommendBuilder(TunedRecommendFluent<?> fluent,TunedRecommend instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMachineConfigLabels(instance.getMachineConfigLabels()); 
    fluent.withMatch(instance.getMatch()); 
    fluent.withOperand(instance.getOperand()); 
    fluent.withPriority(instance.getPriority()); 
    fluent.withProfile(instance.getProfile()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public TunedRecommendBuilder(TunedRecommend instance) {
    this(instance,false);
  }
  public TunedRecommendBuilder(TunedRecommend instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withMachineConfigLabels(instance.getMachineConfigLabels()); 
    this.withMatch(instance.getMatch()); 
    this.withOperand(instance.getOperand()); 
    this.withPriority(instance.getPriority()); 
    this.withProfile(instance.getProfile()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  TunedRecommendFluent<?> fluent;
  Boolean validationEnabled;
  public TunedRecommend build() {
    TunedRecommend buildable = new TunedRecommend(fluent.getMachineConfigLabels(),fluent.getMatch(),fluent.getOperand(),fluent.getPriority(),fluent.getProfile());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}