package io.fabric8.openshift.api.model.tuned.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TunedSpecBuilder extends TunedSpecFluentImpl<TunedSpecBuilder> implements VisitableBuilder<TunedSpec,TunedSpecBuilder>{
  public TunedSpecBuilder() {
    this(false);
  }
  public TunedSpecBuilder(Boolean validationEnabled) {
    this(new TunedSpec(), validationEnabled);
  }
  public TunedSpecBuilder(TunedSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public TunedSpecBuilder(TunedSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TunedSpec(), validationEnabled);
  }
  public TunedSpecBuilder(TunedSpecFluent<?> fluent,TunedSpec instance) {
    this(fluent, instance, false);
  }
  public TunedSpecBuilder(TunedSpecFluent<?> fluent,TunedSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withManagementState(instance.getManagementState()); 
    fluent.withProfile(instance.getProfile()); 
    fluent.withRecommend(instance.getRecommend()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public TunedSpecBuilder(TunedSpec instance) {
    this(instance,false);
  }
  public TunedSpecBuilder(TunedSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withManagementState(instance.getManagementState()); 
    this.withProfile(instance.getProfile()); 
    this.withRecommend(instance.getRecommend()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  TunedSpecFluent<?> fluent;
  Boolean validationEnabled;
  public TunedSpec build() {
    TunedSpec buildable = new TunedSpec(fluent.getManagementState(),fluent.getProfile(),fluent.getRecommend());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}