package io.fabric8.openshift.api.model.tuned.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TunedStatusBuilder extends TunedStatusFluentImpl<TunedStatusBuilder> implements VisitableBuilder<TunedStatus,TunedStatusBuilder>{
  public TunedStatusBuilder() {
    this(false);
  }
  public TunedStatusBuilder(Boolean validationEnabled) {
    this(new TunedStatus(), validationEnabled);
  }
  public TunedStatusBuilder(TunedStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public TunedStatusBuilder(TunedStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TunedStatus(), validationEnabled);
  }
  public TunedStatusBuilder(TunedStatusFluent<?> fluent,TunedStatus instance) {
    this(fluent, instance, false);
  }
  public TunedStatusBuilder(TunedStatusFluent<?> fluent,TunedStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public TunedStatusBuilder(TunedStatus instance) {
    this(instance,false);
  }
  public TunedStatusBuilder(TunedStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  TunedStatusFluent<?> fluent;
  Boolean validationEnabled;
  public TunedStatus build() {
    TunedStatus buildable = new TunedStatus();
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}