package io.fabric8.openshift.api.model.tuned.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class TunedSpecFluentImpl<A extends TunedSpecFluent<A>> extends BaseFluent<A> implements TunedSpecFluent<A>{
  public TunedSpecFluentImpl() {
  }
  public TunedSpecFluentImpl(TunedSpec instance) {
    if (instance != null) {
      this.withManagementState(instance.getManagementState());
      this.withProfile(instance.getProfile());
      this.withRecommend(instance.getRecommend());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String managementState;
  private ArrayList<TunedProfileBuilder> profile = new ArrayList<TunedProfileBuilder>();
  private ArrayList<TunedRecommendBuilder> recommend = new ArrayList<TunedRecommendBuilder>();
  private Map<String,Object> additionalProperties;
  public String getManagementState() {
    return this.managementState;
  }
  public A withManagementState(String managementState) {
    this.managementState=managementState; return (A) this;
  }
  public Boolean hasManagementState() {
    return this.managementState != null;
  }
  public A addToProfile(int index,TunedProfile item) {
    if (this.profile == null) {this.profile = new ArrayList<TunedProfileBuilder>();}
    TunedProfileBuilder builder = new TunedProfileBuilder(item);
    if (index < 0 || index >= profile.size()) { _visitables.get("profile").add(builder); profile.add(builder); } else { _visitables.get("profile").add(index, builder); profile.add(index, builder);}
    return (A)this;
  }
  public A setToProfile(int index,TunedProfile item) {
    if (this.profile == null) {this.profile = new ArrayList<TunedProfileBuilder>();}
    TunedProfileBuilder builder = new TunedProfileBuilder(item);
    if (index < 0 || index >= profile.size()) { _visitables.get("profile").add(builder); profile.add(builder); } else { _visitables.get("profile").set(index, builder); profile.set(index, builder);}
    return (A)this;
  }
  public A addToProfile(io.fabric8.openshift.api.model.tuned.v1.TunedProfile... items) {
    if (this.profile == null) {this.profile = new ArrayList<TunedProfileBuilder>();}
    for (TunedProfile item : items) {TunedProfileBuilder builder = new TunedProfileBuilder(item);_visitables.get("profile").add(builder);this.profile.add(builder);} return (A)this;
  }
  public A addAllToProfile(Collection<TunedProfile> items) {
    if (this.profile == null) {this.profile = new ArrayList<TunedProfileBuilder>();}
    for (TunedProfile item : items) {TunedProfileBuilder builder = new TunedProfileBuilder(item);_visitables.get("profile").add(builder);this.profile.add(builder);} return (A)this;
  }
  public A removeFromProfile(io.fabric8.openshift.api.model.tuned.v1.TunedProfile... items) {
    for (TunedProfile item : items) {TunedProfileBuilder builder = new TunedProfileBuilder(item);_visitables.get("profile").remove(builder);if (this.profile != null) {this.profile.remove(builder);}} return (A)this;
  }
  public A removeAllFromProfile(Collection<TunedProfile> items) {
    for (TunedProfile item : items) {TunedProfileBuilder builder = new TunedProfileBuilder(item);_visitables.get("profile").remove(builder);if (this.profile != null) {this.profile.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromProfile(Predicate<TunedProfileBuilder> predicate) {
    if (profile == null) return (A) this;
    final Iterator<TunedProfileBuilder> each = profile.iterator();
    final List visitables = _visitables.get("profile");
    while (each.hasNext()) {
      TunedProfileBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildProfile instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<TunedProfile> getProfile() {
    return profile != null ? build(profile) : null;
  }
  public List<TunedProfile> buildProfile() {
    return profile != null ? build(profile) : null;
  }
  public TunedProfile buildProfile(int index) {
    return this.profile.get(index).build();
  }
  public TunedProfile buildFirstProfile() {
    return this.profile.get(0).build();
  }
  public TunedProfile buildLastProfile() {
    return this.profile.get(profile.size() - 1).build();
  }
  public TunedProfile buildMatchingProfile(Predicate<TunedProfileBuilder> predicate) {
    for (TunedProfileBuilder item: profile) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingProfile(Predicate<TunedProfileBuilder> predicate) {
    for (TunedProfileBuilder item: profile) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withProfile(List<TunedProfile> profile) {
    if (this.profile != null) { _visitables.get("profile").clear();}
    if (profile != null) {this.profile = new ArrayList(); for (TunedProfile item : profile){this.addToProfile(item);}} else { this.profile = null;} return (A) this;
  }
  public A withProfile(io.fabric8.openshift.api.model.tuned.v1.TunedProfile... profile) {
    if (this.profile != null) {this.profile.clear(); _visitables.remove("profile"); }
    if (profile != null) {for (TunedProfile item :profile){ this.addToProfile(item);}} return (A) this;
  }
  public Boolean hasProfile() {
    return profile != null && !profile.isEmpty();
  }
  public A addNewProfile(String data,String name) {
    return (A)addToProfile(new TunedProfile(data, name));
  }
  public TunedSpecFluentImpl.ProfileNested<A> addNewProfile() {
    return new TunedSpecFluentImpl.ProfileNestedImpl();
  }
  public TunedSpecFluentImpl.ProfileNested<A> addNewProfileLike(TunedProfile item) {
    return new TunedSpecFluentImpl.ProfileNestedImpl(-1, item);
  }
  public TunedSpecFluentImpl.ProfileNested<A> setNewProfileLike(int index,TunedProfile item) {
    return new TunedSpecFluentImpl.ProfileNestedImpl(index, item);
  }
  public TunedSpecFluentImpl.ProfileNested<A> editProfile(int index) {
    if (profile.size() <= index) throw new RuntimeException("Can't edit profile. Index exceeds size.");
    return setNewProfileLike(index, buildProfile(index));
  }
  public TunedSpecFluentImpl.ProfileNested<A> editFirstProfile() {
    if (profile.size() == 0) throw new RuntimeException("Can't edit first profile. The list is empty.");
    return setNewProfileLike(0, buildProfile(0));
  }
  public TunedSpecFluentImpl.ProfileNested<A> editLastProfile() {
    int index = profile.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last profile. The list is empty.");
    return setNewProfileLike(index, buildProfile(index));
  }
  public TunedSpecFluentImpl.ProfileNested<A> editMatchingProfile(Predicate<TunedProfileBuilder> predicate) {
    int index = -1;
    for (int i=0;i<profile.size();i++) { 
    if (predicate.test(profile.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching profile. No match found.");
    return setNewProfileLike(index, buildProfile(index));
  }
  public A addToRecommend(int index,TunedRecommend item) {
    if (this.recommend == null) {this.recommend = new ArrayList<TunedRecommendBuilder>();}
    TunedRecommendBuilder builder = new TunedRecommendBuilder(item);
    if (index < 0 || index >= recommend.size()) { _visitables.get("recommend").add(builder); recommend.add(builder); } else { _visitables.get("recommend").add(index, builder); recommend.add(index, builder);}
    return (A)this;
  }
  public A setToRecommend(int index,TunedRecommend item) {
    if (this.recommend == null) {this.recommend = new ArrayList<TunedRecommendBuilder>();}
    TunedRecommendBuilder builder = new TunedRecommendBuilder(item);
    if (index < 0 || index >= recommend.size()) { _visitables.get("recommend").add(builder); recommend.add(builder); } else { _visitables.get("recommend").set(index, builder); recommend.set(index, builder);}
    return (A)this;
  }
  public A addToRecommend(io.fabric8.openshift.api.model.tuned.v1.TunedRecommend... items) {
    if (this.recommend == null) {this.recommend = new ArrayList<TunedRecommendBuilder>();}
    for (TunedRecommend item : items) {TunedRecommendBuilder builder = new TunedRecommendBuilder(item);_visitables.get("recommend").add(builder);this.recommend.add(builder);} return (A)this;
  }
  public A addAllToRecommend(Collection<TunedRecommend> items) {
    if (this.recommend == null) {this.recommend = new ArrayList<TunedRecommendBuilder>();}
    for (TunedRecommend item : items) {TunedRecommendBuilder builder = new TunedRecommendBuilder(item);_visitables.get("recommend").add(builder);this.recommend.add(builder);} return (A)this;
  }
  public A removeFromRecommend(io.fabric8.openshift.api.model.tuned.v1.TunedRecommend... items) {
    for (TunedRecommend item : items) {TunedRecommendBuilder builder = new TunedRecommendBuilder(item);_visitables.get("recommend").remove(builder);if (this.recommend != null) {this.recommend.remove(builder);}} return (A)this;
  }
  public A removeAllFromRecommend(Collection<TunedRecommend> items) {
    for (TunedRecommend item : items) {TunedRecommendBuilder builder = new TunedRecommendBuilder(item);_visitables.get("recommend").remove(builder);if (this.recommend != null) {this.recommend.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromRecommend(Predicate<TunedRecommendBuilder> predicate) {
    if (recommend == null) return (A) this;
    final Iterator<TunedRecommendBuilder> each = recommend.iterator();
    final List visitables = _visitables.get("recommend");
    while (each.hasNext()) {
      TunedRecommendBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildRecommend instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<TunedRecommend> getRecommend() {
    return recommend != null ? build(recommend) : null;
  }
  public List<TunedRecommend> buildRecommend() {
    return recommend != null ? build(recommend) : null;
  }
  public TunedRecommend buildRecommend(int index) {
    return this.recommend.get(index).build();
  }
  public TunedRecommend buildFirstRecommend() {
    return this.recommend.get(0).build();
  }
  public TunedRecommend buildLastRecommend() {
    return this.recommend.get(recommend.size() - 1).build();
  }
  public TunedRecommend buildMatchingRecommend(Predicate<TunedRecommendBuilder> predicate) {
    for (TunedRecommendBuilder item: recommend) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingRecommend(Predicate<TunedRecommendBuilder> predicate) {
    for (TunedRecommendBuilder item: recommend) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRecommend(List<TunedRecommend> recommend) {
    if (this.recommend != null) { _visitables.get("recommend").clear();}
    if (recommend != null) {this.recommend = new ArrayList(); for (TunedRecommend item : recommend){this.addToRecommend(item);}} else { this.recommend = null;} return (A) this;
  }
  public A withRecommend(io.fabric8.openshift.api.model.tuned.v1.TunedRecommend... recommend) {
    if (this.recommend != null) {this.recommend.clear(); _visitables.remove("recommend"); }
    if (recommend != null) {for (TunedRecommend item :recommend){ this.addToRecommend(item);}} return (A) this;
  }
  public Boolean hasRecommend() {
    return recommend != null && !recommend.isEmpty();
  }
  public TunedSpecFluentImpl.RecommendNested<A> addNewRecommend() {
    return new TunedSpecFluentImpl.RecommendNestedImpl();
  }
  public TunedSpecFluentImpl.RecommendNested<A> addNewRecommendLike(TunedRecommend item) {
    return new TunedSpecFluentImpl.RecommendNestedImpl(-1, item);
  }
  public TunedSpecFluentImpl.RecommendNested<A> setNewRecommendLike(int index,TunedRecommend item) {
    return new TunedSpecFluentImpl.RecommendNestedImpl(index, item);
  }
  public TunedSpecFluentImpl.RecommendNested<A> editRecommend(int index) {
    if (recommend.size() <= index) throw new RuntimeException("Can't edit recommend. Index exceeds size.");
    return setNewRecommendLike(index, buildRecommend(index));
  }
  public TunedSpecFluentImpl.RecommendNested<A> editFirstRecommend() {
    if (recommend.size() == 0) throw new RuntimeException("Can't edit first recommend. The list is empty.");
    return setNewRecommendLike(0, buildRecommend(0));
  }
  public TunedSpecFluentImpl.RecommendNested<A> editLastRecommend() {
    int index = recommend.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last recommend. The list is empty.");
    return setNewRecommendLike(index, buildRecommend(index));
  }
  public TunedSpecFluentImpl.RecommendNested<A> editMatchingRecommend(Predicate<TunedRecommendBuilder> predicate) {
    int index = -1;
    for (int i=0;i<recommend.size();i++) { 
    if (predicate.test(recommend.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching recommend. No match found.");
    return setNewRecommendLike(index, buildRecommend(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TunedSpecFluentImpl that = (TunedSpecFluentImpl) o;
    if (!java.util.Objects.equals(managementState, that.managementState)) return false;

    if (!java.util.Objects.equals(profile, that.profile)) return false;

    if (!java.util.Objects.equals(recommend, that.recommend)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(managementState,  profile,  recommend,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (managementState != null) { sb.append("managementState:"); sb.append(managementState + ","); }
    if (profile != null) { sb.append("profile:"); sb.append(profile + ","); }
    if (recommend != null) { sb.append("recommend:"); sb.append(recommend + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ProfileNestedImpl<N> extends TunedProfileFluentImpl<TunedSpecFluentImpl.ProfileNested<N>> implements TunedSpecFluentImpl.ProfileNested<N>,Nested<N>{
    ProfileNestedImpl(int index,TunedProfile item) {
      this.index = index;
      this.builder = new TunedProfileBuilder(this, item);
    }
    ProfileNestedImpl() {
      this.index = -1;
      this.builder = new TunedProfileBuilder(this);
    }
    TunedProfileBuilder builder;
    int index;
    public N and() {
      return (N) TunedSpecFluentImpl.this.setToProfile(index,builder.build());
    }
    public N endProfile() {
      return and();
    }
    
  }
  class RecommendNestedImpl<N> extends TunedRecommendFluentImpl<TunedSpecFluentImpl.RecommendNested<N>> implements TunedSpecFluentImpl.RecommendNested<N>,Nested<N>{
    RecommendNestedImpl(int index,TunedRecommend item) {
      this.index = index;
      this.builder = new TunedRecommendBuilder(this, item);
    }
    RecommendNestedImpl() {
      this.index = -1;
      this.builder = new TunedRecommendBuilder(this);
    }
    TunedRecommendBuilder builder;
    int index;
    public N and() {
      return (N) TunedSpecFluentImpl.this.setToRecommend(index,builder.build());
    }
    public N endRecommend() {
      return and();
    }
    
  }
  
}