package io.fabric8.openshift.api.model.tuned.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ProfileSpecFluent<A extends ProfileSpecFluent<A>> extends BaseFluent<A>{
  public ProfileSpecFluent() {
  }
  
  public ProfileSpecFluent(ProfileSpec instance) {
    this.copyInstance(instance);
  }
  private ProfileConfigBuilder config;
  private ArrayList<TunedProfileBuilder> profile = new ArrayList<TunedProfileBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ProfileSpec instance) {
    instance = (instance != null ? instance : new ProfileSpec());
    if (instance != null) {
          this.withConfig(instance.getConfig());
          this.withProfile(instance.getProfile());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public ProfileConfig buildConfig() {
    return this.config != null ? this.config.build() : null;
  }
  
  public A withConfig(ProfileConfig config) {
    this._visitables.remove("config");
    if (config != null) {
        this.config = new ProfileConfigBuilder(config);
        this._visitables.get("config").add(this.config);
    } else {
        this.config = null;
        this._visitables.get("config").remove(this.config);
    }
    return (A) this;
  }
  
  public boolean hasConfig() {
    return this.config != null;
  }
  
  public ConfigNested<A> withNewConfig() {
    return new ConfigNested(null);
  }
  
  public ConfigNested<A> withNewConfigLike(ProfileConfig item) {
    return new ConfigNested(item);
  }
  
  public ConfigNested<A> editConfig() {
    return withNewConfigLike(java.util.Optional.ofNullable(buildConfig()).orElse(null));
  }
  
  public ConfigNested<A> editOrNewConfig() {
    return withNewConfigLike(java.util.Optional.ofNullable(buildConfig()).orElse(new ProfileConfigBuilder().build()));
  }
  
  public ConfigNested<A> editOrNewConfigLike(ProfileConfig item) {
    return withNewConfigLike(java.util.Optional.ofNullable(buildConfig()).orElse(item));
  }
  
  public A addToProfile(int index,TunedProfile item) {
    if (this.profile == null) {this.profile = new ArrayList<TunedProfileBuilder>();}
    TunedProfileBuilder builder = new TunedProfileBuilder(item);
    if (index < 0 || index >= profile.size()) {
        _visitables.get("profile").add(builder);
        profile.add(builder);
    } else {
        _visitables.get("profile").add(builder);
        profile.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToProfile(int index,TunedProfile item) {
    if (this.profile == null) {this.profile = new ArrayList<TunedProfileBuilder>();}
    TunedProfileBuilder builder = new TunedProfileBuilder(item);
    if (index < 0 || index >= profile.size()) {
        _visitables.get("profile").add(builder);
        profile.add(builder);
    } else {
        _visitables.get("profile").add(builder);
        profile.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToProfile(io.fabric8.openshift.api.model.tuned.v1.TunedProfile... items) {
    if (this.profile == null) {this.profile = new ArrayList<TunedProfileBuilder>();}
    for (TunedProfile item : items) {TunedProfileBuilder builder = new TunedProfileBuilder(item);_visitables.get("profile").add(builder);this.profile.add(builder);} return (A)this;
  }
  
  public A addAllToProfile(Collection<TunedProfile> items) {
    if (this.profile == null) {this.profile = new ArrayList<TunedProfileBuilder>();}
    for (TunedProfile item : items) {TunedProfileBuilder builder = new TunedProfileBuilder(item);_visitables.get("profile").add(builder);this.profile.add(builder);} return (A)this;
  }
  
  public A removeFromProfile(io.fabric8.openshift.api.model.tuned.v1.TunedProfile... items) {
    if (this.profile == null) return (A)this;
    for (TunedProfile item : items) {TunedProfileBuilder builder = new TunedProfileBuilder(item);_visitables.get("profile").remove(builder); this.profile.remove(builder);} return (A)this;
  }
  
  public A removeAllFromProfile(Collection<TunedProfile> items) {
    if (this.profile == null) return (A)this;
    for (TunedProfile item : items) {TunedProfileBuilder builder = new TunedProfileBuilder(item);_visitables.get("profile").remove(builder); this.profile.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromProfile(Predicate<TunedProfileBuilder> predicate) {
    if (profile == null) return (A) this;
    final Iterator<TunedProfileBuilder> each = profile.iterator();
    final List visitables = _visitables.get("profile");
    while (each.hasNext()) {
      TunedProfileBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<TunedProfile> buildProfile() {
    return this.profile != null ? build(profile) : null;
  }
  
  public TunedProfile buildProfile(int index) {
    return this.profile.get(index).build();
  }
  
  public TunedProfile buildFirstProfile() {
    return this.profile.get(0).build();
  }
  
  public TunedProfile buildLastProfile() {
    return this.profile.get(profile.size() - 1).build();
  }
  
  public TunedProfile buildMatchingProfile(Predicate<TunedProfileBuilder> predicate) {
      for (TunedProfileBuilder item : profile) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingProfile(Predicate<TunedProfileBuilder> predicate) {
      for (TunedProfileBuilder item : profile) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withProfile(List<TunedProfile> profile) {
    if (this.profile != null) {
      this._visitables.get("profile").clear();
    }
    if (profile != null) {
        this.profile = new ArrayList();
        for (TunedProfile item : profile) {
          this.addToProfile(item);
        }
    } else {
      this.profile = null;
    }
    return (A) this;
  }
  
  public A withProfile(io.fabric8.openshift.api.model.tuned.v1.TunedProfile... profile) {
    if (this.profile != null) {
        this.profile.clear();
        _visitables.remove("profile");
    }
    if (profile != null) {
      for (TunedProfile item : profile) {
        this.addToProfile(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasProfile() {
    return this.profile != null && !this.profile.isEmpty();
  }
  
  public A addNewProfile(String data,String name) {
    return (A)addToProfile(new TunedProfile(data, name));
  }
  
  public ProfileNested<A> addNewProfile() {
    return new ProfileNested(-1, null);
  }
  
  public ProfileNested<A> addNewProfileLike(TunedProfile item) {
    return new ProfileNested(-1, item);
  }
  
  public ProfileNested<A> setNewProfileLike(int index,TunedProfile item) {
    return new ProfileNested(index, item);
  }
  
  public ProfileNested<A> editProfile(int index) {
    if (profile.size() <= index) throw new RuntimeException("Can't edit profile. Index exceeds size.");
    return setNewProfileLike(index, buildProfile(index));
  }
  
  public ProfileNested<A> editFirstProfile() {
    if (profile.size() == 0) throw new RuntimeException("Can't edit first profile. The list is empty.");
    return setNewProfileLike(0, buildProfile(0));
  }
  
  public ProfileNested<A> editLastProfile() {
    int index = profile.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last profile. The list is empty.");
    return setNewProfileLike(index, buildProfile(index));
  }
  
  public ProfileNested<A> editMatchingProfile(Predicate<TunedProfileBuilder> predicate) {
    int index = -1;
    for (int i=0;i<profile.size();i++) { 
    if (predicate.test(profile.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching profile. No match found.");
    return setNewProfileLike(index, buildProfile(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ProfileSpecFluent that = (ProfileSpecFluent) o;
    if (!java.util.Objects.equals(config, that.config)) return false;
    if (!java.util.Objects.equals(profile, that.profile)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(config,  profile,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (config != null) { sb.append("config:"); sb.append(config + ","); }
    if (profile != null && !profile.isEmpty()) { sb.append("profile:"); sb.append(profile + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ConfigNested<N> extends ProfileConfigFluent<ConfigNested<N>> implements Nested<N>{
    ConfigNested(ProfileConfig item) {
      this.builder = new ProfileConfigBuilder(this, item);
    }
    ProfileConfigBuilder builder;
    
    public N and() {
      return (N) ProfileSpecFluent.this.withConfig(builder.build());
    }
    
    public N endConfig() {
      return and();
    }
    
  
  }
  public class ProfileNested<N> extends TunedProfileFluent<ProfileNested<N>> implements Nested<N>{
    ProfileNested(int index,TunedProfile item) {
      this.index = index;
      this.builder = new TunedProfileBuilder(this, item);
    }
    TunedProfileBuilder builder;
    int index;
    
    public N and() {
      return (N) ProfileSpecFluent.this.setToProfile(index,builder.build());
    }
    
    public N endProfile() {
      return and();
    }
    
  
  }

}