/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.tuned.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.tuned.v1.OperandConfig;
import io.fabric8.openshift.api.model.tuned.v1.OperandConfigBuilder;
import io.fabric8.openshift.api.model.tuned.v1.OperandConfigFluent;
import io.fabric8.openshift.api.model.tuned.v1.TunedMatch;
import io.fabric8.openshift.api.model.tuned.v1.TunedMatchBuilder;
import io.fabric8.openshift.api.model.tuned.v1.TunedMatchFluent;
import io.fabric8.openshift.api.model.tuned.v1.TunedRecommend;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class TunedRecommendFluent<A extends TunedRecommendFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private Map<String, String> machineConfigLabels;
    private ArrayList<TunedMatchBuilder> match = new ArrayList();
    private OperandConfigBuilder operand;
    private Long priority;
    private String profile;

    public TunedRecommendFluent() {
    }

    public TunedRecommendFluent(TunedRecommend instance) {
        this.copyInstance(instance);
    }

    public A addAllToMatch(Collection<TunedMatch> items) {
        if (this.match == null) {
            this.match = new ArrayList();
        }
        for (TunedMatch item : items) {
            TunedMatchBuilder builder = new TunedMatchBuilder(item);
            this._visitables.get((Object)"match").add(builder);
            this.match.add(builder);
        }
        return (A)((Object)this);
    }

    public MatchNested<A> addNewMatch() {
        return new MatchNested(-1, null);
    }

    public MatchNested<A> addNewMatchLike(TunedMatch item) {
        return new MatchNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToMachineConfigLabels(Map<String, String> map) {
        if (this.machineConfigLabels == null && map != null) {
            this.machineConfigLabels = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.machineConfigLabels.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToMachineConfigLabels(String key, String value) {
        if (this.machineConfigLabels == null && key != null && value != null) {
            this.machineConfigLabels = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.machineConfigLabels.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToMatch(TunedMatch ... items) {
        if (this.match == null) {
            this.match = new ArrayList();
        }
        for (TunedMatch item : items) {
            TunedMatchBuilder builder = new TunedMatchBuilder(item);
            this._visitables.get((Object)"match").add(builder);
            this.match.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToMatch(int index, TunedMatch item) {
        if (this.match == null) {
            this.match = new ArrayList();
        }
        TunedMatchBuilder builder = new TunedMatchBuilder(item);
        if (index < 0 || index >= this.match.size()) {
            this._visitables.get((Object)"match").add(builder);
            this.match.add(builder);
        } else {
            this._visitables.get((Object)"match").add(builder);
            this.match.add(index, builder);
        }
        return (A)((Object)this);
    }

    public TunedMatch buildFirstMatch() {
        return this.match.get(0).build();
    }

    public TunedMatch buildLastMatch() {
        return this.match.get(this.match.size() - 1).build();
    }

    public List<TunedMatch> buildMatch() {
        return this.match != null ? TunedRecommendFluent.build(this.match) : null;
    }

    public TunedMatch buildMatch(int index) {
        return this.match.get(index).build();
    }

    public TunedMatch buildMatchingMatch(Predicate<TunedMatchBuilder> predicate) {
        for (TunedMatchBuilder item : this.match) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public OperandConfig buildOperand() {
        return this.operand != null ? this.operand.build() : null;
    }

    protected void copyInstance(TunedRecommend instance) {
        TunedRecommend tunedRecommend = instance = instance != null ? instance : new TunedRecommend();
        if (instance != null) {
            this.withMachineConfigLabels(instance.getMachineConfigLabels());
            this.withMatch(instance.getMatch());
            this.withOperand(instance.getOperand());
            this.withPriority(instance.getPriority());
            this.withProfile(instance.getProfile());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public MatchNested<A> editFirstMatch() {
        if (this.match.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "match"));
        }
        return this.setNewMatchLike(0, this.buildMatch(0));
    }

    public MatchNested<A> editLastMatch() {
        int index = this.match.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "match"));
        }
        return this.setNewMatchLike(index, this.buildMatch(index));
    }

    public MatchNested<A> editMatch(int index) {
        if (this.match.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "match"));
        }
        return this.setNewMatchLike(index, this.buildMatch(index));
    }

    public MatchNested<A> editMatchingMatch(Predicate<TunedMatchBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.match.size(); ++i) {
            if (!predicate.test(this.match.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "match"));
        }
        return this.setNewMatchLike(index, this.buildMatch(index));
    }

    public OperandNested<A> editOperand() {
        return this.withNewOperandLike(Optional.ofNullable(this.buildOperand()).orElse(null));
    }

    public OperandNested<A> editOrNewOperand() {
        return this.withNewOperandLike(Optional.ofNullable(this.buildOperand()).orElse(new OperandConfigBuilder().build()));
    }

    public OperandNested<A> editOrNewOperandLike(OperandConfig item) {
        return this.withNewOperandLike(Optional.ofNullable(this.buildOperand()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TunedRecommendFluent that = (TunedRecommendFluent)((Object)o);
        if (!Objects.equals(this.machineConfigLabels, that.machineConfigLabels)) {
            return false;
        }
        if (!Objects.equals(this.match, that.match)) {
            return false;
        }
        if (!Objects.equals((Object)this.operand, (Object)that.operand)) {
            return false;
        }
        if (!Objects.equals(this.priority, that.priority)) {
            return false;
        }
        if (!Objects.equals(this.profile, that.profile)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Map<String, String> getMachineConfigLabels() {
        return this.machineConfigLabels;
    }

    public Long getPriority() {
        return this.priority;
    }

    public String getProfile() {
        return this.profile;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasMachineConfigLabels() {
        return this.machineConfigLabels != null;
    }

    public boolean hasMatch() {
        return this.match != null && !this.match.isEmpty();
    }

    public boolean hasMatchingMatch(Predicate<TunedMatchBuilder> predicate) {
        for (TunedMatchBuilder item : this.match) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasOperand() {
        return this.operand != null;
    }

    public boolean hasPriority() {
        return this.priority != null;
    }

    public boolean hasProfile() {
        return this.profile != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.machineConfigLabels, this.match, this.operand, this.priority, this.profile, this.additionalProperties});
    }

    public A removeAllFromMatch(Collection<TunedMatch> items) {
        if (this.match == null) {
            return (A)((Object)this);
        }
        for (TunedMatch item : items) {
            TunedMatchBuilder builder = new TunedMatchBuilder(item);
            this._visitables.get((Object)"match").remove((Object)builder);
            this.match.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromMachineConfigLabels(String key) {
        if (this.machineConfigLabels == null) {
            return (A)((Object)this);
        }
        if (key != null && this.machineConfigLabels != null) {
            this.machineConfigLabels.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromMachineConfigLabels(Map<String, String> map) {
        if (this.machineConfigLabels == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.machineConfigLabels == null) continue;
                this.machineConfigLabels.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromMatch(TunedMatch ... items) {
        if (this.match == null) {
            return (A)((Object)this);
        }
        for (TunedMatch item : items) {
            TunedMatchBuilder builder = new TunedMatchBuilder(item);
            this._visitables.get((Object)"match").remove((Object)builder);
            this.match.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromMatch(Predicate<TunedMatchBuilder> predicate) {
        if (this.match == null) {
            return (A)((Object)this);
        }
        Iterator<TunedMatchBuilder> each = this.match.iterator();
        List visitables = this._visitables.get((Object)"match");
        while (each.hasNext()) {
            TunedMatchBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public MatchNested<A> setNewMatchLike(int index, TunedMatch item) {
        return new MatchNested(index, item);
    }

    public A setToMatch(int index, TunedMatch item) {
        if (this.match == null) {
            this.match = new ArrayList();
        }
        TunedMatchBuilder builder = new TunedMatchBuilder(item);
        if (index < 0 || index >= this.match.size()) {
            this._visitables.get((Object)"match").add(builder);
            this.match.add(builder);
        } else {
            this._visitables.get((Object)"match").add(builder);
            this.match.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.machineConfigLabels != null && !this.machineConfigLabels.isEmpty()) {
            sb.append("machineConfigLabels:");
            sb.append(this.machineConfigLabels);
            sb.append(",");
        }
        if (this.match != null && !this.match.isEmpty()) {
            sb.append("match:");
            sb.append(this.match);
            sb.append(",");
        }
        if (this.operand != null) {
            sb.append("operand:");
            sb.append((Object)this.operand);
            sb.append(",");
        }
        if (this.priority != null) {
            sb.append("priority:");
            sb.append(this.priority);
            sb.append(",");
        }
        if (this.profile != null) {
            sb.append("profile:");
            sb.append(this.profile);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public <K, V> A withMachineConfigLabels(Map<String, String> machineConfigLabels) {
        this.machineConfigLabels = machineConfigLabels == null ? null : new LinkedHashMap<String, String>(machineConfigLabels);
        return (A)((Object)this);
    }

    public A withMatch(List<TunedMatch> match) {
        if (this.match != null) {
            this._visitables.get((Object)"match").clear();
        }
        if (match != null) {
            this.match = new ArrayList();
            for (TunedMatch item : match) {
                this.addToMatch(item);
            }
        } else {
            this.match = null;
        }
        return (A)((Object)this);
    }

    public A withMatch(TunedMatch ... match) {
        if (this.match != null) {
            this.match.clear();
            this._visitables.remove((Object)"match");
        }
        if (match != null) {
            for (TunedMatch item : match) {
                this.addToMatch(item);
            }
        }
        return (A)((Object)this);
    }

    public OperandNested<A> withNewOperand() {
        return new OperandNested(null);
    }

    public OperandNested<A> withNewOperandLike(OperandConfig item) {
        return new OperandNested(item);
    }

    public A withOperand(OperandConfig operand) {
        this._visitables.remove((Object)"operand");
        if (operand != null) {
            this.operand = new OperandConfigBuilder(operand);
            this._visitables.get((Object)"operand").add(this.operand);
        } else {
            this.operand = null;
            this._visitables.get((Object)"operand").remove((Object)this.operand);
        }
        return (A)((Object)this);
    }

    public A withPriority(Long priority) {
        this.priority = priority;
        return (A)((Object)this);
    }

    public A withProfile(String profile) {
        this.profile = profile;
        return (A)((Object)this);
    }

    public class OperandNested<N>
    extends OperandConfigFluent<OperandNested<N>>
    implements Nested<N> {
        OperandConfigBuilder builder;

        OperandNested(OperandConfig item) {
            this.builder = new OperandConfigBuilder(this, item);
        }

        public N and() {
            return (N)TunedRecommendFluent.this.withOperand(this.builder.build());
        }

        public N endOperand() {
            return this.and();
        }
    }

    public class MatchNested<N>
    extends TunedMatchFluent<MatchNested<N>>
    implements Nested<N> {
        TunedMatchBuilder builder;
        int index;

        MatchNested(int index, TunedMatch item) {
            this.index = index;
            this.builder = new TunedMatchBuilder(this, item);
        }

        public N and() {
            return (N)TunedRecommendFluent.this.setToMatch(this.index, this.builder.build());
        }

        public N endMatch() {
            return this.and();
        }
    }
}

