package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class EgressNetworkPolicySpecFluentImpl<A extends EgressNetworkPolicySpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements EgressNetworkPolicySpecFluent<A>{

    private List<EgressNetworkPolicyRuleBuilder> egress =  new ArrayList<EgressNetworkPolicyRuleBuilder>();

    public EgressNetworkPolicySpecFluentImpl(){
    }
    public EgressNetworkPolicySpecFluentImpl(EgressNetworkPolicySpec instance){
            this.withEgress(instance.getEgress()); 
    }

    public A addToEgress(int index,EgressNetworkPolicyRule item){
            if (this.egress == null) {this.egress = new ArrayList<EgressNetworkPolicyRuleBuilder>();}
            EgressNetworkPolicyRuleBuilder builder = new EgressNetworkPolicyRuleBuilder(item);_visitables.get("egress").add(index >= 0 ? index : _visitables.get("egress").size(), builder);this.egress.add(index >= 0 ? index : egress.size(), builder); return (A)this;
    }

    public A setToEgress(int index,EgressNetworkPolicyRule item){
            if (this.egress == null) {this.egress = new ArrayList<EgressNetworkPolicyRuleBuilder>();}
            EgressNetworkPolicyRuleBuilder builder = new EgressNetworkPolicyRuleBuilder(item);
            if (index < 0 || index >= _visitables.get("egress").size()) { _visitables.get("egress").add(builder); } else { _visitables.get("egress").set(index, builder);}
            if (index < 0 || index >= egress.size()) { egress.add(builder); } else { egress.set(index, builder);}
             return (A)this;
    }

    public A addToEgress(EgressNetworkPolicyRule... items){
            if (this.egress == null) {this.egress = new ArrayList<EgressNetworkPolicyRuleBuilder>();}
            for (EgressNetworkPolicyRule item : items) {EgressNetworkPolicyRuleBuilder builder = new EgressNetworkPolicyRuleBuilder(item);_visitables.get("egress").add(builder);this.egress.add(builder);} return (A)this;
    }

    public A addAllToEgress(Collection<EgressNetworkPolicyRule> items){
            if (this.egress == null) {this.egress = new ArrayList<EgressNetworkPolicyRuleBuilder>();}
            for (EgressNetworkPolicyRule item : items) {EgressNetworkPolicyRuleBuilder builder = new EgressNetworkPolicyRuleBuilder(item);_visitables.get("egress").add(builder);this.egress.add(builder);} return (A)this;
    }

    public A removeFromEgress(EgressNetworkPolicyRule... items){
            for (EgressNetworkPolicyRule item : items) {EgressNetworkPolicyRuleBuilder builder = new EgressNetworkPolicyRuleBuilder(item);_visitables.get("egress").remove(builder);if (this.egress != null) {this.egress.remove(builder);}} return (A)this;
    }

    public A removeAllFromEgress(Collection<EgressNetworkPolicyRule> items){
            for (EgressNetworkPolicyRule item : items) {EgressNetworkPolicyRuleBuilder builder = new EgressNetworkPolicyRuleBuilder(item);_visitables.get("egress").remove(builder);if (this.egress != null) {this.egress.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromEgress(io.fabric8.kubernetes.api.builder.Predicate<EgressNetworkPolicyRuleBuilder> predicate){
            if (egress == null) return (A) this;
            final Iterator<EgressNetworkPolicyRuleBuilder> each = egress.iterator();
            final List visitables = _visitables.get("egress");
            while (each.hasNext()) {
              EgressNetworkPolicyRuleBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildEgress instead.
 * @return The buildable object.
 */
@Deprecated public List<EgressNetworkPolicyRule> getEgress(){
            return build(egress);
    }

    public List<EgressNetworkPolicyRule> buildEgress(){
            return build(egress);
    }

    public EgressNetworkPolicyRule buildEgress(int index){
            return this.egress.get(index).build();
    }

    public EgressNetworkPolicyRule buildFirstEgress(){
            return this.egress.get(0).build();
    }

    public EgressNetworkPolicyRule buildLastEgress(){
            return this.egress.get(egress.size() - 1).build();
    }

    public EgressNetworkPolicyRule buildMatchingEgress(io.fabric8.kubernetes.api.builder.Predicate<EgressNetworkPolicyRuleBuilder> predicate){
            for (EgressNetworkPolicyRuleBuilder item: egress) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingEgress(io.fabric8.kubernetes.api.builder.Predicate<EgressNetworkPolicyRuleBuilder> predicate){
            for (EgressNetworkPolicyRuleBuilder item: egress) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withEgress(List<EgressNetworkPolicyRule> egress){
            if (this.egress != null) { _visitables.get("egress").removeAll(this.egress);}
            if (egress != null) {this.egress = new ArrayList<EgressNetworkPolicyRuleBuilder>(); for (EgressNetworkPolicyRule item : egress){this.addToEgress(item);}} else { this.egress = null;} return (A) this;
    }

    public A withEgress(EgressNetworkPolicyRule... egress){
            if (this.egress != null) {this.egress.clear();}
            if (egress != null) {for (EgressNetworkPolicyRule item :egress){ this.addToEgress(item);}} return (A) this;
    }

    public Boolean hasEgress(){
            return egress != null && !egress.isEmpty();
    }

    public EgressNetworkPolicySpecFluent.EgressNested<A> addNewEgress(){
            return new EgressNestedImpl();
    }

    public EgressNetworkPolicySpecFluent.EgressNested<A> addNewEgressLike(EgressNetworkPolicyRule item){
            return new EgressNestedImpl(-1, item);
    }

    public EgressNetworkPolicySpecFluent.EgressNested<A> setNewEgressLike(int index,EgressNetworkPolicyRule item){
            return new EgressNestedImpl(index, item);
    }

    public EgressNetworkPolicySpecFluent.EgressNested<A> editEgress(int index){
            if (egress.size() <= index) throw new RuntimeException("Can't edit egress. Index exceeds size.");
            return setNewEgressLike(index, buildEgress(index));
    }

    public EgressNetworkPolicySpecFluent.EgressNested<A> editFirstEgress(){
            if (egress.size() == 0) throw new RuntimeException("Can't edit first egress. The list is empty.");
            return setNewEgressLike(0, buildEgress(0));
    }

    public EgressNetworkPolicySpecFluent.EgressNested<A> editLastEgress(){
            int index = egress.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last egress. The list is empty.");
            return setNewEgressLike(index, buildEgress(index));
    }

    public EgressNetworkPolicySpecFluent.EgressNested<A> editMatchingEgress(io.fabric8.kubernetes.api.builder.Predicate<EgressNetworkPolicyRuleBuilder> predicate){
            int index = -1;
            for (int i=0;i<egress.size();i++) { 
            if (predicate.apply(egress.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching egress. No match found.");
            return setNewEgressLike(index, buildEgress(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            EgressNetworkPolicySpecFluentImpl that = (EgressNetworkPolicySpecFluentImpl) o;
            if (egress != null ? !egress.equals(that.egress) :that.egress != null) return false;
            return true;
    }


    public class EgressNestedImpl<N> extends EgressNetworkPolicyRuleFluentImpl<EgressNetworkPolicySpecFluent.EgressNested<N>> implements EgressNetworkPolicySpecFluent.EgressNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final EgressNetworkPolicyRuleBuilder builder;
        private final int index;
    
            EgressNestedImpl(int index,EgressNetworkPolicyRule item){
                    this.index = index;
                    this.builder = new EgressNetworkPolicyRuleBuilder(this, item);
            }
            EgressNestedImpl(){
                    this.index = -1;
                    this.builder = new EgressNetworkPolicyRuleBuilder(this);
            }
    
    public N and(){
            return (N) EgressNetworkPolicySpecFluentImpl.this.setToEgress(index,builder.build());
    }
    public N endEgress(){
            return and();
    }

}


}
