package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class OperandVersionBuilder extends OperandVersionFluentImpl<OperandVersionBuilder> implements VisitableBuilder<OperandVersion,OperandVersionBuilder>{

    OperandVersionFluent<?> fluent;
    Boolean validationEnabled;

    public OperandVersionBuilder(){
            this(true);
    }
    public OperandVersionBuilder(Boolean validationEnabled){
            this(new OperandVersion(), validationEnabled);
    }
    public OperandVersionBuilder(OperandVersionFluent<?> fluent){
            this(fluent, true);
    }
    public OperandVersionBuilder(OperandVersionFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new OperandVersion(), validationEnabled);
    }
    public OperandVersionBuilder(OperandVersionFluent<?> fluent,OperandVersion instance){
            this(fluent, instance, true);
    }
    public OperandVersionBuilder(OperandVersionFluent<?> fluent,OperandVersion instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName()); 
            fluent.withVersion(instance.getVersion()); 
            this.validationEnabled = validationEnabled; 
    }
    public OperandVersionBuilder(OperandVersion instance){
            this(instance,true);
    }
    public OperandVersionBuilder(OperandVersion instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName()); 
            this.withVersion(instance.getVersion()); 
            this.validationEnabled = validationEnabled; 
    }

    public OperandVersion build(){
            OperandVersion buildable = new OperandVersion(fluent.getName(),fluent.getVersion());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            OperandVersionBuilder that = (OperandVersionBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
