package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class OvirtPlatformSpecBuilder extends OvirtPlatformSpecFluentImpl<OvirtPlatformSpecBuilder> implements VisitableBuilder<OvirtPlatformSpec,OvirtPlatformSpecBuilder>{

    OvirtPlatformSpecFluent<?> fluent;
    Boolean validationEnabled;

    public OvirtPlatformSpecBuilder(){
            this(true);
    }
    public OvirtPlatformSpecBuilder(Boolean validationEnabled){
            this(new OvirtPlatformSpec(), validationEnabled);
    }
    public OvirtPlatformSpecBuilder(OvirtPlatformSpecFluent<?> fluent){
            this(fluent, true);
    }
    public OvirtPlatformSpecBuilder(OvirtPlatformSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new OvirtPlatformSpec(), validationEnabled);
    }
    public OvirtPlatformSpecBuilder(OvirtPlatformSpecFluent<?> fluent,OvirtPlatformSpec instance){
            this(fluent, instance, true);
    }
    public OvirtPlatformSpecBuilder(OvirtPlatformSpecFluent<?> fluent,OvirtPlatformSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            this.validationEnabled = validationEnabled; 
    }
    public OvirtPlatformSpecBuilder(OvirtPlatformSpec instance){
            this(instance,true);
    }
    public OvirtPlatformSpecBuilder(OvirtPlatformSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.validationEnabled = validationEnabled; 
    }

    public OvirtPlatformSpec build(){
            OvirtPlatformSpec buildable = new OvirtPlatformSpec();
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            OvirtPlatformSpecBuilder that = (OvirtPlatformSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
