package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PodSecurityPolicyReviewBuilder extends PodSecurityPolicyReviewFluentImpl<PodSecurityPolicyReviewBuilder> implements VisitableBuilder<PodSecurityPolicyReview,PodSecurityPolicyReviewBuilder>{

    PodSecurityPolicyReviewFluent<?> fluent;
    Boolean validationEnabled;

    public PodSecurityPolicyReviewBuilder(){
            this(true);
    }
    public PodSecurityPolicyReviewBuilder(Boolean validationEnabled){
            this(new PodSecurityPolicyReview(), validationEnabled);
    }
    public PodSecurityPolicyReviewBuilder(PodSecurityPolicyReviewFluent<?> fluent){
            this(fluent, true);
    }
    public PodSecurityPolicyReviewBuilder(PodSecurityPolicyReviewFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PodSecurityPolicyReview(), validationEnabled);
    }
    public PodSecurityPolicyReviewBuilder(PodSecurityPolicyReviewFluent<?> fluent,PodSecurityPolicyReview instance){
            this(fluent, instance, true);
    }
    public PodSecurityPolicyReviewBuilder(PodSecurityPolicyReviewFluent<?> fluent,PodSecurityPolicyReview instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withSpec(instance.getSpec()); 
            fluent.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public PodSecurityPolicyReviewBuilder(PodSecurityPolicyReview instance){
            this(instance,true);
    }
    public PodSecurityPolicyReviewBuilder(PodSecurityPolicyReview instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withSpec(instance.getSpec()); 
            this.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }

    public PodSecurityPolicyReview build(){
            PodSecurityPolicyReview buildable = new PodSecurityPolicyReview(fluent.getApiVersion(),fluent.getKind(),fluent.getSpec(),fluent.getStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PodSecurityPolicyReviewBuilder that = (PodSecurityPolicyReviewBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
