
package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.authentication.TokenReview;
import io.fabric8.kubernetes.api.model.rbac.AggregationRule;
import io.fabric8.kubernetes.api.model.version.Info;
import io.fabric8.openshift.api.model.APIServer;
import io.fabric8.openshift.api.model.APIServerList;
import io.fabric8.openshift.api.model.AppliedClusterResourceQuota;
import io.fabric8.openshift.api.model.AppliedClusterResourceQuotaList;
import io.fabric8.openshift.api.model.BuildConfigList;
import io.fabric8.openshift.api.model.BuildList;
import io.fabric8.openshift.api.model.BuildRequest;
import io.fabric8.openshift.api.model.ClusterNetwork;
import io.fabric8.openshift.api.model.ClusterNetworkList;
import io.fabric8.openshift.api.model.ClusterOperator;
import io.fabric8.openshift.api.model.ClusterOperatorList;
import io.fabric8.openshift.api.model.ClusterResourceQuota;
import io.fabric8.openshift.api.model.ClusterResourceQuotaList;
import io.fabric8.openshift.api.model.ClusterRole;
import io.fabric8.openshift.api.model.ClusterRoleBinding;
import io.fabric8.openshift.api.model.ClusterRoleBindingList;
import io.fabric8.openshift.api.model.ClusterRoleList;
import io.fabric8.openshift.api.model.ClusterRoleScopeRestriction;
import io.fabric8.openshift.api.model.ClusterVersion;
import io.fabric8.openshift.api.model.ClusterVersionList;
import io.fabric8.openshift.api.model.ConfigMapFileReference;
import io.fabric8.openshift.api.model.DNSZone;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigList;
import io.fabric8.openshift.api.model.EgressNetworkPolicy;
import io.fabric8.openshift.api.model.EgressNetworkPolicyList;
import io.fabric8.openshift.api.model.FeatureGate;
import io.fabric8.openshift.api.model.FeatureGateList;
import io.fabric8.openshift.api.model.Group;
import io.fabric8.openshift.api.model.GroupList;
import io.fabric8.openshift.api.model.Identity;
import io.fabric8.openshift.api.model.IdentityList;
import io.fabric8.openshift.api.model.ImageList;
import io.fabric8.openshift.api.model.ImageStreamImage;
import io.fabric8.openshift.api.model.ImageStreamImport;
import io.fabric8.openshift.api.model.ImageStreamList;
import io.fabric8.openshift.api.model.ImageStreamMapping;
import io.fabric8.openshift.api.model.ImageStreamTagList;
import io.fabric8.openshift.api.model.ImageTag;
import io.fabric8.openshift.api.model.ImageTagList;
import io.fabric8.openshift.api.model.Infrastructure;
import io.fabric8.openshift.api.model.InfrastructureList;
import io.fabric8.openshift.api.model.LocalResourceAccessReview;
import io.fabric8.openshift.api.model.LocalSubjectAccessReview;
import io.fabric8.openshift.api.model.NetNamespace;
import io.fabric8.openshift.api.model.NetNamespaceList;
import io.fabric8.openshift.api.model.OAuth;
import io.fabric8.openshift.api.model.OAuthAccessToken;
import io.fabric8.openshift.api.model.OAuthAccessTokenList;
import io.fabric8.openshift.api.model.OAuthAuthorizeToken;
import io.fabric8.openshift.api.model.OAuthAuthorizeTokenList;
import io.fabric8.openshift.api.model.OAuthClient;
import io.fabric8.openshift.api.model.OAuthClientAuthorization;
import io.fabric8.openshift.api.model.OAuthClientAuthorizationList;
import io.fabric8.openshift.api.model.OAuthClientList;
import io.fabric8.openshift.api.model.OAuthList;
import io.fabric8.openshift.api.model.OperatorHub;
import io.fabric8.openshift.api.model.OperatorHubList;
import io.fabric8.openshift.api.model.PodSecurityPolicyReview;
import io.fabric8.openshift.api.model.PodSecurityPolicySelfSubjectReview;
import io.fabric8.openshift.api.model.PodSecurityPolicySubjectReview;
import io.fabric8.openshift.api.model.Project;
import io.fabric8.openshift.api.model.ProjectList;
import io.fabric8.openshift.api.model.ProjectRequest;
import io.fabric8.openshift.api.model.Proxy;
import io.fabric8.openshift.api.model.ProxyList;
import io.fabric8.openshift.api.model.RangeAllocation;
import io.fabric8.openshift.api.model.RangeAllocationList;
import io.fabric8.openshift.api.model.ResourceAccessReview;
import io.fabric8.openshift.api.model.Role;
import io.fabric8.openshift.api.model.RoleBinding;
import io.fabric8.openshift.api.model.RoleBindingList;
import io.fabric8.openshift.api.model.RoleBindingRestriction;
import io.fabric8.openshift.api.model.RoleBindingRestrictionSpec;
import io.fabric8.openshift.api.model.RoleList;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteList;
import io.fabric8.openshift.api.model.Scheduler;
import io.fabric8.openshift.api.model.SchedulerList;
import io.fabric8.openshift.api.model.SecretNameReference;
import io.fabric8.openshift.api.model.SecurityContextConstraints;
import io.fabric8.openshift.api.model.SecurityContextConstraintsList;
import io.fabric8.openshift.api.model.SelfSubjectRulesReview;
import io.fabric8.openshift.api.model.SubjectAccessReview;
import io.fabric8.openshift.api.model.SubjectAccessReviewResponse;
import io.fabric8.openshift.api.model.SubjectRulesReview;
import io.fabric8.openshift.api.model.TLSProfileSpec;
import io.fabric8.openshift.api.model.TagEvent;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.api.model.TemplateList;
import io.fabric8.openshift.api.model.User;
import io.fabric8.openshift.api.model.UserList;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "APIGroup",
    "APIGroupList",
    "APIServer",
    "APIServerList",
    "AggregationRule",
    "AppliedClusterResourceQuota",
    "AppliedClusterResourceQuotaList",
    "BaseKubernetesList",
    "BuildConfigList",
    "BuildList",
    "BuildRequest",
    "ClusterNetwork",
    "ClusterNetworkList",
    "ClusterOperator",
    "ClusterOperatorList",
    "ClusterResourceQuota",
    "ClusterResourceQuotaList",
    "ClusterVersion",
    "ClusterVersionList",
    "Config",
    "ConfigMapFileReference",
    "CreateOptions",
    "DNSZone",
    "DeleteOptions",
    "DeploymentConfig",
    "DeploymentConfigList",
    "EgressNetworkPolicy",
    "EgressNetworkPolicyList",
    "FeatureGate",
    "FeatureGateList",
    "GetOptions",
    "Group",
    "GroupList",
    "Identity",
    "IdentityList",
    "ImageList",
    "ImageStreamImage",
    "ImageStreamImport",
    "ImageStreamList",
    "ImageStreamMapping",
    "ImageStreamTagList",
    "ImageTag",
    "ImageTagList",
    "Info",
    "Infrastructure",
    "InfrastructureList",
    "ListOptions",
    "LocalResourceAccessReview",
    "LocalSubjectAccessReview",
    "NetNamespace",
    "NetNamespaceList",
    "OAuth",
    "OAuthAccessToken",
    "OAuthAccessTokenList",
    "OAuthAuthorizeToken",
    "OAuthAuthorizeTokenList",
    "OAuthClient",
    "OAuthClientAuthorization",
    "OAuthClientAuthorizationList",
    "OAuthClientList",
    "OAuthList",
    "ObjectMeta",
    "OpenshiftClusterRole",
    "OpenshiftClusterRoleBinding",
    "OpenshiftClusterRoleBindingList",
    "OpenshiftClusterRoleList",
    "OpenshiftClusterRoleScopeRestriction",
    "OpenshiftRole",
    "OpenshiftRoleBinding",
    "OpenshiftRoleBindingList",
    "OpenshiftRoleBindingRestriction",
    "OpenshiftRoleBindingRestrictionSpec",
    "OpenshiftRoleList",
    "OperatorHub",
    "OperatorHubList",
    "Patch",
    "PatchOptions",
    "PodSecurityPolicyReview",
    "PodSecurityPolicySelfSubjectReview",
    "PodSecurityPolicySubjectReview",
    "Project",
    "ProjectList",
    "ProjectRequest",
    "Proxy",
    "ProxyList",
    "Quantity",
    "RangeAllocation",
    "RangeAllocationList",
    "ResourceAccessReview",
    "RootPaths",
    "Route",
    "RouteList",
    "Scheduler",
    "SchedulerList",
    "SecretNameReference",
    "SecurityContextConstraints",
    "SecurityContextConstraintsList",
    "SelfSubjectRulesReview",
    "Status",
    "SubjectAccessReview",
    "SubjectAccessReviewResponse",
    "SubjectRulesReview",
    "TLSProfileSpec",
    "TagEvent",
    "Template",
    "TemplateList",
    "Time",
    "TokenReview",
    "TypeMeta",
    "UpdateOptions",
    "User",
    "UserList"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = false, generateBuilderPackage = false, lazyCollectionInitEnabled = false, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(io.fabric8.kubernetes.api.model.ObjectMeta.class),
    @BuildableReference(LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(PodTemplateSpec.class),
    @BuildableReference(ResourceRequirements.class),
    @BuildableReference(IntOrString.class),
    @BuildableReference(ObjectReference.class),
    @BuildableReference(LocalObjectReference.class),
    @BuildableReference(PersistentVolumeClaim.class)
})
public class KubeSchema {

    /**
     * 
     * 
     */
    @JsonProperty("APIGroup")
    private APIGroup aPIGroup;
    /**
     * 
     * 
     */
    @JsonProperty("APIGroupList")
    private APIGroupList aPIGroupList;
    /**
     * 
     * 
     */
    @JsonProperty("APIServer")
    private APIServer aPIServer;
    /**
     * 
     * 
     */
    @JsonProperty("APIServerList")
    private APIServerList aPIServerList;
    /**
     * 
     * 
     */
    @JsonProperty("AggregationRule")
    private AggregationRule aggregationRule;
    /**
     * 
     * 
     */
    @JsonProperty("AppliedClusterResourceQuota")
    private AppliedClusterResourceQuota appliedClusterResourceQuota;
    /**
     * 
     * 
     */
    @JsonProperty("AppliedClusterResourceQuotaList")
    private AppliedClusterResourceQuotaList appliedClusterResourceQuotaList;
    /**
     * 
     * 
     */
    @JsonProperty("BaseKubernetesList")
    private BaseKubernetesList baseKubernetesList;
    /**
     * 
     * 
     */
    @JsonProperty("BuildConfigList")
    private BuildConfigList buildConfigList;
    /**
     * 
     * 
     */
    @JsonProperty("BuildList")
    private BuildList buildList;
    /**
     * 
     * 
     */
    @JsonProperty("BuildRequest")
    private BuildRequest buildRequest;
    /**
     * 
     * 
     */
    @JsonProperty("ClusterNetwork")
    private ClusterNetwork clusterNetwork;
    /**
     * 
     * 
     */
    @JsonProperty("ClusterNetworkList")
    private ClusterNetworkList clusterNetworkList;
    /**
     * 
     * 
     */
    @JsonProperty("ClusterOperator")
    private ClusterOperator clusterOperator;
    /**
     * 
     * 
     */
    @JsonProperty("ClusterOperatorList")
    private ClusterOperatorList clusterOperatorList;
    /**
     * 
     * 
     */
    @JsonProperty("ClusterResourceQuota")
    private ClusterResourceQuota clusterResourceQuota;
    /**
     * 
     * 
     */
    @JsonProperty("ClusterResourceQuotaList")
    private ClusterResourceQuotaList clusterResourceQuotaList;
    /**
     * 
     * 
     */
    @JsonProperty("ClusterVersion")
    private ClusterVersion clusterVersion;
    /**
     * 
     * 
     */
    @JsonProperty("ClusterVersionList")
    private ClusterVersionList clusterVersionList;
    /**
     * 
     * 
     */
    @JsonProperty("Config")
    private Config config;
    /**
     * 
     * 
     */
    @JsonProperty("ConfigMapFileReference")
    private ConfigMapFileReference configMapFileReference;
    /**
     * 
     * 
     */
    @JsonProperty("CreateOptions")
    private CreateOptions createOptions;
    /**
     * 
     * 
     */
    @JsonProperty("DNSZone")
    private DNSZone dNSZone;
    /**
     * 
     * 
     */
    @JsonProperty("DeleteOptions")
    private DeleteOptions deleteOptions;
    /**
     * 
     * 
     */
    @JsonProperty("DeploymentConfig")
    private DeploymentConfig deploymentConfig;
    /**
     * 
     * 
     */
    @JsonProperty("DeploymentConfigList")
    private DeploymentConfigList deploymentConfigList;
    /**
     * 
     * 
     */
    @JsonProperty("EgressNetworkPolicy")
    private EgressNetworkPolicy egressNetworkPolicy;
    /**
     * 
     * 
     */
    @JsonProperty("EgressNetworkPolicyList")
    private EgressNetworkPolicyList egressNetworkPolicyList;
    /**
     * 
     * 
     */
    @JsonProperty("FeatureGate")
    private FeatureGate featureGate;
    /**
     * 
     * 
     */
    @JsonProperty("FeatureGateList")
    private FeatureGateList featureGateList;
    /**
     * 
     * 
     */
    @JsonProperty("GetOptions")
    private GetOptions getOptions;
    /**
     * 
     * 
     */
    @JsonProperty("Group")
    private Group group;
    /**
     * 
     * 
     */
    @JsonProperty("GroupList")
    private GroupList groupList;
    /**
     * 
     * 
     */
    @JsonProperty("Identity")
    private Identity identity;
    /**
     * 
     * 
     */
    @JsonProperty("IdentityList")
    private IdentityList identityList;
    /**
     * 
     * 
     */
    @JsonProperty("ImageList")
    private ImageList imageList;
    /**
     * 
     * 
     */
    @JsonProperty("ImageStreamImage")
    private ImageStreamImage imageStreamImage;
    /**
     * 
     * 
     */
    @JsonProperty("ImageStreamImport")
    private ImageStreamImport imageStreamImport;
    /**
     * 
     * 
     */
    @JsonProperty("ImageStreamList")
    private ImageStreamList imageStreamList;
    /**
     * 
     * 
     */
    @JsonProperty("ImageStreamMapping")
    private ImageStreamMapping imageStreamMapping;
    /**
     * 
     * 
     */
    @JsonProperty("ImageStreamTagList")
    private ImageStreamTagList imageStreamTagList;
    /**
     * 
     * 
     */
    @JsonProperty("ImageTag")
    private ImageTag imageTag;
    /**
     * 
     * 
     */
    @JsonProperty("ImageTagList")
    private ImageTagList imageTagList;
    /**
     * 
     * 
     */
    @JsonProperty("Info")
    private Info info;
    /**
     * 
     * 
     */
    @JsonProperty("Infrastructure")
    private Infrastructure infrastructure;
    /**
     * 
     * 
     */
    @JsonProperty("InfrastructureList")
    private InfrastructureList infrastructureList;
    /**
     * 
     * 
     */
    @JsonProperty("ListOptions")
    private ListOptions listOptions;
    /**
     * 
     * 
     */
    @JsonProperty("LocalResourceAccessReview")
    private LocalResourceAccessReview localResourceAccessReview;
    /**
     * 
     * 
     */
    @JsonProperty("LocalSubjectAccessReview")
    private LocalSubjectAccessReview localSubjectAccessReview;
    /**
     * 
     * 
     */
    @JsonProperty("NetNamespace")
    private NetNamespace netNamespace;
    /**
     * 
     * 
     */
    @JsonProperty("NetNamespaceList")
    private NetNamespaceList netNamespaceList;
    /**
     * 
     * 
     */
    @JsonProperty("OAuth")
    private OAuth oAuth;
    /**
     * 
     * 
     */
    @JsonProperty("OAuthAccessToken")
    private OAuthAccessToken oAuthAccessToken;
    /**
     * 
     * 
     */
    @JsonProperty("OAuthAccessTokenList")
    private OAuthAccessTokenList oAuthAccessTokenList;
    /**
     * 
     * 
     */
    @JsonProperty("OAuthAuthorizeToken")
    private OAuthAuthorizeToken oAuthAuthorizeToken;
    /**
     * 
     * 
     */
    @JsonProperty("OAuthAuthorizeTokenList")
    private OAuthAuthorizeTokenList oAuthAuthorizeTokenList;
    /**
     * 
     * 
     */
    @JsonProperty("OAuthClient")
    private OAuthClient oAuthClient;
    /**
     * 
     * 
     */
    @JsonProperty("OAuthClientAuthorization")
    private OAuthClientAuthorization oAuthClientAuthorization;
    /**
     * 
     * 
     */
    @JsonProperty("OAuthClientAuthorizationList")
    private OAuthClientAuthorizationList oAuthClientAuthorizationList;
    /**
     * 
     * 
     */
    @JsonProperty("OAuthClientList")
    private OAuthClientList oAuthClientList;
    /**
     * 
     * 
     */
    @JsonProperty("OAuthList")
    private OAuthList oAuthList;
    /**
     * 
     * 
     */
    @JsonProperty("ObjectMeta")
    private io.fabric8.kubernetes.api.model.ObjectMeta objectMeta;
    /**
     * 
     * 
     */
    @JsonProperty("OpenshiftClusterRole")
    private ClusterRole openshiftClusterRole;
    /**
     * 
     * 
     */
    @JsonProperty("OpenshiftClusterRoleBinding")
    private ClusterRoleBinding openshiftClusterRoleBinding;
    /**
     * 
     * 
     */
    @JsonProperty("OpenshiftClusterRoleBindingList")
    private ClusterRoleBindingList openshiftClusterRoleBindingList;
    /**
     * 
     * 
     */
    @JsonProperty("OpenshiftClusterRoleList")
    private ClusterRoleList openshiftClusterRoleList;
    /**
     * 
     * 
     */
    @JsonProperty("OpenshiftClusterRoleScopeRestriction")
    private ClusterRoleScopeRestriction openshiftClusterRoleScopeRestriction;
    /**
     * 
     * 
     */
    @JsonProperty("OpenshiftRole")
    private Role openshiftRole;
    /**
     * 
     * 
     */
    @JsonProperty("OpenshiftRoleBinding")
    private RoleBinding openshiftRoleBinding;
    /**
     * 
     * 
     */
    @JsonProperty("OpenshiftRoleBindingList")
    private RoleBindingList openshiftRoleBindingList;
    /**
     * 
     * 
     */
    @JsonProperty("OpenshiftRoleBindingRestriction")
    private RoleBindingRestriction openshiftRoleBindingRestriction;
    /**
     * 
     * 
     */
    @JsonProperty("OpenshiftRoleBindingRestrictionSpec")
    private RoleBindingRestrictionSpec openshiftRoleBindingRestrictionSpec;
    /**
     * 
     * 
     */
    @JsonProperty("OpenshiftRoleList")
    private RoleList openshiftRoleList;
    /**
     * 
     * 
     */
    @JsonProperty("OperatorHub")
    private OperatorHub operatorHub;
    /**
     * 
     * 
     */
    @JsonProperty("OperatorHubList")
    private OperatorHubList operatorHubList;
    /**
     * 
     * 
     */
    @JsonProperty("Patch")
    private Patch patch;
    /**
     * 
     * 
     */
    @JsonProperty("PatchOptions")
    private PatchOptions patchOptions;
    /**
     * 
     * 
     */
    @JsonProperty("PodSecurityPolicyReview")
    private PodSecurityPolicyReview podSecurityPolicyReview;
    /**
     * 
     * 
     */
    @JsonProperty("PodSecurityPolicySelfSubjectReview")
    private PodSecurityPolicySelfSubjectReview podSecurityPolicySelfSubjectReview;
    /**
     * 
     * 
     */
    @JsonProperty("PodSecurityPolicySubjectReview")
    private PodSecurityPolicySubjectReview podSecurityPolicySubjectReview;
    /**
     * 
     * 
     */
    @JsonProperty("Project")
    private Project project;
    /**
     * 
     * 
     */
    @JsonProperty("ProjectList")
    private ProjectList projectList;
    /**
     * 
     * 
     */
    @JsonProperty("ProjectRequest")
    private ProjectRequest projectRequest;
    /**
     * 
     * 
     */
    @JsonProperty("Proxy")
    private Proxy proxy;
    /**
     * 
     * 
     */
    @JsonProperty("ProxyList")
    private ProxyList proxyList;
    /**
     * 
     * 
     */
    @JsonProperty("Quantity")
    private Quantity quantity;
    /**
     * 
     * 
     */
    @JsonProperty("RangeAllocation")
    private RangeAllocation rangeAllocation;
    /**
     * 
     * 
     */
    @JsonProperty("RangeAllocationList")
    private RangeAllocationList rangeAllocationList;
    /**
     * 
     * 
     */
    @JsonProperty("ResourceAccessReview")
    private ResourceAccessReview resourceAccessReview;
    /**
     * 
     * 
     */
    @JsonProperty("RootPaths")
    private RootPaths rootPaths;
    /**
     * 
     * 
     */
    @JsonProperty("Route")
    private Route route;
    /**
     * 
     * 
     */
    @JsonProperty("RouteList")
    private RouteList routeList;
    /**
     * 
     * 
     */
    @JsonProperty("Scheduler")
    private Scheduler scheduler;
    /**
     * 
     * 
     */
    @JsonProperty("SchedulerList")
    private SchedulerList schedulerList;
    /**
     * 
     * 
     */
    @JsonProperty("SecretNameReference")
    private SecretNameReference secretNameReference;
    /**
     * 
     * 
     */
    @JsonProperty("SecurityContextConstraints")
    private SecurityContextConstraints securityContextConstraints;
    /**
     * 
     * 
     */
    @JsonProperty("SecurityContextConstraintsList")
    private SecurityContextConstraintsList securityContextConstraintsList;
    /**
     * 
     * 
     */
    @JsonProperty("SelfSubjectRulesReview")
    private SelfSubjectRulesReview selfSubjectRulesReview;
    /**
     * 
     * 
     */
    @JsonProperty("Status")
    private Status status;
    /**
     * 
     * 
     */
    @JsonProperty("SubjectAccessReview")
    private SubjectAccessReview subjectAccessReview;
    /**
     * 
     * 
     */
    @JsonProperty("SubjectAccessReviewResponse")
    private SubjectAccessReviewResponse subjectAccessReviewResponse;
    /**
     * 
     * 
     */
    @JsonProperty("SubjectRulesReview")
    private SubjectRulesReview subjectRulesReview;
    /**
     * 
     * 
     */
    @JsonProperty("TLSProfileSpec")
    private TLSProfileSpec tLSProfileSpec;
    /**
     * 
     * 
     */
    @JsonProperty("TagEvent")
    private TagEvent tagEvent;
    /**
     * 
     * 
     */
    @JsonProperty("Template")
    private Template template;
    /**
     * 
     * 
     */
    @JsonProperty("TemplateList")
    private TemplateList templateList;
    /**
     * 
     * 
     */
    @JsonProperty("Time")
    private String time;
    /**
     * 
     * 
     */
    @JsonProperty("TokenReview")
    private TokenReview tokenReview;
    /**
     * 
     * 
     */
    @JsonProperty("TypeMeta")
    private TypeMeta typeMeta;
    /**
     * 
     * 
     */
    @JsonProperty("UpdateOptions")
    private UpdateOptions updateOptions;
    /**
     * 
     * 
     */
    @JsonProperty("User")
    private User user;
    /**
     * 
     * 
     */
    @JsonProperty("UserList")
    private UserList userList;
    @JsonIgnore
    private Map<java.lang.String, Object> additionalProperties = new HashMap<java.lang.String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public KubeSchema() {
    }

    /**
     * 
     * @param listOptions
     * @param aPIGroupList
     * @param schedulerList
     * @param aggregationRule
     * @param openshiftClusterRole
     * @param patch
     * @param securityContextConstraintsList
     * @param oAuthClientAuthorizationList
     * @param userList
     * @param oAuthList
     * @param openshiftClusterRoleBindingList
     * @param appliedClusterResourceQuota
     * @param deleteOptions
     * @param clusterResourceQuotaList
     * @param operatorHubList
     * @param clusterVersionList
     * @param imageStreamImage
     * @param groupList
     * @param tagEvent
     * @param imageTagList
     * @param projectRequest
     * @param clusterResourceQuota
     * @param proxy
     * @param route
     * @param tokenReview
     * @param getOptions
     * @param imageList
     * @param status
     * @param template
     * @param buildRequest
     * @param rangeAllocationList
     * @param selfSubjectRulesReview
     * @param baseKubernetesList
     * @param subjectAccessReviewResponse
     * @param clusterNetwork
     * @param openshiftRoleBindingList
     * @param subjectRulesReview
     * @param egressNetworkPolicyList
     * @param identity
     * @param oAuthAccessTokenList
     * @param buildList
     * @param rootPaths
     * @param featureGate
     * @param oAuthClientList
     * @param patchOptions
     * @param oAuthAuthorizeTokenList
     * @param aPIServerList
     * @param imageStreamMapping
     * @param openshiftRoleBindingRestrictionSpec
     * @param rangeAllocation
     * @param createOptions
     * @param openshiftRoleBindingRestriction
     * @param aPIGroup
     * @param objectMeta
     * @param oAuthClient
     * @param config
     * @param routeList
     * @param securityContextConstraints
     * @param resourceAccessReview
     * @param secretNameReference
     * @param openshiftRole
     * @param infrastructureList
     * @param netNamespaceList
     * @param openshiftClusterRoleScopeRestriction
     * @param project
     * @param oAuth
     * @param clusterOperator
     * @param podSecurityPolicyReview
     * @param deploymentConfig
     * @param openshiftClusterRoleBinding
     * @param egressNetworkPolicy
     * @param group
     * @param info
     * @param projectList
     * @param oAuthAccessToken
     * @param openshiftClusterRoleList
     * @param operatorHub
     * @param imageStreamImport
     * @param aPIServer
     * @param imageStreamList
     * @param oAuthClientAuthorization
     * @param localResourceAccessReview
     * @param imageStreamTagList
     * @param openshiftRoleList
     * @param dNSZone
     * @param buildConfigList
     * @param proxyList
     * @param identityList
     * @param configMapFileReference
     * @param subjectAccessReview
     * @param openshiftRoleBinding
     * @param featureGateList
     * @param clusterNetworkList
     * @param podSecurityPolicySubjectReview
     * @param updateOptions
     * @param clusterVersion
     * @param scheduler
     * @param netNamespace
     * @param oAuthAuthorizeToken
     * @param clusterOperatorList
     * @param appliedClusterResourceQuotaList
     * @param localSubjectAccessReview
     * @param quantity
     * @param templateList
     * @param deploymentConfigList
     * @param podSecurityPolicySelfSubjectReview
     * @param typeMeta
     * @param infrastructure
     * @param tLSProfileSpec
     * @param time
     * @param imageTag
     * @param user
     */
    public KubeSchema(APIGroup aPIGroup, APIGroupList aPIGroupList, APIServer aPIServer, APIServerList aPIServerList, AggregationRule aggregationRule, AppliedClusterResourceQuota appliedClusterResourceQuota, AppliedClusterResourceQuotaList appliedClusterResourceQuotaList, BaseKubernetesList baseKubernetesList, BuildConfigList buildConfigList, BuildList buildList, BuildRequest buildRequest, ClusterNetwork clusterNetwork, ClusterNetworkList clusterNetworkList, ClusterOperator clusterOperator, ClusterOperatorList clusterOperatorList, ClusterResourceQuota clusterResourceQuota, ClusterResourceQuotaList clusterResourceQuotaList, ClusterVersion clusterVersion, ClusterVersionList clusterVersionList, Config config, ConfigMapFileReference configMapFileReference, CreateOptions createOptions, DNSZone dNSZone, DeleteOptions deleteOptions, DeploymentConfig deploymentConfig, DeploymentConfigList deploymentConfigList, EgressNetworkPolicy egressNetworkPolicy, EgressNetworkPolicyList egressNetworkPolicyList, FeatureGate featureGate, FeatureGateList featureGateList, GetOptions getOptions, Group group, GroupList groupList, Identity identity, IdentityList identityList, ImageList imageList, ImageStreamImage imageStreamImage, ImageStreamImport imageStreamImport, ImageStreamList imageStreamList, ImageStreamMapping imageStreamMapping, ImageStreamTagList imageStreamTagList, ImageTag imageTag, ImageTagList imageTagList, Info info, Infrastructure infrastructure, InfrastructureList infrastructureList, ListOptions listOptions, LocalResourceAccessReview localResourceAccessReview, LocalSubjectAccessReview localSubjectAccessReview, NetNamespace netNamespace, NetNamespaceList netNamespaceList, OAuth oAuth, OAuthAccessToken oAuthAccessToken, OAuthAccessTokenList oAuthAccessTokenList, OAuthAuthorizeToken oAuthAuthorizeToken, OAuthAuthorizeTokenList oAuthAuthorizeTokenList, OAuthClient oAuthClient, OAuthClientAuthorization oAuthClientAuthorization, OAuthClientAuthorizationList oAuthClientAuthorizationList, OAuthClientList oAuthClientList, OAuthList oAuthList, io.fabric8.kubernetes.api.model.ObjectMeta objectMeta, ClusterRole openshiftClusterRole, ClusterRoleBinding openshiftClusterRoleBinding, ClusterRoleBindingList openshiftClusterRoleBindingList, ClusterRoleList openshiftClusterRoleList, ClusterRoleScopeRestriction openshiftClusterRoleScopeRestriction, Role openshiftRole, RoleBinding openshiftRoleBinding, RoleBindingList openshiftRoleBindingList, RoleBindingRestriction openshiftRoleBindingRestriction, RoleBindingRestrictionSpec openshiftRoleBindingRestrictionSpec, RoleList openshiftRoleList, OperatorHub operatorHub, OperatorHubList operatorHubList, Patch patch, PatchOptions patchOptions, PodSecurityPolicyReview podSecurityPolicyReview, PodSecurityPolicySelfSubjectReview podSecurityPolicySelfSubjectReview, PodSecurityPolicySubjectReview podSecurityPolicySubjectReview, Project project, ProjectList projectList, ProjectRequest projectRequest, Proxy proxy, ProxyList proxyList, Quantity quantity, RangeAllocation rangeAllocation, RangeAllocationList rangeAllocationList, ResourceAccessReview resourceAccessReview, RootPaths rootPaths, Route route, RouteList routeList, Scheduler scheduler, SchedulerList schedulerList, SecretNameReference secretNameReference, SecurityContextConstraints securityContextConstraints, SecurityContextConstraintsList securityContextConstraintsList, SelfSubjectRulesReview selfSubjectRulesReview, Status status, SubjectAccessReview subjectAccessReview, SubjectAccessReviewResponse subjectAccessReviewResponse, SubjectRulesReview subjectRulesReview, TLSProfileSpec tLSProfileSpec, TagEvent tagEvent, Template template, TemplateList templateList, String time, TokenReview tokenReview, TypeMeta typeMeta, UpdateOptions updateOptions, User user, UserList userList) {
        this.aPIGroup = aPIGroup;
        this.aPIGroupList = aPIGroupList;
        this.aPIServer = aPIServer;
        this.aPIServerList = aPIServerList;
        this.aggregationRule = aggregationRule;
        this.appliedClusterResourceQuota = appliedClusterResourceQuota;
        this.appliedClusterResourceQuotaList = appliedClusterResourceQuotaList;
        this.baseKubernetesList = baseKubernetesList;
        this.buildConfigList = buildConfigList;
        this.buildList = buildList;
        this.buildRequest = buildRequest;
        this.clusterNetwork = clusterNetwork;
        this.clusterNetworkList = clusterNetworkList;
        this.clusterOperator = clusterOperator;
        this.clusterOperatorList = clusterOperatorList;
        this.clusterResourceQuota = clusterResourceQuota;
        this.clusterResourceQuotaList = clusterResourceQuotaList;
        this.clusterVersion = clusterVersion;
        this.clusterVersionList = clusterVersionList;
        this.config = config;
        this.configMapFileReference = configMapFileReference;
        this.createOptions = createOptions;
        this.dNSZone = dNSZone;
        this.deleteOptions = deleteOptions;
        this.deploymentConfig = deploymentConfig;
        this.deploymentConfigList = deploymentConfigList;
        this.egressNetworkPolicy = egressNetworkPolicy;
        this.egressNetworkPolicyList = egressNetworkPolicyList;
        this.featureGate = featureGate;
        this.featureGateList = featureGateList;
        this.getOptions = getOptions;
        this.group = group;
        this.groupList = groupList;
        this.identity = identity;
        this.identityList = identityList;
        this.imageList = imageList;
        this.imageStreamImage = imageStreamImage;
        this.imageStreamImport = imageStreamImport;
        this.imageStreamList = imageStreamList;
        this.imageStreamMapping = imageStreamMapping;
        this.imageStreamTagList = imageStreamTagList;
        this.imageTag = imageTag;
        this.imageTagList = imageTagList;
        this.info = info;
        this.infrastructure = infrastructure;
        this.infrastructureList = infrastructureList;
        this.listOptions = listOptions;
        this.localResourceAccessReview = localResourceAccessReview;
        this.localSubjectAccessReview = localSubjectAccessReview;
        this.netNamespace = netNamespace;
        this.netNamespaceList = netNamespaceList;
        this.oAuth = oAuth;
        this.oAuthAccessToken = oAuthAccessToken;
        this.oAuthAccessTokenList = oAuthAccessTokenList;
        this.oAuthAuthorizeToken = oAuthAuthorizeToken;
        this.oAuthAuthorizeTokenList = oAuthAuthorizeTokenList;
        this.oAuthClient = oAuthClient;
        this.oAuthClientAuthorization = oAuthClientAuthorization;
        this.oAuthClientAuthorizationList = oAuthClientAuthorizationList;
        this.oAuthClientList = oAuthClientList;
        this.oAuthList = oAuthList;
        this.objectMeta = objectMeta;
        this.openshiftClusterRole = openshiftClusterRole;
        this.openshiftClusterRoleBinding = openshiftClusterRoleBinding;
        this.openshiftClusterRoleBindingList = openshiftClusterRoleBindingList;
        this.openshiftClusterRoleList = openshiftClusterRoleList;
        this.openshiftClusterRoleScopeRestriction = openshiftClusterRoleScopeRestriction;
        this.openshiftRole = openshiftRole;
        this.openshiftRoleBinding = openshiftRoleBinding;
        this.openshiftRoleBindingList = openshiftRoleBindingList;
        this.openshiftRoleBindingRestriction = openshiftRoleBindingRestriction;
        this.openshiftRoleBindingRestrictionSpec = openshiftRoleBindingRestrictionSpec;
        this.openshiftRoleList = openshiftRoleList;
        this.operatorHub = operatorHub;
        this.operatorHubList = operatorHubList;
        this.patch = patch;
        this.patchOptions = patchOptions;
        this.podSecurityPolicyReview = podSecurityPolicyReview;
        this.podSecurityPolicySelfSubjectReview = podSecurityPolicySelfSubjectReview;
        this.podSecurityPolicySubjectReview = podSecurityPolicySubjectReview;
        this.project = project;
        this.projectList = projectList;
        this.projectRequest = projectRequest;
        this.proxy = proxy;
        this.proxyList = proxyList;
        this.quantity = quantity;
        this.rangeAllocation = rangeAllocation;
        this.rangeAllocationList = rangeAllocationList;
        this.resourceAccessReview = resourceAccessReview;
        this.rootPaths = rootPaths;
        this.route = route;
        this.routeList = routeList;
        this.scheduler = scheduler;
        this.schedulerList = schedulerList;
        this.secretNameReference = secretNameReference;
        this.securityContextConstraints = securityContextConstraints;
        this.securityContextConstraintsList = securityContextConstraintsList;
        this.selfSubjectRulesReview = selfSubjectRulesReview;
        this.status = status;
        this.subjectAccessReview = subjectAccessReview;
        this.subjectAccessReviewResponse = subjectAccessReviewResponse;
        this.subjectRulesReview = subjectRulesReview;
        this.tLSProfileSpec = tLSProfileSpec;
        this.tagEvent = tagEvent;
        this.template = template;
        this.templateList = templateList;
        this.time = time;
        this.tokenReview = tokenReview;
        this.typeMeta = typeMeta;
        this.updateOptions = updateOptions;
        this.user = user;
        this.userList = userList;
    }

    /**
     * 
     * 
     * @return
     *     The aPIGroup
     */
    @JsonProperty("APIGroup")
    public APIGroup getAPIGroup() {
        return aPIGroup;
    }

    /**
     * 
     * 
     * @param aPIGroup
     *     The APIGroup
     */
    @JsonProperty("APIGroup")
    public void setAPIGroup(APIGroup aPIGroup) {
        this.aPIGroup = aPIGroup;
    }

    /**
     * 
     * 
     * @return
     *     The aPIGroupList
     */
    @JsonProperty("APIGroupList")
    public APIGroupList getAPIGroupList() {
        return aPIGroupList;
    }

    /**
     * 
     * 
     * @param aPIGroupList
     *     The APIGroupList
     */
    @JsonProperty("APIGroupList")
    public void setAPIGroupList(APIGroupList aPIGroupList) {
        this.aPIGroupList = aPIGroupList;
    }

    /**
     * 
     * 
     * @return
     *     The aPIServer
     */
    @JsonProperty("APIServer")
    public APIServer getAPIServer() {
        return aPIServer;
    }

    /**
     * 
     * 
     * @param aPIServer
     *     The APIServer
     */
    @JsonProperty("APIServer")
    public void setAPIServer(APIServer aPIServer) {
        this.aPIServer = aPIServer;
    }

    /**
     * 
     * 
     * @return
     *     The aPIServerList
     */
    @JsonProperty("APIServerList")
    public APIServerList getAPIServerList() {
        return aPIServerList;
    }

    /**
     * 
     * 
     * @param aPIServerList
     *     The APIServerList
     */
    @JsonProperty("APIServerList")
    public void setAPIServerList(APIServerList aPIServerList) {
        this.aPIServerList = aPIServerList;
    }

    /**
     * 
     * 
     * @return
     *     The aggregationRule
     */
    @JsonProperty("AggregationRule")
    public AggregationRule getAggregationRule() {
        return aggregationRule;
    }

    /**
     * 
     * 
     * @param aggregationRule
     *     The AggregationRule
     */
    @JsonProperty("AggregationRule")
    public void setAggregationRule(AggregationRule aggregationRule) {
        this.aggregationRule = aggregationRule;
    }

    /**
     * 
     * 
     * @return
     *     The appliedClusterResourceQuota
     */
    @JsonProperty("AppliedClusterResourceQuota")
    public AppliedClusterResourceQuota getAppliedClusterResourceQuota() {
        return appliedClusterResourceQuota;
    }

    /**
     * 
     * 
     * @param appliedClusterResourceQuota
     *     The AppliedClusterResourceQuota
     */
    @JsonProperty("AppliedClusterResourceQuota")
    public void setAppliedClusterResourceQuota(AppliedClusterResourceQuota appliedClusterResourceQuota) {
        this.appliedClusterResourceQuota = appliedClusterResourceQuota;
    }

    /**
     * 
     * 
     * @return
     *     The appliedClusterResourceQuotaList
     */
    @JsonProperty("AppliedClusterResourceQuotaList")
    public AppliedClusterResourceQuotaList getAppliedClusterResourceQuotaList() {
        return appliedClusterResourceQuotaList;
    }

    /**
     * 
     * 
     * @param appliedClusterResourceQuotaList
     *     The AppliedClusterResourceQuotaList
     */
    @JsonProperty("AppliedClusterResourceQuotaList")
    public void setAppliedClusterResourceQuotaList(AppliedClusterResourceQuotaList appliedClusterResourceQuotaList) {
        this.appliedClusterResourceQuotaList = appliedClusterResourceQuotaList;
    }

    /**
     * 
     * 
     * @return
     *     The baseKubernetesList
     */
    @JsonProperty("BaseKubernetesList")
    public BaseKubernetesList getBaseKubernetesList() {
        return baseKubernetesList;
    }

    /**
     * 
     * 
     * @param baseKubernetesList
     *     The BaseKubernetesList
     */
    @JsonProperty("BaseKubernetesList")
    public void setBaseKubernetesList(BaseKubernetesList baseKubernetesList) {
        this.baseKubernetesList = baseKubernetesList;
    }

    /**
     * 
     * 
     * @return
     *     The buildConfigList
     */
    @JsonProperty("BuildConfigList")
    public BuildConfigList getBuildConfigList() {
        return buildConfigList;
    }

    /**
     * 
     * 
     * @param buildConfigList
     *     The BuildConfigList
     */
    @JsonProperty("BuildConfigList")
    public void setBuildConfigList(BuildConfigList buildConfigList) {
        this.buildConfigList = buildConfigList;
    }

    /**
     * 
     * 
     * @return
     *     The buildList
     */
    @JsonProperty("BuildList")
    public BuildList getBuildList() {
        return buildList;
    }

    /**
     * 
     * 
     * @param buildList
     *     The BuildList
     */
    @JsonProperty("BuildList")
    public void setBuildList(BuildList buildList) {
        this.buildList = buildList;
    }

    /**
     * 
     * 
     * @return
     *     The buildRequest
     */
    @JsonProperty("BuildRequest")
    public BuildRequest getBuildRequest() {
        return buildRequest;
    }

    /**
     * 
     * 
     * @param buildRequest
     *     The BuildRequest
     */
    @JsonProperty("BuildRequest")
    public void setBuildRequest(BuildRequest buildRequest) {
        this.buildRequest = buildRequest;
    }

    /**
     * 
     * 
     * @return
     *     The clusterNetwork
     */
    @JsonProperty("ClusterNetwork")
    public ClusterNetwork getClusterNetwork() {
        return clusterNetwork;
    }

    /**
     * 
     * 
     * @param clusterNetwork
     *     The ClusterNetwork
     */
    @JsonProperty("ClusterNetwork")
    public void setClusterNetwork(ClusterNetwork clusterNetwork) {
        this.clusterNetwork = clusterNetwork;
    }

    /**
     * 
     * 
     * @return
     *     The clusterNetworkList
     */
    @JsonProperty("ClusterNetworkList")
    public ClusterNetworkList getClusterNetworkList() {
        return clusterNetworkList;
    }

    /**
     * 
     * 
     * @param clusterNetworkList
     *     The ClusterNetworkList
     */
    @JsonProperty("ClusterNetworkList")
    public void setClusterNetworkList(ClusterNetworkList clusterNetworkList) {
        this.clusterNetworkList = clusterNetworkList;
    }

    /**
     * 
     * 
     * @return
     *     The clusterOperator
     */
    @JsonProperty("ClusterOperator")
    public ClusterOperator getClusterOperator() {
        return clusterOperator;
    }

    /**
     * 
     * 
     * @param clusterOperator
     *     The ClusterOperator
     */
    @JsonProperty("ClusterOperator")
    public void setClusterOperator(ClusterOperator clusterOperator) {
        this.clusterOperator = clusterOperator;
    }

    /**
     * 
     * 
     * @return
     *     The clusterOperatorList
     */
    @JsonProperty("ClusterOperatorList")
    public ClusterOperatorList getClusterOperatorList() {
        return clusterOperatorList;
    }

    /**
     * 
     * 
     * @param clusterOperatorList
     *     The ClusterOperatorList
     */
    @JsonProperty("ClusterOperatorList")
    public void setClusterOperatorList(ClusterOperatorList clusterOperatorList) {
        this.clusterOperatorList = clusterOperatorList;
    }

    /**
     * 
     * 
     * @return
     *     The clusterResourceQuota
     */
    @JsonProperty("ClusterResourceQuota")
    public ClusterResourceQuota getClusterResourceQuota() {
        return clusterResourceQuota;
    }

    /**
     * 
     * 
     * @param clusterResourceQuota
     *     The ClusterResourceQuota
     */
    @JsonProperty("ClusterResourceQuota")
    public void setClusterResourceQuota(ClusterResourceQuota clusterResourceQuota) {
        this.clusterResourceQuota = clusterResourceQuota;
    }

    /**
     * 
     * 
     * @return
     *     The clusterResourceQuotaList
     */
    @JsonProperty("ClusterResourceQuotaList")
    public ClusterResourceQuotaList getClusterResourceQuotaList() {
        return clusterResourceQuotaList;
    }

    /**
     * 
     * 
     * @param clusterResourceQuotaList
     *     The ClusterResourceQuotaList
     */
    @JsonProperty("ClusterResourceQuotaList")
    public void setClusterResourceQuotaList(ClusterResourceQuotaList clusterResourceQuotaList) {
        this.clusterResourceQuotaList = clusterResourceQuotaList;
    }

    /**
     * 
     * 
     * @return
     *     The clusterVersion
     */
    @JsonProperty("ClusterVersion")
    public ClusterVersion getClusterVersion() {
        return clusterVersion;
    }

    /**
     * 
     * 
     * @param clusterVersion
     *     The ClusterVersion
     */
    @JsonProperty("ClusterVersion")
    public void setClusterVersion(ClusterVersion clusterVersion) {
        this.clusterVersion = clusterVersion;
    }

    /**
     * 
     * 
     * @return
     *     The clusterVersionList
     */
    @JsonProperty("ClusterVersionList")
    public ClusterVersionList getClusterVersionList() {
        return clusterVersionList;
    }

    /**
     * 
     * 
     * @param clusterVersionList
     *     The ClusterVersionList
     */
    @JsonProperty("ClusterVersionList")
    public void setClusterVersionList(ClusterVersionList clusterVersionList) {
        this.clusterVersionList = clusterVersionList;
    }

    /**
     * 
     * 
     * @return
     *     The config
     */
    @JsonProperty("Config")
    public Config getConfig() {
        return config;
    }

    /**
     * 
     * 
     * @param config
     *     The Config
     */
    @JsonProperty("Config")
    public void setConfig(Config config) {
        this.config = config;
    }

    /**
     * 
     * 
     * @return
     *     The configMapFileReference
     */
    @JsonProperty("ConfigMapFileReference")
    public ConfigMapFileReference getConfigMapFileReference() {
        return configMapFileReference;
    }

    /**
     * 
     * 
     * @param configMapFileReference
     *     The ConfigMapFileReference
     */
    @JsonProperty("ConfigMapFileReference")
    public void setConfigMapFileReference(ConfigMapFileReference configMapFileReference) {
        this.configMapFileReference = configMapFileReference;
    }

    /**
     * 
     * 
     * @return
     *     The createOptions
     */
    @JsonProperty("CreateOptions")
    public CreateOptions getCreateOptions() {
        return createOptions;
    }

    /**
     * 
     * 
     * @param createOptions
     *     The CreateOptions
     */
    @JsonProperty("CreateOptions")
    public void setCreateOptions(CreateOptions createOptions) {
        this.createOptions = createOptions;
    }

    /**
     * 
     * 
     * @return
     *     The dNSZone
     */
    @JsonProperty("DNSZone")
    public DNSZone getDNSZone() {
        return dNSZone;
    }

    /**
     * 
     * 
     * @param dNSZone
     *     The DNSZone
     */
    @JsonProperty("DNSZone")
    public void setDNSZone(DNSZone dNSZone) {
        this.dNSZone = dNSZone;
    }

    /**
     * 
     * 
     * @return
     *     The deleteOptions
     */
    @JsonProperty("DeleteOptions")
    public DeleteOptions getDeleteOptions() {
        return deleteOptions;
    }

    /**
     * 
     * 
     * @param deleteOptions
     *     The DeleteOptions
     */
    @JsonProperty("DeleteOptions")
    public void setDeleteOptions(DeleteOptions deleteOptions) {
        this.deleteOptions = deleteOptions;
    }

    /**
     * 
     * 
     * @return
     *     The deploymentConfig
     */
    @JsonProperty("DeploymentConfig")
    public DeploymentConfig getDeploymentConfig() {
        return deploymentConfig;
    }

    /**
     * 
     * 
     * @param deploymentConfig
     *     The DeploymentConfig
     */
    @JsonProperty("DeploymentConfig")
    public void setDeploymentConfig(DeploymentConfig deploymentConfig) {
        this.deploymentConfig = deploymentConfig;
    }

    /**
     * 
     * 
     * @return
     *     The deploymentConfigList
     */
    @JsonProperty("DeploymentConfigList")
    public DeploymentConfigList getDeploymentConfigList() {
        return deploymentConfigList;
    }

    /**
     * 
     * 
     * @param deploymentConfigList
     *     The DeploymentConfigList
     */
    @JsonProperty("DeploymentConfigList")
    public void setDeploymentConfigList(DeploymentConfigList deploymentConfigList) {
        this.deploymentConfigList = deploymentConfigList;
    }

    /**
     * 
     * 
     * @return
     *     The egressNetworkPolicy
     */
    @JsonProperty("EgressNetworkPolicy")
    public EgressNetworkPolicy getEgressNetworkPolicy() {
        return egressNetworkPolicy;
    }

    /**
     * 
     * 
     * @param egressNetworkPolicy
     *     The EgressNetworkPolicy
     */
    @JsonProperty("EgressNetworkPolicy")
    public void setEgressNetworkPolicy(EgressNetworkPolicy egressNetworkPolicy) {
        this.egressNetworkPolicy = egressNetworkPolicy;
    }

    /**
     * 
     * 
     * @return
     *     The egressNetworkPolicyList
     */
    @JsonProperty("EgressNetworkPolicyList")
    public EgressNetworkPolicyList getEgressNetworkPolicyList() {
        return egressNetworkPolicyList;
    }

    /**
     * 
     * 
     * @param egressNetworkPolicyList
     *     The EgressNetworkPolicyList
     */
    @JsonProperty("EgressNetworkPolicyList")
    public void setEgressNetworkPolicyList(EgressNetworkPolicyList egressNetworkPolicyList) {
        this.egressNetworkPolicyList = egressNetworkPolicyList;
    }

    /**
     * 
     * 
     * @return
     *     The featureGate
     */
    @JsonProperty("FeatureGate")
    public FeatureGate getFeatureGate() {
        return featureGate;
    }

    /**
     * 
     * 
     * @param featureGate
     *     The FeatureGate
     */
    @JsonProperty("FeatureGate")
    public void setFeatureGate(FeatureGate featureGate) {
        this.featureGate = featureGate;
    }

    /**
     * 
     * 
     * @return
     *     The featureGateList
     */
    @JsonProperty("FeatureGateList")
    public FeatureGateList getFeatureGateList() {
        return featureGateList;
    }

    /**
     * 
     * 
     * @param featureGateList
     *     The FeatureGateList
     */
    @JsonProperty("FeatureGateList")
    public void setFeatureGateList(FeatureGateList featureGateList) {
        this.featureGateList = featureGateList;
    }

    /**
     * 
     * 
     * @return
     *     The getOptions
     */
    @JsonProperty("GetOptions")
    public GetOptions getGetOptions() {
        return getOptions;
    }

    /**
     * 
     * 
     * @param getOptions
     *     The GetOptions
     */
    @JsonProperty("GetOptions")
    public void setGetOptions(GetOptions getOptions) {
        this.getOptions = getOptions;
    }

    /**
     * 
     * 
     * @return
     *     The group
     */
    @JsonProperty("Group")
    public Group getGroup() {
        return group;
    }

    /**
     * 
     * 
     * @param group
     *     The Group
     */
    @JsonProperty("Group")
    public void setGroup(Group group) {
        this.group = group;
    }

    /**
     * 
     * 
     * @return
     *     The groupList
     */
    @JsonProperty("GroupList")
    public GroupList getGroupList() {
        return groupList;
    }

    /**
     * 
     * 
     * @param groupList
     *     The GroupList
     */
    @JsonProperty("GroupList")
    public void setGroupList(GroupList groupList) {
        this.groupList = groupList;
    }

    /**
     * 
     * 
     * @return
     *     The identity
     */
    @JsonProperty("Identity")
    public Identity getIdentity() {
        return identity;
    }

    /**
     * 
     * 
     * @param identity
     *     The Identity
     */
    @JsonProperty("Identity")
    public void setIdentity(Identity identity) {
        this.identity = identity;
    }

    /**
     * 
     * 
     * @return
     *     The identityList
     */
    @JsonProperty("IdentityList")
    public IdentityList getIdentityList() {
        return identityList;
    }

    /**
     * 
     * 
     * @param identityList
     *     The IdentityList
     */
    @JsonProperty("IdentityList")
    public void setIdentityList(IdentityList identityList) {
        this.identityList = identityList;
    }

    /**
     * 
     * 
     * @return
     *     The imageList
     */
    @JsonProperty("ImageList")
    public ImageList getImageList() {
        return imageList;
    }

    /**
     * 
     * 
     * @param imageList
     *     The ImageList
     */
    @JsonProperty("ImageList")
    public void setImageList(ImageList imageList) {
        this.imageList = imageList;
    }

    /**
     * 
     * 
     * @return
     *     The imageStreamImage
     */
    @JsonProperty("ImageStreamImage")
    public ImageStreamImage getImageStreamImage() {
        return imageStreamImage;
    }

    /**
     * 
     * 
     * @param imageStreamImage
     *     The ImageStreamImage
     */
    @JsonProperty("ImageStreamImage")
    public void setImageStreamImage(ImageStreamImage imageStreamImage) {
        this.imageStreamImage = imageStreamImage;
    }

    /**
     * 
     * 
     * @return
     *     The imageStreamImport
     */
    @JsonProperty("ImageStreamImport")
    public ImageStreamImport getImageStreamImport() {
        return imageStreamImport;
    }

    /**
     * 
     * 
     * @param imageStreamImport
     *     The ImageStreamImport
     */
    @JsonProperty("ImageStreamImport")
    public void setImageStreamImport(ImageStreamImport imageStreamImport) {
        this.imageStreamImport = imageStreamImport;
    }

    /**
     * 
     * 
     * @return
     *     The imageStreamList
     */
    @JsonProperty("ImageStreamList")
    public ImageStreamList getImageStreamList() {
        return imageStreamList;
    }

    /**
     * 
     * 
     * @param imageStreamList
     *     The ImageStreamList
     */
    @JsonProperty("ImageStreamList")
    public void setImageStreamList(ImageStreamList imageStreamList) {
        this.imageStreamList = imageStreamList;
    }

    /**
     * 
     * 
     * @return
     *     The imageStreamMapping
     */
    @JsonProperty("ImageStreamMapping")
    public ImageStreamMapping getImageStreamMapping() {
        return imageStreamMapping;
    }

    /**
     * 
     * 
     * @param imageStreamMapping
     *     The ImageStreamMapping
     */
    @JsonProperty("ImageStreamMapping")
    public void setImageStreamMapping(ImageStreamMapping imageStreamMapping) {
        this.imageStreamMapping = imageStreamMapping;
    }

    /**
     * 
     * 
     * @return
     *     The imageStreamTagList
     */
    @JsonProperty("ImageStreamTagList")
    public ImageStreamTagList getImageStreamTagList() {
        return imageStreamTagList;
    }

    /**
     * 
     * 
     * @param imageStreamTagList
     *     The ImageStreamTagList
     */
    @JsonProperty("ImageStreamTagList")
    public void setImageStreamTagList(ImageStreamTagList imageStreamTagList) {
        this.imageStreamTagList = imageStreamTagList;
    }

    /**
     * 
     * 
     * @return
     *     The imageTag
     */
    @JsonProperty("ImageTag")
    public ImageTag getImageTag() {
        return imageTag;
    }

    /**
     * 
     * 
     * @param imageTag
     *     The ImageTag
     */
    @JsonProperty("ImageTag")
    public void setImageTag(ImageTag imageTag) {
        this.imageTag = imageTag;
    }

    /**
     * 
     * 
     * @return
     *     The imageTagList
     */
    @JsonProperty("ImageTagList")
    public ImageTagList getImageTagList() {
        return imageTagList;
    }

    /**
     * 
     * 
     * @param imageTagList
     *     The ImageTagList
     */
    @JsonProperty("ImageTagList")
    public void setImageTagList(ImageTagList imageTagList) {
        this.imageTagList = imageTagList;
    }

    /**
     * 
     * 
     * @return
     *     The info
     */
    @JsonProperty("Info")
    public Info getInfo() {
        return info;
    }

    /**
     * 
     * 
     * @param info
     *     The Info
     */
    @JsonProperty("Info")
    public void setInfo(Info info) {
        this.info = info;
    }

    /**
     * 
     * 
     * @return
     *     The infrastructure
     */
    @JsonProperty("Infrastructure")
    public Infrastructure getInfrastructure() {
        return infrastructure;
    }

    /**
     * 
     * 
     * @param infrastructure
     *     The Infrastructure
     */
    @JsonProperty("Infrastructure")
    public void setInfrastructure(Infrastructure infrastructure) {
        this.infrastructure = infrastructure;
    }

    /**
     * 
     * 
     * @return
     *     The infrastructureList
     */
    @JsonProperty("InfrastructureList")
    public InfrastructureList getInfrastructureList() {
        return infrastructureList;
    }

    /**
     * 
     * 
     * @param infrastructureList
     *     The InfrastructureList
     */
    @JsonProperty("InfrastructureList")
    public void setInfrastructureList(InfrastructureList infrastructureList) {
        this.infrastructureList = infrastructureList;
    }

    /**
     * 
     * 
     * @return
     *     The listOptions
     */
    @JsonProperty("ListOptions")
    public ListOptions getListOptions() {
        return listOptions;
    }

    /**
     * 
     * 
     * @param listOptions
     *     The ListOptions
     */
    @JsonProperty("ListOptions")
    public void setListOptions(ListOptions listOptions) {
        this.listOptions = listOptions;
    }

    /**
     * 
     * 
     * @return
     *     The localResourceAccessReview
     */
    @JsonProperty("LocalResourceAccessReview")
    public LocalResourceAccessReview getLocalResourceAccessReview() {
        return localResourceAccessReview;
    }

    /**
     * 
     * 
     * @param localResourceAccessReview
     *     The LocalResourceAccessReview
     */
    @JsonProperty("LocalResourceAccessReview")
    public void setLocalResourceAccessReview(LocalResourceAccessReview localResourceAccessReview) {
        this.localResourceAccessReview = localResourceAccessReview;
    }

    /**
     * 
     * 
     * @return
     *     The localSubjectAccessReview
     */
    @JsonProperty("LocalSubjectAccessReview")
    public LocalSubjectAccessReview getLocalSubjectAccessReview() {
        return localSubjectAccessReview;
    }

    /**
     * 
     * 
     * @param localSubjectAccessReview
     *     The LocalSubjectAccessReview
     */
    @JsonProperty("LocalSubjectAccessReview")
    public void setLocalSubjectAccessReview(LocalSubjectAccessReview localSubjectAccessReview) {
        this.localSubjectAccessReview = localSubjectAccessReview;
    }

    /**
     * 
     * 
     * @return
     *     The netNamespace
     */
    @JsonProperty("NetNamespace")
    public NetNamespace getNetNamespace() {
        return netNamespace;
    }

    /**
     * 
     * 
     * @param netNamespace
     *     The NetNamespace
     */
    @JsonProperty("NetNamespace")
    public void setNetNamespace(NetNamespace netNamespace) {
        this.netNamespace = netNamespace;
    }

    /**
     * 
     * 
     * @return
     *     The netNamespaceList
     */
    @JsonProperty("NetNamespaceList")
    public NetNamespaceList getNetNamespaceList() {
        return netNamespaceList;
    }

    /**
     * 
     * 
     * @param netNamespaceList
     *     The NetNamespaceList
     */
    @JsonProperty("NetNamespaceList")
    public void setNetNamespaceList(NetNamespaceList netNamespaceList) {
        this.netNamespaceList = netNamespaceList;
    }

    /**
     * 
     * 
     * @return
     *     The oAuth
     */
    @JsonProperty("OAuth")
    public OAuth getOAuth() {
        return oAuth;
    }

    /**
     * 
     * 
     * @param oAuth
     *     The OAuth
     */
    @JsonProperty("OAuth")
    public void setOAuth(OAuth oAuth) {
        this.oAuth = oAuth;
    }

    /**
     * 
     * 
     * @return
     *     The oAuthAccessToken
     */
    @JsonProperty("OAuthAccessToken")
    public OAuthAccessToken getOAuthAccessToken() {
        return oAuthAccessToken;
    }

    /**
     * 
     * 
     * @param oAuthAccessToken
     *     The OAuthAccessToken
     */
    @JsonProperty("OAuthAccessToken")
    public void setOAuthAccessToken(OAuthAccessToken oAuthAccessToken) {
        this.oAuthAccessToken = oAuthAccessToken;
    }

    /**
     * 
     * 
     * @return
     *     The oAuthAccessTokenList
     */
    @JsonProperty("OAuthAccessTokenList")
    public OAuthAccessTokenList getOAuthAccessTokenList() {
        return oAuthAccessTokenList;
    }

    /**
     * 
     * 
     * @param oAuthAccessTokenList
     *     The OAuthAccessTokenList
     */
    @JsonProperty("OAuthAccessTokenList")
    public void setOAuthAccessTokenList(OAuthAccessTokenList oAuthAccessTokenList) {
        this.oAuthAccessTokenList = oAuthAccessTokenList;
    }

    /**
     * 
     * 
     * @return
     *     The oAuthAuthorizeToken
     */
    @JsonProperty("OAuthAuthorizeToken")
    public OAuthAuthorizeToken getOAuthAuthorizeToken() {
        return oAuthAuthorizeToken;
    }

    /**
     * 
     * 
     * @param oAuthAuthorizeToken
     *     The OAuthAuthorizeToken
     */
    @JsonProperty("OAuthAuthorizeToken")
    public void setOAuthAuthorizeToken(OAuthAuthorizeToken oAuthAuthorizeToken) {
        this.oAuthAuthorizeToken = oAuthAuthorizeToken;
    }

    /**
     * 
     * 
     * @return
     *     The oAuthAuthorizeTokenList
     */
    @JsonProperty("OAuthAuthorizeTokenList")
    public OAuthAuthorizeTokenList getOAuthAuthorizeTokenList() {
        return oAuthAuthorizeTokenList;
    }

    /**
     * 
     * 
     * @param oAuthAuthorizeTokenList
     *     The OAuthAuthorizeTokenList
     */
    @JsonProperty("OAuthAuthorizeTokenList")
    public void setOAuthAuthorizeTokenList(OAuthAuthorizeTokenList oAuthAuthorizeTokenList) {
        this.oAuthAuthorizeTokenList = oAuthAuthorizeTokenList;
    }

    /**
     * 
     * 
     * @return
     *     The oAuthClient
     */
    @JsonProperty("OAuthClient")
    public OAuthClient getOAuthClient() {
        return oAuthClient;
    }

    /**
     * 
     * 
     * @param oAuthClient
     *     The OAuthClient
     */
    @JsonProperty("OAuthClient")
    public void setOAuthClient(OAuthClient oAuthClient) {
        this.oAuthClient = oAuthClient;
    }

    /**
     * 
     * 
     * @return
     *     The oAuthClientAuthorization
     */
    @JsonProperty("OAuthClientAuthorization")
    public OAuthClientAuthorization getOAuthClientAuthorization() {
        return oAuthClientAuthorization;
    }

    /**
     * 
     * 
     * @param oAuthClientAuthorization
     *     The OAuthClientAuthorization
     */
    @JsonProperty("OAuthClientAuthorization")
    public void setOAuthClientAuthorization(OAuthClientAuthorization oAuthClientAuthorization) {
        this.oAuthClientAuthorization = oAuthClientAuthorization;
    }

    /**
     * 
     * 
     * @return
     *     The oAuthClientAuthorizationList
     */
    @JsonProperty("OAuthClientAuthorizationList")
    public OAuthClientAuthorizationList getOAuthClientAuthorizationList() {
        return oAuthClientAuthorizationList;
    }

    /**
     * 
     * 
     * @param oAuthClientAuthorizationList
     *     The OAuthClientAuthorizationList
     */
    @JsonProperty("OAuthClientAuthorizationList")
    public void setOAuthClientAuthorizationList(OAuthClientAuthorizationList oAuthClientAuthorizationList) {
        this.oAuthClientAuthorizationList = oAuthClientAuthorizationList;
    }

    /**
     * 
     * 
     * @return
     *     The oAuthClientList
     */
    @JsonProperty("OAuthClientList")
    public OAuthClientList getOAuthClientList() {
        return oAuthClientList;
    }

    /**
     * 
     * 
     * @param oAuthClientList
     *     The OAuthClientList
     */
    @JsonProperty("OAuthClientList")
    public void setOAuthClientList(OAuthClientList oAuthClientList) {
        this.oAuthClientList = oAuthClientList;
    }

    /**
     * 
     * 
     * @return
     *     The oAuthList
     */
    @JsonProperty("OAuthList")
    public OAuthList getOAuthList() {
        return oAuthList;
    }

    /**
     * 
     * 
     * @param oAuthList
     *     The OAuthList
     */
    @JsonProperty("OAuthList")
    public void setOAuthList(OAuthList oAuthList) {
        this.oAuthList = oAuthList;
    }

    /**
     * 
     * 
     * @return
     *     The objectMeta
     */
    @JsonProperty("ObjectMeta")
    public io.fabric8.kubernetes.api.model.ObjectMeta getObjectMeta() {
        return objectMeta;
    }

    /**
     * 
     * 
     * @param objectMeta
     *     The ObjectMeta
     */
    @JsonProperty("ObjectMeta")
    public void setObjectMeta(io.fabric8.kubernetes.api.model.ObjectMeta objectMeta) {
        this.objectMeta = objectMeta;
    }

    /**
     * 
     * 
     * @return
     *     The openshiftClusterRole
     */
    @JsonProperty("OpenshiftClusterRole")
    public ClusterRole getOpenshiftClusterRole() {
        return openshiftClusterRole;
    }

    /**
     * 
     * 
     * @param openshiftClusterRole
     *     The OpenshiftClusterRole
     */
    @JsonProperty("OpenshiftClusterRole")
    public void setOpenshiftClusterRole(ClusterRole openshiftClusterRole) {
        this.openshiftClusterRole = openshiftClusterRole;
    }

    /**
     * 
     * 
     * @return
     *     The openshiftClusterRoleBinding
     */
    @JsonProperty("OpenshiftClusterRoleBinding")
    public ClusterRoleBinding getOpenshiftClusterRoleBinding() {
        return openshiftClusterRoleBinding;
    }

    /**
     * 
     * 
     * @param openshiftClusterRoleBinding
     *     The OpenshiftClusterRoleBinding
     */
    @JsonProperty("OpenshiftClusterRoleBinding")
    public void setOpenshiftClusterRoleBinding(ClusterRoleBinding openshiftClusterRoleBinding) {
        this.openshiftClusterRoleBinding = openshiftClusterRoleBinding;
    }

    /**
     * 
     * 
     * @return
     *     The openshiftClusterRoleBindingList
     */
    @JsonProperty("OpenshiftClusterRoleBindingList")
    public ClusterRoleBindingList getOpenshiftClusterRoleBindingList() {
        return openshiftClusterRoleBindingList;
    }

    /**
     * 
     * 
     * @param openshiftClusterRoleBindingList
     *     The OpenshiftClusterRoleBindingList
     */
    @JsonProperty("OpenshiftClusterRoleBindingList")
    public void setOpenshiftClusterRoleBindingList(ClusterRoleBindingList openshiftClusterRoleBindingList) {
        this.openshiftClusterRoleBindingList = openshiftClusterRoleBindingList;
    }

    /**
     * 
     * 
     * @return
     *     The openshiftClusterRoleList
     */
    @JsonProperty("OpenshiftClusterRoleList")
    public ClusterRoleList getOpenshiftClusterRoleList() {
        return openshiftClusterRoleList;
    }

    /**
     * 
     * 
     * @param openshiftClusterRoleList
     *     The OpenshiftClusterRoleList
     */
    @JsonProperty("OpenshiftClusterRoleList")
    public void setOpenshiftClusterRoleList(ClusterRoleList openshiftClusterRoleList) {
        this.openshiftClusterRoleList = openshiftClusterRoleList;
    }

    /**
     * 
     * 
     * @return
     *     The openshiftClusterRoleScopeRestriction
     */
    @JsonProperty("OpenshiftClusterRoleScopeRestriction")
    public ClusterRoleScopeRestriction getOpenshiftClusterRoleScopeRestriction() {
        return openshiftClusterRoleScopeRestriction;
    }

    /**
     * 
     * 
     * @param openshiftClusterRoleScopeRestriction
     *     The OpenshiftClusterRoleScopeRestriction
     */
    @JsonProperty("OpenshiftClusterRoleScopeRestriction")
    public void setOpenshiftClusterRoleScopeRestriction(ClusterRoleScopeRestriction openshiftClusterRoleScopeRestriction) {
        this.openshiftClusterRoleScopeRestriction = openshiftClusterRoleScopeRestriction;
    }

    /**
     * 
     * 
     * @return
     *     The openshiftRole
     */
    @JsonProperty("OpenshiftRole")
    public Role getOpenshiftRole() {
        return openshiftRole;
    }

    /**
     * 
     * 
     * @param openshiftRole
     *     The OpenshiftRole
     */
    @JsonProperty("OpenshiftRole")
    public void setOpenshiftRole(Role openshiftRole) {
        this.openshiftRole = openshiftRole;
    }

    /**
     * 
     * 
     * @return
     *     The openshiftRoleBinding
     */
    @JsonProperty("OpenshiftRoleBinding")
    public RoleBinding getOpenshiftRoleBinding() {
        return openshiftRoleBinding;
    }

    /**
     * 
     * 
     * @param openshiftRoleBinding
     *     The OpenshiftRoleBinding
     */
    @JsonProperty("OpenshiftRoleBinding")
    public void setOpenshiftRoleBinding(RoleBinding openshiftRoleBinding) {
        this.openshiftRoleBinding = openshiftRoleBinding;
    }

    /**
     * 
     * 
     * @return
     *     The openshiftRoleBindingList
     */
    @JsonProperty("OpenshiftRoleBindingList")
    public RoleBindingList getOpenshiftRoleBindingList() {
        return openshiftRoleBindingList;
    }

    /**
     * 
     * 
     * @param openshiftRoleBindingList
     *     The OpenshiftRoleBindingList
     */
    @JsonProperty("OpenshiftRoleBindingList")
    public void setOpenshiftRoleBindingList(RoleBindingList openshiftRoleBindingList) {
        this.openshiftRoleBindingList = openshiftRoleBindingList;
    }

    /**
     * 
     * 
     * @return
     *     The openshiftRoleBindingRestriction
     */
    @JsonProperty("OpenshiftRoleBindingRestriction")
    public RoleBindingRestriction getOpenshiftRoleBindingRestriction() {
        return openshiftRoleBindingRestriction;
    }

    /**
     * 
     * 
     * @param openshiftRoleBindingRestriction
     *     The OpenshiftRoleBindingRestriction
     */
    @JsonProperty("OpenshiftRoleBindingRestriction")
    public void setOpenshiftRoleBindingRestriction(RoleBindingRestriction openshiftRoleBindingRestriction) {
        this.openshiftRoleBindingRestriction = openshiftRoleBindingRestriction;
    }

    /**
     * 
     * 
     * @return
     *     The openshiftRoleBindingRestrictionSpec
     */
    @JsonProperty("OpenshiftRoleBindingRestrictionSpec")
    public RoleBindingRestrictionSpec getOpenshiftRoleBindingRestrictionSpec() {
        return openshiftRoleBindingRestrictionSpec;
    }

    /**
     * 
     * 
     * @param openshiftRoleBindingRestrictionSpec
     *     The OpenshiftRoleBindingRestrictionSpec
     */
    @JsonProperty("OpenshiftRoleBindingRestrictionSpec")
    public void setOpenshiftRoleBindingRestrictionSpec(RoleBindingRestrictionSpec openshiftRoleBindingRestrictionSpec) {
        this.openshiftRoleBindingRestrictionSpec = openshiftRoleBindingRestrictionSpec;
    }

    /**
     * 
     * 
     * @return
     *     The openshiftRoleList
     */
    @JsonProperty("OpenshiftRoleList")
    public RoleList getOpenshiftRoleList() {
        return openshiftRoleList;
    }

    /**
     * 
     * 
     * @param openshiftRoleList
     *     The OpenshiftRoleList
     */
    @JsonProperty("OpenshiftRoleList")
    public void setOpenshiftRoleList(RoleList openshiftRoleList) {
        this.openshiftRoleList = openshiftRoleList;
    }

    /**
     * 
     * 
     * @return
     *     The operatorHub
     */
    @JsonProperty("OperatorHub")
    public OperatorHub getOperatorHub() {
        return operatorHub;
    }

    /**
     * 
     * 
     * @param operatorHub
     *     The OperatorHub
     */
    @JsonProperty("OperatorHub")
    public void setOperatorHub(OperatorHub operatorHub) {
        this.operatorHub = operatorHub;
    }

    /**
     * 
     * 
     * @return
     *     The operatorHubList
     */
    @JsonProperty("OperatorHubList")
    public OperatorHubList getOperatorHubList() {
        return operatorHubList;
    }

    /**
     * 
     * 
     * @param operatorHubList
     *     The OperatorHubList
     */
    @JsonProperty("OperatorHubList")
    public void setOperatorHubList(OperatorHubList operatorHubList) {
        this.operatorHubList = operatorHubList;
    }

    /**
     * 
     * 
     * @return
     *     The patch
     */
    @JsonProperty("Patch")
    public Patch getPatch() {
        return patch;
    }

    /**
     * 
     * 
     * @param patch
     *     The Patch
     */
    @JsonProperty("Patch")
    public void setPatch(Patch patch) {
        this.patch = patch;
    }

    /**
     * 
     * 
     * @return
     *     The patchOptions
     */
    @JsonProperty("PatchOptions")
    public PatchOptions getPatchOptions() {
        return patchOptions;
    }

    /**
     * 
     * 
     * @param patchOptions
     *     The PatchOptions
     */
    @JsonProperty("PatchOptions")
    public void setPatchOptions(PatchOptions patchOptions) {
        this.patchOptions = patchOptions;
    }

    /**
     * 
     * 
     * @return
     *     The podSecurityPolicyReview
     */
    @JsonProperty("PodSecurityPolicyReview")
    public PodSecurityPolicyReview getPodSecurityPolicyReview() {
        return podSecurityPolicyReview;
    }

    /**
     * 
     * 
     * @param podSecurityPolicyReview
     *     The PodSecurityPolicyReview
     */
    @JsonProperty("PodSecurityPolicyReview")
    public void setPodSecurityPolicyReview(PodSecurityPolicyReview podSecurityPolicyReview) {
        this.podSecurityPolicyReview = podSecurityPolicyReview;
    }

    /**
     * 
     * 
     * @return
     *     The podSecurityPolicySelfSubjectReview
     */
    @JsonProperty("PodSecurityPolicySelfSubjectReview")
    public PodSecurityPolicySelfSubjectReview getPodSecurityPolicySelfSubjectReview() {
        return podSecurityPolicySelfSubjectReview;
    }

    /**
     * 
     * 
     * @param podSecurityPolicySelfSubjectReview
     *     The PodSecurityPolicySelfSubjectReview
     */
    @JsonProperty("PodSecurityPolicySelfSubjectReview")
    public void setPodSecurityPolicySelfSubjectReview(PodSecurityPolicySelfSubjectReview podSecurityPolicySelfSubjectReview) {
        this.podSecurityPolicySelfSubjectReview = podSecurityPolicySelfSubjectReview;
    }

    /**
     * 
     * 
     * @return
     *     The podSecurityPolicySubjectReview
     */
    @JsonProperty("PodSecurityPolicySubjectReview")
    public PodSecurityPolicySubjectReview getPodSecurityPolicySubjectReview() {
        return podSecurityPolicySubjectReview;
    }

    /**
     * 
     * 
     * @param podSecurityPolicySubjectReview
     *     The PodSecurityPolicySubjectReview
     */
    @JsonProperty("PodSecurityPolicySubjectReview")
    public void setPodSecurityPolicySubjectReview(PodSecurityPolicySubjectReview podSecurityPolicySubjectReview) {
        this.podSecurityPolicySubjectReview = podSecurityPolicySubjectReview;
    }

    /**
     * 
     * 
     * @return
     *     The project
     */
    @JsonProperty("Project")
    public Project getProject() {
        return project;
    }

    /**
     * 
     * 
     * @param project
     *     The Project
     */
    @JsonProperty("Project")
    public void setProject(Project project) {
        this.project = project;
    }

    /**
     * 
     * 
     * @return
     *     The projectList
     */
    @JsonProperty("ProjectList")
    public ProjectList getProjectList() {
        return projectList;
    }

    /**
     * 
     * 
     * @param projectList
     *     The ProjectList
     */
    @JsonProperty("ProjectList")
    public void setProjectList(ProjectList projectList) {
        this.projectList = projectList;
    }

    /**
     * 
     * 
     * @return
     *     The projectRequest
     */
    @JsonProperty("ProjectRequest")
    public ProjectRequest getProjectRequest() {
        return projectRequest;
    }

    /**
     * 
     * 
     * @param projectRequest
     *     The ProjectRequest
     */
    @JsonProperty("ProjectRequest")
    public void setProjectRequest(ProjectRequest projectRequest) {
        this.projectRequest = projectRequest;
    }

    /**
     * 
     * 
     * @return
     *     The proxy
     */
    @JsonProperty("Proxy")
    public Proxy getProxy() {
        return proxy;
    }

    /**
     * 
     * 
     * @param proxy
     *     The Proxy
     */
    @JsonProperty("Proxy")
    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    /**
     * 
     * 
     * @return
     *     The proxyList
     */
    @JsonProperty("ProxyList")
    public ProxyList getProxyList() {
        return proxyList;
    }

    /**
     * 
     * 
     * @param proxyList
     *     The ProxyList
     */
    @JsonProperty("ProxyList")
    public void setProxyList(ProxyList proxyList) {
        this.proxyList = proxyList;
    }

    /**
     * 
     * 
     * @return
     *     The quantity
     */
    @JsonProperty("Quantity")
    public Quantity getQuantity() {
        return quantity;
    }

    /**
     * 
     * 
     * @param quantity
     *     The Quantity
     */
    @JsonProperty("Quantity")
    public void setQuantity(Quantity quantity) {
        this.quantity = quantity;
    }

    /**
     * 
     * 
     * @return
     *     The rangeAllocation
     */
    @JsonProperty("RangeAllocation")
    public RangeAllocation getRangeAllocation() {
        return rangeAllocation;
    }

    /**
     * 
     * 
     * @param rangeAllocation
     *     The RangeAllocation
     */
    @JsonProperty("RangeAllocation")
    public void setRangeAllocation(RangeAllocation rangeAllocation) {
        this.rangeAllocation = rangeAllocation;
    }

    /**
     * 
     * 
     * @return
     *     The rangeAllocationList
     */
    @JsonProperty("RangeAllocationList")
    public RangeAllocationList getRangeAllocationList() {
        return rangeAllocationList;
    }

    /**
     * 
     * 
     * @param rangeAllocationList
     *     The RangeAllocationList
     */
    @JsonProperty("RangeAllocationList")
    public void setRangeAllocationList(RangeAllocationList rangeAllocationList) {
        this.rangeAllocationList = rangeAllocationList;
    }

    /**
     * 
     * 
     * @return
     *     The resourceAccessReview
     */
    @JsonProperty("ResourceAccessReview")
    public ResourceAccessReview getResourceAccessReview() {
        return resourceAccessReview;
    }

    /**
     * 
     * 
     * @param resourceAccessReview
     *     The ResourceAccessReview
     */
    @JsonProperty("ResourceAccessReview")
    public void setResourceAccessReview(ResourceAccessReview resourceAccessReview) {
        this.resourceAccessReview = resourceAccessReview;
    }

    /**
     * 
     * 
     * @return
     *     The rootPaths
     */
    @JsonProperty("RootPaths")
    public RootPaths getRootPaths() {
        return rootPaths;
    }

    /**
     * 
     * 
     * @param rootPaths
     *     The RootPaths
     */
    @JsonProperty("RootPaths")
    public void setRootPaths(RootPaths rootPaths) {
        this.rootPaths = rootPaths;
    }

    /**
     * 
     * 
     * @return
     *     The route
     */
    @JsonProperty("Route")
    public Route getRoute() {
        return route;
    }

    /**
     * 
     * 
     * @param route
     *     The Route
     */
    @JsonProperty("Route")
    public void setRoute(Route route) {
        this.route = route;
    }

    /**
     * 
     * 
     * @return
     *     The routeList
     */
    @JsonProperty("RouteList")
    public RouteList getRouteList() {
        return routeList;
    }

    /**
     * 
     * 
     * @param routeList
     *     The RouteList
     */
    @JsonProperty("RouteList")
    public void setRouteList(RouteList routeList) {
        this.routeList = routeList;
    }

    /**
     * 
     * 
     * @return
     *     The scheduler
     */
    @JsonProperty("Scheduler")
    public Scheduler getScheduler() {
        return scheduler;
    }

    /**
     * 
     * 
     * @param scheduler
     *     The Scheduler
     */
    @JsonProperty("Scheduler")
    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    /**
     * 
     * 
     * @return
     *     The schedulerList
     */
    @JsonProperty("SchedulerList")
    public SchedulerList getSchedulerList() {
        return schedulerList;
    }

    /**
     * 
     * 
     * @param schedulerList
     *     The SchedulerList
     */
    @JsonProperty("SchedulerList")
    public void setSchedulerList(SchedulerList schedulerList) {
        this.schedulerList = schedulerList;
    }

    /**
     * 
     * 
     * @return
     *     The secretNameReference
     */
    @JsonProperty("SecretNameReference")
    public SecretNameReference getSecretNameReference() {
        return secretNameReference;
    }

    /**
     * 
     * 
     * @param secretNameReference
     *     The SecretNameReference
     */
    @JsonProperty("SecretNameReference")
    public void setSecretNameReference(SecretNameReference secretNameReference) {
        this.secretNameReference = secretNameReference;
    }

    /**
     * 
     * 
     * @return
     *     The securityContextConstraints
     */
    @JsonProperty("SecurityContextConstraints")
    public SecurityContextConstraints getSecurityContextConstraints() {
        return securityContextConstraints;
    }

    /**
     * 
     * 
     * @param securityContextConstraints
     *     The SecurityContextConstraints
     */
    @JsonProperty("SecurityContextConstraints")
    public void setSecurityContextConstraints(SecurityContextConstraints securityContextConstraints) {
        this.securityContextConstraints = securityContextConstraints;
    }

    /**
     * 
     * 
     * @return
     *     The securityContextConstraintsList
     */
    @JsonProperty("SecurityContextConstraintsList")
    public SecurityContextConstraintsList getSecurityContextConstraintsList() {
        return securityContextConstraintsList;
    }

    /**
     * 
     * 
     * @param securityContextConstraintsList
     *     The SecurityContextConstraintsList
     */
    @JsonProperty("SecurityContextConstraintsList")
    public void setSecurityContextConstraintsList(SecurityContextConstraintsList securityContextConstraintsList) {
        this.securityContextConstraintsList = securityContextConstraintsList;
    }

    /**
     * 
     * 
     * @return
     *     The selfSubjectRulesReview
     */
    @JsonProperty("SelfSubjectRulesReview")
    public SelfSubjectRulesReview getSelfSubjectRulesReview() {
        return selfSubjectRulesReview;
    }

    /**
     * 
     * 
     * @param selfSubjectRulesReview
     *     The SelfSubjectRulesReview
     */
    @JsonProperty("SelfSubjectRulesReview")
    public void setSelfSubjectRulesReview(SelfSubjectRulesReview selfSubjectRulesReview) {
        this.selfSubjectRulesReview = selfSubjectRulesReview;
    }

    /**
     * 
     * 
     * @return
     *     The status
     */
    @JsonProperty("Status")
    public Status getStatus() {
        return status;
    }

    /**
     * 
     * 
     * @param status
     *     The Status
     */
    @JsonProperty("Status")
    public void setStatus(Status status) {
        this.status = status;
    }

    /**
     * 
     * 
     * @return
     *     The subjectAccessReview
     */
    @JsonProperty("SubjectAccessReview")
    public SubjectAccessReview getSubjectAccessReview() {
        return subjectAccessReview;
    }

    /**
     * 
     * 
     * @param subjectAccessReview
     *     The SubjectAccessReview
     */
    @JsonProperty("SubjectAccessReview")
    public void setSubjectAccessReview(SubjectAccessReview subjectAccessReview) {
        this.subjectAccessReview = subjectAccessReview;
    }

    /**
     * 
     * 
     * @return
     *     The subjectAccessReviewResponse
     */
    @JsonProperty("SubjectAccessReviewResponse")
    public SubjectAccessReviewResponse getSubjectAccessReviewResponse() {
        return subjectAccessReviewResponse;
    }

    /**
     * 
     * 
     * @param subjectAccessReviewResponse
     *     The SubjectAccessReviewResponse
     */
    @JsonProperty("SubjectAccessReviewResponse")
    public void setSubjectAccessReviewResponse(SubjectAccessReviewResponse subjectAccessReviewResponse) {
        this.subjectAccessReviewResponse = subjectAccessReviewResponse;
    }

    /**
     * 
     * 
     * @return
     *     The subjectRulesReview
     */
    @JsonProperty("SubjectRulesReview")
    public SubjectRulesReview getSubjectRulesReview() {
        return subjectRulesReview;
    }

    /**
     * 
     * 
     * @param subjectRulesReview
     *     The SubjectRulesReview
     */
    @JsonProperty("SubjectRulesReview")
    public void setSubjectRulesReview(SubjectRulesReview subjectRulesReview) {
        this.subjectRulesReview = subjectRulesReview;
    }

    /**
     * 
     * 
     * @return
     *     The tLSProfileSpec
     */
    @JsonProperty("TLSProfileSpec")
    public TLSProfileSpec getTLSProfileSpec() {
        return tLSProfileSpec;
    }

    /**
     * 
     * 
     * @param tLSProfileSpec
     *     The TLSProfileSpec
     */
    @JsonProperty("TLSProfileSpec")
    public void setTLSProfileSpec(TLSProfileSpec tLSProfileSpec) {
        this.tLSProfileSpec = tLSProfileSpec;
    }

    /**
     * 
     * 
     * @return
     *     The tagEvent
     */
    @JsonProperty("TagEvent")
    public TagEvent getTagEvent() {
        return tagEvent;
    }

    /**
     * 
     * 
     * @param tagEvent
     *     The TagEvent
     */
    @JsonProperty("TagEvent")
    public void setTagEvent(TagEvent tagEvent) {
        this.tagEvent = tagEvent;
    }

    /**
     * 
     * 
     * @return
     *     The template
     */
    @JsonProperty("Template")
    public Template getTemplate() {
        return template;
    }

    /**
     * 
     * 
     * @param template
     *     The Template
     */
    @JsonProperty("Template")
    public void setTemplate(Template template) {
        this.template = template;
    }

    /**
     * 
     * 
     * @return
     *     The templateList
     */
    @JsonProperty("TemplateList")
    public TemplateList getTemplateList() {
        return templateList;
    }

    /**
     * 
     * 
     * @param templateList
     *     The TemplateList
     */
    @JsonProperty("TemplateList")
    public void setTemplateList(TemplateList templateList) {
        this.templateList = templateList;
    }

    /**
     * 
     * 
     * @return
     *     The time
     */
    @JsonProperty("Time")
    public String getTime() {
        return time;
    }

    /**
     * 
     * 
     * @param time
     *     The Time
     */
    @JsonProperty("Time")
    public void setTime(String time) {
        this.time = time;
    }

    /**
     * 
     * 
     * @return
     *     The tokenReview
     */
    @JsonProperty("TokenReview")
    public TokenReview getTokenReview() {
        return tokenReview;
    }

    /**
     * 
     * 
     * @param tokenReview
     *     The TokenReview
     */
    @JsonProperty("TokenReview")
    public void setTokenReview(TokenReview tokenReview) {
        this.tokenReview = tokenReview;
    }

    /**
     * 
     * 
     * @return
     *     The typeMeta
     */
    @JsonProperty("TypeMeta")
    public TypeMeta getTypeMeta() {
        return typeMeta;
    }

    /**
     * 
     * 
     * @param typeMeta
     *     The TypeMeta
     */
    @JsonProperty("TypeMeta")
    public void setTypeMeta(TypeMeta typeMeta) {
        this.typeMeta = typeMeta;
    }

    /**
     * 
     * 
     * @return
     *     The updateOptions
     */
    @JsonProperty("UpdateOptions")
    public UpdateOptions getUpdateOptions() {
        return updateOptions;
    }

    /**
     * 
     * 
     * @param updateOptions
     *     The UpdateOptions
     */
    @JsonProperty("UpdateOptions")
    public void setUpdateOptions(UpdateOptions updateOptions) {
        this.updateOptions = updateOptions;
    }

    /**
     * 
     * 
     * @return
     *     The user
     */
    @JsonProperty("User")
    public User getUser() {
        return user;
    }

    /**
     * 
     * 
     * @param user
     *     The User
     */
    @JsonProperty("User")
    public void setUser(User user) {
        this.user = user;
    }

    /**
     * 
     * 
     * @return
     *     The userList
     */
    @JsonProperty("UserList")
    public UserList getUserList() {
        return userList;
    }

    /**
     * 
     * 
     * @param userList
     *     The UserList
     */
    @JsonProperty("UserList")
    public void setUserList(UserList userList) {
        this.userList = userList;
    }

    @JsonAnyGetter
    public Map<java.lang.String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(java.lang.String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
