package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class BasicAuthIdentityProviderFluentImpl<A extends BasicAuthIdentityProviderFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements BasicAuthIdentityProviderFluent<A>{

    private ConfigMapNameReferenceBuilder ca;
    private SecretNameReferenceBuilder tlsClientCert;
    private SecretNameReferenceBuilder tlsClientKey;
    private String url;

    public BasicAuthIdentityProviderFluentImpl(){
    }
    public BasicAuthIdentityProviderFluentImpl(BasicAuthIdentityProvider instance){
            this.withCa(instance.getCa()); 
            this.withTlsClientCert(instance.getTlsClientCert()); 
            this.withTlsClientKey(instance.getTlsClientKey()); 
            this.withUrl(instance.getUrl()); 
    }

    
/**
 * This method has been deprecated, please use method buildCa instead.
 * @return The buildable object.
 */
@Deprecated public ConfigMapNameReference getCa(){
            return this.ca!=null?this.ca.build():null;
    }

    public ConfigMapNameReference buildCa(){
            return this.ca!=null?this.ca.build():null;
    }

    public A withCa(ConfigMapNameReference ca){
            _visitables.get("ca").remove(this.ca);
            if (ca!=null){ this.ca= new ConfigMapNameReferenceBuilder(ca); _visitables.get("ca").add(this.ca);} return (A) this;
    }

    public Boolean hasCa(){
            return this.ca != null;
    }

    public A withNewCa(String name){
            return (A)withCa(new ConfigMapNameReference(name));
    }

    public BasicAuthIdentityProviderFluent.CaNested<A> withNewCa(){
            return new CaNestedImpl();
    }

    public BasicAuthIdentityProviderFluent.CaNested<A> withNewCaLike(ConfigMapNameReference item){
            return new CaNestedImpl(item);
    }

    public BasicAuthIdentityProviderFluent.CaNested<A> editCa(){
            return withNewCaLike(getCa());
    }

    public BasicAuthIdentityProviderFluent.CaNested<A> editOrNewCa(){
            return withNewCaLike(getCa() != null ? getCa(): new ConfigMapNameReferenceBuilder().build());
    }

    public BasicAuthIdentityProviderFluent.CaNested<A> editOrNewCaLike(ConfigMapNameReference item){
            return withNewCaLike(getCa() != null ? getCa(): item);
    }

    
/**
 * This method has been deprecated, please use method buildTlsClientCert instead.
 * @return The buildable object.
 */
@Deprecated public SecretNameReference getTlsClientCert(){
            return this.tlsClientCert!=null?this.tlsClientCert.build():null;
    }

    public SecretNameReference buildTlsClientCert(){
            return this.tlsClientCert!=null?this.tlsClientCert.build():null;
    }

    public A withTlsClientCert(SecretNameReference tlsClientCert){
            _visitables.get("tlsClientCert").remove(this.tlsClientCert);
            if (tlsClientCert!=null){ this.tlsClientCert= new SecretNameReferenceBuilder(tlsClientCert); _visitables.get("tlsClientCert").add(this.tlsClientCert);} return (A) this;
    }

    public Boolean hasTlsClientCert(){
            return this.tlsClientCert != null;
    }

    public A withNewTlsClientCert(String name){
            return (A)withTlsClientCert(new SecretNameReference(name));
    }

    public BasicAuthIdentityProviderFluent.TlsClientCertNested<A> withNewTlsClientCert(){
            return new TlsClientCertNestedImpl();
    }

    public BasicAuthIdentityProviderFluent.TlsClientCertNested<A> withNewTlsClientCertLike(SecretNameReference item){
            return new TlsClientCertNestedImpl(item);
    }

    public BasicAuthIdentityProviderFluent.TlsClientCertNested<A> editTlsClientCert(){
            return withNewTlsClientCertLike(getTlsClientCert());
    }

    public BasicAuthIdentityProviderFluent.TlsClientCertNested<A> editOrNewTlsClientCert(){
            return withNewTlsClientCertLike(getTlsClientCert() != null ? getTlsClientCert(): new SecretNameReferenceBuilder().build());
    }

    public BasicAuthIdentityProviderFluent.TlsClientCertNested<A> editOrNewTlsClientCertLike(SecretNameReference item){
            return withNewTlsClientCertLike(getTlsClientCert() != null ? getTlsClientCert(): item);
    }

    
/**
 * This method has been deprecated, please use method buildTlsClientKey instead.
 * @return The buildable object.
 */
@Deprecated public SecretNameReference getTlsClientKey(){
            return this.tlsClientKey!=null?this.tlsClientKey.build():null;
    }

    public SecretNameReference buildTlsClientKey(){
            return this.tlsClientKey!=null?this.tlsClientKey.build():null;
    }

    public A withTlsClientKey(SecretNameReference tlsClientKey){
            _visitables.get("tlsClientKey").remove(this.tlsClientKey);
            if (tlsClientKey!=null){ this.tlsClientKey= new SecretNameReferenceBuilder(tlsClientKey); _visitables.get("tlsClientKey").add(this.tlsClientKey);} return (A) this;
    }

    public Boolean hasTlsClientKey(){
            return this.tlsClientKey != null;
    }

    public A withNewTlsClientKey(String name){
            return (A)withTlsClientKey(new SecretNameReference(name));
    }

    public BasicAuthIdentityProviderFluent.TlsClientKeyNested<A> withNewTlsClientKey(){
            return new TlsClientKeyNestedImpl();
    }

    public BasicAuthIdentityProviderFluent.TlsClientKeyNested<A> withNewTlsClientKeyLike(SecretNameReference item){
            return new TlsClientKeyNestedImpl(item);
    }

    public BasicAuthIdentityProviderFluent.TlsClientKeyNested<A> editTlsClientKey(){
            return withNewTlsClientKeyLike(getTlsClientKey());
    }

    public BasicAuthIdentityProviderFluent.TlsClientKeyNested<A> editOrNewTlsClientKey(){
            return withNewTlsClientKeyLike(getTlsClientKey() != null ? getTlsClientKey(): new SecretNameReferenceBuilder().build());
    }

    public BasicAuthIdentityProviderFluent.TlsClientKeyNested<A> editOrNewTlsClientKeyLike(SecretNameReference item){
            return withNewTlsClientKeyLike(getTlsClientKey() != null ? getTlsClientKey(): item);
    }

    public String getUrl(){
            return this.url;
    }

    public A withUrl(String url){
            this.url=url; return (A) this;
    }

    public Boolean hasUrl(){
            return this.url != null;
    }

    public A withNewUrl(String arg1){
            return (A)withUrl(new String(arg1));
    }

    public A withNewUrl(StringBuilder arg1){
            return (A)withUrl(new String(arg1));
    }

    public A withNewUrl(StringBuffer arg1){
            return (A)withUrl(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            BasicAuthIdentityProviderFluentImpl that = (BasicAuthIdentityProviderFluentImpl) o;
            if (ca != null ? !ca.equals(that.ca) :that.ca != null) return false;
            if (tlsClientCert != null ? !tlsClientCert.equals(that.tlsClientCert) :that.tlsClientCert != null) return false;
            if (tlsClientKey != null ? !tlsClientKey.equals(that.tlsClientKey) :that.tlsClientKey != null) return false;
            if (url != null ? !url.equals(that.url) :that.url != null) return false;
            return true;
    }


    public class CaNestedImpl<N> extends ConfigMapNameReferenceFluentImpl<BasicAuthIdentityProviderFluent.CaNested<N>> implements BasicAuthIdentityProviderFluent.CaNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ConfigMapNameReferenceBuilder builder;
    
            CaNestedImpl(ConfigMapNameReference item){
                    this.builder = new ConfigMapNameReferenceBuilder(this, item);
            }
            CaNestedImpl(){
                    this.builder = new ConfigMapNameReferenceBuilder(this);
            }
    
    public N and(){
            return (N) BasicAuthIdentityProviderFluentImpl.this.withCa(builder.build());
    }
    public N endCa(){
            return and();
    }

}
    public class TlsClientCertNestedImpl<N> extends SecretNameReferenceFluentImpl<BasicAuthIdentityProviderFluent.TlsClientCertNested<N>> implements BasicAuthIdentityProviderFluent.TlsClientCertNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final SecretNameReferenceBuilder builder;
    
            TlsClientCertNestedImpl(SecretNameReference item){
                    this.builder = new SecretNameReferenceBuilder(this, item);
            }
            TlsClientCertNestedImpl(){
                    this.builder = new SecretNameReferenceBuilder(this);
            }
    
    public N and(){
            return (N) BasicAuthIdentityProviderFluentImpl.this.withTlsClientCert(builder.build());
    }
    public N endTlsClientCert(){
            return and();
    }

}
    public class TlsClientKeyNestedImpl<N> extends SecretNameReferenceFluentImpl<BasicAuthIdentityProviderFluent.TlsClientKeyNested<N>> implements BasicAuthIdentityProviderFluent.TlsClientKeyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final SecretNameReferenceBuilder builder;
    
            TlsClientKeyNestedImpl(SecretNameReference item){
                    this.builder = new SecretNameReferenceBuilder(this, item);
            }
            TlsClientKeyNestedImpl(){
                    this.builder = new SecretNameReferenceBuilder(this);
            }
    
    public N and(){
            return (N) BasicAuthIdentityProviderFluentImpl.this.withTlsClientKey(builder.build());
    }
    public N endTlsClientKey(){
            return and();
    }

}


}
