package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public class OpenIDIdentityProviderFluentImpl<A extends OpenIDIdentityProviderFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements OpenIDIdentityProviderFluent<A>{

    private ConfigMapNameReferenceBuilder ca;
    private OpenIDClaimsBuilder claims;
    private String clientID;
    private SecretNameReferenceBuilder clientSecret;
    private Map<String,String> extraAuthorizeParameters;
    private List<String> extraScopes = new ArrayList<String>();
    private String issuer;

    public OpenIDIdentityProviderFluentImpl(){
    }
    public OpenIDIdentityProviderFluentImpl(OpenIDIdentityProvider instance){
            this.withCa(instance.getCa()); 
            this.withClaims(instance.getClaims()); 
            this.withClientID(instance.getClientID()); 
            this.withClientSecret(instance.getClientSecret()); 
            this.withExtraAuthorizeParameters(instance.getExtraAuthorizeParameters()); 
            this.withExtraScopes(instance.getExtraScopes()); 
            this.withIssuer(instance.getIssuer()); 
    }

    
/**
 * This method has been deprecated, please use method buildCa instead.
 * @return The buildable object.
 */
@Deprecated public ConfigMapNameReference getCa(){
            return this.ca!=null?this.ca.build():null;
    }

    public ConfigMapNameReference buildCa(){
            return this.ca!=null?this.ca.build():null;
    }

    public A withCa(ConfigMapNameReference ca){
            _visitables.get("ca").remove(this.ca);
            if (ca!=null){ this.ca= new ConfigMapNameReferenceBuilder(ca); _visitables.get("ca").add(this.ca);} return (A) this;
    }

    public Boolean hasCa(){
            return this.ca != null;
    }

    public A withNewCa(String name){
            return (A)withCa(new ConfigMapNameReference(name));
    }

    public OpenIDIdentityProviderFluent.CaNested<A> withNewCa(){
            return new CaNestedImpl();
    }

    public OpenIDIdentityProviderFluent.CaNested<A> withNewCaLike(ConfigMapNameReference item){
            return new CaNestedImpl(item);
    }

    public OpenIDIdentityProviderFluent.CaNested<A> editCa(){
            return withNewCaLike(getCa());
    }

    public OpenIDIdentityProviderFluent.CaNested<A> editOrNewCa(){
            return withNewCaLike(getCa() != null ? getCa(): new ConfigMapNameReferenceBuilder().build());
    }

    public OpenIDIdentityProviderFluent.CaNested<A> editOrNewCaLike(ConfigMapNameReference item){
            return withNewCaLike(getCa() != null ? getCa(): item);
    }

    
/**
 * This method has been deprecated, please use method buildClaims instead.
 * @return The buildable object.
 */
@Deprecated public OpenIDClaims getClaims(){
            return this.claims!=null?this.claims.build():null;
    }

    public OpenIDClaims buildClaims(){
            return this.claims!=null?this.claims.build():null;
    }

    public A withClaims(OpenIDClaims claims){
            _visitables.get("claims").remove(this.claims);
            if (claims!=null){ this.claims= new OpenIDClaimsBuilder(claims); _visitables.get("claims").add(this.claims);} return (A) this;
    }

    public Boolean hasClaims(){
            return this.claims != null;
    }

    public OpenIDIdentityProviderFluent.ClaimsNested<A> withNewClaims(){
            return new ClaimsNestedImpl();
    }

    public OpenIDIdentityProviderFluent.ClaimsNested<A> withNewClaimsLike(OpenIDClaims item){
            return new ClaimsNestedImpl(item);
    }

    public OpenIDIdentityProviderFluent.ClaimsNested<A> editClaims(){
            return withNewClaimsLike(getClaims());
    }

    public OpenIDIdentityProviderFluent.ClaimsNested<A> editOrNewClaims(){
            return withNewClaimsLike(getClaims() != null ? getClaims(): new OpenIDClaimsBuilder().build());
    }

    public OpenIDIdentityProviderFluent.ClaimsNested<A> editOrNewClaimsLike(OpenIDClaims item){
            return withNewClaimsLike(getClaims() != null ? getClaims(): item);
    }

    public String getClientID(){
            return this.clientID;
    }

    public A withClientID(String clientID){
            this.clientID=clientID; return (A) this;
    }

    public Boolean hasClientID(){
            return this.clientID != null;
    }

    public A withNewClientID(String arg1){
            return (A)withClientID(new String(arg1));
    }

    public A withNewClientID(StringBuilder arg1){
            return (A)withClientID(new String(arg1));
    }

    public A withNewClientID(StringBuffer arg1){
            return (A)withClientID(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildClientSecret instead.
 * @return The buildable object.
 */
@Deprecated public SecretNameReference getClientSecret(){
            return this.clientSecret!=null?this.clientSecret.build():null;
    }

    public SecretNameReference buildClientSecret(){
            return this.clientSecret!=null?this.clientSecret.build():null;
    }

    public A withClientSecret(SecretNameReference clientSecret){
            _visitables.get("clientSecret").remove(this.clientSecret);
            if (clientSecret!=null){ this.clientSecret= new SecretNameReferenceBuilder(clientSecret); _visitables.get("clientSecret").add(this.clientSecret);} return (A) this;
    }

    public Boolean hasClientSecret(){
            return this.clientSecret != null;
    }

    public A withNewClientSecret(String name){
            return (A)withClientSecret(new SecretNameReference(name));
    }

    public OpenIDIdentityProviderFluent.ClientSecretNested<A> withNewClientSecret(){
            return new ClientSecretNestedImpl();
    }

    public OpenIDIdentityProviderFluent.ClientSecretNested<A> withNewClientSecretLike(SecretNameReference item){
            return new ClientSecretNestedImpl(item);
    }

    public OpenIDIdentityProviderFluent.ClientSecretNested<A> editClientSecret(){
            return withNewClientSecretLike(getClientSecret());
    }

    public OpenIDIdentityProviderFluent.ClientSecretNested<A> editOrNewClientSecret(){
            return withNewClientSecretLike(getClientSecret() != null ? getClientSecret(): new SecretNameReferenceBuilder().build());
    }

    public OpenIDIdentityProviderFluent.ClientSecretNested<A> editOrNewClientSecretLike(SecretNameReference item){
            return withNewClientSecretLike(getClientSecret() != null ? getClientSecret(): item);
    }

    public A addToExtraAuthorizeParameters(String key,String value){
            if(this.extraAuthorizeParameters == null && key != null && value != null) { this.extraAuthorizeParameters = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.extraAuthorizeParameters.put(key, value);} return (A)this;
    }

    public A addToExtraAuthorizeParameters(Map<String,String> map){
            if(this.extraAuthorizeParameters == null && map != null) { this.extraAuthorizeParameters = new LinkedHashMap<String,String>(); }
            if(map != null) { this.extraAuthorizeParameters.putAll(map);} return (A)this;
    }

    public A removeFromExtraAuthorizeParameters(String key){
            if(this.extraAuthorizeParameters == null) { return (A) this; }
            if(key != null && this.extraAuthorizeParameters != null) {this.extraAuthorizeParameters.remove(key);} return (A)this;
    }

    public A removeFromExtraAuthorizeParameters(Map<String,String> map){
            if(this.extraAuthorizeParameters == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.extraAuthorizeParameters != null){this.extraAuthorizeParameters.remove(key);}}} return (A)this;
    }

    public Map<String,String> getExtraAuthorizeParameters(){
            return this.extraAuthorizeParameters;
    }

    public A withExtraAuthorizeParameters(Map<String,String> extraAuthorizeParameters){
            if (extraAuthorizeParameters == null) { this.extraAuthorizeParameters =  null;} else {this.extraAuthorizeParameters = new LinkedHashMap<String,String>(extraAuthorizeParameters);} return (A) this;
    }

    public Boolean hasExtraAuthorizeParameters(){
            return this.extraAuthorizeParameters != null;
    }

    public A addToExtraScopes(int index,String item){
            if (this.extraScopes == null) {this.extraScopes = new ArrayList<String>();}
            this.extraScopes.add(index, item);
            return (A)this;
    }

    public A setToExtraScopes(int index,String item){
            if (this.extraScopes == null) {this.extraScopes = new ArrayList<String>();}
            this.extraScopes.set(index, item); return (A)this;
    }

    public A addToExtraScopes(String... items){
            if (this.extraScopes == null) {this.extraScopes = new ArrayList<String>();}
            for (String item : items) {this.extraScopes.add(item);} return (A)this;
    }

    public A addAllToExtraScopes(Collection<String> items){
            if (this.extraScopes == null) {this.extraScopes = new ArrayList<String>();}
            for (String item : items) {this.extraScopes.add(item);} return (A)this;
    }

    public A removeFromExtraScopes(String... items){
            for (String item : items) {if (this.extraScopes!= null){ this.extraScopes.remove(item);}} return (A)this;
    }

    public A removeAllFromExtraScopes(Collection<String> items){
            for (String item : items) {if (this.extraScopes!= null){ this.extraScopes.remove(item);}} return (A)this;
    }

    public List<String> getExtraScopes(){
            return this.extraScopes;
    }

    public String getExtraScope(int index){
            return this.extraScopes.get(index);
    }

    public String getFirstExtraScope(){
            return this.extraScopes.get(0);
    }

    public String getLastExtraScope(){
            return this.extraScopes.get(extraScopes.size() - 1);
    }

    public String getMatchingExtraScope(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: extraScopes) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingExtraScope(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: extraScopes) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withExtraScopes(List<String> extraScopes){
            if (this.extraScopes != null) { _visitables.get("extraScopes").removeAll(this.extraScopes);}
            if (extraScopes != null) {this.extraScopes = new ArrayList<String>(); for (String item : extraScopes){this.addToExtraScopes(item);}} else { this.extraScopes = null;} return (A) this;
    }

    public A withExtraScopes(String... extraScopes){
            if (this.extraScopes != null) {this.extraScopes.clear();}
            if (extraScopes != null) {for (String item :extraScopes){ this.addToExtraScopes(item);}} return (A) this;
    }

    public Boolean hasExtraScopes(){
            return extraScopes != null && !extraScopes.isEmpty();
    }

    public A addNewExtraScope(String arg1){
            return (A)addToExtraScopes(new String(arg1));
    }

    public A addNewExtraScope(StringBuilder arg1){
            return (A)addToExtraScopes(new String(arg1));
    }

    public A addNewExtraScope(StringBuffer arg1){
            return (A)addToExtraScopes(new String(arg1));
    }

    public String getIssuer(){
            return this.issuer;
    }

    public A withIssuer(String issuer){
            this.issuer=issuer; return (A) this;
    }

    public Boolean hasIssuer(){
            return this.issuer != null;
    }

    public A withNewIssuer(String arg1){
            return (A)withIssuer(new String(arg1));
    }

    public A withNewIssuer(StringBuilder arg1){
            return (A)withIssuer(new String(arg1));
    }

    public A withNewIssuer(StringBuffer arg1){
            return (A)withIssuer(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            OpenIDIdentityProviderFluentImpl that = (OpenIDIdentityProviderFluentImpl) o;
            if (ca != null ? !ca.equals(that.ca) :that.ca != null) return false;
            if (claims != null ? !claims.equals(that.claims) :that.claims != null) return false;
            if (clientID != null ? !clientID.equals(that.clientID) :that.clientID != null) return false;
            if (clientSecret != null ? !clientSecret.equals(that.clientSecret) :that.clientSecret != null) return false;
            if (extraAuthorizeParameters != null ? !extraAuthorizeParameters.equals(that.extraAuthorizeParameters) :that.extraAuthorizeParameters != null) return false;
            if (extraScopes != null ? !extraScopes.equals(that.extraScopes) :that.extraScopes != null) return false;
            if (issuer != null ? !issuer.equals(that.issuer) :that.issuer != null) return false;
            return true;
    }


    public class CaNestedImpl<N> extends ConfigMapNameReferenceFluentImpl<OpenIDIdentityProviderFluent.CaNested<N>> implements OpenIDIdentityProviderFluent.CaNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ConfigMapNameReferenceBuilder builder;
    
            CaNestedImpl(ConfigMapNameReference item){
                    this.builder = new ConfigMapNameReferenceBuilder(this, item);
            }
            CaNestedImpl(){
                    this.builder = new ConfigMapNameReferenceBuilder(this);
            }
    
    public N and(){
            return (N) OpenIDIdentityProviderFluentImpl.this.withCa(builder.build());
    }
    public N endCa(){
            return and();
    }

}
    public class ClaimsNestedImpl<N> extends OpenIDClaimsFluentImpl<OpenIDIdentityProviderFluent.ClaimsNested<N>> implements OpenIDIdentityProviderFluent.ClaimsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final OpenIDClaimsBuilder builder;
    
            ClaimsNestedImpl(OpenIDClaims item){
                    this.builder = new OpenIDClaimsBuilder(this, item);
            }
            ClaimsNestedImpl(){
                    this.builder = new OpenIDClaimsBuilder(this);
            }
    
    public N and(){
            return (N) OpenIDIdentityProviderFluentImpl.this.withClaims(builder.build());
    }
    public N endClaims(){
            return and();
    }

}
    public class ClientSecretNestedImpl<N> extends SecretNameReferenceFluentImpl<OpenIDIdentityProviderFluent.ClientSecretNested<N>> implements OpenIDIdentityProviderFluent.ClientSecretNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final SecretNameReferenceBuilder builder;
    
            ClientSecretNestedImpl(SecretNameReference item){
                    this.builder = new SecretNameReferenceBuilder(this, item);
            }
            ClientSecretNestedImpl(){
                    this.builder = new SecretNameReferenceBuilder(this);
            }
    
    public N and(){
            return (N) OpenIDIdentityProviderFluentImpl.this.withClientSecret(builder.build());
    }
    public N endClientSecret(){
            return and();
    }

}


}
