package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.lang.Deprecated;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.authentication.TokenReviewFluentImpl;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.List;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.authentication.TokenReviewBuilder;
import io.fabric8.kubernetes.api.model.authentication.TokenReview;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Collection;
import io.fabric8.kubernetes.api.builder.Nested;

public class SubjectAccessReviewFluentImpl<A extends SubjectAccessReviewFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SubjectAccessReviewFluent<A>{

    private String apiVersion;
    private VisitableBuilder<? extends HasMetadata,?> content;
    private List<String> groups = new ArrayList<String>();
    private Boolean isNonResourceURL;
    private String kind;
    private String namespace;
    private String path;
    private String resource;
    private String resourceAPIGroup;
    private String resourceAPIVersion;
    private String resourceName;
    private List<String> scopes = new ArrayList<String>();
    private String user;
    private String verb;

    public SubjectAccessReviewFluentImpl(){
    }
    public SubjectAccessReviewFluentImpl(SubjectAccessReview instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withContent(instance.getContent()); 
            this.withGroups(instance.getGroups()); 
            this.withIsNonResourceURL(instance.getIsNonResourceURL()); 
            this.withKind(instance.getKind()); 
            this.withNamespace(instance.getNamespace()); 
            this.withPath(instance.getPath()); 
            this.withResource(instance.getResource()); 
            this.withResourceAPIGroup(instance.getResourceAPIGroup()); 
            this.withResourceAPIVersion(instance.getResourceAPIVersion()); 
            this.withResourceName(instance.getResourceName()); 
            this.withScopes(instance.getScopes()); 
            this.withUser(instance.getUser()); 
            this.withVerb(instance.getVerb()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildContent instead.
 * @return The buildable object.
 */
@Deprecated public HasMetadata getContent(){
            return this.content!=null?this.content.build():null;
    }

    public HasMetadata buildContent(){
            return this.content!=null?this.content.build():null;
    }

    public A withContent(HasMetadata content){
            if (content instanceof ClusterVersion){ this.content= new ClusterVersionBuilder((ClusterVersion)content); _visitables.get("content").add(this.content);}
            if (content instanceof ImageStreamImport){ this.content= new ImageStreamImportBuilder((ImageStreamImport)content); _visitables.get("content").add(this.content);}
            if (content instanceof Proxy){ this.content= new ProxyBuilder((Proxy)content); _visitables.get("content").add(this.content);}
            if (content instanceof Project){ this.content= new ProjectBuilder((Project)content); _visitables.get("content").add(this.content);}
            if (content instanceof ClusterOperator){ this.content= new ClusterOperatorBuilder((ClusterOperator)content); _visitables.get("content").add(this.content);}
            if (content instanceof BuildConfig){ this.content= new BuildConfigBuilder((BuildConfig)content); _visitables.get("content").add(this.content);}
            if (content instanceof Infrastructure){ this.content= new InfrastructureBuilder((Infrastructure)content); _visitables.get("content").add(this.content);}
            if (content instanceof Scheduler){ this.content= new SchedulerBuilder((Scheduler)content); _visitables.get("content").add(this.content);}
            if (content instanceof RangeAllocation){ this.content= new RangeAllocationBuilder((RangeAllocation)content); _visitables.get("content").add(this.content);}
            if (content instanceof Route){ this.content= new RouteBuilder((Route)content); _visitables.get("content").add(this.content);}
            if (content instanceof ClusterNetwork){ this.content= new ClusterNetworkBuilder((ClusterNetwork)content); _visitables.get("content").add(this.content);}
            if (content instanceof OAuthAuthorizeToken){ this.content= new OAuthAuthorizeTokenBuilder((OAuthAuthorizeToken)content); _visitables.get("content").add(this.content);}
            if (content instanceof OAuth){ this.content= new OAuthBuilder((OAuth)content); _visitables.get("content").add(this.content);}
            if (content instanceof OperatorHub){ this.content= new OperatorHubBuilder((OperatorHub)content); _visitables.get("content").add(this.content);}
            if (content instanceof ClusterRoleBinding){ this.content= new ClusterRoleBindingBuilder((ClusterRoleBinding)content); _visitables.get("content").add(this.content);}
            if (content instanceof ClusterResourceQuota){ this.content= new ClusterResourceQuotaBuilder((ClusterResourceQuota)content); _visitables.get("content").add(this.content);}
            if (content instanceof ProjectRequest){ this.content= new ProjectRequestBuilder((ProjectRequest)content); _visitables.get("content").add(this.content);}
            if (content instanceof Template){ this.content= new TemplateBuilder((Template)content); _visitables.get("content").add(this.content);}
            if (content instanceof OAuthClientAuthorization){ this.content= new OAuthClientAuthorizationBuilder((OAuthClientAuthorization)content); _visitables.get("content").add(this.content);}
            if (content instanceof ClusterRole){ this.content= new ClusterRoleBuilder((ClusterRole)content); _visitables.get("content").add(this.content);}
            if (content instanceof ImageTag){ this.content= new ImageTagBuilder((ImageTag)content); _visitables.get("content").add(this.content);}
            if (content instanceof DeploymentConfig){ this.content= new DeploymentConfigBuilder((DeploymentConfig)content); _visitables.get("content").add(this.content);}
            if (content instanceof OAuthAccessToken){ this.content= new OAuthAccessTokenBuilder((OAuthAccessToken)content); _visitables.get("content").add(this.content);}
            if (content instanceof RoleBinding){ this.content= new RoleBindingBuilder((RoleBinding)content); _visitables.get("content").add(this.content);}
            if (content instanceof Image){ this.content= new ImageBuilder((Image)content); _visitables.get("content").add(this.content);}
            if (content instanceof APIServer){ this.content= new APIServerBuilder((APIServer)content); _visitables.get("content").add(this.content);}
            if (content instanceof PersistentVolumeClaim){ this.content= new PersistentVolumeClaimBuilder((PersistentVolumeClaim)content); _visitables.get("content").add(this.content);}
            if (content instanceof ImageStreamMapping){ this.content= new ImageStreamMappingBuilder((ImageStreamMapping)content); _visitables.get("content").add(this.content);}
            if (content instanceof Role){ this.content= new RoleBuilder((Role)content); _visitables.get("content").add(this.content);}
            if (content instanceof FeatureGate){ this.content= new FeatureGateBuilder((FeatureGate)content); _visitables.get("content").add(this.content);}
            if (content instanceof User){ this.content= new UserBuilder((User)content); _visitables.get("content").add(this.content);}
            if (content instanceof ImageStreamImage){ this.content= new ImageStreamImageBuilder((ImageStreamImage)content); _visitables.get("content").add(this.content);}
            if (content instanceof Build){ this.content= new BuildBuilder((Build)content); _visitables.get("content").add(this.content);}
            if (content instanceof RoleBindingRestriction){ this.content= new RoleBindingRestrictionBuilder((RoleBindingRestriction)content); _visitables.get("content").add(this.content);}
            if (content instanceof ImageStreamTag){ this.content= new ImageStreamTagBuilder((ImageStreamTag)content); _visitables.get("content").add(this.content);}
            if (content instanceof Group){ this.content= new GroupBuilder((Group)content); _visitables.get("content").add(this.content);}
            if (content instanceof TokenReview){ this.content= new TokenReviewBuilder((TokenReview)content); _visitables.get("content").add(this.content);}
            if (content instanceof ImageSignature){ this.content= new ImageSignatureBuilder((ImageSignature)content); _visitables.get("content").add(this.content);}
            if (content instanceof AppliedClusterResourceQuota){ this.content= new AppliedClusterResourceQuotaBuilder((AppliedClusterResourceQuota)content); _visitables.get("content").add(this.content);}
            if (content instanceof SecurityContextConstraints){ this.content= new SecurityContextConstraintsBuilder((SecurityContextConstraints)content); _visitables.get("content").add(this.content);}
            if (content instanceof BuildRequest){ this.content= new BuildRequestBuilder((BuildRequest)content); _visitables.get("content").add(this.content);}
            if (content instanceof EgressNetworkPolicy){ this.content= new EgressNetworkPolicyBuilder((EgressNetworkPolicy)content); _visitables.get("content").add(this.content);}
            if (content instanceof NetNamespace){ this.content= new NetNamespaceBuilder((NetNamespace)content); _visitables.get("content").add(this.content);}
            if (content instanceof ImageStream){ this.content= new ImageStreamBuilder((ImageStream)content); _visitables.get("content").add(this.content);}
            if (content instanceof OAuthClient){ this.content= new OAuthClientBuilder((OAuthClient)content); _visitables.get("content").add(this.content);}
            if (content instanceof Identity){ this.content= new IdentityBuilder((Identity)content); _visitables.get("content").add(this.content);}
            return (A) this;
    }

    public Boolean hasContent(){
            return this.content != null;
    }

    public A withClusterVersionContent(ClusterVersion clusterVersionContent){
            _visitables.get("content").remove(this.content);
            if (clusterVersionContent!=null){ this.content= new ClusterVersionBuilder(clusterVersionContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public SubjectAccessReviewFluent.ClusterVersionContentNested<A> withNewClusterVersionContent(){
            return new ClusterVersionContentNestedImpl();
    }

    public SubjectAccessReviewFluent.ClusterVersionContentNested<A> withNewClusterVersionContentLike(ClusterVersion item){
            return new ClusterVersionContentNestedImpl(item);
    }

    public A withImageStreamImportContent(ImageStreamImport imageStreamImportContent){
            _visitables.get("content").remove(this.content);
            if (imageStreamImportContent!=null){ this.content= new ImageStreamImportBuilder(imageStreamImportContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public SubjectAccessReviewFluent.ImageStreamImportContentNested<A> withNewImageStreamImportContent(){
            return new ImageStreamImportContentNestedImpl();
    }

    public SubjectAccessReviewFluent.ImageStreamImportContentNested<A> withNewImageStreamImportContentLike(ImageStreamImport item){
            return new ImageStreamImportContentNestedImpl(item);
    }

    public A withProxyContent(Proxy proxyContent){
            _visitables.get("content").remove(this.content);
            if (proxyContent!=null){ this.content= new ProxyBuilder(proxyContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public SubjectAccessReviewFluent.ProxyContentNested<A> withNewProxyContent(){
            return new ProxyContentNestedImpl();
    }

    public SubjectAccessReviewFluent.ProxyContentNested<A> withNewProxyContentLike(Proxy item){
            return new ProxyContentNestedImpl(item);
    }

    public A withProjectContent(Project projectContent){
            _visitables.get("content").remove(this.content);
            if (projectContent!=null){ this.content= new ProjectBuilder(projectContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public SubjectAccessReviewFluent.ProjectContentNested<A> withNewProjectContent(){
            return new ProjectContentNestedImpl();
    }

    public SubjectAccessReviewFluent.ProjectContentNested<A> withNewProjectContentLike(Project item){
            return new ProjectContentNestedImpl(item);
    }

    public A withClusterOperatorContent(ClusterOperator clusterOperatorContent){
            _visitables.get("content").remove(this.content);
            if (clusterOperatorContent!=null){ this.content= new ClusterOperatorBuilder(clusterOperatorContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public SubjectAccessReviewFluent.ClusterOperatorContentNested<A> withNewClusterOperatorContent(){
            return new ClusterOperatorContentNestedImpl();
    }

    public SubjectAccessReviewFluent.ClusterOperatorContentNested<A> withNewClusterOperatorContentLike(ClusterOperator item){
            return new ClusterOperatorContentNestedImpl(item);
    }

    public A withBuildConfigContent(BuildConfig buildConfigContent){
            _visitables.get("content").remove(this.content);
            if (buildConfigContent!=null){ this.content= new BuildConfigBuilder(buildConfigContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public SubjectAccessReviewFluent.BuildConfigContentNested<A> withNewBuildConfigContent(){
            return new BuildConfigContentNestedImpl();
    }

    public SubjectAccessReviewFluent.BuildConfigContentNested<A> withNewBuildConfigContentLike(BuildConfig item){
            return new BuildConfigContentNestedImpl(item);
    }

    public A withInfrastructureContent(Infrastructure infrastructureContent){
            _visitables.get("content").remove(this.content);
            if (infrastructureContent!=null){ this.content= new InfrastructureBuilder(infrastructureContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public SubjectAccessReviewFluent.InfrastructureContentNested<A> withNewInfrastructureContent(){
            return new InfrastructureContentNestedImpl();
    }

    public SubjectAccessReviewFluent.InfrastructureContentNested<A> withNewInfrastructureContentLike(Infrastructure item){
            return new InfrastructureContentNestedImpl(item);
    }

    public A withSchedulerContent(Scheduler schedulerContent){
            _visitables.get("content").remove(this.content);
            if (schedulerContent!=null){ this.content= new SchedulerBuilder(schedulerContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public SubjectAccessReviewFluent.SchedulerContentNested<A> withNewSchedulerContent(){
            return new SchedulerContentNestedImpl();
    }

    public SubjectAccessReviewFluent.SchedulerContentNested<A> withNewSchedulerContentLike(Scheduler item){
            return new SchedulerContentNestedImpl(item);
    }

    public A withRangeAllocationContent(RangeAllocation rangeAllocationContent){
            _visitables.get("content").remove(this.content);
            if (rangeAllocationContent!=null){ this.content= new RangeAllocationBuilder(rangeAllocationContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public SubjectAccessReviewFluent.RangeAllocationContentNested<A> withNewRangeAllocationContent(){
            return new RangeAllocationContentNestedImpl();
    }

    public SubjectAccessReviewFluent.RangeAllocationContentNested<A> withNewRangeAllocationContentLike(RangeAllocation item){
            return new RangeAllocationContentNestedImpl(item);
    }

    public A withRouteContent(Route routeContent){
            _visitables.get("content").remove(this.content);
            if (routeContent!=null){ this.content= new RouteBuilder(routeContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public SubjectAccessReviewFluent.RouteContentNested<A> withNewRouteContent(){
            return new RouteContentNestedImpl();
    }

    public SubjectAccessReviewFluent.RouteContentNested<A> withNewRouteContentLike(Route item){
            return new RouteContentNestedImpl(item);
    }

    public A withClusterNetworkContent(ClusterNetwork clusterNetworkContent){
            _visitables.get("content").remove(this.content);
            if (clusterNetworkContent!=null){ this.content= new ClusterNetworkBuilder(clusterNetworkContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public SubjectAccessReviewFluent.ClusterNetworkContentNested<A> withNewClusterNetworkContent(){
            return new ClusterNetworkContentNestedImpl();
    }

    public SubjectAccessReviewFluent.ClusterNetworkContentNested<A> withNewClusterNetworkContentLike(ClusterNetwork item){
            return new ClusterNetworkContentNestedImpl(item);
    }

    public A withOAuthAuthorizeTokenContent(OAuthAuthorizeToken oAuthAuthorizeTokenContent){
            _visitables.get("content").remove(this.content);
            if (oAuthAuthorizeTokenContent!=null){ this.content= new OAuthAuthorizeTokenBuilder(oAuthAuthorizeTokenContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public SubjectAccessReviewFluent.OAuthAuthorizeTokenContentNested<A> withNewOAuthAuthorizeTokenContent(){
            return new OAuthAuthorizeTokenContentNestedImpl();
    }

    public SubjectAccessReviewFluent.OAuthAuthorizeTokenContentNested<A> withNewOAuthAuthorizeTokenContentLike(OAuthAuthorizeToken item){
            return new OAuthAuthorizeTokenContentNestedImpl(item);
    }

    public A withOAuthContent(OAuth oAuthContent){
            _visitables.get("content").remove(this.content);
            if (oAuthContent!=null){ this.content= new OAuthBuilder(oAuthContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public SubjectAccessReviewFluent.OAuthContentNested<A> withNewOAuthContent(){
            return new OAuthContentNestedImpl();
    }

    public SubjectAccessReviewFluent.OAuthContentNested<A> withNewOAuthContentLike(OAuth item){
            return new OAuthContentNestedImpl(item);
    }

    public A withOperatorHubContent(OperatorHub operatorHubContent){
            _visitables.get("content").remove(this.content);
            if (operatorHubContent!=null){ this.content= new OperatorHubBuilder(operatorHubContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public SubjectAccessReviewFluent.OperatorHubContentNested<A> withNewOperatorHubContent(){
            return new OperatorHubContentNestedImpl();
    }

    public SubjectAccessReviewFluent.OperatorHubContentNested<A> withNewOperatorHubContentLike(OperatorHub item){
            return new OperatorHubContentNestedImpl(item);
    }

    public A withClusterRoleBindingContent(ClusterRoleBinding clusterRoleBindingContent){
            _visitables.get("content").remove(this.content);
            if (clusterRoleBindingContent!=null){ this.content= new ClusterRoleBindingBuilder(clusterRoleBindingContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public SubjectAccessReviewFluent.ClusterRoleBindingContentNested<A> withNewClusterRoleBindingContent(){
            return new ClusterRoleBindingContentNestedImpl();
    }

    public SubjectAccessReviewFluent.ClusterRoleBindingContentNested<A> withNewClusterRoleBindingContentLike(ClusterRoleBinding item){
            return new ClusterRoleBindingContentNestedImpl(item);
    }

    public A withClusterResourceQuotaContent(ClusterResourceQuota clusterResourceQuotaContent){
            _visitables.get("content").remove(this.content);
            if (clusterResourceQuotaContent!=null){ this.content= new ClusterResourceQuotaBuilder(clusterResourceQuotaContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public SubjectAccessReviewFluent.ClusterResourceQuotaContentNested<A> withNewClusterResourceQuotaContent(){
            return new ClusterResourceQuotaContentNestedImpl();
    }

    public SubjectAccessReviewFluent.ClusterResourceQuotaContentNested<A> withNewClusterResourceQuotaContentLike(ClusterResourceQuota item){
            return new ClusterResourceQuotaContentNestedImpl(item);
    }

    public A withProjectRequestContent(ProjectRequest projectRequestContent){
            _visitables.get("content").remove(this.content);
            if (projectRequestContent!=null){ this.content= new ProjectRequestBuilder(projectRequestContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public SubjectAccessReviewFluent.ProjectRequestContentNested<A> withNewProjectRequestContent(){
            return new ProjectRequestContentNestedImpl();
    }

    public SubjectAccessReviewFluent.ProjectRequestContentNested<A> withNewProjectRequestContentLike(ProjectRequest item){
            return new ProjectRequestContentNestedImpl(item);
    }

    public A withTemplateContent(Template templateContent){
            _visitables.get("content").remove(this.content);
            if (templateContent!=null){ this.content= new TemplateBuilder(templateContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public SubjectAccessReviewFluent.TemplateContentNested<A> withNewTemplateContent(){
            return new TemplateContentNestedImpl();
    }

    public SubjectAccessReviewFluent.TemplateContentNested<A> withNewTemplateContentLike(Template item){
            return new TemplateContentNestedImpl(item);
    }

    public A withOAuthClientAuthorizationContent(OAuthClientAuthorization oAuthClientAuthorizationContent){
            _visitables.get("content").remove(this.content);
            if (oAuthClientAuthorizationContent!=null){ this.content= new OAuthClientAuthorizationBuilder(oAuthClientAuthorizationContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public SubjectAccessReviewFluent.OAuthClientAuthorizationContentNested<A> withNewOAuthClientAuthorizationContent(){
            return new OAuthClientAuthorizationContentNestedImpl();
    }

    public SubjectAccessReviewFluent.OAuthClientAuthorizationContentNested<A> withNewOAuthClientAuthorizationContentLike(OAuthClientAuthorization item){
            return new OAuthClientAuthorizationContentNestedImpl(item);
    }

    public A withClusterRoleContent(ClusterRole clusterRoleContent){
            _visitables.get("content").remove(this.content);
            if (clusterRoleContent!=null){ this.content= new ClusterRoleBuilder(clusterRoleContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public SubjectAccessReviewFluent.ClusterRoleContentNested<A> withNewClusterRoleContent(){
            return new ClusterRoleContentNestedImpl();
    }

    public SubjectAccessReviewFluent.ClusterRoleContentNested<A> withNewClusterRoleContentLike(ClusterRole item){
            return new ClusterRoleContentNestedImpl(item);
    }

    public A withImageTagContent(ImageTag imageTagContent){
            _visitables.get("content").remove(this.content);
            if (imageTagContent!=null){ this.content= new ImageTagBuilder(imageTagContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public SubjectAccessReviewFluent.ImageTagContentNested<A> withNewImageTagContent(){
            return new ImageTagContentNestedImpl();
    }

    public SubjectAccessReviewFluent.ImageTagContentNested<A> withNewImageTagContentLike(ImageTag item){
            return new ImageTagContentNestedImpl(item);
    }

    public A withDeploymentConfigContent(DeploymentConfig deploymentConfigContent){
            _visitables.get("content").remove(this.content);
            if (deploymentConfigContent!=null){ this.content= new DeploymentConfigBuilder(deploymentConfigContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public SubjectAccessReviewFluent.DeploymentConfigContentNested<A> withNewDeploymentConfigContent(){
            return new DeploymentConfigContentNestedImpl();
    }

    public SubjectAccessReviewFluent.DeploymentConfigContentNested<A> withNewDeploymentConfigContentLike(DeploymentConfig item){
            return new DeploymentConfigContentNestedImpl(item);
    }

    public A withOAuthAccessTokenContent(OAuthAccessToken oAuthAccessTokenContent){
            _visitables.get("content").remove(this.content);
            if (oAuthAccessTokenContent!=null){ this.content= new OAuthAccessTokenBuilder(oAuthAccessTokenContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public SubjectAccessReviewFluent.OAuthAccessTokenContentNested<A> withNewOAuthAccessTokenContent(){
            return new OAuthAccessTokenContentNestedImpl();
    }

    public SubjectAccessReviewFluent.OAuthAccessTokenContentNested<A> withNewOAuthAccessTokenContentLike(OAuthAccessToken item){
            return new OAuthAccessTokenContentNestedImpl(item);
    }

    public A withRoleBindingContent(RoleBinding roleBindingContent){
            _visitables.get("content").remove(this.content);
            if (roleBindingContent!=null){ this.content= new RoleBindingBuilder(roleBindingContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public SubjectAccessReviewFluent.RoleBindingContentNested<A> withNewRoleBindingContent(){
            return new RoleBindingContentNestedImpl();
    }

    public SubjectAccessReviewFluent.RoleBindingContentNested<A> withNewRoleBindingContentLike(RoleBinding item){
            return new RoleBindingContentNestedImpl(item);
    }

    public A withImageContent(Image imageContent){
            _visitables.get("content").remove(this.content);
            if (imageContent!=null){ this.content= new ImageBuilder(imageContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public SubjectAccessReviewFluent.ImageContentNested<A> withNewImageContent(){
            return new ImageContentNestedImpl();
    }

    public SubjectAccessReviewFluent.ImageContentNested<A> withNewImageContentLike(Image item){
            return new ImageContentNestedImpl(item);
    }

    public A withAPIServerContent(APIServer aPIServerContent){
            _visitables.get("content").remove(this.content);
            if (aPIServerContent!=null){ this.content= new APIServerBuilder(aPIServerContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public SubjectAccessReviewFluent.APIServerContentNested<A> withNewAPIServerContent(){
            return new APIServerContentNestedImpl();
    }

    public SubjectAccessReviewFluent.APIServerContentNested<A> withNewAPIServerContentLike(APIServer item){
            return new APIServerContentNestedImpl(item);
    }

    public A withPersistentVolumeClaimContent(PersistentVolumeClaim persistentVolumeClaimContent){
            _visitables.get("content").remove(this.content);
            if (persistentVolumeClaimContent!=null){ this.content= new PersistentVolumeClaimBuilder(persistentVolumeClaimContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public SubjectAccessReviewFluent.PersistentVolumeClaimContentNested<A> withNewPersistentVolumeClaimContent(){
            return new PersistentVolumeClaimContentNestedImpl();
    }

    public SubjectAccessReviewFluent.PersistentVolumeClaimContentNested<A> withNewPersistentVolumeClaimContentLike(PersistentVolumeClaim item){
            return new PersistentVolumeClaimContentNestedImpl(item);
    }

    public A withImageStreamMappingContent(ImageStreamMapping imageStreamMappingContent){
            _visitables.get("content").remove(this.content);
            if (imageStreamMappingContent!=null){ this.content= new ImageStreamMappingBuilder(imageStreamMappingContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public SubjectAccessReviewFluent.ImageStreamMappingContentNested<A> withNewImageStreamMappingContent(){
            return new ImageStreamMappingContentNestedImpl();
    }

    public SubjectAccessReviewFluent.ImageStreamMappingContentNested<A> withNewImageStreamMappingContentLike(ImageStreamMapping item){
            return new ImageStreamMappingContentNestedImpl(item);
    }

    public A withRoleContent(Role roleContent){
            _visitables.get("content").remove(this.content);
            if (roleContent!=null){ this.content= new RoleBuilder(roleContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public SubjectAccessReviewFluent.RoleContentNested<A> withNewRoleContent(){
            return new RoleContentNestedImpl();
    }

    public SubjectAccessReviewFluent.RoleContentNested<A> withNewRoleContentLike(Role item){
            return new RoleContentNestedImpl(item);
    }

    public A withFeatureGateContent(FeatureGate featureGateContent){
            _visitables.get("content").remove(this.content);
            if (featureGateContent!=null){ this.content= new FeatureGateBuilder(featureGateContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public SubjectAccessReviewFluent.FeatureGateContentNested<A> withNewFeatureGateContent(){
            return new FeatureGateContentNestedImpl();
    }

    public SubjectAccessReviewFluent.FeatureGateContentNested<A> withNewFeatureGateContentLike(FeatureGate item){
            return new FeatureGateContentNestedImpl(item);
    }

    public A withUserContent(User userContent){
            _visitables.get("content").remove(this.content);
            if (userContent!=null){ this.content= new UserBuilder(userContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public SubjectAccessReviewFluent.UserContentNested<A> withNewUserContent(){
            return new UserContentNestedImpl();
    }

    public SubjectAccessReviewFluent.UserContentNested<A> withNewUserContentLike(User item){
            return new UserContentNestedImpl(item);
    }

    public A withImageStreamImageContent(ImageStreamImage imageStreamImageContent){
            _visitables.get("content").remove(this.content);
            if (imageStreamImageContent!=null){ this.content= new ImageStreamImageBuilder(imageStreamImageContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public SubjectAccessReviewFluent.ImageStreamImageContentNested<A> withNewImageStreamImageContent(){
            return new ImageStreamImageContentNestedImpl();
    }

    public SubjectAccessReviewFluent.ImageStreamImageContentNested<A> withNewImageStreamImageContentLike(ImageStreamImage item){
            return new ImageStreamImageContentNestedImpl(item);
    }

    public A withBuildContent(Build buildContent){
            _visitables.get("content").remove(this.content);
            if (buildContent!=null){ this.content= new BuildBuilder(buildContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public SubjectAccessReviewFluent.BuildContentNested<A> withNewBuildContent(){
            return new BuildContentNestedImpl();
    }

    public SubjectAccessReviewFluent.BuildContentNested<A> withNewBuildContentLike(Build item){
            return new BuildContentNestedImpl(item);
    }

    public A withRoleBindingRestrictionContent(RoleBindingRestriction roleBindingRestrictionContent){
            _visitables.get("content").remove(this.content);
            if (roleBindingRestrictionContent!=null){ this.content= new RoleBindingRestrictionBuilder(roleBindingRestrictionContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public SubjectAccessReviewFluent.RoleBindingRestrictionContentNested<A> withNewRoleBindingRestrictionContent(){
            return new RoleBindingRestrictionContentNestedImpl();
    }

    public SubjectAccessReviewFluent.RoleBindingRestrictionContentNested<A> withNewRoleBindingRestrictionContentLike(RoleBindingRestriction item){
            return new RoleBindingRestrictionContentNestedImpl(item);
    }

    public A withImageStreamTagContent(ImageStreamTag imageStreamTagContent){
            _visitables.get("content").remove(this.content);
            if (imageStreamTagContent!=null){ this.content= new ImageStreamTagBuilder(imageStreamTagContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public SubjectAccessReviewFluent.ImageStreamTagContentNested<A> withNewImageStreamTagContent(){
            return new ImageStreamTagContentNestedImpl();
    }

    public SubjectAccessReviewFluent.ImageStreamTagContentNested<A> withNewImageStreamTagContentLike(ImageStreamTag item){
            return new ImageStreamTagContentNestedImpl(item);
    }

    public A withGroupContent(Group groupContent){
            _visitables.get("content").remove(this.content);
            if (groupContent!=null){ this.content= new GroupBuilder(groupContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public SubjectAccessReviewFluent.GroupContentNested<A> withNewGroupContent(){
            return new GroupContentNestedImpl();
    }

    public SubjectAccessReviewFluent.GroupContentNested<A> withNewGroupContentLike(Group item){
            return new GroupContentNestedImpl(item);
    }

    public A withTokenReviewContent(TokenReview tokenReviewContent){
            _visitables.get("content").remove(this.content);
            if (tokenReviewContent!=null){ this.content= new TokenReviewBuilder(tokenReviewContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public SubjectAccessReviewFluent.TokenReviewContentNested<A> withNewTokenReviewContent(){
            return new TokenReviewContentNestedImpl();
    }

    public SubjectAccessReviewFluent.TokenReviewContentNested<A> withNewTokenReviewContentLike(TokenReview item){
            return new TokenReviewContentNestedImpl(item);
    }

    public A withImageSignatureContent(ImageSignature imageSignatureContent){
            _visitables.get("content").remove(this.content);
            if (imageSignatureContent!=null){ this.content= new ImageSignatureBuilder(imageSignatureContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public SubjectAccessReviewFluent.ImageSignatureContentNested<A> withNewImageSignatureContent(){
            return new ImageSignatureContentNestedImpl();
    }

    public SubjectAccessReviewFluent.ImageSignatureContentNested<A> withNewImageSignatureContentLike(ImageSignature item){
            return new ImageSignatureContentNestedImpl(item);
    }

    public A withAppliedClusterResourceQuotaContent(AppliedClusterResourceQuota appliedClusterResourceQuotaContent){
            _visitables.get("content").remove(this.content);
            if (appliedClusterResourceQuotaContent!=null){ this.content= new AppliedClusterResourceQuotaBuilder(appliedClusterResourceQuotaContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public SubjectAccessReviewFluent.AppliedClusterResourceQuotaContentNested<A> withNewAppliedClusterResourceQuotaContent(){
            return new AppliedClusterResourceQuotaContentNestedImpl();
    }

    public SubjectAccessReviewFluent.AppliedClusterResourceQuotaContentNested<A> withNewAppliedClusterResourceQuotaContentLike(AppliedClusterResourceQuota item){
            return new AppliedClusterResourceQuotaContentNestedImpl(item);
    }

    public A withSecurityContextConstraintsContent(SecurityContextConstraints securityContextConstraintsContent){
            _visitables.get("content").remove(this.content);
            if (securityContextConstraintsContent!=null){ this.content= new SecurityContextConstraintsBuilder(securityContextConstraintsContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public SubjectAccessReviewFluent.SecurityContextConstraintsContentNested<A> withNewSecurityContextConstraintsContent(){
            return new SecurityContextConstraintsContentNestedImpl();
    }

    public SubjectAccessReviewFluent.SecurityContextConstraintsContentNested<A> withNewSecurityContextConstraintsContentLike(SecurityContextConstraints item){
            return new SecurityContextConstraintsContentNestedImpl(item);
    }

    public A withBuildRequestContent(BuildRequest buildRequestContent){
            _visitables.get("content").remove(this.content);
            if (buildRequestContent!=null){ this.content= new BuildRequestBuilder(buildRequestContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public SubjectAccessReviewFluent.BuildRequestContentNested<A> withNewBuildRequestContent(){
            return new BuildRequestContentNestedImpl();
    }

    public SubjectAccessReviewFluent.BuildRequestContentNested<A> withNewBuildRequestContentLike(BuildRequest item){
            return new BuildRequestContentNestedImpl(item);
    }

    public A withEgressNetworkPolicyContent(EgressNetworkPolicy egressNetworkPolicyContent){
            _visitables.get("content").remove(this.content);
            if (egressNetworkPolicyContent!=null){ this.content= new EgressNetworkPolicyBuilder(egressNetworkPolicyContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public SubjectAccessReviewFluent.EgressNetworkPolicyContentNested<A> withNewEgressNetworkPolicyContent(){
            return new EgressNetworkPolicyContentNestedImpl();
    }

    public SubjectAccessReviewFluent.EgressNetworkPolicyContentNested<A> withNewEgressNetworkPolicyContentLike(EgressNetworkPolicy item){
            return new EgressNetworkPolicyContentNestedImpl(item);
    }

    public A withNetNamespaceContent(NetNamespace netNamespaceContent){
            _visitables.get("content").remove(this.content);
            if (netNamespaceContent!=null){ this.content= new NetNamespaceBuilder(netNamespaceContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public SubjectAccessReviewFluent.NetNamespaceContentNested<A> withNewNetNamespaceContent(){
            return new NetNamespaceContentNestedImpl();
    }

    public SubjectAccessReviewFluent.NetNamespaceContentNested<A> withNewNetNamespaceContentLike(NetNamespace item){
            return new NetNamespaceContentNestedImpl(item);
    }

    public A withImageStreamContent(ImageStream imageStreamContent){
            _visitables.get("content").remove(this.content);
            if (imageStreamContent!=null){ this.content= new ImageStreamBuilder(imageStreamContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public SubjectAccessReviewFluent.ImageStreamContentNested<A> withNewImageStreamContent(){
            return new ImageStreamContentNestedImpl();
    }

    public SubjectAccessReviewFluent.ImageStreamContentNested<A> withNewImageStreamContentLike(ImageStream item){
            return new ImageStreamContentNestedImpl(item);
    }

    public A withOAuthClientContent(OAuthClient oAuthClientContent){
            _visitables.get("content").remove(this.content);
            if (oAuthClientContent!=null){ this.content= new OAuthClientBuilder(oAuthClientContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public SubjectAccessReviewFluent.OAuthClientContentNested<A> withNewOAuthClientContent(){
            return new OAuthClientContentNestedImpl();
    }

    public SubjectAccessReviewFluent.OAuthClientContentNested<A> withNewOAuthClientContentLike(OAuthClient item){
            return new OAuthClientContentNestedImpl(item);
    }

    public A withIdentityContent(Identity identityContent){
            _visitables.get("content").remove(this.content);
            if (identityContent!=null){ this.content= new IdentityBuilder(identityContent); _visitables.get("content").add(this.content);} return (A) this;
    }

    public SubjectAccessReviewFluent.IdentityContentNested<A> withNewIdentityContent(){
            return new IdentityContentNestedImpl();
    }

    public SubjectAccessReviewFluent.IdentityContentNested<A> withNewIdentityContentLike(Identity item){
            return new IdentityContentNestedImpl(item);
    }

    public A addToGroups(int index,String item){
            if (this.groups == null) {this.groups = new ArrayList<String>();}
            this.groups.add(index, item);
            return (A)this;
    }

    public A setToGroups(int index,String item){
            if (this.groups == null) {this.groups = new ArrayList<String>();}
            this.groups.set(index, item); return (A)this;
    }

    public A addToGroups(String... items){
            if (this.groups == null) {this.groups = new ArrayList<String>();}
            for (String item : items) {this.groups.add(item);} return (A)this;
    }

    public A addAllToGroups(Collection<String> items){
            if (this.groups == null) {this.groups = new ArrayList<String>();}
            for (String item : items) {this.groups.add(item);} return (A)this;
    }

    public A removeFromGroups(String... items){
            for (String item : items) {if (this.groups!= null){ this.groups.remove(item);}} return (A)this;
    }

    public A removeAllFromGroups(Collection<String> items){
            for (String item : items) {if (this.groups!= null){ this.groups.remove(item);}} return (A)this;
    }

    public List<String> getGroups(){
            return this.groups;
    }

    public String getGroup(int index){
            return this.groups.get(index);
    }

    public String getFirstGroup(){
            return this.groups.get(0);
    }

    public String getLastGroup(){
            return this.groups.get(groups.size() - 1);
    }

    public String getMatchingGroup(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: groups) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingGroup(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: groups) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withGroups(List<String> groups){
            if (this.groups != null) { _visitables.get("groups").removeAll(this.groups);}
            if (groups != null) {this.groups = new ArrayList<String>(); for (String item : groups){this.addToGroups(item);}} else { this.groups = null;} return (A) this;
    }

    public A withGroups(String... groups){
            if (this.groups != null) {this.groups.clear();}
            if (groups != null) {for (String item :groups){ this.addToGroups(item);}} return (A) this;
    }

    public Boolean hasGroups(){
            return groups != null && !groups.isEmpty();
    }

    public A addNewGroup(String arg1){
            return (A)addToGroups(new String(arg1));
    }

    public A addNewGroup(StringBuilder arg1){
            return (A)addToGroups(new String(arg1));
    }

    public A addNewGroup(StringBuffer arg1){
            return (A)addToGroups(new String(arg1));
    }

    public Boolean isIsNonResourceURL(){
            return this.isNonResourceURL;
    }

    public A withIsNonResourceURL(Boolean isNonResourceURL){
            this.isNonResourceURL=isNonResourceURL; return (A) this;
    }

    public Boolean hasIsNonResourceURL(){
            return this.isNonResourceURL != null;
    }

    public A withNewIsNonResourceURL(String arg1){
            return (A)withIsNonResourceURL(new Boolean(arg1));
    }

    public A withNewIsNonResourceURL(boolean arg1){
            return (A)withIsNonResourceURL(new Boolean(arg1));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public A withNewKind(String arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1){
            return (A)withKind(new String(arg1));
    }

    public String getNamespace(){
            return this.namespace;
    }

    public A withNamespace(String namespace){
            this.namespace=namespace; return (A) this;
    }

    public Boolean hasNamespace(){
            return this.namespace != null;
    }

    public A withNewNamespace(String arg1){
            return (A)withNamespace(new String(arg1));
    }

    public A withNewNamespace(StringBuilder arg1){
            return (A)withNamespace(new String(arg1));
    }

    public A withNewNamespace(StringBuffer arg1){
            return (A)withNamespace(new String(arg1));
    }

    public String getPath(){
            return this.path;
    }

    public A withPath(String path){
            this.path=path; return (A) this;
    }

    public Boolean hasPath(){
            return this.path != null;
    }

    public A withNewPath(String arg1){
            return (A)withPath(new String(arg1));
    }

    public A withNewPath(StringBuilder arg1){
            return (A)withPath(new String(arg1));
    }

    public A withNewPath(StringBuffer arg1){
            return (A)withPath(new String(arg1));
    }

    public String getResource(){
            return this.resource;
    }

    public A withResource(String resource){
            this.resource=resource; return (A) this;
    }

    public Boolean hasResource(){
            return this.resource != null;
    }

    public A withNewResource(String arg1){
            return (A)withResource(new String(arg1));
    }

    public A withNewResource(StringBuilder arg1){
            return (A)withResource(new String(arg1));
    }

    public A withNewResource(StringBuffer arg1){
            return (A)withResource(new String(arg1));
    }

    public String getResourceAPIGroup(){
            return this.resourceAPIGroup;
    }

    public A withResourceAPIGroup(String resourceAPIGroup){
            this.resourceAPIGroup=resourceAPIGroup; return (A) this;
    }

    public Boolean hasResourceAPIGroup(){
            return this.resourceAPIGroup != null;
    }

    public A withNewResourceAPIGroup(String arg1){
            return (A)withResourceAPIGroup(new String(arg1));
    }

    public A withNewResourceAPIGroup(StringBuilder arg1){
            return (A)withResourceAPIGroup(new String(arg1));
    }

    public A withNewResourceAPIGroup(StringBuffer arg1){
            return (A)withResourceAPIGroup(new String(arg1));
    }

    public String getResourceAPIVersion(){
            return this.resourceAPIVersion;
    }

    public A withResourceAPIVersion(String resourceAPIVersion){
            this.resourceAPIVersion=resourceAPIVersion; return (A) this;
    }

    public Boolean hasResourceAPIVersion(){
            return this.resourceAPIVersion != null;
    }

    public A withNewResourceAPIVersion(String arg1){
            return (A)withResourceAPIVersion(new String(arg1));
    }

    public A withNewResourceAPIVersion(StringBuilder arg1){
            return (A)withResourceAPIVersion(new String(arg1));
    }

    public A withNewResourceAPIVersion(StringBuffer arg1){
            return (A)withResourceAPIVersion(new String(arg1));
    }

    public String getResourceName(){
            return this.resourceName;
    }

    public A withResourceName(String resourceName){
            this.resourceName=resourceName; return (A) this;
    }

    public Boolean hasResourceName(){
            return this.resourceName != null;
    }

    public A withNewResourceName(String arg1){
            return (A)withResourceName(new String(arg1));
    }

    public A withNewResourceName(StringBuilder arg1){
            return (A)withResourceName(new String(arg1));
    }

    public A withNewResourceName(StringBuffer arg1){
            return (A)withResourceName(new String(arg1));
    }

    public A addToScopes(int index,String item){
            if (this.scopes == null) {this.scopes = new ArrayList<String>();}
            this.scopes.add(index, item);
            return (A)this;
    }

    public A setToScopes(int index,String item){
            if (this.scopes == null) {this.scopes = new ArrayList<String>();}
            this.scopes.set(index, item); return (A)this;
    }

    public A addToScopes(String... items){
            if (this.scopes == null) {this.scopes = new ArrayList<String>();}
            for (String item : items) {this.scopes.add(item);} return (A)this;
    }

    public A addAllToScopes(Collection<String> items){
            if (this.scopes == null) {this.scopes = new ArrayList<String>();}
            for (String item : items) {this.scopes.add(item);} return (A)this;
    }

    public A removeFromScopes(String... items){
            for (String item : items) {if (this.scopes!= null){ this.scopes.remove(item);}} return (A)this;
    }

    public A removeAllFromScopes(Collection<String> items){
            for (String item : items) {if (this.scopes!= null){ this.scopes.remove(item);}} return (A)this;
    }

    public List<String> getScopes(){
            return this.scopes;
    }

    public String getScope(int index){
            return this.scopes.get(index);
    }

    public String getFirstScope(){
            return this.scopes.get(0);
    }

    public String getLastScope(){
            return this.scopes.get(scopes.size() - 1);
    }

    public String getMatchingScope(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: scopes) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingScope(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: scopes) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withScopes(List<String> scopes){
            if (this.scopes != null) { _visitables.get("scopes").removeAll(this.scopes);}
            if (scopes != null) {this.scopes = new ArrayList<String>(); for (String item : scopes){this.addToScopes(item);}} else { this.scopes = null;} return (A) this;
    }

    public A withScopes(String... scopes){
            if (this.scopes != null) {this.scopes.clear();}
            if (scopes != null) {for (String item :scopes){ this.addToScopes(item);}} return (A) this;
    }

    public Boolean hasScopes(){
            return scopes != null && !scopes.isEmpty();
    }

    public A addNewScope(String arg1){
            return (A)addToScopes(new String(arg1));
    }

    public A addNewScope(StringBuilder arg1){
            return (A)addToScopes(new String(arg1));
    }

    public A addNewScope(StringBuffer arg1){
            return (A)addToScopes(new String(arg1));
    }

    public String getUser(){
            return this.user;
    }

    public A withUser(String user){
            this.user=user; return (A) this;
    }

    public Boolean hasUser(){
            return this.user != null;
    }

    public A withNewUser(String arg1){
            return (A)withUser(new String(arg1));
    }

    public A withNewUser(StringBuilder arg1){
            return (A)withUser(new String(arg1));
    }

    public A withNewUser(StringBuffer arg1){
            return (A)withUser(new String(arg1));
    }

    public String getVerb(){
            return this.verb;
    }

    public A withVerb(String verb){
            this.verb=verb; return (A) this;
    }

    public Boolean hasVerb(){
            return this.verb != null;
    }

    public A withNewVerb(String arg1){
            return (A)withVerb(new String(arg1));
    }

    public A withNewVerb(StringBuilder arg1){
            return (A)withVerb(new String(arg1));
    }

    public A withNewVerb(StringBuffer arg1){
            return (A)withVerb(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            SubjectAccessReviewFluentImpl that = (SubjectAccessReviewFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (content != null ? !content.equals(that.content) :that.content != null) return false;
            if (groups != null ? !groups.equals(that.groups) :that.groups != null) return false;
            if (isNonResourceURL != null ? !isNonResourceURL.equals(that.isNonResourceURL) :that.isNonResourceURL != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (namespace != null ? !namespace.equals(that.namespace) :that.namespace != null) return false;
            if (path != null ? !path.equals(that.path) :that.path != null) return false;
            if (resource != null ? !resource.equals(that.resource) :that.resource != null) return false;
            if (resourceAPIGroup != null ? !resourceAPIGroup.equals(that.resourceAPIGroup) :that.resourceAPIGroup != null) return false;
            if (resourceAPIVersion != null ? !resourceAPIVersion.equals(that.resourceAPIVersion) :that.resourceAPIVersion != null) return false;
            if (resourceName != null ? !resourceName.equals(that.resourceName) :that.resourceName != null) return false;
            if (scopes != null ? !scopes.equals(that.scopes) :that.scopes != null) return false;
            if (user != null ? !user.equals(that.user) :that.user != null) return false;
            if (verb != null ? !verb.equals(that.verb) :that.verb != null) return false;
            return true;
    }


    public class ClusterVersionContentNestedImpl<N> extends ClusterVersionFluentImpl<SubjectAccessReviewFluent.ClusterVersionContentNested<N>> implements SubjectAccessReviewFluent.ClusterVersionContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ClusterVersionBuilder builder;
    
            ClusterVersionContentNestedImpl(ClusterVersion item){
                    this.builder = new ClusterVersionBuilder(this, item);
            }
            ClusterVersionContentNestedImpl(){
                    this.builder = new ClusterVersionBuilder(this);
            }
    
    public N and(){
            return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endClusterVersionContent(){
            return and();
    }

}
    public class ImageStreamImportContentNestedImpl<N> extends ImageStreamImportFluentImpl<SubjectAccessReviewFluent.ImageStreamImportContentNested<N>> implements SubjectAccessReviewFluent.ImageStreamImportContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ImageStreamImportBuilder builder;
    
            ImageStreamImportContentNestedImpl(ImageStreamImport item){
                    this.builder = new ImageStreamImportBuilder(this, item);
            }
            ImageStreamImportContentNestedImpl(){
                    this.builder = new ImageStreamImportBuilder(this);
            }
    
    public N and(){
            return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageStreamImportContent(){
            return and();
    }

}
    public class ProxyContentNestedImpl<N> extends ProxyFluentImpl<SubjectAccessReviewFluent.ProxyContentNested<N>> implements SubjectAccessReviewFluent.ProxyContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ProxyBuilder builder;
    
            ProxyContentNestedImpl(Proxy item){
                    this.builder = new ProxyBuilder(this, item);
            }
            ProxyContentNestedImpl(){
                    this.builder = new ProxyBuilder(this);
            }
    
    public N and(){
            return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endProxyContent(){
            return and();
    }

}
    public class ProjectContentNestedImpl<N> extends ProjectFluentImpl<SubjectAccessReviewFluent.ProjectContentNested<N>> implements SubjectAccessReviewFluent.ProjectContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ProjectBuilder builder;
    
            ProjectContentNestedImpl(Project item){
                    this.builder = new ProjectBuilder(this, item);
            }
            ProjectContentNestedImpl(){
                    this.builder = new ProjectBuilder(this);
            }
    
    public N and(){
            return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endProjectContent(){
            return and();
    }

}
    public class ClusterOperatorContentNestedImpl<N> extends ClusterOperatorFluentImpl<SubjectAccessReviewFluent.ClusterOperatorContentNested<N>> implements SubjectAccessReviewFluent.ClusterOperatorContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ClusterOperatorBuilder builder;
    
            ClusterOperatorContentNestedImpl(ClusterOperator item){
                    this.builder = new ClusterOperatorBuilder(this, item);
            }
            ClusterOperatorContentNestedImpl(){
                    this.builder = new ClusterOperatorBuilder(this);
            }
    
    public N and(){
            return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endClusterOperatorContent(){
            return and();
    }

}
    public class BuildConfigContentNestedImpl<N> extends BuildConfigFluentImpl<SubjectAccessReviewFluent.BuildConfigContentNested<N>> implements SubjectAccessReviewFluent.BuildConfigContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final BuildConfigBuilder builder;
    
            BuildConfigContentNestedImpl(BuildConfig item){
                    this.builder = new BuildConfigBuilder(this, item);
            }
            BuildConfigContentNestedImpl(){
                    this.builder = new BuildConfigBuilder(this);
            }
    
    public N and(){
            return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBuildConfigContent(){
            return and();
    }

}
    public class InfrastructureContentNestedImpl<N> extends InfrastructureFluentImpl<SubjectAccessReviewFluent.InfrastructureContentNested<N>> implements SubjectAccessReviewFluent.InfrastructureContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final InfrastructureBuilder builder;
    
            InfrastructureContentNestedImpl(Infrastructure item){
                    this.builder = new InfrastructureBuilder(this, item);
            }
            InfrastructureContentNestedImpl(){
                    this.builder = new InfrastructureBuilder(this);
            }
    
    public N and(){
            return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endInfrastructureContent(){
            return and();
    }

}
    public class SchedulerContentNestedImpl<N> extends SchedulerFluentImpl<SubjectAccessReviewFluent.SchedulerContentNested<N>> implements SubjectAccessReviewFluent.SchedulerContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final SchedulerBuilder builder;
    
            SchedulerContentNestedImpl(Scheduler item){
                    this.builder = new SchedulerBuilder(this, item);
            }
            SchedulerContentNestedImpl(){
                    this.builder = new SchedulerBuilder(this);
            }
    
    public N and(){
            return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endSchedulerContent(){
            return and();
    }

}
    public class RangeAllocationContentNestedImpl<N> extends RangeAllocationFluentImpl<SubjectAccessReviewFluent.RangeAllocationContentNested<N>> implements SubjectAccessReviewFluent.RangeAllocationContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final RangeAllocationBuilder builder;
    
            RangeAllocationContentNestedImpl(RangeAllocation item){
                    this.builder = new RangeAllocationBuilder(this, item);
            }
            RangeAllocationContentNestedImpl(){
                    this.builder = new RangeAllocationBuilder(this);
            }
    
    public N and(){
            return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRangeAllocationContent(){
            return and();
    }

}
    public class RouteContentNestedImpl<N> extends RouteFluentImpl<SubjectAccessReviewFluent.RouteContentNested<N>> implements SubjectAccessReviewFluent.RouteContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final RouteBuilder builder;
    
            RouteContentNestedImpl(Route item){
                    this.builder = new RouteBuilder(this, item);
            }
            RouteContentNestedImpl(){
                    this.builder = new RouteBuilder(this);
            }
    
    public N and(){
            return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRouteContent(){
            return and();
    }

}
    public class ClusterNetworkContentNestedImpl<N> extends ClusterNetworkFluentImpl<SubjectAccessReviewFluent.ClusterNetworkContentNested<N>> implements SubjectAccessReviewFluent.ClusterNetworkContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ClusterNetworkBuilder builder;
    
            ClusterNetworkContentNestedImpl(ClusterNetwork item){
                    this.builder = new ClusterNetworkBuilder(this, item);
            }
            ClusterNetworkContentNestedImpl(){
                    this.builder = new ClusterNetworkBuilder(this);
            }
    
    public N and(){
            return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endClusterNetworkContent(){
            return and();
    }

}
    public class OAuthAuthorizeTokenContentNestedImpl<N> extends OAuthAuthorizeTokenFluentImpl<SubjectAccessReviewFluent.OAuthAuthorizeTokenContentNested<N>> implements SubjectAccessReviewFluent.OAuthAuthorizeTokenContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final OAuthAuthorizeTokenBuilder builder;
    
            OAuthAuthorizeTokenContentNestedImpl(OAuthAuthorizeToken item){
                    this.builder = new OAuthAuthorizeTokenBuilder(this, item);
            }
            OAuthAuthorizeTokenContentNestedImpl(){
                    this.builder = new OAuthAuthorizeTokenBuilder(this);
            }
    
    public N and(){
            return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endOAuthAuthorizeTokenContent(){
            return and();
    }

}
    public class OAuthContentNestedImpl<N> extends OAuthFluentImpl<SubjectAccessReviewFluent.OAuthContentNested<N>> implements SubjectAccessReviewFluent.OAuthContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final OAuthBuilder builder;
    
            OAuthContentNestedImpl(OAuth item){
                    this.builder = new OAuthBuilder(this, item);
            }
            OAuthContentNestedImpl(){
                    this.builder = new OAuthBuilder(this);
            }
    
    public N and(){
            return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endOAuthContent(){
            return and();
    }

}
    public class OperatorHubContentNestedImpl<N> extends OperatorHubFluentImpl<SubjectAccessReviewFluent.OperatorHubContentNested<N>> implements SubjectAccessReviewFluent.OperatorHubContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final OperatorHubBuilder builder;
    
            OperatorHubContentNestedImpl(OperatorHub item){
                    this.builder = new OperatorHubBuilder(this, item);
            }
            OperatorHubContentNestedImpl(){
                    this.builder = new OperatorHubBuilder(this);
            }
    
    public N and(){
            return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endOperatorHubContent(){
            return and();
    }

}
    public class ClusterRoleBindingContentNestedImpl<N> extends ClusterRoleBindingFluentImpl<SubjectAccessReviewFluent.ClusterRoleBindingContentNested<N>> implements SubjectAccessReviewFluent.ClusterRoleBindingContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ClusterRoleBindingBuilder builder;
    
            ClusterRoleBindingContentNestedImpl(ClusterRoleBinding item){
                    this.builder = new ClusterRoleBindingBuilder(this, item);
            }
            ClusterRoleBindingContentNestedImpl(){
                    this.builder = new ClusterRoleBindingBuilder(this);
            }
    
    public N and(){
            return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endClusterRoleBindingContent(){
            return and();
    }

}
    public class ClusterResourceQuotaContentNestedImpl<N> extends ClusterResourceQuotaFluentImpl<SubjectAccessReviewFluent.ClusterResourceQuotaContentNested<N>> implements SubjectAccessReviewFluent.ClusterResourceQuotaContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ClusterResourceQuotaBuilder builder;
    
            ClusterResourceQuotaContentNestedImpl(ClusterResourceQuota item){
                    this.builder = new ClusterResourceQuotaBuilder(this, item);
            }
            ClusterResourceQuotaContentNestedImpl(){
                    this.builder = new ClusterResourceQuotaBuilder(this);
            }
    
    public N and(){
            return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endClusterResourceQuotaContent(){
            return and();
    }

}
    public class ProjectRequestContentNestedImpl<N> extends ProjectRequestFluentImpl<SubjectAccessReviewFluent.ProjectRequestContentNested<N>> implements SubjectAccessReviewFluent.ProjectRequestContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ProjectRequestBuilder builder;
    
            ProjectRequestContentNestedImpl(ProjectRequest item){
                    this.builder = new ProjectRequestBuilder(this, item);
            }
            ProjectRequestContentNestedImpl(){
                    this.builder = new ProjectRequestBuilder(this);
            }
    
    public N and(){
            return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endProjectRequestContent(){
            return and();
    }

}
    public class TemplateContentNestedImpl<N> extends TemplateFluentImpl<SubjectAccessReviewFluent.TemplateContentNested<N>> implements SubjectAccessReviewFluent.TemplateContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TemplateBuilder builder;
    
            TemplateContentNestedImpl(Template item){
                    this.builder = new TemplateBuilder(this, item);
            }
            TemplateContentNestedImpl(){
                    this.builder = new TemplateBuilder(this);
            }
    
    public N and(){
            return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endTemplateContent(){
            return and();
    }

}
    public class OAuthClientAuthorizationContentNestedImpl<N> extends OAuthClientAuthorizationFluentImpl<SubjectAccessReviewFluent.OAuthClientAuthorizationContentNested<N>> implements SubjectAccessReviewFluent.OAuthClientAuthorizationContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final OAuthClientAuthorizationBuilder builder;
    
            OAuthClientAuthorizationContentNestedImpl(OAuthClientAuthorization item){
                    this.builder = new OAuthClientAuthorizationBuilder(this, item);
            }
            OAuthClientAuthorizationContentNestedImpl(){
                    this.builder = new OAuthClientAuthorizationBuilder(this);
            }
    
    public N and(){
            return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endOAuthClientAuthorizationContent(){
            return and();
    }

}
    public class ClusterRoleContentNestedImpl<N> extends ClusterRoleFluentImpl<SubjectAccessReviewFluent.ClusterRoleContentNested<N>> implements SubjectAccessReviewFluent.ClusterRoleContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ClusterRoleBuilder builder;
    
            ClusterRoleContentNestedImpl(ClusterRole item){
                    this.builder = new ClusterRoleBuilder(this, item);
            }
            ClusterRoleContentNestedImpl(){
                    this.builder = new ClusterRoleBuilder(this);
            }
    
    public N and(){
            return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endClusterRoleContent(){
            return and();
    }

}
    public class ImageTagContentNestedImpl<N> extends ImageTagFluentImpl<SubjectAccessReviewFluent.ImageTagContentNested<N>> implements SubjectAccessReviewFluent.ImageTagContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ImageTagBuilder builder;
    
            ImageTagContentNestedImpl(ImageTag item){
                    this.builder = new ImageTagBuilder(this, item);
            }
            ImageTagContentNestedImpl(){
                    this.builder = new ImageTagBuilder(this);
            }
    
    public N and(){
            return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageTagContent(){
            return and();
    }

}
    public class DeploymentConfigContentNestedImpl<N> extends DeploymentConfigFluentImpl<SubjectAccessReviewFluent.DeploymentConfigContentNested<N>> implements SubjectAccessReviewFluent.DeploymentConfigContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DeploymentConfigBuilder builder;
    
            DeploymentConfigContentNestedImpl(DeploymentConfig item){
                    this.builder = new DeploymentConfigBuilder(this, item);
            }
            DeploymentConfigContentNestedImpl(){
                    this.builder = new DeploymentConfigBuilder(this);
            }
    
    public N and(){
            return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endDeploymentConfigContent(){
            return and();
    }

}
    public class OAuthAccessTokenContentNestedImpl<N> extends OAuthAccessTokenFluentImpl<SubjectAccessReviewFluent.OAuthAccessTokenContentNested<N>> implements SubjectAccessReviewFluent.OAuthAccessTokenContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final OAuthAccessTokenBuilder builder;
    
            OAuthAccessTokenContentNestedImpl(OAuthAccessToken item){
                    this.builder = new OAuthAccessTokenBuilder(this, item);
            }
            OAuthAccessTokenContentNestedImpl(){
                    this.builder = new OAuthAccessTokenBuilder(this);
            }
    
    public N and(){
            return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endOAuthAccessTokenContent(){
            return and();
    }

}
    public class RoleBindingContentNestedImpl<N> extends RoleBindingFluentImpl<SubjectAccessReviewFluent.RoleBindingContentNested<N>> implements SubjectAccessReviewFluent.RoleBindingContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final RoleBindingBuilder builder;
    
            RoleBindingContentNestedImpl(RoleBinding item){
                    this.builder = new RoleBindingBuilder(this, item);
            }
            RoleBindingContentNestedImpl(){
                    this.builder = new RoleBindingBuilder(this);
            }
    
    public N and(){
            return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRoleBindingContent(){
            return and();
    }

}
    public class ImageContentNestedImpl<N> extends ImageFluentImpl<SubjectAccessReviewFluent.ImageContentNested<N>> implements SubjectAccessReviewFluent.ImageContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ImageBuilder builder;
    
            ImageContentNestedImpl(Image item){
                    this.builder = new ImageBuilder(this, item);
            }
            ImageContentNestedImpl(){
                    this.builder = new ImageBuilder(this);
            }
    
    public N and(){
            return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageContent(){
            return and();
    }

}
    public class APIServerContentNestedImpl<N> extends APIServerFluentImpl<SubjectAccessReviewFluent.APIServerContentNested<N>> implements SubjectAccessReviewFluent.APIServerContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final APIServerBuilder builder;
    
            APIServerContentNestedImpl(APIServer item){
                    this.builder = new APIServerBuilder(this, item);
            }
            APIServerContentNestedImpl(){
                    this.builder = new APIServerBuilder(this);
            }
    
    public N and(){
            return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endAPIServerContent(){
            return and();
    }

}
    public class PersistentVolumeClaimContentNestedImpl<N> extends PersistentVolumeClaimFluentImpl<SubjectAccessReviewFluent.PersistentVolumeClaimContentNested<N>> implements SubjectAccessReviewFluent.PersistentVolumeClaimContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PersistentVolumeClaimBuilder builder;
    
            PersistentVolumeClaimContentNestedImpl(PersistentVolumeClaim item){
                    this.builder = new PersistentVolumeClaimBuilder(this, item);
            }
            PersistentVolumeClaimContentNestedImpl(){
                    this.builder = new PersistentVolumeClaimBuilder(this);
            }
    
    public N and(){
            return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endPersistentVolumeClaimContent(){
            return and();
    }

}
    public class ImageStreamMappingContentNestedImpl<N> extends ImageStreamMappingFluentImpl<SubjectAccessReviewFluent.ImageStreamMappingContentNested<N>> implements SubjectAccessReviewFluent.ImageStreamMappingContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ImageStreamMappingBuilder builder;
    
            ImageStreamMappingContentNestedImpl(ImageStreamMapping item){
                    this.builder = new ImageStreamMappingBuilder(this, item);
            }
            ImageStreamMappingContentNestedImpl(){
                    this.builder = new ImageStreamMappingBuilder(this);
            }
    
    public N and(){
            return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageStreamMappingContent(){
            return and();
    }

}
    public class RoleContentNestedImpl<N> extends RoleFluentImpl<SubjectAccessReviewFluent.RoleContentNested<N>> implements SubjectAccessReviewFluent.RoleContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final RoleBuilder builder;
    
            RoleContentNestedImpl(Role item){
                    this.builder = new RoleBuilder(this, item);
            }
            RoleContentNestedImpl(){
                    this.builder = new RoleBuilder(this);
            }
    
    public N and(){
            return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRoleContent(){
            return and();
    }

}
    public class FeatureGateContentNestedImpl<N> extends FeatureGateFluentImpl<SubjectAccessReviewFluent.FeatureGateContentNested<N>> implements SubjectAccessReviewFluent.FeatureGateContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final FeatureGateBuilder builder;
    
            FeatureGateContentNestedImpl(FeatureGate item){
                    this.builder = new FeatureGateBuilder(this, item);
            }
            FeatureGateContentNestedImpl(){
                    this.builder = new FeatureGateBuilder(this);
            }
    
    public N and(){
            return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endFeatureGateContent(){
            return and();
    }

}
    public class UserContentNestedImpl<N> extends UserFluentImpl<SubjectAccessReviewFluent.UserContentNested<N>> implements SubjectAccessReviewFluent.UserContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final UserBuilder builder;
    
            UserContentNestedImpl(User item){
                    this.builder = new UserBuilder(this, item);
            }
            UserContentNestedImpl(){
                    this.builder = new UserBuilder(this);
            }
    
    public N and(){
            return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endUserContent(){
            return and();
    }

}
    public class ImageStreamImageContentNestedImpl<N> extends ImageStreamImageFluentImpl<SubjectAccessReviewFluent.ImageStreamImageContentNested<N>> implements SubjectAccessReviewFluent.ImageStreamImageContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ImageStreamImageBuilder builder;
    
            ImageStreamImageContentNestedImpl(ImageStreamImage item){
                    this.builder = new ImageStreamImageBuilder(this, item);
            }
            ImageStreamImageContentNestedImpl(){
                    this.builder = new ImageStreamImageBuilder(this);
            }
    
    public N and(){
            return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageStreamImageContent(){
            return and();
    }

}
    public class BuildContentNestedImpl<N> extends BuildFluentImpl<SubjectAccessReviewFluent.BuildContentNested<N>> implements SubjectAccessReviewFluent.BuildContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final BuildBuilder builder;
    
            BuildContentNestedImpl(Build item){
                    this.builder = new BuildBuilder(this, item);
            }
            BuildContentNestedImpl(){
                    this.builder = new BuildBuilder(this);
            }
    
    public N and(){
            return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBuildContent(){
            return and();
    }

}
    public class RoleBindingRestrictionContentNestedImpl<N> extends RoleBindingRestrictionFluentImpl<SubjectAccessReviewFluent.RoleBindingRestrictionContentNested<N>> implements SubjectAccessReviewFluent.RoleBindingRestrictionContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final RoleBindingRestrictionBuilder builder;
    
            RoleBindingRestrictionContentNestedImpl(RoleBindingRestriction item){
                    this.builder = new RoleBindingRestrictionBuilder(this, item);
            }
            RoleBindingRestrictionContentNestedImpl(){
                    this.builder = new RoleBindingRestrictionBuilder(this);
            }
    
    public N and(){
            return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endRoleBindingRestrictionContent(){
            return and();
    }

}
    public class ImageStreamTagContentNestedImpl<N> extends ImageStreamTagFluentImpl<SubjectAccessReviewFluent.ImageStreamTagContentNested<N>> implements SubjectAccessReviewFluent.ImageStreamTagContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ImageStreamTagBuilder builder;
    
            ImageStreamTagContentNestedImpl(ImageStreamTag item){
                    this.builder = new ImageStreamTagBuilder(this, item);
            }
            ImageStreamTagContentNestedImpl(){
                    this.builder = new ImageStreamTagBuilder(this);
            }
    
    public N and(){
            return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageStreamTagContent(){
            return and();
    }

}
    public class GroupContentNestedImpl<N> extends GroupFluentImpl<SubjectAccessReviewFluent.GroupContentNested<N>> implements SubjectAccessReviewFluent.GroupContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final GroupBuilder builder;
    
            GroupContentNestedImpl(Group item){
                    this.builder = new GroupBuilder(this, item);
            }
            GroupContentNestedImpl(){
                    this.builder = new GroupBuilder(this);
            }
    
    public N and(){
            return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endGroupContent(){
            return and();
    }

}
    public class TokenReviewContentNestedImpl<N> extends TokenReviewFluentImpl<SubjectAccessReviewFluent.TokenReviewContentNested<N>> implements SubjectAccessReviewFluent.TokenReviewContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TokenReviewBuilder builder;
    
            TokenReviewContentNestedImpl(TokenReview item){
                    this.builder = new TokenReviewBuilder(this, item);
            }
            TokenReviewContentNestedImpl(){
                    this.builder = new TokenReviewBuilder(this);
            }
    
    public N and(){
            return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endTokenReviewContent(){
            return and();
    }

}
    public class ImageSignatureContentNestedImpl<N> extends ImageSignatureFluentImpl<SubjectAccessReviewFluent.ImageSignatureContentNested<N>> implements SubjectAccessReviewFluent.ImageSignatureContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ImageSignatureBuilder builder;
    
            ImageSignatureContentNestedImpl(ImageSignature item){
                    this.builder = new ImageSignatureBuilder(this, item);
            }
            ImageSignatureContentNestedImpl(){
                    this.builder = new ImageSignatureBuilder(this);
            }
    
    public N and(){
            return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageSignatureContent(){
            return and();
    }

}
    public class AppliedClusterResourceQuotaContentNestedImpl<N> extends AppliedClusterResourceQuotaFluentImpl<SubjectAccessReviewFluent.AppliedClusterResourceQuotaContentNested<N>> implements SubjectAccessReviewFluent.AppliedClusterResourceQuotaContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final AppliedClusterResourceQuotaBuilder builder;
    
            AppliedClusterResourceQuotaContentNestedImpl(AppliedClusterResourceQuota item){
                    this.builder = new AppliedClusterResourceQuotaBuilder(this, item);
            }
            AppliedClusterResourceQuotaContentNestedImpl(){
                    this.builder = new AppliedClusterResourceQuotaBuilder(this);
            }
    
    public N and(){
            return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endAppliedClusterResourceQuotaContent(){
            return and();
    }

}
    public class SecurityContextConstraintsContentNestedImpl<N> extends SecurityContextConstraintsFluentImpl<SubjectAccessReviewFluent.SecurityContextConstraintsContentNested<N>> implements SubjectAccessReviewFluent.SecurityContextConstraintsContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final SecurityContextConstraintsBuilder builder;
    
            SecurityContextConstraintsContentNestedImpl(SecurityContextConstraints item){
                    this.builder = new SecurityContextConstraintsBuilder(this, item);
            }
            SecurityContextConstraintsContentNestedImpl(){
                    this.builder = new SecurityContextConstraintsBuilder(this);
            }
    
    public N and(){
            return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endSecurityContextConstraintsContent(){
            return and();
    }

}
    public class BuildRequestContentNestedImpl<N> extends BuildRequestFluentImpl<SubjectAccessReviewFluent.BuildRequestContentNested<N>> implements SubjectAccessReviewFluent.BuildRequestContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final BuildRequestBuilder builder;
    
            BuildRequestContentNestedImpl(BuildRequest item){
                    this.builder = new BuildRequestBuilder(this, item);
            }
            BuildRequestContentNestedImpl(){
                    this.builder = new BuildRequestBuilder(this);
            }
    
    public N and(){
            return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endBuildRequestContent(){
            return and();
    }

}
    public class EgressNetworkPolicyContentNestedImpl<N> extends EgressNetworkPolicyFluentImpl<SubjectAccessReviewFluent.EgressNetworkPolicyContentNested<N>> implements SubjectAccessReviewFluent.EgressNetworkPolicyContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final EgressNetworkPolicyBuilder builder;
    
            EgressNetworkPolicyContentNestedImpl(EgressNetworkPolicy item){
                    this.builder = new EgressNetworkPolicyBuilder(this, item);
            }
            EgressNetworkPolicyContentNestedImpl(){
                    this.builder = new EgressNetworkPolicyBuilder(this);
            }
    
    public N and(){
            return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endEgressNetworkPolicyContent(){
            return and();
    }

}
    public class NetNamespaceContentNestedImpl<N> extends NetNamespaceFluentImpl<SubjectAccessReviewFluent.NetNamespaceContentNested<N>> implements SubjectAccessReviewFluent.NetNamespaceContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final NetNamespaceBuilder builder;
    
            NetNamespaceContentNestedImpl(NetNamespace item){
                    this.builder = new NetNamespaceBuilder(this, item);
            }
            NetNamespaceContentNestedImpl(){
                    this.builder = new NetNamespaceBuilder(this);
            }
    
    public N and(){
            return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endNetNamespaceContent(){
            return and();
    }

}
    public class ImageStreamContentNestedImpl<N> extends ImageStreamFluentImpl<SubjectAccessReviewFluent.ImageStreamContentNested<N>> implements SubjectAccessReviewFluent.ImageStreamContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ImageStreamBuilder builder;
    
            ImageStreamContentNestedImpl(ImageStream item){
                    this.builder = new ImageStreamBuilder(this, item);
            }
            ImageStreamContentNestedImpl(){
                    this.builder = new ImageStreamBuilder(this);
            }
    
    public N and(){
            return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endImageStreamContent(){
            return and();
    }

}
    public class OAuthClientContentNestedImpl<N> extends OAuthClientFluentImpl<SubjectAccessReviewFluent.OAuthClientContentNested<N>> implements SubjectAccessReviewFluent.OAuthClientContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final OAuthClientBuilder builder;
    
            OAuthClientContentNestedImpl(OAuthClient item){
                    this.builder = new OAuthClientBuilder(this, item);
            }
            OAuthClientContentNestedImpl(){
                    this.builder = new OAuthClientBuilder(this);
            }
    
    public N and(){
            return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endOAuthClientContent(){
            return and();
    }

}
    public class IdentityContentNestedImpl<N> extends IdentityFluentImpl<SubjectAccessReviewFluent.IdentityContentNested<N>> implements SubjectAccessReviewFluent.IdentityContentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final IdentityBuilder builder;
    
            IdentityContentNestedImpl(Identity item){
                    this.builder = new IdentityBuilder(this, item);
            }
            IdentityContentNestedImpl(){
                    this.builder = new IdentityBuilder(this);
            }
    
    public N and(){
            return (N) SubjectAccessReviewFluentImpl.this.withContent(builder.build());
    }
    public N endIdentityContent(){
            return and();
    }

}


}
