/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.ClusterVersion;
import io.fabric8.openshift.api.model.ClusterVersionFluent;
import io.fabric8.openshift.api.model.ClusterVersionFluentImpl;

public class ClusterVersionBuilder
extends ClusterVersionFluentImpl<ClusterVersionBuilder>
implements VisitableBuilder<ClusterVersion, ClusterVersionBuilder> {
    ClusterVersionFluent<?> fluent;
    Boolean validationEnabled;

    public ClusterVersionBuilder() {
        this(true);
    }

    public ClusterVersionBuilder(Boolean validationEnabled) {
        this(new ClusterVersion(), validationEnabled);
    }

    public ClusterVersionBuilder(ClusterVersionFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ClusterVersionBuilder(ClusterVersionFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ClusterVersion(), validationEnabled);
    }

    public ClusterVersionBuilder(ClusterVersionFluent<?> fluent, ClusterVersion instance) {
        this(fluent, instance, true);
    }

    public ClusterVersionBuilder(ClusterVersionFluent<?> fluent, ClusterVersion instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public ClusterVersionBuilder(ClusterVersion instance) {
        this(instance, (Boolean)true);
    }

    public ClusterVersionBuilder(ClusterVersion instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public ClusterVersion build() {
        ClusterVersion buildable = new ClusterVersion(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterVersionBuilder that = (ClusterVersionBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

