/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.openshift.api.model.HubSourceStatus;
import io.fabric8.openshift.api.model.HubSourceStatusBuilder;
import io.fabric8.openshift.api.model.HubSourceStatusFluentImpl;
import io.fabric8.openshift.api.model.OperatorHubStatus;
import io.fabric8.openshift.api.model.OperatorHubStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class OperatorHubStatusFluentImpl<A extends OperatorHubStatusFluent<A>>
extends BaseFluent<A>
implements OperatorHubStatusFluent<A> {
    private List<HubSourceStatusBuilder> sources = new ArrayList<HubSourceStatusBuilder>();

    public OperatorHubStatusFluentImpl() {
    }

    public OperatorHubStatusFluentImpl(OperatorHubStatus instance) {
        this.withSources(instance.getSources());
    }

    @Override
    public A addToSources(int index, HubSourceStatus item) {
        if (this.sources == null) {
            this.sources = new ArrayList<HubSourceStatusBuilder>();
        }
        HubSourceStatusBuilder builder = new HubSourceStatusBuilder(item);
        this._visitables.get((Object)"sources").add(index >= 0 ? index : this._visitables.get((Object)"sources").size(), builder);
        this.sources.add(index >= 0 ? index : this.sources.size(), builder);
        return (A)this;
    }

    @Override
    public A setToSources(int index, HubSourceStatus item) {
        if (this.sources == null) {
            this.sources = new ArrayList<HubSourceStatusBuilder>();
        }
        HubSourceStatusBuilder builder = new HubSourceStatusBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"sources").size()) {
            this._visitables.get((Object)"sources").add(builder);
        } else {
            this._visitables.get((Object)"sources").set(index, builder);
        }
        if (index < 0 || index >= this.sources.size()) {
            this.sources.add(builder);
        } else {
            this.sources.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSources(HubSourceStatus ... items) {
        if (this.sources == null) {
            this.sources = new ArrayList<HubSourceStatusBuilder>();
        }
        for (HubSourceStatus item : items) {
            HubSourceStatusBuilder builder = new HubSourceStatusBuilder(item);
            this._visitables.get((Object)"sources").add(builder);
            this.sources.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSources(Collection<HubSourceStatus> items) {
        if (this.sources == null) {
            this.sources = new ArrayList<HubSourceStatusBuilder>();
        }
        for (HubSourceStatus item : items) {
            HubSourceStatusBuilder builder = new HubSourceStatusBuilder(item);
            this._visitables.get((Object)"sources").add(builder);
            this.sources.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSources(HubSourceStatus ... items) {
        for (HubSourceStatus item : items) {
            HubSourceStatusBuilder builder = new HubSourceStatusBuilder(item);
            this._visitables.get((Object)"sources").remove(builder);
            if (this.sources == null) continue;
            this.sources.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSources(Collection<HubSourceStatus> items) {
        for (HubSourceStatus item : items) {
            HubSourceStatusBuilder builder = new HubSourceStatusBuilder(item);
            this._visitables.get((Object)"sources").remove(builder);
            if (this.sources == null) continue;
            this.sources.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromSources(Predicate<HubSourceStatusBuilder> predicate) {
        if (this.sources == null) {
            return (A)this;
        }
        Iterator<HubSourceStatusBuilder> each = this.sources.iterator();
        List visitables = this._visitables.get((Object)"sources");
        while (each.hasNext()) {
            HubSourceStatusBuilder builder = each.next();
            if (!predicate.apply((Object)builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<HubSourceStatus> getSources() {
        return OperatorHubStatusFluentImpl.build(this.sources);
    }

    @Override
    public List<HubSourceStatus> buildSources() {
        return OperatorHubStatusFluentImpl.build(this.sources);
    }

    @Override
    public HubSourceStatus buildSource(int index) {
        return this.sources.get(index).build();
    }

    @Override
    public HubSourceStatus buildFirstSource() {
        return this.sources.get(0).build();
    }

    @Override
    public HubSourceStatus buildLastSource() {
        return this.sources.get(this.sources.size() - 1).build();
    }

    @Override
    public HubSourceStatus buildMatchingSource(Predicate<HubSourceStatusBuilder> predicate) {
        for (HubSourceStatusBuilder item : this.sources) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSource(Predicate<HubSourceStatusBuilder> predicate) {
        for (HubSourceStatusBuilder item : this.sources) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSources(List<HubSourceStatus> sources) {
        if (this.sources != null) {
            this._visitables.get((Object)"sources").removeAll(this.sources);
        }
        if (sources != null) {
            this.sources = new ArrayList<HubSourceStatusBuilder>();
            for (HubSourceStatus item : sources) {
                this.addToSources(item);
            }
        } else {
            this.sources = null;
        }
        return (A)this;
    }

    @Override
    public A withSources(HubSourceStatus ... sources) {
        if (this.sources != null) {
            this.sources.clear();
        }
        if (sources != null) {
            for (HubSourceStatus item : sources) {
                this.addToSources(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSources() {
        return this.sources != null && !this.sources.isEmpty();
    }

    @Override
    public A addNewSource(Boolean disabled, String message, String name, String status) {
        return this.addToSources(new HubSourceStatus(disabled, message, name, status));
    }

    @Override
    public OperatorHubStatusFluent.SourcesNested<A> addNewSource() {
        return new SourcesNestedImpl();
    }

    @Override
    public OperatorHubStatusFluent.SourcesNested<A> addNewSourceLike(HubSourceStatus item) {
        return new SourcesNestedImpl(-1, item);
    }

    @Override
    public OperatorHubStatusFluent.SourcesNested<A> setNewSourceLike(int index, HubSourceStatus item) {
        return new SourcesNestedImpl(index, item);
    }

    @Override
    public OperatorHubStatusFluent.SourcesNested<A> editSource(int index) {
        if (this.sources.size() <= index) {
            throw new RuntimeException("Can't edit sources. Index exceeds size.");
        }
        return this.setNewSourceLike(index, this.buildSource(index));
    }

    @Override
    public OperatorHubStatusFluent.SourcesNested<A> editFirstSource() {
        if (this.sources.size() == 0) {
            throw new RuntimeException("Can't edit first sources. The list is empty.");
        }
        return this.setNewSourceLike(0, this.buildSource(0));
    }

    @Override
    public OperatorHubStatusFluent.SourcesNested<A> editLastSource() {
        int index = this.sources.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last sources. The list is empty.");
        }
        return this.setNewSourceLike(index, this.buildSource(index));
    }

    @Override
    public OperatorHubStatusFluent.SourcesNested<A> editMatchingSource(Predicate<HubSourceStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.sources.size(); ++i) {
            if (!predicate.apply((Object)this.sources.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching sources. No match found.");
        }
        return this.setNewSourceLike(index, this.buildSource(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperatorHubStatusFluentImpl that = (OperatorHubStatusFluentImpl)o;
        return !(this.sources != null ? !this.sources.equals(that.sources) : that.sources != null);
    }

    public class SourcesNestedImpl<N>
    extends HubSourceStatusFluentImpl<OperatorHubStatusFluent.SourcesNested<N>>
    implements OperatorHubStatusFluent.SourcesNested<N>,
    Nested<N> {
        private final HubSourceStatusBuilder builder;
        private final int index;

        SourcesNestedImpl(int index, HubSourceStatus item) {
            this.index = index;
            this.builder = new HubSourceStatusBuilder(this, item);
        }

        SourcesNestedImpl() {
            this.index = -1;
            this.builder = new HubSourceStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)OperatorHubStatusFluentImpl.this.setToSources(this.index, this.builder.build());
        }

        @Override
        public N endSource() {
            return this.and();
        }
    }
}

