/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.PlatformSpec;
import io.fabric8.openshift.api.model.PlatformSpecFluent;
import io.fabric8.openshift.api.model.PlatformSpecFluentImpl;

public class PlatformSpecBuilder
extends PlatformSpecFluentImpl<PlatformSpecBuilder>
implements VisitableBuilder<PlatformSpec, PlatformSpecBuilder> {
    PlatformSpecFluent<?> fluent;
    Boolean validationEnabled;

    public PlatformSpecBuilder() {
        this(true);
    }

    public PlatformSpecBuilder(Boolean validationEnabled) {
        this(new PlatformSpec(), validationEnabled);
    }

    public PlatformSpecBuilder(PlatformSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public PlatformSpecBuilder(PlatformSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new PlatformSpec(), validationEnabled);
    }

    public PlatformSpecBuilder(PlatformSpecFluent<?> fluent, PlatformSpec instance) {
        this(fluent, instance, true);
    }

    public PlatformSpecBuilder(PlatformSpecFluent<?> fluent, PlatformSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAws(instance.getAws());
        fluent.withAzure(instance.getAzure());
        fluent.withBaremetal(instance.getBaremetal());
        fluent.withGcp(instance.getGcp());
        fluent.withIbmcloud(instance.getIbmcloud());
        fluent.withOpenstack(instance.getOpenstack());
        fluent.withOvirt(instance.getOvirt());
        fluent.withType(instance.getType());
        fluent.withVsphere(instance.getVsphere());
        this.validationEnabled = validationEnabled;
    }

    public PlatformSpecBuilder(PlatformSpec instance) {
        this(instance, (Boolean)true);
    }

    public PlatformSpecBuilder(PlatformSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAws(instance.getAws());
        this.withAzure(instance.getAzure());
        this.withBaremetal(instance.getBaremetal());
        this.withGcp(instance.getGcp());
        this.withIbmcloud(instance.getIbmcloud());
        this.withOpenstack(instance.getOpenstack());
        this.withOvirt(instance.getOvirt());
        this.withType(instance.getType());
        this.withVsphere(instance.getVsphere());
        this.validationEnabled = validationEnabled;
    }

    public PlatformSpec build() {
        PlatformSpec buildable = new PlatformSpec(this.fluent.getAws(), this.fluent.getAzure(), this.fluent.getBaremetal(), this.fluent.getGcp(), this.fluent.getIbmcloud(), this.fluent.getOpenstack(), this.fluent.getOvirt(), this.fluent.getType(), this.fluent.getVsphere());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PlatformSpecBuilder that = (PlatformSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

