package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface OperatorHubSpecFluent<A extends OperatorHubSpecFluent<A>> extends Fluent<A> {


    public Boolean isDisableAllDefaultSources();
    public A withDisableAllDefaultSources(Boolean disableAllDefaultSources);
    public Boolean hasDisableAllDefaultSources();
    public A withNewDisableAllDefaultSources(String arg1);
    public A withNewDisableAllDefaultSources(boolean arg1);
    public A addToSources(int index,HubSource item);
    public A setToSources(int index,HubSource item);
    public A addToSources(HubSource... items);
    public A addAllToSources(Collection<HubSource> items);
    public A removeFromSources(HubSource... items);
    public A removeAllFromSources(Collection<HubSource> items);
    public A removeMatchingFromSources(io.fabric8.kubernetes.api.builder.Predicate<HubSourceBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildSources instead.
 * @return The buildable object.
 */
@Deprecated public List<HubSource> getSources();
    public List<HubSource> buildSources();
    public HubSource buildSource(int index);
    public HubSource buildFirstSource();
    public HubSource buildLastSource();
    public HubSource buildMatchingSource(io.fabric8.kubernetes.api.builder.Predicate<HubSourceBuilder> predicate);
    public Boolean hasMatchingSource(io.fabric8.kubernetes.api.builder.Predicate<HubSourceBuilder> predicate);
    public A withSources(List<HubSource> sources);
    public A withSources(HubSource... sources);
    public Boolean hasSources();
    public A addNewSource(Boolean disabled,String name);
    public OperatorHubSpecFluent.SourcesNested<A> addNewSource();
    public OperatorHubSpecFluent.SourcesNested<A> addNewSourceLike(HubSource item);
    public OperatorHubSpecFluent.SourcesNested<A> setNewSourceLike(int index,HubSource item);
    public OperatorHubSpecFluent.SourcesNested<A> editSource(int index);
    public OperatorHubSpecFluent.SourcesNested<A> editFirstSource();
    public OperatorHubSpecFluent.SourcesNested<A> editLastSource();
    public OperatorHubSpecFluent.SourcesNested<A> editMatchingSource(io.fabric8.kubernetes.api.builder.Predicate<HubSourceBuilder> predicate);
    public interface SourcesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,HubSourceFluent<OperatorHubSpecFluent.SourcesNested<N>> {

        public N and();
        public N endSource();    }


}
