package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AuditBuilder extends AuditFluentImpl<AuditBuilder> implements VisitableBuilder<Audit,AuditBuilder> {

    AuditFluent<?> fluent;
    Boolean validationEnabled;

    public AuditBuilder() { 
        this(true);
    }


    public AuditBuilder(Boolean validationEnabled) { 
        this(new Audit(), validationEnabled);
    }


    public AuditBuilder(AuditFluent<?> fluent) { 
        this(fluent, true);
    }


    public AuditBuilder(AuditFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new Audit(), validationEnabled);
    }


    public AuditBuilder(AuditFluent<?> fluent,Audit instance) { 
        this(fluent, instance, true);
    }


    public AuditBuilder(AuditFluent<?> fluent,Audit instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withProfile(instance.getProfile()); 
        this.validationEnabled = validationEnabled; 
    }


    public AuditBuilder(Audit instance) { 
        this(instance,true);
    }


    public AuditBuilder(Audit instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withProfile(instance.getProfile()); 
        this.validationEnabled = validationEnabled; 
    }


    public Audit build() {
        Audit buildable = new Audit(fluent.getProfile());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        AuditBuilder that = (AuditBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
