/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.openshift.api.model.CustomTLSProfile;
import io.fabric8.openshift.api.model.CustomTLSProfileFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class CustomTLSProfileFluentImpl<A extends CustomTLSProfileFluent<A>>
extends BaseFluent<A>
implements CustomTLSProfileFluent<A> {
    private List<String> ciphers = new ArrayList<String>();
    private String minTLSVersion;

    public CustomTLSProfileFluentImpl() {
    }

    public CustomTLSProfileFluentImpl(CustomTLSProfile instance) {
        this.withCiphers(instance.getCiphers());
        this.withMinTLSVersion(instance.getMinTLSVersion());
    }

    @Override
    public A addToCiphers(int index, String item) {
        if (this.ciphers == null) {
            this.ciphers = new ArrayList<String>();
        }
        this.ciphers.add(index, item);
        return (A)this;
    }

    @Override
    public A setToCiphers(int index, String item) {
        if (this.ciphers == null) {
            this.ciphers = new ArrayList<String>();
        }
        this.ciphers.set(index, item);
        return (A)this;
    }

    @Override
    public A addToCiphers(String ... items) {
        if (this.ciphers == null) {
            this.ciphers = new ArrayList<String>();
        }
        for (String item : items) {
            this.ciphers.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToCiphers(Collection<String> items) {
        if (this.ciphers == null) {
            this.ciphers = new ArrayList<String>();
        }
        for (String item : items) {
            this.ciphers.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromCiphers(String ... items) {
        for (String item : items) {
            if (this.ciphers == null) continue;
            this.ciphers.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCiphers(Collection<String> items) {
        for (String item : items) {
            if (this.ciphers == null) continue;
            this.ciphers.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getCiphers() {
        return this.ciphers;
    }

    @Override
    public String getCipher(int index) {
        return this.ciphers.get(index);
    }

    @Override
    public String getFirstCipher() {
        return this.ciphers.get(0);
    }

    @Override
    public String getLastCipher() {
        return this.ciphers.get(this.ciphers.size() - 1);
    }

    @Override
    public String getMatchingCipher(Predicate<String> predicate) {
        for (String item : this.ciphers) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCipher(Predicate<String> predicate) {
        for (String item : this.ciphers) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withCiphers(List<String> ciphers) {
        if (this.ciphers != null) {
            this._visitables.get((Object)"ciphers").removeAll(this.ciphers);
        }
        if (ciphers != null) {
            this.ciphers = new ArrayList<String>();
            for (String item : ciphers) {
                this.addToCiphers(item);
            }
        } else {
            this.ciphers = null;
        }
        return (A)this;
    }

    @Override
    public A withCiphers(String ... ciphers) {
        if (this.ciphers != null) {
            this.ciphers.clear();
        }
        if (ciphers != null) {
            for (String item : ciphers) {
                this.addToCiphers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasCiphers() {
        return this.ciphers != null && !this.ciphers.isEmpty();
    }

    @Override
    public A addNewCipher(String arg1) {
        return this.addToCiphers(new String(arg1));
    }

    @Override
    public A addNewCipher(StringBuilder arg1) {
        return this.addToCiphers(new String(arg1));
    }

    @Override
    public A addNewCipher(StringBuffer arg1) {
        return this.addToCiphers(new String(arg1));
    }

    @Override
    public String getMinTLSVersion() {
        return this.minTLSVersion;
    }

    @Override
    public A withMinTLSVersion(String minTLSVersion) {
        this.minTLSVersion = minTLSVersion;
        return (A)this;
    }

    @Override
    public Boolean hasMinTLSVersion() {
        return this.minTLSVersion != null;
    }

    @Override
    public A withNewMinTLSVersion(String arg1) {
        return this.withMinTLSVersion(new String(arg1));
    }

    @Override
    public A withNewMinTLSVersion(StringBuilder arg1) {
        return this.withMinTLSVersion(new String(arg1));
    }

    @Override
    public A withNewMinTLSVersion(StringBuffer arg1) {
        return this.withMinTLSVersion(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomTLSProfileFluentImpl that = (CustomTLSProfileFluentImpl)o;
        if (this.ciphers != null ? !this.ciphers.equals(that.ciphers) : that.ciphers != null) {
            return false;
        }
        return !(this.minTLSVersion != null ? !this.minTLSVersion.equals(that.minTLSVersion) : that.minTLSVersion != null);
    }

    public int hashCode() {
        return Objects.hash(this.ciphers, this.minTLSVersion, super.hashCode());
    }
}

