package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public class OpenIDIdentityProviderFluentImpl<A extends io.fabric8.openshift.api.model.OpenIDIdentityProviderFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.OpenIDIdentityProviderFluent<A>{
  public OpenIDIdentityProviderFluentImpl() {
  }
  public OpenIDIdentityProviderFluentImpl(io.fabric8.openshift.api.model.OpenIDIdentityProvider instance) {
    this.withCa(instance.getCa()); 
    this.withClaims(instance.getClaims()); 
    this.withClientID(instance.getClientID()); 
    this.withClientSecret(instance.getClientSecret()); 
    this.withExtraAuthorizeParameters(instance.getExtraAuthorizeParameters()); 
    this.withExtraScopes(instance.getExtraScopes()); 
    this.withIssuer(instance.getIssuer()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private io.fabric8.openshift.api.model.ConfigMapNameReferenceBuilder ca;
  private io.fabric8.openshift.api.model.OpenIDClaimsBuilder claims;
  private java.lang.String clientID;
  private io.fabric8.openshift.api.model.SecretNameReferenceBuilder clientSecret;
  private java.util.Map<java.lang.String,java.lang.String> extraAuthorizeParameters;
  private java.util.List<java.lang.String> extraScopes = new java.util.ArrayList<java.lang.String>();
  private java.lang.String issuer;
  private java.util.Map<java.lang.String,java.lang.Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildCa instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.openshift.api.model.ConfigMapNameReference getCa() {
    return this.ca!=null?this.ca.build():null;
  }
  public io.fabric8.openshift.api.model.ConfigMapNameReference buildCa() {
    return this.ca!=null?this.ca.build():null;
  }
  public A withCa(io.fabric8.openshift.api.model.ConfigMapNameReference ca) {
    _visitables.get("ca").remove(this.ca);
    if (ca!=null){ this.ca= new io.fabric8.openshift.api.model.ConfigMapNameReferenceBuilder(ca); _visitables.get("ca").add(this.ca);} return (A) this;
  }
  public java.lang.Boolean hasCa() {
    return this.ca != null;
  }
  public A withNewCa(java.lang.String name) {
    return (A)withCa(new ConfigMapNameReference(name));
  }
  public io.fabric8.openshift.api.model.OpenIDIdentityProviderFluent.CaNested<A> withNewCa() {
    return new io.fabric8.openshift.api.model.OpenIDIdentityProviderFluentImpl.CaNestedImpl();
  }
  public io.fabric8.openshift.api.model.OpenIDIdentityProviderFluent.CaNested<A> withNewCaLike(io.fabric8.openshift.api.model.ConfigMapNameReference item) {
    return new io.fabric8.openshift.api.model.OpenIDIdentityProviderFluentImpl.CaNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.OpenIDIdentityProviderFluent.CaNested<A> editCa() {
    return withNewCaLike(getCa());
  }
  public io.fabric8.openshift.api.model.OpenIDIdentityProviderFluent.CaNested<A> editOrNewCa() {
    return withNewCaLike(getCa() != null ? getCa(): new io.fabric8.openshift.api.model.ConfigMapNameReferenceBuilder().build());
  }
  public io.fabric8.openshift.api.model.OpenIDIdentityProviderFluent.CaNested<A> editOrNewCaLike(io.fabric8.openshift.api.model.ConfigMapNameReference item) {
    return withNewCaLike(getCa() != null ? getCa(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildClaims instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.openshift.api.model.OpenIDClaims getClaims() {
    return this.claims!=null?this.claims.build():null;
  }
  public io.fabric8.openshift.api.model.OpenIDClaims buildClaims() {
    return this.claims!=null?this.claims.build():null;
  }
  public A withClaims(io.fabric8.openshift.api.model.OpenIDClaims claims) {
    _visitables.get("claims").remove(this.claims);
    if (claims!=null){ this.claims= new io.fabric8.openshift.api.model.OpenIDClaimsBuilder(claims); _visitables.get("claims").add(this.claims);} return (A) this;
  }
  public java.lang.Boolean hasClaims() {
    return this.claims != null;
  }
  public io.fabric8.openshift.api.model.OpenIDIdentityProviderFluent.ClaimsNested<A> withNewClaims() {
    return new io.fabric8.openshift.api.model.OpenIDIdentityProviderFluentImpl.ClaimsNestedImpl();
  }
  public io.fabric8.openshift.api.model.OpenIDIdentityProviderFluent.ClaimsNested<A> withNewClaimsLike(io.fabric8.openshift.api.model.OpenIDClaims item) {
    return new io.fabric8.openshift.api.model.OpenIDIdentityProviderFluentImpl.ClaimsNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.OpenIDIdentityProviderFluent.ClaimsNested<A> editClaims() {
    return withNewClaimsLike(getClaims());
  }
  public io.fabric8.openshift.api.model.OpenIDIdentityProviderFluent.ClaimsNested<A> editOrNewClaims() {
    return withNewClaimsLike(getClaims() != null ? getClaims(): new io.fabric8.openshift.api.model.OpenIDClaimsBuilder().build());
  }
  public io.fabric8.openshift.api.model.OpenIDIdentityProviderFluent.ClaimsNested<A> editOrNewClaimsLike(io.fabric8.openshift.api.model.OpenIDClaims item) {
    return withNewClaimsLike(getClaims() != null ? getClaims(): item);
  }
  public java.lang.String getClientID() {
    return this.clientID;
  }
  public A withClientID(java.lang.String clientID) {
    this.clientID=clientID; return (A) this;
  }
  public java.lang.Boolean hasClientID() {
    return this.clientID != null;
  }
  
  /**
   * Method is deprecated. use withClientID instead.
   */
  @java.lang.Deprecated
  public A withNewClientID(java.lang.String arg0) {
    return (A)withClientID(new String(arg0));
  }
  
  /**
   * This method has been deprecated, please use method buildClientSecret instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.openshift.api.model.SecretNameReference getClientSecret() {
    return this.clientSecret!=null?this.clientSecret.build():null;
  }
  public io.fabric8.openshift.api.model.SecretNameReference buildClientSecret() {
    return this.clientSecret!=null?this.clientSecret.build():null;
  }
  public A withClientSecret(io.fabric8.openshift.api.model.SecretNameReference clientSecret) {
    _visitables.get("clientSecret").remove(this.clientSecret);
    if (clientSecret!=null){ this.clientSecret= new io.fabric8.openshift.api.model.SecretNameReferenceBuilder(clientSecret); _visitables.get("clientSecret").add(this.clientSecret);} return (A) this;
  }
  public java.lang.Boolean hasClientSecret() {
    return this.clientSecret != null;
  }
  public A withNewClientSecret(java.lang.String name) {
    return (A)withClientSecret(new SecretNameReference(name));
  }
  public io.fabric8.openshift.api.model.OpenIDIdentityProviderFluent.ClientSecretNested<A> withNewClientSecret() {
    return new io.fabric8.openshift.api.model.OpenIDIdentityProviderFluentImpl.ClientSecretNestedImpl();
  }
  public io.fabric8.openshift.api.model.OpenIDIdentityProviderFluent.ClientSecretNested<A> withNewClientSecretLike(io.fabric8.openshift.api.model.SecretNameReference item) {
    return new io.fabric8.openshift.api.model.OpenIDIdentityProviderFluentImpl.ClientSecretNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.OpenIDIdentityProviderFluent.ClientSecretNested<A> editClientSecret() {
    return withNewClientSecretLike(getClientSecret());
  }
  public io.fabric8.openshift.api.model.OpenIDIdentityProviderFluent.ClientSecretNested<A> editOrNewClientSecret() {
    return withNewClientSecretLike(getClientSecret() != null ? getClientSecret(): new io.fabric8.openshift.api.model.SecretNameReferenceBuilder().build());
  }
  public io.fabric8.openshift.api.model.OpenIDIdentityProviderFluent.ClientSecretNested<A> editOrNewClientSecretLike(io.fabric8.openshift.api.model.SecretNameReference item) {
    return withNewClientSecretLike(getClientSecret() != null ? getClientSecret(): item);
  }
  public A addToExtraAuthorizeParameters(java.lang.String key,java.lang.String value) {
    if(this.extraAuthorizeParameters == null && key != null && value != null) { this.extraAuthorizeParameters = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(); }
    if(key != null && value != null) {this.extraAuthorizeParameters.put(key, value);} return (A)this;
  }
  public A addToExtraAuthorizeParameters(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.extraAuthorizeParameters == null && map != null) { this.extraAuthorizeParameters = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(); }
    if(map != null) { this.extraAuthorizeParameters.putAll(map);} return (A)this;
  }
  public A removeFromExtraAuthorizeParameters(java.lang.String key) {
    if(this.extraAuthorizeParameters == null) { return (A) this; }
    if(key != null && this.extraAuthorizeParameters != null) {this.extraAuthorizeParameters.remove(key);} return (A)this;
  }
  public A removeFromExtraAuthorizeParameters(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.extraAuthorizeParameters == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.extraAuthorizeParameters != null){this.extraAuthorizeParameters.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.String> getExtraAuthorizeParameters() {
    return this.extraAuthorizeParameters;
  }
  public <K,V>A withExtraAuthorizeParameters(java.util.Map<java.lang.String,java.lang.String> extraAuthorizeParameters) {
    if (extraAuthorizeParameters == null) { this.extraAuthorizeParameters =  null;} else {this.extraAuthorizeParameters = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(extraAuthorizeParameters);} return (A) this;
  }
  public java.lang.Boolean hasExtraAuthorizeParameters() {
    return this.extraAuthorizeParameters != null;
  }
  public A addToExtraScopes(java.lang.Integer index,java.lang.String item) {
    if (this.extraScopes == null) {this.extraScopes = new java.util.ArrayList<java.lang.String>();}
    this.extraScopes.add(index, item);
    return (A)this;
  }
  public A setToExtraScopes(java.lang.Integer index,java.lang.String item) {
    if (this.extraScopes == null) {this.extraScopes = new java.util.ArrayList<java.lang.String>();}
    this.extraScopes.set(index, item); return (A)this;
  }
  public A addToExtraScopes(java.lang.String... items) {
    if (this.extraScopes == null) {this.extraScopes = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.extraScopes.add(item);} return (A)this;
  }
  public A addAllToExtraScopes(java.util.Collection<java.lang.String> items) {
    if (this.extraScopes == null) {this.extraScopes = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.extraScopes.add(item);} return (A)this;
  }
  public A removeFromExtraScopes(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.extraScopes!= null){ this.extraScopes.remove(item);}} return (A)this;
  }
  public A removeAllFromExtraScopes(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.extraScopes!= null){ this.extraScopes.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getExtraScopes() {
    return this.extraScopes;
  }
  public java.lang.String getExtraScope(java.lang.Integer index) {
    return this.extraScopes.get(index);
  }
  public java.lang.String getFirstExtraScope() {
    return this.extraScopes.get(0);
  }
  public java.lang.String getLastExtraScope() {
    return this.extraScopes.get(extraScopes.size() - 1);
  }
  public java.lang.String getMatchingExtraScope(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: extraScopes) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingExtraScope(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: extraScopes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withExtraScopes(java.util.List<java.lang.String> extraScopes) {
    if (extraScopes != null) {this.extraScopes = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : extraScopes){this.addToExtraScopes(item);}} else { this.extraScopes = null;} return (A) this;
  }
  public A withExtraScopes(java.lang.String... extraScopes) {
    if (this.extraScopes != null) {this.extraScopes.clear();}
    if (extraScopes != null) {for (java.lang.String item :extraScopes){ this.addToExtraScopes(item);}} return (A) this;
  }
  public java.lang.Boolean hasExtraScopes() {
    return extraScopes != null && !extraScopes.isEmpty();
  }
  public A addNewExtraScope(java.lang.String arg0) {
    return (A)addToExtraScopes(new String(arg0));
  }
  public java.lang.String getIssuer() {
    return this.issuer;
  }
  public A withIssuer(java.lang.String issuer) {
    this.issuer=issuer; return (A) this;
  }
  public java.lang.Boolean hasIssuer() {
    return this.issuer != null;
  }
  
  /**
   * Method is deprecated. use withIssuer instead.
   */
  @java.lang.Deprecated
  public A withNewIssuer(java.lang.String arg0) {
    return (A)withIssuer(new String(arg0));
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OpenIDIdentityProviderFluentImpl that = (OpenIDIdentityProviderFluentImpl) o;
    if (ca != null ? !ca.equals(that.ca) :that.ca != null) return false;
    if (claims != null ? !claims.equals(that.claims) :that.claims != null) return false;
    if (clientID != null ? !clientID.equals(that.clientID) :that.clientID != null) return false;
    if (clientSecret != null ? !clientSecret.equals(that.clientSecret) :that.clientSecret != null) return false;
    if (extraAuthorizeParameters != null ? !extraAuthorizeParameters.equals(that.extraAuthorizeParameters) :that.extraAuthorizeParameters != null) return false;
    if (extraScopes != null ? !extraScopes.equals(that.extraScopes) :that.extraScopes != null) return false;
    if (issuer != null ? !issuer.equals(that.issuer) :that.issuer != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(ca,  claims,  clientID,  clientSecret,  extraAuthorizeParameters,  extraScopes,  issuer,  additionalProperties,  super.hashCode());
  }
  public class CaNestedImpl<N> extends io.fabric8.openshift.api.model.ConfigMapNameReferenceFluentImpl<io.fabric8.openshift.api.model.OpenIDIdentityProviderFluent.CaNested<N>> implements io.fabric8.openshift.api.model.OpenIDIdentityProviderFluent.CaNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    CaNestedImpl(io.fabric8.openshift.api.model.ConfigMapNameReference item) {
      this.builder = new io.fabric8.openshift.api.model.ConfigMapNameReferenceBuilder(this, item);
    }
    CaNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ConfigMapNameReferenceBuilder(this);
    }
    io.fabric8.openshift.api.model.ConfigMapNameReferenceBuilder builder;
    public N and() {
      return (N) OpenIDIdentityProviderFluentImpl.this.withCa(builder.build());
    }
    public N endCa() {
      return and();
    }
    
  }
  public class ClaimsNestedImpl<N> extends io.fabric8.openshift.api.model.OpenIDClaimsFluentImpl<io.fabric8.openshift.api.model.OpenIDIdentityProviderFluent.ClaimsNested<N>> implements io.fabric8.openshift.api.model.OpenIDIdentityProviderFluent.ClaimsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ClaimsNestedImpl(io.fabric8.openshift.api.model.OpenIDClaims item) {
      this.builder = new io.fabric8.openshift.api.model.OpenIDClaimsBuilder(this, item);
    }
    ClaimsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.OpenIDClaimsBuilder(this);
    }
    io.fabric8.openshift.api.model.OpenIDClaimsBuilder builder;
    public N and() {
      return (N) OpenIDIdentityProviderFluentImpl.this.withClaims(builder.build());
    }
    public N endClaims() {
      return and();
    }
    
  }
  public class ClientSecretNestedImpl<N> extends io.fabric8.openshift.api.model.SecretNameReferenceFluentImpl<io.fabric8.openshift.api.model.OpenIDIdentityProviderFluent.ClientSecretNested<N>> implements io.fabric8.openshift.api.model.OpenIDIdentityProviderFluent.ClientSecretNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ClientSecretNestedImpl(io.fabric8.openshift.api.model.SecretNameReference item) {
      this.builder = new io.fabric8.openshift.api.model.SecretNameReferenceBuilder(this, item);
    }
    ClientSecretNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.SecretNameReferenceBuilder(this);
    }
    io.fabric8.openshift.api.model.SecretNameReferenceBuilder builder;
    public N and() {
      return (N) OpenIDIdentityProviderFluentImpl.this.withClientSecret(builder.build());
    }
    public N endClientSecret() {
      return and();
    }
    
  }
  
}