package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class StageInfoBuilder extends io.fabric8.openshift.api.model.StageInfoFluentImpl<io.fabric8.openshift.api.model.StageInfoBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.StageInfo,io.fabric8.openshift.api.model.StageInfoBuilder>{
  public StageInfoBuilder() {
    this(false);
  }
  public StageInfoBuilder(java.lang.Boolean validationEnabled) {
    this(new StageInfo(), validationEnabled);
  }
  public StageInfoBuilder(io.fabric8.openshift.api.model.StageInfoFluent<?> fluent) {
    this(fluent, false);
  }
  public StageInfoBuilder(io.fabric8.openshift.api.model.StageInfoFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new StageInfo(), validationEnabled);
  }
  public StageInfoBuilder(io.fabric8.openshift.api.model.StageInfoFluent<?> fluent,io.fabric8.openshift.api.model.StageInfo instance) {
    this(fluent, instance, false);
  }
  public StageInfoBuilder(io.fabric8.openshift.api.model.StageInfoFluent<?> fluent,io.fabric8.openshift.api.model.StageInfo instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDurationMilliseconds(instance.getDurationMilliseconds()); 
    fluent.withName(instance.getName()); 
    fluent.withStartTime(instance.getStartTime()); 
    fluent.withSteps(instance.getSteps()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public StageInfoBuilder(io.fabric8.openshift.api.model.StageInfo instance) {
    this(instance,false);
  }
  public StageInfoBuilder(io.fabric8.openshift.api.model.StageInfo instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withDurationMilliseconds(instance.getDurationMilliseconds()); 
    this.withName(instance.getName()); 
    this.withStartTime(instance.getStartTime()); 
    this.withSteps(instance.getSteps()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.StageInfoFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.StageInfo build() {
    StageInfo buildable = new StageInfo(fluent.getDurationMilliseconds(),fluent.getName(),fluent.getStartTime(),fluent.getSteps());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    StageInfoBuilder that = (StageInfoBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}