/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.DNSSpec;
import io.fabric8.openshift.api.model.DNSSpecFluent;
import io.fabric8.openshift.api.model.DNSZone;
import io.fabric8.openshift.api.model.DNSZoneBuilder;
import io.fabric8.openshift.api.model.DNSZoneFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class DNSSpecFluentImpl<A extends DNSSpecFluent<A>>
extends BaseFluent<A>
implements DNSSpecFluent<A> {
    private String baseDomain;
    private DNSZoneBuilder privateZone;
    private DNSZoneBuilder publicZone;
    private Map<String, Object> additionalProperties;

    public DNSSpecFluentImpl() {
    }

    public DNSSpecFluentImpl(DNSSpec instance) {
        this.withBaseDomain(instance.getBaseDomain());
        this.withPrivateZone(instance.getPrivateZone());
        this.withPublicZone(instance.getPublicZone());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getBaseDomain() {
        return this.baseDomain;
    }

    @Override
    public A withBaseDomain(String baseDomain) {
        this.baseDomain = baseDomain;
        return (A)this;
    }

    @Override
    public Boolean hasBaseDomain() {
        return this.baseDomain != null;
    }

    @Override
    @Deprecated
    public A withNewBaseDomain(String arg0) {
        return this.withBaseDomain(new String(arg0));
    }

    @Override
    @Deprecated
    public DNSZone getPrivateZone() {
        return this.privateZone != null ? this.privateZone.build() : null;
    }

    @Override
    public DNSZone buildPrivateZone() {
        return this.privateZone != null ? this.privateZone.build() : null;
    }

    @Override
    public A withPrivateZone(DNSZone privateZone) {
        this._visitables.get((Object)"privateZone").remove(this.privateZone);
        if (privateZone != null) {
            this.privateZone = new DNSZoneBuilder(privateZone);
            this._visitables.get((Object)"privateZone").add(this.privateZone);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPrivateZone() {
        return this.privateZone != null;
    }

    @Override
    public DNSSpecFluent.PrivateZoneNested<A> withNewPrivateZone() {
        return new PrivateZoneNestedImpl();
    }

    @Override
    public DNSSpecFluent.PrivateZoneNested<A> withNewPrivateZoneLike(DNSZone item) {
        return new PrivateZoneNestedImpl(item);
    }

    @Override
    public DNSSpecFluent.PrivateZoneNested<A> editPrivateZone() {
        return this.withNewPrivateZoneLike(this.getPrivateZone());
    }

    @Override
    public DNSSpecFluent.PrivateZoneNested<A> editOrNewPrivateZone() {
        return this.withNewPrivateZoneLike(this.getPrivateZone() != null ? this.getPrivateZone() : new DNSZoneBuilder().build());
    }

    @Override
    public DNSSpecFluent.PrivateZoneNested<A> editOrNewPrivateZoneLike(DNSZone item) {
        return this.withNewPrivateZoneLike(this.getPrivateZone() != null ? this.getPrivateZone() : item);
    }

    @Override
    @Deprecated
    public DNSZone getPublicZone() {
        return this.publicZone != null ? this.publicZone.build() : null;
    }

    @Override
    public DNSZone buildPublicZone() {
        return this.publicZone != null ? this.publicZone.build() : null;
    }

    @Override
    public A withPublicZone(DNSZone publicZone) {
        this._visitables.get((Object)"publicZone").remove(this.publicZone);
        if (publicZone != null) {
            this.publicZone = new DNSZoneBuilder(publicZone);
            this._visitables.get((Object)"publicZone").add(this.publicZone);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPublicZone() {
        return this.publicZone != null;
    }

    @Override
    public DNSSpecFluent.PublicZoneNested<A> withNewPublicZone() {
        return new PublicZoneNestedImpl();
    }

    @Override
    public DNSSpecFluent.PublicZoneNested<A> withNewPublicZoneLike(DNSZone item) {
        return new PublicZoneNestedImpl(item);
    }

    @Override
    public DNSSpecFluent.PublicZoneNested<A> editPublicZone() {
        return this.withNewPublicZoneLike(this.getPublicZone());
    }

    @Override
    public DNSSpecFluent.PublicZoneNested<A> editOrNewPublicZone() {
        return this.withNewPublicZoneLike(this.getPublicZone() != null ? this.getPublicZone() : new DNSZoneBuilder().build());
    }

    @Override
    public DNSSpecFluent.PublicZoneNested<A> editOrNewPublicZoneLike(DNSZone item) {
        return this.withNewPublicZoneLike(this.getPublicZone() != null ? this.getPublicZone() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DNSSpecFluentImpl that = (DNSSpecFluentImpl)o;
        if (this.baseDomain != null ? !this.baseDomain.equals(that.baseDomain) : that.baseDomain != null) {
            return false;
        }
        if (this.privateZone != null ? !this.privateZone.equals(that.privateZone) : that.privateZone != null) {
            return false;
        }
        if (this.publicZone != null ? !this.publicZone.equals(that.publicZone) : that.publicZone != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.baseDomain, this.privateZone, this.publicZone, this.additionalProperties, super.hashCode());
    }

    public class PublicZoneNestedImpl<N>
    extends DNSZoneFluentImpl<DNSSpecFluent.PublicZoneNested<N>>
    implements DNSSpecFluent.PublicZoneNested<N>,
    Nested<N> {
        DNSZoneBuilder builder;

        PublicZoneNestedImpl(DNSZone item) {
            this.builder = new DNSZoneBuilder(this, item);
        }

        PublicZoneNestedImpl() {
            this.builder = new DNSZoneBuilder(this);
        }

        @Override
        public N and() {
            return (N)DNSSpecFluentImpl.this.withPublicZone(this.builder.build());
        }

        @Override
        public N endPublicZone() {
            return this.and();
        }
    }

    public class PrivateZoneNestedImpl<N>
    extends DNSZoneFluentImpl<DNSSpecFluent.PrivateZoneNested<N>>
    implements DNSSpecFluent.PrivateZoneNested<N>,
    Nested<N> {
        DNSZoneBuilder builder;

        PrivateZoneNestedImpl(DNSZone item) {
            this.builder = new DNSZoneBuilder(this, item);
        }

        PrivateZoneNestedImpl() {
            this.builder = new DNSZoneBuilder(this);
        }

        @Override
        public N and() {
            return (N)DNSSpecFluentImpl.this.withPrivateZone(this.builder.build());
        }

        @Override
        public N endPrivateZone() {
            return this.and();
        }
    }
}

