package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class AWSPlatformSpecBuilder extends io.fabric8.openshift.api.model.AWSPlatformSpecFluentImpl<io.fabric8.openshift.api.model.AWSPlatformSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.AWSPlatformSpec,io.fabric8.openshift.api.model.AWSPlatformSpecBuilder>{
  public AWSPlatformSpecBuilder() {
    this(false);
  }
  public AWSPlatformSpecBuilder(java.lang.Boolean validationEnabled) {
    this(new AWSPlatformSpec(), validationEnabled);
  }
  public AWSPlatformSpecBuilder(io.fabric8.openshift.api.model.AWSPlatformSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public AWSPlatformSpecBuilder(io.fabric8.openshift.api.model.AWSPlatformSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new AWSPlatformSpec(), validationEnabled);
  }
  public AWSPlatformSpecBuilder(io.fabric8.openshift.api.model.AWSPlatformSpecFluent<?> fluent,io.fabric8.openshift.api.model.AWSPlatformSpec instance) {
    this(fluent, instance, false);
  }
  public AWSPlatformSpecBuilder(io.fabric8.openshift.api.model.AWSPlatformSpecFluent<?> fluent,io.fabric8.openshift.api.model.AWSPlatformSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withServiceEndpoints(instance.getServiceEndpoints()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public AWSPlatformSpecBuilder(io.fabric8.openshift.api.model.AWSPlatformSpec instance) {
    this(instance,false);
  }
  public AWSPlatformSpecBuilder(io.fabric8.openshift.api.model.AWSPlatformSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withServiceEndpoints(instance.getServiceEndpoints()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.AWSPlatformSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.AWSPlatformSpec build() {
    AWSPlatformSpec buildable = new AWSPlatformSpec(fluent.getServiceEndpoints());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AWSPlatformSpecBuilder that = (AWSPlatformSpecBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}