package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public class AWSPlatformStatusFluentImpl<A extends io.fabric8.openshift.api.model.AWSPlatformStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.AWSPlatformStatusFluent<A>{
  public AWSPlatformStatusFluentImpl() {
  }
  public AWSPlatformStatusFluentImpl(io.fabric8.openshift.api.model.AWSPlatformStatus instance) {
    this.withRegion(instance.getRegion()); 
    this.withResourceTags(instance.getResourceTags()); 
    this.withServiceEndpoints(instance.getServiceEndpoints()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private java.lang.String region;
  private java.util.List<io.fabric8.openshift.api.model.AWSResourceTagBuilder> resourceTags =  new java.util.ArrayList<io.fabric8.openshift.api.model.AWSResourceTagBuilder>();
  private java.util.List<io.fabric8.openshift.api.model.AWSServiceEndpointBuilder> serviceEndpoints =  new java.util.ArrayList<io.fabric8.openshift.api.model.AWSServiceEndpointBuilder>();
  private java.util.Map<java.lang.String,java.lang.Object> additionalProperties;
  public java.lang.String getRegion() {
    return this.region;
  }
  public A withRegion(java.lang.String region) {
    this.region=region; return (A) this;
  }
  public java.lang.Boolean hasRegion() {
    return this.region != null;
  }
  
  /**
   * Method is deprecated. use withRegion instead.
   */
  @java.lang.Deprecated
  public A withNewRegion(java.lang.String arg0) {
    return (A)withRegion(new String(arg0));
  }
  public A addToResourceTags(java.lang.Integer index,io.fabric8.openshift.api.model.AWSResourceTag item) {
    if (this.resourceTags == null) {this.resourceTags = new java.util.ArrayList<io.fabric8.openshift.api.model.AWSResourceTagBuilder>();}
    io.fabric8.openshift.api.model.AWSResourceTagBuilder builder = new io.fabric8.openshift.api.model.AWSResourceTagBuilder(item);_visitables.get("resourceTags").add(index >= 0 ? index : _visitables.get("resourceTags").size(), builder);this.resourceTags.add(index >= 0 ? index : resourceTags.size(), builder); return (A)this;
  }
  public A setToResourceTags(java.lang.Integer index,io.fabric8.openshift.api.model.AWSResourceTag item) {
    if (this.resourceTags == null) {this.resourceTags = new java.util.ArrayList<io.fabric8.openshift.api.model.AWSResourceTagBuilder>();}
    io.fabric8.openshift.api.model.AWSResourceTagBuilder builder = new io.fabric8.openshift.api.model.AWSResourceTagBuilder(item);
    if (index < 0 || index >= _visitables.get("resourceTags").size()) { _visitables.get("resourceTags").add(builder); } else { _visitables.get("resourceTags").set(index, builder);}
    if (index < 0 || index >= resourceTags.size()) { resourceTags.add(builder); } else { resourceTags.set(index, builder);}
     return (A)this;
  }
  public A addToResourceTags(io.fabric8.openshift.api.model.AWSResourceTag... items) {
    if (this.resourceTags == null) {this.resourceTags = new java.util.ArrayList<io.fabric8.openshift.api.model.AWSResourceTagBuilder>();}
    for (io.fabric8.openshift.api.model.AWSResourceTag item : items) {io.fabric8.openshift.api.model.AWSResourceTagBuilder builder = new io.fabric8.openshift.api.model.AWSResourceTagBuilder(item);_visitables.get("resourceTags").add(builder);this.resourceTags.add(builder);} return (A)this;
  }
  public A addAllToResourceTags(java.util.Collection<io.fabric8.openshift.api.model.AWSResourceTag> items) {
    if (this.resourceTags == null) {this.resourceTags = new java.util.ArrayList<io.fabric8.openshift.api.model.AWSResourceTagBuilder>();}
    for (io.fabric8.openshift.api.model.AWSResourceTag item : items) {io.fabric8.openshift.api.model.AWSResourceTagBuilder builder = new io.fabric8.openshift.api.model.AWSResourceTagBuilder(item);_visitables.get("resourceTags").add(builder);this.resourceTags.add(builder);} return (A)this;
  }
  public A removeFromResourceTags(io.fabric8.openshift.api.model.AWSResourceTag... items) {
    for (io.fabric8.openshift.api.model.AWSResourceTag item : items) {io.fabric8.openshift.api.model.AWSResourceTagBuilder builder = new io.fabric8.openshift.api.model.AWSResourceTagBuilder(item);_visitables.get("resourceTags").remove(builder);if (this.resourceTags != null) {this.resourceTags.remove(builder);}} return (A)this;
  }
  public A removeAllFromResourceTags(java.util.Collection<io.fabric8.openshift.api.model.AWSResourceTag> items) {
    for (io.fabric8.openshift.api.model.AWSResourceTag item : items) {io.fabric8.openshift.api.model.AWSResourceTagBuilder builder = new io.fabric8.openshift.api.model.AWSResourceTagBuilder(item);_visitables.get("resourceTags").remove(builder);if (this.resourceTags != null) {this.resourceTags.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromResourceTags(java.util.function.Predicate<io.fabric8.openshift.api.model.AWSResourceTagBuilder> predicate) {
    if (resourceTags == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.AWSResourceTagBuilder> each = resourceTags.iterator();
    final List visitables = _visitables.get("resourceTags");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.AWSResourceTagBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildResourceTags instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.openshift.api.model.AWSResourceTag> getResourceTags() {
    return build(resourceTags);
  }
  public java.util.List<io.fabric8.openshift.api.model.AWSResourceTag> buildResourceTags() {
    return build(resourceTags);
  }
  public io.fabric8.openshift.api.model.AWSResourceTag buildResourceTag(java.lang.Integer index) {
    return this.resourceTags.get(index).build();
  }
  public io.fabric8.openshift.api.model.AWSResourceTag buildFirstResourceTag() {
    return this.resourceTags.get(0).build();
  }
  public io.fabric8.openshift.api.model.AWSResourceTag buildLastResourceTag() {
    return this.resourceTags.get(resourceTags.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.AWSResourceTag buildMatchingResourceTag(java.util.function.Predicate<io.fabric8.openshift.api.model.AWSResourceTagBuilder> predicate) {
    for (io.fabric8.openshift.api.model.AWSResourceTagBuilder item: resourceTags) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingResourceTag(java.util.function.Predicate<io.fabric8.openshift.api.model.AWSResourceTagBuilder> predicate) {
    for (io.fabric8.openshift.api.model.AWSResourceTagBuilder item: resourceTags) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withResourceTags(java.util.List<io.fabric8.openshift.api.model.AWSResourceTag> resourceTags) {
    if (this.resourceTags != null) { _visitables.get("resourceTags").removeAll(this.resourceTags);}
    if (resourceTags != null) {this.resourceTags = new java.util.ArrayList<io.fabric8.openshift.api.model.AWSResourceTagBuilder>(); for (io.fabric8.openshift.api.model.AWSResourceTag item : resourceTags){this.addToResourceTags(item);}} else { this.resourceTags = null;} return (A) this;
  }
  public A withResourceTags(io.fabric8.openshift.api.model.AWSResourceTag... resourceTags) {
    if (this.resourceTags != null) {this.resourceTags.clear();}
    if (resourceTags != null) {for (io.fabric8.openshift.api.model.AWSResourceTag item :resourceTags){ this.addToResourceTags(item);}} return (A) this;
  }
  public java.lang.Boolean hasResourceTags() {
    return resourceTags != null && !resourceTags.isEmpty();
  }
  public A addNewResourceTag(java.lang.String key,java.lang.String value) {
    return (A)addToResourceTags(new AWSResourceTag(key, value));
  }
  public io.fabric8.openshift.api.model.AWSPlatformStatusFluent.ResourceTagsNested<A> addNewResourceTag() {
    return new io.fabric8.openshift.api.model.AWSPlatformStatusFluentImpl.ResourceTagsNestedImpl();
  }
  public io.fabric8.openshift.api.model.AWSPlatformStatusFluent.ResourceTagsNested<A> addNewResourceTagLike(io.fabric8.openshift.api.model.AWSResourceTag item) {
    return new io.fabric8.openshift.api.model.AWSPlatformStatusFluentImpl.ResourceTagsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.AWSPlatformStatusFluent.ResourceTagsNested<A> setNewResourceTagLike(java.lang.Integer index,io.fabric8.openshift.api.model.AWSResourceTag item) {
    return new io.fabric8.openshift.api.model.AWSPlatformStatusFluentImpl.ResourceTagsNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.AWSPlatformStatusFluent.ResourceTagsNested<A> editResourceTag(java.lang.Integer index) {
    if (resourceTags.size() <= index) throw new RuntimeException("Can't edit resourceTags. Index exceeds size.");
    return setNewResourceTagLike(index, buildResourceTag(index));
  }
  public io.fabric8.openshift.api.model.AWSPlatformStatusFluent.ResourceTagsNested<A> editFirstResourceTag() {
    if (resourceTags.size() == 0) throw new RuntimeException("Can't edit first resourceTags. The list is empty.");
    return setNewResourceTagLike(0, buildResourceTag(0));
  }
  public io.fabric8.openshift.api.model.AWSPlatformStatusFluent.ResourceTagsNested<A> editLastResourceTag() {
    int index = resourceTags.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last resourceTags. The list is empty.");
    return setNewResourceTagLike(index, buildResourceTag(index));
  }
  public io.fabric8.openshift.api.model.AWSPlatformStatusFluent.ResourceTagsNested<A> editMatchingResourceTag(java.util.function.Predicate<io.fabric8.openshift.api.model.AWSResourceTagBuilder> predicate) {
    int index = -1;
    for (int i=0;i<resourceTags.size();i++) { 
    if (predicate.test(resourceTags.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching resourceTags. No match found.");
    return setNewResourceTagLike(index, buildResourceTag(index));
  }
  public A addToServiceEndpoints(java.lang.Integer index,io.fabric8.openshift.api.model.AWSServiceEndpoint item) {
    if (this.serviceEndpoints == null) {this.serviceEndpoints = new java.util.ArrayList<io.fabric8.openshift.api.model.AWSServiceEndpointBuilder>();}
    io.fabric8.openshift.api.model.AWSServiceEndpointBuilder builder = new io.fabric8.openshift.api.model.AWSServiceEndpointBuilder(item);_visitables.get("serviceEndpoints").add(index >= 0 ? index : _visitables.get("serviceEndpoints").size(), builder);this.serviceEndpoints.add(index >= 0 ? index : serviceEndpoints.size(), builder); return (A)this;
  }
  public A setToServiceEndpoints(java.lang.Integer index,io.fabric8.openshift.api.model.AWSServiceEndpoint item) {
    if (this.serviceEndpoints == null) {this.serviceEndpoints = new java.util.ArrayList<io.fabric8.openshift.api.model.AWSServiceEndpointBuilder>();}
    io.fabric8.openshift.api.model.AWSServiceEndpointBuilder builder = new io.fabric8.openshift.api.model.AWSServiceEndpointBuilder(item);
    if (index < 0 || index >= _visitables.get("serviceEndpoints").size()) { _visitables.get("serviceEndpoints").add(builder); } else { _visitables.get("serviceEndpoints").set(index, builder);}
    if (index < 0 || index >= serviceEndpoints.size()) { serviceEndpoints.add(builder); } else { serviceEndpoints.set(index, builder);}
     return (A)this;
  }
  public A addToServiceEndpoints(io.fabric8.openshift.api.model.AWSServiceEndpoint... items) {
    if (this.serviceEndpoints == null) {this.serviceEndpoints = new java.util.ArrayList<io.fabric8.openshift.api.model.AWSServiceEndpointBuilder>();}
    for (io.fabric8.openshift.api.model.AWSServiceEndpoint item : items) {io.fabric8.openshift.api.model.AWSServiceEndpointBuilder builder = new io.fabric8.openshift.api.model.AWSServiceEndpointBuilder(item);_visitables.get("serviceEndpoints").add(builder);this.serviceEndpoints.add(builder);} return (A)this;
  }
  public A addAllToServiceEndpoints(java.util.Collection<io.fabric8.openshift.api.model.AWSServiceEndpoint> items) {
    if (this.serviceEndpoints == null) {this.serviceEndpoints = new java.util.ArrayList<io.fabric8.openshift.api.model.AWSServiceEndpointBuilder>();}
    for (io.fabric8.openshift.api.model.AWSServiceEndpoint item : items) {io.fabric8.openshift.api.model.AWSServiceEndpointBuilder builder = new io.fabric8.openshift.api.model.AWSServiceEndpointBuilder(item);_visitables.get("serviceEndpoints").add(builder);this.serviceEndpoints.add(builder);} return (A)this;
  }
  public A removeFromServiceEndpoints(io.fabric8.openshift.api.model.AWSServiceEndpoint... items) {
    for (io.fabric8.openshift.api.model.AWSServiceEndpoint item : items) {io.fabric8.openshift.api.model.AWSServiceEndpointBuilder builder = new io.fabric8.openshift.api.model.AWSServiceEndpointBuilder(item);_visitables.get("serviceEndpoints").remove(builder);if (this.serviceEndpoints != null) {this.serviceEndpoints.remove(builder);}} return (A)this;
  }
  public A removeAllFromServiceEndpoints(java.util.Collection<io.fabric8.openshift.api.model.AWSServiceEndpoint> items) {
    for (io.fabric8.openshift.api.model.AWSServiceEndpoint item : items) {io.fabric8.openshift.api.model.AWSServiceEndpointBuilder builder = new io.fabric8.openshift.api.model.AWSServiceEndpointBuilder(item);_visitables.get("serviceEndpoints").remove(builder);if (this.serviceEndpoints != null) {this.serviceEndpoints.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromServiceEndpoints(java.util.function.Predicate<io.fabric8.openshift.api.model.AWSServiceEndpointBuilder> predicate) {
    if (serviceEndpoints == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.AWSServiceEndpointBuilder> each = serviceEndpoints.iterator();
    final List visitables = _visitables.get("serviceEndpoints");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.AWSServiceEndpointBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildServiceEndpoints instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.openshift.api.model.AWSServiceEndpoint> getServiceEndpoints() {
    return build(serviceEndpoints);
  }
  public java.util.List<io.fabric8.openshift.api.model.AWSServiceEndpoint> buildServiceEndpoints() {
    return build(serviceEndpoints);
  }
  public io.fabric8.openshift.api.model.AWSServiceEndpoint buildServiceEndpoint(java.lang.Integer index) {
    return this.serviceEndpoints.get(index).build();
  }
  public io.fabric8.openshift.api.model.AWSServiceEndpoint buildFirstServiceEndpoint() {
    return this.serviceEndpoints.get(0).build();
  }
  public io.fabric8.openshift.api.model.AWSServiceEndpoint buildLastServiceEndpoint() {
    return this.serviceEndpoints.get(serviceEndpoints.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.AWSServiceEndpoint buildMatchingServiceEndpoint(java.util.function.Predicate<io.fabric8.openshift.api.model.AWSServiceEndpointBuilder> predicate) {
    for (io.fabric8.openshift.api.model.AWSServiceEndpointBuilder item: serviceEndpoints) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingServiceEndpoint(java.util.function.Predicate<io.fabric8.openshift.api.model.AWSServiceEndpointBuilder> predicate) {
    for (io.fabric8.openshift.api.model.AWSServiceEndpointBuilder item: serviceEndpoints) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withServiceEndpoints(java.util.List<io.fabric8.openshift.api.model.AWSServiceEndpoint> serviceEndpoints) {
    if (this.serviceEndpoints != null) { _visitables.get("serviceEndpoints").removeAll(this.serviceEndpoints);}
    if (serviceEndpoints != null) {this.serviceEndpoints = new java.util.ArrayList<io.fabric8.openshift.api.model.AWSServiceEndpointBuilder>(); for (io.fabric8.openshift.api.model.AWSServiceEndpoint item : serviceEndpoints){this.addToServiceEndpoints(item);}} else { this.serviceEndpoints = null;} return (A) this;
  }
  public A withServiceEndpoints(io.fabric8.openshift.api.model.AWSServiceEndpoint... serviceEndpoints) {
    if (this.serviceEndpoints != null) {this.serviceEndpoints.clear();}
    if (serviceEndpoints != null) {for (io.fabric8.openshift.api.model.AWSServiceEndpoint item :serviceEndpoints){ this.addToServiceEndpoints(item);}} return (A) this;
  }
  public java.lang.Boolean hasServiceEndpoints() {
    return serviceEndpoints != null && !serviceEndpoints.isEmpty();
  }
  public A addNewServiceEndpoint(java.lang.String name,java.lang.String url) {
    return (A)addToServiceEndpoints(new AWSServiceEndpoint(name, url));
  }
  public io.fabric8.openshift.api.model.AWSPlatformStatusFluent.ServiceEndpointsNested<A> addNewServiceEndpoint() {
    return new io.fabric8.openshift.api.model.AWSPlatformStatusFluentImpl.ServiceEndpointsNestedImpl();
  }
  public io.fabric8.openshift.api.model.AWSPlatformStatusFluent.ServiceEndpointsNested<A> addNewServiceEndpointLike(io.fabric8.openshift.api.model.AWSServiceEndpoint item) {
    return new io.fabric8.openshift.api.model.AWSPlatformStatusFluentImpl.ServiceEndpointsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.AWSPlatformStatusFluent.ServiceEndpointsNested<A> setNewServiceEndpointLike(java.lang.Integer index,io.fabric8.openshift.api.model.AWSServiceEndpoint item) {
    return new io.fabric8.openshift.api.model.AWSPlatformStatusFluentImpl.ServiceEndpointsNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.AWSPlatformStatusFluent.ServiceEndpointsNested<A> editServiceEndpoint(java.lang.Integer index) {
    if (serviceEndpoints.size() <= index) throw new RuntimeException("Can't edit serviceEndpoints. Index exceeds size.");
    return setNewServiceEndpointLike(index, buildServiceEndpoint(index));
  }
  public io.fabric8.openshift.api.model.AWSPlatformStatusFluent.ServiceEndpointsNested<A> editFirstServiceEndpoint() {
    if (serviceEndpoints.size() == 0) throw new RuntimeException("Can't edit first serviceEndpoints. The list is empty.");
    return setNewServiceEndpointLike(0, buildServiceEndpoint(0));
  }
  public io.fabric8.openshift.api.model.AWSPlatformStatusFluent.ServiceEndpointsNested<A> editLastServiceEndpoint() {
    int index = serviceEndpoints.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last serviceEndpoints. The list is empty.");
    return setNewServiceEndpointLike(index, buildServiceEndpoint(index));
  }
  public io.fabric8.openshift.api.model.AWSPlatformStatusFluent.ServiceEndpointsNested<A> editMatchingServiceEndpoint(java.util.function.Predicate<io.fabric8.openshift.api.model.AWSServiceEndpointBuilder> predicate) {
    int index = -1;
    for (int i=0;i<serviceEndpoints.size();i++) { 
    if (predicate.test(serviceEndpoints.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching serviceEndpoints. No match found.");
    return setNewServiceEndpointLike(index, buildServiceEndpoint(index));
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AWSPlatformStatusFluentImpl that = (AWSPlatformStatusFluentImpl) o;
    if (region != null ? !region.equals(that.region) :that.region != null) return false;
    if (resourceTags != null ? !resourceTags.equals(that.resourceTags) :that.resourceTags != null) return false;
    if (serviceEndpoints != null ? !serviceEndpoints.equals(that.serviceEndpoints) :that.serviceEndpoints != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(region,  resourceTags,  serviceEndpoints,  additionalProperties,  super.hashCode());
  }
  public class ResourceTagsNestedImpl<N> extends io.fabric8.openshift.api.model.AWSResourceTagFluentImpl<io.fabric8.openshift.api.model.AWSPlatformStatusFluent.ResourceTagsNested<N>> implements io.fabric8.openshift.api.model.AWSPlatformStatusFluent.ResourceTagsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ResourceTagsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.AWSResourceTag item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.AWSResourceTagBuilder(this, item);
    }
    ResourceTagsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.AWSResourceTagBuilder(this);
    }
    io.fabric8.openshift.api.model.AWSResourceTagBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) AWSPlatformStatusFluentImpl.this.setToResourceTags(index,builder.build());
    }
    public N endResourceTag() {
      return and();
    }
    
  }
  public class ServiceEndpointsNestedImpl<N> extends io.fabric8.openshift.api.model.AWSServiceEndpointFluentImpl<io.fabric8.openshift.api.model.AWSPlatformStatusFluent.ServiceEndpointsNested<N>> implements io.fabric8.openshift.api.model.AWSPlatformStatusFluent.ServiceEndpointsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ServiceEndpointsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.AWSServiceEndpoint item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.AWSServiceEndpointBuilder(this, item);
    }
    ServiceEndpointsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.AWSServiceEndpointBuilder(this);
    }
    io.fabric8.openshift.api.model.AWSServiceEndpointBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) AWSPlatformStatusFluentImpl.this.setToServiceEndpoints(index,builder.build());
    }
    public N endServiceEndpoint() {
      return and();
    }
    
  }
  
}