package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class DeploymentStrategyBuilder extends io.fabric8.openshift.api.model.DeploymentStrategyFluentImpl<io.fabric8.openshift.api.model.DeploymentStrategyBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.DeploymentStrategy,io.fabric8.openshift.api.model.DeploymentStrategyBuilder>{
  public DeploymentStrategyBuilder() {
    this(false);
  }
  public DeploymentStrategyBuilder(java.lang.Boolean validationEnabled) {
    this(new DeploymentStrategy(), validationEnabled);
  }
  public DeploymentStrategyBuilder(io.fabric8.openshift.api.model.DeploymentStrategyFluent<?> fluent) {
    this(fluent, false);
  }
  public DeploymentStrategyBuilder(io.fabric8.openshift.api.model.DeploymentStrategyFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new DeploymentStrategy(), validationEnabled);
  }
  public DeploymentStrategyBuilder(io.fabric8.openshift.api.model.DeploymentStrategyFluent<?> fluent,io.fabric8.openshift.api.model.DeploymentStrategy instance) {
    this(fluent, instance, false);
  }
  public DeploymentStrategyBuilder(io.fabric8.openshift.api.model.DeploymentStrategyFluent<?> fluent,io.fabric8.openshift.api.model.DeploymentStrategy instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds()); 
    fluent.withAnnotations(instance.getAnnotations()); 
    fluent.withCustomParams(instance.getCustomParams()); 
    fluent.withLabels(instance.getLabels()); 
    fluent.withRecreateParams(instance.getRecreateParams()); 
    fluent.withResources(instance.getResources()); 
    fluent.withRollingParams(instance.getRollingParams()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public DeploymentStrategyBuilder(io.fabric8.openshift.api.model.DeploymentStrategy instance) {
    this(instance,false);
  }
  public DeploymentStrategyBuilder(io.fabric8.openshift.api.model.DeploymentStrategy instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds()); 
    this.withAnnotations(instance.getAnnotations()); 
    this.withCustomParams(instance.getCustomParams()); 
    this.withLabels(instance.getLabels()); 
    this.withRecreateParams(instance.getRecreateParams()); 
    this.withResources(instance.getResources()); 
    this.withRollingParams(instance.getRollingParams()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.DeploymentStrategyFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.DeploymentStrategy build() {
    DeploymentStrategy buildable = new DeploymentStrategy(fluent.getActiveDeadlineSeconds(),fluent.getAnnotations(),fluent.getCustomParams(),fluent.getLabels(),fluent.getRecreateParams(),fluent.getResources(),fluent.getRollingParams(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DeploymentStrategyBuilder that = (DeploymentStrategyBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}