package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ImageSignatureBuilder extends io.fabric8.openshift.api.model.ImageSignatureFluentImpl<io.fabric8.openshift.api.model.ImageSignatureBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.ImageSignature,io.fabric8.openshift.api.model.ImageSignatureBuilder>{
  public ImageSignatureBuilder() {
    this(false);
  }
  public ImageSignatureBuilder(java.lang.Boolean validationEnabled) {
    this(new ImageSignature(), validationEnabled);
  }
  public ImageSignatureBuilder(io.fabric8.openshift.api.model.ImageSignatureFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageSignatureBuilder(io.fabric8.openshift.api.model.ImageSignatureFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ImageSignature(), validationEnabled);
  }
  public ImageSignatureBuilder(io.fabric8.openshift.api.model.ImageSignatureFluent<?> fluent,io.fabric8.openshift.api.model.ImageSignature instance) {
    this(fluent, instance, false);
  }
  public ImageSignatureBuilder(io.fabric8.openshift.api.model.ImageSignatureFluent<?> fluent,io.fabric8.openshift.api.model.ImageSignature instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withConditions(instance.getConditions()); 
    fluent.withContent(instance.getContent()); 
    fluent.withCreated(instance.getCreated()); 
    fluent.withImageIdentity(instance.getImageIdentity()); 
    fluent.withIssuedBy(instance.getIssuedBy()); 
    fluent.withIssuedTo(instance.getIssuedTo()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSignedClaims(instance.getSignedClaims()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ImageSignatureBuilder(io.fabric8.openshift.api.model.ImageSignature instance) {
    this(instance,false);
  }
  public ImageSignatureBuilder(io.fabric8.openshift.api.model.ImageSignature instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withConditions(instance.getConditions()); 
    this.withContent(instance.getContent()); 
    this.withCreated(instance.getCreated()); 
    this.withImageIdentity(instance.getImageIdentity()); 
    this.withIssuedBy(instance.getIssuedBy()); 
    this.withIssuedTo(instance.getIssuedTo()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSignedClaims(instance.getSignedClaims()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ImageSignatureFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ImageSignature build() {
    ImageSignature buildable = new ImageSignature(fluent.getApiVersion(),fluent.getConditions(),fluent.getContent(),fluent.getCreated(),fluent.getImageIdentity(),fluent.getIssuedBy(),fluent.getIssuedTo(),fluent.getKind(),fluent.getMetadata(),fluent.getSignedClaims(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ImageSignatureBuilder that = (ImageSignatureBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}