package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ImageSourcePathBuilder extends io.fabric8.openshift.api.model.ImageSourcePathFluentImpl<io.fabric8.openshift.api.model.ImageSourcePathBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.ImageSourcePath,io.fabric8.openshift.api.model.ImageSourcePathBuilder>{
  public ImageSourcePathBuilder() {
    this(false);
  }
  public ImageSourcePathBuilder(java.lang.Boolean validationEnabled) {
    this(new ImageSourcePath(), validationEnabled);
  }
  public ImageSourcePathBuilder(io.fabric8.openshift.api.model.ImageSourcePathFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageSourcePathBuilder(io.fabric8.openshift.api.model.ImageSourcePathFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ImageSourcePath(), validationEnabled);
  }
  public ImageSourcePathBuilder(io.fabric8.openshift.api.model.ImageSourcePathFluent<?> fluent,io.fabric8.openshift.api.model.ImageSourcePath instance) {
    this(fluent, instance, false);
  }
  public ImageSourcePathBuilder(io.fabric8.openshift.api.model.ImageSourcePathFluent<?> fluent,io.fabric8.openshift.api.model.ImageSourcePath instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDestinationDir(instance.getDestinationDir()); 
    fluent.withSourcePath(instance.getSourcePath()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ImageSourcePathBuilder(io.fabric8.openshift.api.model.ImageSourcePath instance) {
    this(instance,false);
  }
  public ImageSourcePathBuilder(io.fabric8.openshift.api.model.ImageSourcePath instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withDestinationDir(instance.getDestinationDir()); 
    this.withSourcePath(instance.getSourcePath()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ImageSourcePathFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ImageSourcePath build() {
    ImageSourcePath buildable = new ImageSourcePath(fluent.getDestinationDir(),fluent.getSourcePath());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ImageSourcePathBuilder that = (ImageSourcePathBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}