package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class IngressSpecBuilder extends io.fabric8.openshift.api.model.IngressSpecFluentImpl<io.fabric8.openshift.api.model.IngressSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.IngressSpec,io.fabric8.openshift.api.model.IngressSpecBuilder>{
  public IngressSpecBuilder() {
    this(false);
  }
  public IngressSpecBuilder(java.lang.Boolean validationEnabled) {
    this(new IngressSpec(), validationEnabled);
  }
  public IngressSpecBuilder(io.fabric8.openshift.api.model.IngressSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public IngressSpecBuilder(io.fabric8.openshift.api.model.IngressSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new IngressSpec(), validationEnabled);
  }
  public IngressSpecBuilder(io.fabric8.openshift.api.model.IngressSpecFluent<?> fluent,io.fabric8.openshift.api.model.IngressSpec instance) {
    this(fluent, instance, false);
  }
  public IngressSpecBuilder(io.fabric8.openshift.api.model.IngressSpecFluent<?> fluent,io.fabric8.openshift.api.model.IngressSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAppsDomain(instance.getAppsDomain()); 
    fluent.withComponentRoutes(instance.getComponentRoutes()); 
    fluent.withDomain(instance.getDomain()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public IngressSpecBuilder(io.fabric8.openshift.api.model.IngressSpec instance) {
    this(instance,false);
  }
  public IngressSpecBuilder(io.fabric8.openshift.api.model.IngressSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAppsDomain(instance.getAppsDomain()); 
    this.withComponentRoutes(instance.getComponentRoutes()); 
    this.withDomain(instance.getDomain()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.IngressSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.IngressSpec build() {
    IngressSpec buildable = new IngressSpec(fluent.getAppsDomain(),fluent.getComponentRoutes(),fluent.getDomain());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    IngressSpecBuilder that = (IngressSpecBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}