package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class OperandVersionBuilder extends io.fabric8.openshift.api.model.OperandVersionFluentImpl<io.fabric8.openshift.api.model.OperandVersionBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.OperandVersion,io.fabric8.openshift.api.model.OperandVersionBuilder>{
  public OperandVersionBuilder() {
    this(false);
  }
  public OperandVersionBuilder(java.lang.Boolean validationEnabled) {
    this(new OperandVersion(), validationEnabled);
  }
  public OperandVersionBuilder(io.fabric8.openshift.api.model.OperandVersionFluent<?> fluent) {
    this(fluent, false);
  }
  public OperandVersionBuilder(io.fabric8.openshift.api.model.OperandVersionFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new OperandVersion(), validationEnabled);
  }
  public OperandVersionBuilder(io.fabric8.openshift.api.model.OperandVersionFluent<?> fluent,io.fabric8.openshift.api.model.OperandVersion instance) {
    this(fluent, instance, false);
  }
  public OperandVersionBuilder(io.fabric8.openshift.api.model.OperandVersionFluent<?> fluent,io.fabric8.openshift.api.model.OperandVersion instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withVersion(instance.getVersion()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public OperandVersionBuilder(io.fabric8.openshift.api.model.OperandVersion instance) {
    this(instance,false);
  }
  public OperandVersionBuilder(io.fabric8.openshift.api.model.OperandVersion instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withVersion(instance.getVersion()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.OperandVersionFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.OperandVersion build() {
    OperandVersion buildable = new OperandVersion(fluent.getName(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    OperandVersionBuilder that = (OperandVersionBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}