package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public class RouteIngressFluentImpl<A extends io.fabric8.openshift.api.model.RouteIngressFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.RouteIngressFluent<A>{
  public RouteIngressFluentImpl() {
  }
  public RouteIngressFluentImpl(io.fabric8.openshift.api.model.RouteIngress instance) {
    this.withConditions(instance.getConditions()); 
    this.withHost(instance.getHost()); 
    this.withRouterCanonicalHostname(instance.getRouterCanonicalHostname()); 
    this.withRouterName(instance.getRouterName()); 
    this.withWildcardPolicy(instance.getWildcardPolicy()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private java.util.List<io.fabric8.openshift.api.model.RouteIngressConditionBuilder> conditions =  new java.util.ArrayList<io.fabric8.openshift.api.model.RouteIngressConditionBuilder>();
  private java.lang.String host;
  private java.lang.String routerCanonicalHostname;
  private java.lang.String routerName;
  private java.lang.String wildcardPolicy;
  private java.util.Map<java.lang.String,java.lang.Object> additionalProperties;
  public A addToConditions(java.lang.Integer index,io.fabric8.openshift.api.model.RouteIngressCondition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.openshift.api.model.RouteIngressConditionBuilder>();}
    io.fabric8.openshift.api.model.RouteIngressConditionBuilder builder = new io.fabric8.openshift.api.model.RouteIngressConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(java.lang.Integer index,io.fabric8.openshift.api.model.RouteIngressCondition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.openshift.api.model.RouteIngressConditionBuilder>();}
    io.fabric8.openshift.api.model.RouteIngressConditionBuilder builder = new io.fabric8.openshift.api.model.RouteIngressConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.openshift.api.model.RouteIngressCondition... items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.openshift.api.model.RouteIngressConditionBuilder>();}
    for (io.fabric8.openshift.api.model.RouteIngressCondition item : items) {io.fabric8.openshift.api.model.RouteIngressConditionBuilder builder = new io.fabric8.openshift.api.model.RouteIngressConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(java.util.Collection<io.fabric8.openshift.api.model.RouteIngressCondition> items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.openshift.api.model.RouteIngressConditionBuilder>();}
    for (io.fabric8.openshift.api.model.RouteIngressCondition item : items) {io.fabric8.openshift.api.model.RouteIngressConditionBuilder builder = new io.fabric8.openshift.api.model.RouteIngressConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.openshift.api.model.RouteIngressCondition... items) {
    for (io.fabric8.openshift.api.model.RouteIngressCondition item : items) {io.fabric8.openshift.api.model.RouteIngressConditionBuilder builder = new io.fabric8.openshift.api.model.RouteIngressConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(java.util.Collection<io.fabric8.openshift.api.model.RouteIngressCondition> items) {
    for (io.fabric8.openshift.api.model.RouteIngressCondition item : items) {io.fabric8.openshift.api.model.RouteIngressConditionBuilder builder = new io.fabric8.openshift.api.model.RouteIngressConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(java.util.function.Predicate<io.fabric8.openshift.api.model.RouteIngressConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.RouteIngressConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.RouteIngressConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.openshift.api.model.RouteIngressCondition> getConditions() {
    return build(conditions);
  }
  public java.util.List<io.fabric8.openshift.api.model.RouteIngressCondition> buildConditions() {
    return build(conditions);
  }
  public io.fabric8.openshift.api.model.RouteIngressCondition buildCondition(java.lang.Integer index) {
    return this.conditions.get(index).build();
  }
  public io.fabric8.openshift.api.model.RouteIngressCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public io.fabric8.openshift.api.model.RouteIngressCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.RouteIngressCondition buildMatchingCondition(java.util.function.Predicate<io.fabric8.openshift.api.model.RouteIngressConditionBuilder> predicate) {
    for (io.fabric8.openshift.api.model.RouteIngressConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingCondition(java.util.function.Predicate<io.fabric8.openshift.api.model.RouteIngressConditionBuilder> predicate) {
    for (io.fabric8.openshift.api.model.RouteIngressConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(java.util.List<io.fabric8.openshift.api.model.RouteIngressCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new java.util.ArrayList<io.fabric8.openshift.api.model.RouteIngressConditionBuilder>(); for (io.fabric8.openshift.api.model.RouteIngressCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.openshift.api.model.RouteIngressCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (io.fabric8.openshift.api.model.RouteIngressCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public java.lang.Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public A addNewCondition(java.lang.String lastTransitionTime,java.lang.String message,java.lang.String reason,java.lang.String status,java.lang.String type) {
    return (A)addToConditions(new RouteIngressCondition(lastTransitionTime, message, reason, status, type));
  }
  public io.fabric8.openshift.api.model.RouteIngressFluent.ConditionsNested<A> addNewCondition() {
    return new io.fabric8.openshift.api.model.RouteIngressFluentImpl.ConditionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.RouteIngressFluent.ConditionsNested<A> addNewConditionLike(io.fabric8.openshift.api.model.RouteIngressCondition item) {
    return new io.fabric8.openshift.api.model.RouteIngressFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.RouteIngressFluent.ConditionsNested<A> setNewConditionLike(java.lang.Integer index,io.fabric8.openshift.api.model.RouteIngressCondition item) {
    return new io.fabric8.openshift.api.model.RouteIngressFluentImpl.ConditionsNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.RouteIngressFluent.ConditionsNested<A> editCondition(java.lang.Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public io.fabric8.openshift.api.model.RouteIngressFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public io.fabric8.openshift.api.model.RouteIngressFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public io.fabric8.openshift.api.model.RouteIngressFluent.ConditionsNested<A> editMatchingCondition(java.util.function.Predicate<io.fabric8.openshift.api.model.RouteIngressConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public java.lang.String getHost() {
    return this.host;
  }
  public A withHost(java.lang.String host) {
    this.host=host; return (A) this;
  }
  public java.lang.Boolean hasHost() {
    return this.host != null;
  }
  
  /**
   * Method is deprecated. use withHost instead.
   */
  @java.lang.Deprecated
  public A withNewHost(java.lang.String arg0) {
    return (A)withHost(new String(arg0));
  }
  public java.lang.String getRouterCanonicalHostname() {
    return this.routerCanonicalHostname;
  }
  public A withRouterCanonicalHostname(java.lang.String routerCanonicalHostname) {
    this.routerCanonicalHostname=routerCanonicalHostname; return (A) this;
  }
  public java.lang.Boolean hasRouterCanonicalHostname() {
    return this.routerCanonicalHostname != null;
  }
  
  /**
   * Method is deprecated. use withRouterCanonicalHostname instead.
   */
  @java.lang.Deprecated
  public A withNewRouterCanonicalHostname(java.lang.String arg0) {
    return (A)withRouterCanonicalHostname(new String(arg0));
  }
  public java.lang.String getRouterName() {
    return this.routerName;
  }
  public A withRouterName(java.lang.String routerName) {
    this.routerName=routerName; return (A) this;
  }
  public java.lang.Boolean hasRouterName() {
    return this.routerName != null;
  }
  
  /**
   * Method is deprecated. use withRouterName instead.
   */
  @java.lang.Deprecated
  public A withNewRouterName(java.lang.String arg0) {
    return (A)withRouterName(new String(arg0));
  }
  public java.lang.String getWildcardPolicy() {
    return this.wildcardPolicy;
  }
  public A withWildcardPolicy(java.lang.String wildcardPolicy) {
    this.wildcardPolicy=wildcardPolicy; return (A) this;
  }
  public java.lang.Boolean hasWildcardPolicy() {
    return this.wildcardPolicy != null;
  }
  
  /**
   * Method is deprecated. use withWildcardPolicy instead.
   */
  @java.lang.Deprecated
  public A withNewWildcardPolicy(java.lang.String arg0) {
    return (A)withWildcardPolicy(new String(arg0));
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RouteIngressFluentImpl that = (RouteIngressFluentImpl) o;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (host != null ? !host.equals(that.host) :that.host != null) return false;
    if (routerCanonicalHostname != null ? !routerCanonicalHostname.equals(that.routerCanonicalHostname) :that.routerCanonicalHostname != null) return false;
    if (routerName != null ? !routerName.equals(that.routerName) :that.routerName != null) return false;
    if (wildcardPolicy != null ? !wildcardPolicy.equals(that.wildcardPolicy) :that.wildcardPolicy != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(conditions,  host,  routerCanonicalHostname,  routerName,  wildcardPolicy,  additionalProperties,  super.hashCode());
  }
  public class ConditionsNestedImpl<N> extends io.fabric8.openshift.api.model.RouteIngressConditionFluentImpl<io.fabric8.openshift.api.model.RouteIngressFluent.ConditionsNested<N>> implements io.fabric8.openshift.api.model.RouteIngressFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ConditionsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.RouteIngressCondition item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.RouteIngressConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.RouteIngressConditionBuilder(this);
    }
    io.fabric8.openshift.api.model.RouteIngressConditionBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) RouteIngressFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  
}