package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class SecurityContextConstraintsBuilder extends io.fabric8.openshift.api.model.SecurityContextConstraintsFluentImpl<io.fabric8.openshift.api.model.SecurityContextConstraintsBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.SecurityContextConstraints,io.fabric8.openshift.api.model.SecurityContextConstraintsBuilder>{
  public SecurityContextConstraintsBuilder() {
    this(false);
  }
  public SecurityContextConstraintsBuilder(java.lang.Boolean validationEnabled) {
    this(new SecurityContextConstraints(), validationEnabled);
  }
  public SecurityContextConstraintsBuilder(io.fabric8.openshift.api.model.SecurityContextConstraintsFluent<?> fluent) {
    this(fluent, false);
  }
  public SecurityContextConstraintsBuilder(io.fabric8.openshift.api.model.SecurityContextConstraintsFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new SecurityContextConstraints(), validationEnabled);
  }
  public SecurityContextConstraintsBuilder(io.fabric8.openshift.api.model.SecurityContextConstraintsFluent<?> fluent,io.fabric8.openshift.api.model.SecurityContextConstraints instance) {
    this(fluent, instance, false);
  }
  public SecurityContextConstraintsBuilder(io.fabric8.openshift.api.model.SecurityContextConstraintsFluent<?> fluent,io.fabric8.openshift.api.model.SecurityContextConstraints instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAllowHostDirVolumePlugin(instance.getAllowHostDirVolumePlugin()); 
    fluent.withAllowHostIPC(instance.getAllowHostIPC()); 
    fluent.withAllowHostNetwork(instance.getAllowHostNetwork()); 
    fluent.withAllowHostPID(instance.getAllowHostPID()); 
    fluent.withAllowHostPorts(instance.getAllowHostPorts()); 
    fluent.withAllowPrivilegeEscalation(instance.getAllowPrivilegeEscalation()); 
    fluent.withAllowPrivilegedContainer(instance.getAllowPrivilegedContainer()); 
    fluent.withAllowedCapabilities(instance.getAllowedCapabilities()); 
    fluent.withAllowedFlexVolumes(instance.getAllowedFlexVolumes()); 
    fluent.withAllowedUnsafeSysctls(instance.getAllowedUnsafeSysctls()); 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withDefaultAddCapabilities(instance.getDefaultAddCapabilities()); 
    fluent.withDefaultAllowPrivilegeEscalation(instance.getDefaultAllowPrivilegeEscalation()); 
    fluent.withForbiddenSysctls(instance.getForbiddenSysctls()); 
    fluent.withFsGroup(instance.getFsGroup()); 
    fluent.withGroups(instance.getGroups()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withPriority(instance.getPriority()); 
    fluent.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem()); 
    fluent.withRequiredDropCapabilities(instance.getRequiredDropCapabilities()); 
    fluent.withRunAsUser(instance.getRunAsUser()); 
    fluent.withSeLinuxContext(instance.getSeLinuxContext()); 
    fluent.withSeccompProfiles(instance.getSeccompProfiles()); 
    fluent.withSupplementalGroups(instance.getSupplementalGroups()); 
    fluent.withUsers(instance.getUsers()); 
    fluent.withVolumes(instance.getVolumes()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public SecurityContextConstraintsBuilder(io.fabric8.openshift.api.model.SecurityContextConstraints instance) {
    this(instance,false);
  }
  public SecurityContextConstraintsBuilder(io.fabric8.openshift.api.model.SecurityContextConstraints instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAllowHostDirVolumePlugin(instance.getAllowHostDirVolumePlugin()); 
    this.withAllowHostIPC(instance.getAllowHostIPC()); 
    this.withAllowHostNetwork(instance.getAllowHostNetwork()); 
    this.withAllowHostPID(instance.getAllowHostPID()); 
    this.withAllowHostPorts(instance.getAllowHostPorts()); 
    this.withAllowPrivilegeEscalation(instance.getAllowPrivilegeEscalation()); 
    this.withAllowPrivilegedContainer(instance.getAllowPrivilegedContainer()); 
    this.withAllowedCapabilities(instance.getAllowedCapabilities()); 
    this.withAllowedFlexVolumes(instance.getAllowedFlexVolumes()); 
    this.withAllowedUnsafeSysctls(instance.getAllowedUnsafeSysctls()); 
    this.withApiVersion(instance.getApiVersion()); 
    this.withDefaultAddCapabilities(instance.getDefaultAddCapabilities()); 
    this.withDefaultAllowPrivilegeEscalation(instance.getDefaultAllowPrivilegeEscalation()); 
    this.withForbiddenSysctls(instance.getForbiddenSysctls()); 
    this.withFsGroup(instance.getFsGroup()); 
    this.withGroups(instance.getGroups()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withPriority(instance.getPriority()); 
    this.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem()); 
    this.withRequiredDropCapabilities(instance.getRequiredDropCapabilities()); 
    this.withRunAsUser(instance.getRunAsUser()); 
    this.withSeLinuxContext(instance.getSeLinuxContext()); 
    this.withSeccompProfiles(instance.getSeccompProfiles()); 
    this.withSupplementalGroups(instance.getSupplementalGroups()); 
    this.withUsers(instance.getUsers()); 
    this.withVolumes(instance.getVolumes()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.SecurityContextConstraintsFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.SecurityContextConstraints build() {
    SecurityContextConstraints buildable = new SecurityContextConstraints(fluent.getAllowHostDirVolumePlugin(),fluent.getAllowHostIPC(),fluent.getAllowHostNetwork(),fluent.getAllowHostPID(),fluent.getAllowHostPorts(),fluent.getAllowPrivilegeEscalation(),fluent.getAllowPrivilegedContainer(),fluent.getAllowedCapabilities(),fluent.getAllowedFlexVolumes(),fluent.getAllowedUnsafeSysctls(),fluent.getApiVersion(),fluent.getDefaultAddCapabilities(),fluent.getDefaultAllowPrivilegeEscalation(),fluent.getForbiddenSysctls(),fluent.getFsGroup(),fluent.getGroups(),fluent.getKind(),fluent.getMetadata(),fluent.getPriority(),fluent.getReadOnlyRootFilesystem(),fluent.getRequiredDropCapabilities(),fluent.getRunAsUser(),fluent.getSeLinuxContext(),fluent.getSeccompProfiles(),fluent.getSupplementalGroups(),fluent.getUsers(),fluent.getVolumes());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SecurityContextConstraintsBuilder that = (SecurityContextConstraintsBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}