package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.function.Predicate;
import java.util.List;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.util.Iterator;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.LinkedHashMap;
import java.util.Collection;
import io.fabric8.kubernetes.api.builder.Nested;

 /**
  * Generated
  */
public class TemplateFluentImpl<A extends io.fabric8.openshift.api.model.TemplateFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.TemplateFluent<A>{
  public TemplateFluentImpl() {
  }
  public TemplateFluentImpl(io.fabric8.openshift.api.model.Template instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withLabels(instance.getLabels()); 
    this.withMetadata(instance.getMetadata()); 
    this.withObjects(instance.getObjects()); 
    this.withParameters(instance.getParameters()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private java.lang.String apiVersion;
  private java.lang.String kind;
  private java.util.Map<java.lang.String,java.lang.String> labels;
  private io.fabric8.kubernetes.api.model.ObjectMetaBuilder metadata;
  private java.util.List<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> objects;
  private java.util.List<io.fabric8.openshift.api.model.ParameterBuilder> parameters;
  private java.util.Map<java.lang.String,java.lang.Object> additionalProperties;
  public java.lang.String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(java.lang.String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public java.lang.Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  /**
   * Method is deprecated. use withApiVersion instead.
   */
  @java.lang.Deprecated
  public A withNewApiVersion(java.lang.String arg0) {
    return (A)withApiVersion(new String(arg0));
  }
  public java.lang.String getKind() {
    return this.kind;
  }
  public A withKind(java.lang.String kind) {
    this.kind=kind; return (A) this;
  }
  public java.lang.Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * Method is deprecated. use withKind instead.
   */
  @java.lang.Deprecated
  public A withNewKind(java.lang.String arg0) {
    return (A)withKind(new String(arg0));
  }
  public A addToLabels(java.lang.String key,java.lang.String value) {
    if(this.labels == null && key != null && value != null) { this.labels = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(); }
    if(key != null && value != null) {this.labels.put(key, value);} return (A)this;
  }
  public A addToLabels(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.labels == null && map != null) { this.labels = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(); }
    if(map != null) { this.labels.putAll(map);} return (A)this;
  }
  public A removeFromLabels(java.lang.String key) {
    if(this.labels == null) { return (A) this; }
    if(key != null && this.labels != null) {this.labels.remove(key);} return (A)this;
  }
  public A removeFromLabels(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.labels == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.labels != null){this.labels.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.String> getLabels() {
    return this.labels;
  }
  public <K,V>A withLabels(java.util.Map<java.lang.String,java.lang.String> labels) {
    if (labels == null) { this.labels =  null;} else {this.labels = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(labels);} return (A) this;
  }
  public java.lang.Boolean hasLabels() {
    return this.labels != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.ObjectMeta getMetadata() {
    return this.metadata!=null?this.metadata.build():null;
  }
  public io.fabric8.kubernetes.api.model.ObjectMeta buildMetadata() {
    return this.metadata!=null?this.metadata.build():null;
  }
  public A withMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
  }
  public java.lang.Boolean hasMetadata() {
    return this.metadata != null;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.MetadataNested<A> withNewMetadata() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.MetadataNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.MetadataNested<A> withNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.MetadataNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public io.fabric8.openshift.api.model.TemplateFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new io.fabric8.kubernetes.api.model.ObjectMetaBuilder().build());
  }
  public io.fabric8.openshift.api.model.TemplateFluent.MetadataNested<A> editOrNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  public A addToObjects(io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    _visitables.get("objects").add(builder);this.objects.add(builder); return (A)this;
  }
  public A addToObjects(java.lang.Integer index,io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    _visitables.get("objects").add(index, builder);this.objects.add(index, builder); return (A)this;
  }
  public A addToObjects(java.lang.Integer index,io.fabric8.kubernetes.api.model.HasMetadata item) {
    if (item instanceof io.fabric8.openshift.api.model.ClusterVersion){addToClusterVersionObjects(index, (io.fabric8.openshift.api.model.ClusterVersion)item);}
 else if (item instanceof io.fabric8.openshift.api.model.DNS){addToDNSObjects(index, (io.fabric8.openshift.api.model.DNS)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ImageStreamImport){addToImageStreamImportObjects(index, (io.fabric8.openshift.api.model.ImageStreamImport)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Proxy){addToProxyObjects(index, (io.fabric8.openshift.api.model.Proxy)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Project){addToProjectObjects(index, (io.fabric8.openshift.api.model.Project)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ClusterOperator){addToClusterOperatorObjects(index, (io.fabric8.openshift.api.model.ClusterOperator)item);}
 else if (item instanceof io.fabric8.openshift.api.model.BuildConfig){addToBuildConfigObjects(index, (io.fabric8.openshift.api.model.BuildConfig)item);}
 else if (item instanceof io.fabric8.openshift.api.model.HelmChartRepository){addToHelmChartRepositoryObjects(index, (io.fabric8.openshift.api.model.HelmChartRepository)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Infrastructure){addToInfrastructureObjects(index, (io.fabric8.openshift.api.model.Infrastructure)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Scheduler){addToSchedulerObjects(index, (io.fabric8.openshift.api.model.Scheduler)item);}
 else if (item instanceof io.fabric8.openshift.api.model.RangeAllocation){addToRangeAllocationObjects(index, (io.fabric8.openshift.api.model.RangeAllocation)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Route){addToRouteObjects(index, (io.fabric8.openshift.api.model.Route)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ClusterNetwork){addToClusterNetworkObjects(index, (io.fabric8.openshift.api.model.ClusterNetwork)item);}
 else if (item instanceof io.fabric8.openshift.api.model.OAuthAuthorizeToken){addToOAuthAuthorizeTokenObjects(index, (io.fabric8.openshift.api.model.OAuthAuthorizeToken)item);}
 else if (item instanceof io.fabric8.openshift.api.model.UserOAuthAccessToken){addToUserOAuthAccessTokenObjects(index, (io.fabric8.openshift.api.model.UserOAuthAccessToken)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Ingress){addToIngressObjects(index, (io.fabric8.openshift.api.model.Ingress)item);}
 else if (item instanceof io.fabric8.openshift.api.model.OAuth){addToOAuthObjects(index, (io.fabric8.openshift.api.model.OAuth)item);}
 else if (item instanceof io.fabric8.openshift.api.model.OperatorHub){addToOperatorHubObjects(index, (io.fabric8.openshift.api.model.OperatorHub)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ClusterRoleBinding){addToClusterRoleBindingObjects(index, (io.fabric8.openshift.api.model.ClusterRoleBinding)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ClusterResourceQuota){addToClusterResourceQuotaObjects(index, (io.fabric8.openshift.api.model.ClusterResourceQuota)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ProjectRequest){addToProjectRequestObjects(index, (io.fabric8.openshift.api.model.ProjectRequest)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Template){addToTemplateObjects(index, (io.fabric8.openshift.api.model.Template)item);}
 else if (item instanceof io.fabric8.openshift.api.model.OAuthClientAuthorization){addToOAuthClientAuthorizationObjects(index, (io.fabric8.openshift.api.model.OAuthClientAuthorization)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ClusterRole){addToClusterRoleObjects(index, (io.fabric8.openshift.api.model.ClusterRole)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Authentication){addToAuthenticationObjects(index, (io.fabric8.openshift.api.model.Authentication)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ImageTag){addToImageTagObjects(index, (io.fabric8.openshift.api.model.ImageTag)item);}
 else if (item instanceof io.fabric8.openshift.api.model.OAuthAccessToken){addToOAuthAccessTokenObjects(index, (io.fabric8.openshift.api.model.OAuthAccessToken)item);}
 else if (item instanceof io.fabric8.openshift.api.model.DeploymentConfig){addToDeploymentConfigObjects(index, (io.fabric8.openshift.api.model.DeploymentConfig)item);}
 else if (item instanceof io.fabric8.openshift.api.model.RoleBinding){addToRoleBindingObjects(index, (io.fabric8.openshift.api.model.RoleBinding)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Image){addToImageObjects(index, (io.fabric8.openshift.api.model.Image)item);}
 else if (item instanceof io.fabric8.openshift.api.model.APIServer){addToAPIServerObjects(index, (io.fabric8.openshift.api.model.APIServer)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.PersistentVolumeClaim){addToPersistentVolumeClaimObjects(index, (io.fabric8.kubernetes.api.model.PersistentVolumeClaim)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ImageStreamMapping){addToImageStreamMappingObjects(index, (io.fabric8.openshift.api.model.ImageStreamMapping)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Role){addToRoleObjects(index, (io.fabric8.openshift.api.model.Role)item);}
 else if (item instanceof io.fabric8.openshift.api.model.BrokerTemplateInstance){addToBrokerTemplateInstanceObjects(index, (io.fabric8.openshift.api.model.BrokerTemplateInstance)item);}
 else if (item instanceof io.fabric8.openshift.api.model.FeatureGate){addToFeatureGateObjects(index, (io.fabric8.openshift.api.model.FeatureGate)item);}
 else if (item instanceof io.fabric8.openshift.api.model.User){addToUserObjects(index, (io.fabric8.openshift.api.model.User)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ImageStreamImage){addToImageStreamImageObjects(index, (io.fabric8.openshift.api.model.ImageStreamImage)item);}
 else if (item instanceof io.fabric8.openshift.api.model.TemplateInstance){addToTemplateInstanceObjects(index, (io.fabric8.openshift.api.model.TemplateInstance)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Build){addToBuildObjects(index, (io.fabric8.openshift.api.model.Build)item);}
 else if (item instanceof io.fabric8.openshift.api.model.RoleBindingRestriction){addToRoleBindingRestrictionObjects(index, (io.fabric8.openshift.api.model.RoleBindingRestriction)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ImageStreamTag){addToImageStreamTagObjects(index, (io.fabric8.openshift.api.model.ImageStreamTag)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Group){addToGroupObjects(index, (io.fabric8.openshift.api.model.Group)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ImageSignature){addToImageSignatureObjects(index, (io.fabric8.openshift.api.model.ImageSignature)item);}
 else if (item instanceof io.fabric8.openshift.api.model.HostSubnet){addToHostSubnetObjects(index, (io.fabric8.openshift.api.model.HostSubnet)item);}
 else if (item instanceof io.fabric8.openshift.api.model.AppliedClusterResourceQuota){addToAppliedClusterResourceQuotaObjects(index, (io.fabric8.openshift.api.model.AppliedClusterResourceQuota)item);}
 else if (item instanceof io.fabric8.openshift.api.model.SecurityContextConstraints){addToSecurityContextConstraintsObjects(index, (io.fabric8.openshift.api.model.SecurityContextConstraints)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Console){addToConsoleObjects(index, (io.fabric8.openshift.api.model.Console)item);}
 else if (item instanceof io.fabric8.openshift.api.model.BuildRequest){addToBuildRequestObjects(index, (io.fabric8.openshift.api.model.BuildRequest)item);}
 else if (item instanceof io.fabric8.openshift.api.model.EgressNetworkPolicy){addToEgressNetworkPolicyObjects(index, (io.fabric8.openshift.api.model.EgressNetworkPolicy)item);}
 else if (item instanceof io.fabric8.openshift.api.model.NetNamespace){addToNetNamespaceObjects(index, (io.fabric8.openshift.api.model.NetNamespace)item);}
 else if (item instanceof io.fabric8.openshift.api.model.UserIdentityMapping){addToUserIdentityMappingObjects(index, (io.fabric8.openshift.api.model.UserIdentityMapping)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ImageStream){addToImageStreamObjects(index, (io.fabric8.openshift.api.model.ImageStream)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Network){addToNetworkObjects(index, (io.fabric8.openshift.api.model.Network)item);}
 else if (item instanceof io.fabric8.openshift.api.model.OAuthClient){addToOAuthClientObjects(index, (io.fabric8.openshift.api.model.OAuthClient)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Identity){addToIdentityObjects(index, (io.fabric8.openshift.api.model.Identity)item);}

    return (A)this;
  }
  public A setToObjects(java.lang.Integer index,io.fabric8.kubernetes.api.model.HasMetadata item) {
    if (item instanceof io.fabric8.openshift.api.model.ClusterVersion){setToClusterVersionObjects(index, (io.fabric8.openshift.api.model.ClusterVersion)item);}
 else if (item instanceof io.fabric8.openshift.api.model.DNS){setToDNSObjects(index, (io.fabric8.openshift.api.model.DNS)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ImageStreamImport){setToImageStreamImportObjects(index, (io.fabric8.openshift.api.model.ImageStreamImport)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Proxy){setToProxyObjects(index, (io.fabric8.openshift.api.model.Proxy)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Project){setToProjectObjects(index, (io.fabric8.openshift.api.model.Project)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ClusterOperator){setToClusterOperatorObjects(index, (io.fabric8.openshift.api.model.ClusterOperator)item);}
 else if (item instanceof io.fabric8.openshift.api.model.BuildConfig){setToBuildConfigObjects(index, (io.fabric8.openshift.api.model.BuildConfig)item);}
 else if (item instanceof io.fabric8.openshift.api.model.HelmChartRepository){setToHelmChartRepositoryObjects(index, (io.fabric8.openshift.api.model.HelmChartRepository)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Infrastructure){setToInfrastructureObjects(index, (io.fabric8.openshift.api.model.Infrastructure)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Scheduler){setToSchedulerObjects(index, (io.fabric8.openshift.api.model.Scheduler)item);}
 else if (item instanceof io.fabric8.openshift.api.model.RangeAllocation){setToRangeAllocationObjects(index, (io.fabric8.openshift.api.model.RangeAllocation)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Route){setToRouteObjects(index, (io.fabric8.openshift.api.model.Route)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ClusterNetwork){setToClusterNetworkObjects(index, (io.fabric8.openshift.api.model.ClusterNetwork)item);}
 else if (item instanceof io.fabric8.openshift.api.model.OAuthAuthorizeToken){setToOAuthAuthorizeTokenObjects(index, (io.fabric8.openshift.api.model.OAuthAuthorizeToken)item);}
 else if (item instanceof io.fabric8.openshift.api.model.UserOAuthAccessToken){setToUserOAuthAccessTokenObjects(index, (io.fabric8.openshift.api.model.UserOAuthAccessToken)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Ingress){setToIngressObjects(index, (io.fabric8.openshift.api.model.Ingress)item);}
 else if (item instanceof io.fabric8.openshift.api.model.OAuth){setToOAuthObjects(index, (io.fabric8.openshift.api.model.OAuth)item);}
 else if (item instanceof io.fabric8.openshift.api.model.OperatorHub){setToOperatorHubObjects(index, (io.fabric8.openshift.api.model.OperatorHub)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ClusterRoleBinding){setToClusterRoleBindingObjects(index, (io.fabric8.openshift.api.model.ClusterRoleBinding)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ClusterResourceQuota){setToClusterResourceQuotaObjects(index, (io.fabric8.openshift.api.model.ClusterResourceQuota)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ProjectRequest){setToProjectRequestObjects(index, (io.fabric8.openshift.api.model.ProjectRequest)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Template){setToTemplateObjects(index, (io.fabric8.openshift.api.model.Template)item);}
 else if (item instanceof io.fabric8.openshift.api.model.OAuthClientAuthorization){setToOAuthClientAuthorizationObjects(index, (io.fabric8.openshift.api.model.OAuthClientAuthorization)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ClusterRole){setToClusterRoleObjects(index, (io.fabric8.openshift.api.model.ClusterRole)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Authentication){setToAuthenticationObjects(index, (io.fabric8.openshift.api.model.Authentication)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ImageTag){setToImageTagObjects(index, (io.fabric8.openshift.api.model.ImageTag)item);}
 else if (item instanceof io.fabric8.openshift.api.model.OAuthAccessToken){setToOAuthAccessTokenObjects(index, (io.fabric8.openshift.api.model.OAuthAccessToken)item);}
 else if (item instanceof io.fabric8.openshift.api.model.DeploymentConfig){setToDeploymentConfigObjects(index, (io.fabric8.openshift.api.model.DeploymentConfig)item);}
 else if (item instanceof io.fabric8.openshift.api.model.RoleBinding){setToRoleBindingObjects(index, (io.fabric8.openshift.api.model.RoleBinding)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Image){setToImageObjects(index, (io.fabric8.openshift.api.model.Image)item);}
 else if (item instanceof io.fabric8.openshift.api.model.APIServer){setToAPIServerObjects(index, (io.fabric8.openshift.api.model.APIServer)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.PersistentVolumeClaim){setToPersistentVolumeClaimObjects(index, (io.fabric8.kubernetes.api.model.PersistentVolumeClaim)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ImageStreamMapping){setToImageStreamMappingObjects(index, (io.fabric8.openshift.api.model.ImageStreamMapping)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Role){setToRoleObjects(index, (io.fabric8.openshift.api.model.Role)item);}
 else if (item instanceof io.fabric8.openshift.api.model.BrokerTemplateInstance){setToBrokerTemplateInstanceObjects(index, (io.fabric8.openshift.api.model.BrokerTemplateInstance)item);}
 else if (item instanceof io.fabric8.openshift.api.model.FeatureGate){setToFeatureGateObjects(index, (io.fabric8.openshift.api.model.FeatureGate)item);}
 else if (item instanceof io.fabric8.openshift.api.model.User){setToUserObjects(index, (io.fabric8.openshift.api.model.User)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ImageStreamImage){setToImageStreamImageObjects(index, (io.fabric8.openshift.api.model.ImageStreamImage)item);}
 else if (item instanceof io.fabric8.openshift.api.model.TemplateInstance){setToTemplateInstanceObjects(index, (io.fabric8.openshift.api.model.TemplateInstance)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Build){setToBuildObjects(index, (io.fabric8.openshift.api.model.Build)item);}
 else if (item instanceof io.fabric8.openshift.api.model.RoleBindingRestriction){setToRoleBindingRestrictionObjects(index, (io.fabric8.openshift.api.model.RoleBindingRestriction)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ImageStreamTag){setToImageStreamTagObjects(index, (io.fabric8.openshift.api.model.ImageStreamTag)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Group){setToGroupObjects(index, (io.fabric8.openshift.api.model.Group)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ImageSignature){setToImageSignatureObjects(index, (io.fabric8.openshift.api.model.ImageSignature)item);}
 else if (item instanceof io.fabric8.openshift.api.model.HostSubnet){setToHostSubnetObjects(index, (io.fabric8.openshift.api.model.HostSubnet)item);}
 else if (item instanceof io.fabric8.openshift.api.model.AppliedClusterResourceQuota){setToAppliedClusterResourceQuotaObjects(index, (io.fabric8.openshift.api.model.AppliedClusterResourceQuota)item);}
 else if (item instanceof io.fabric8.openshift.api.model.SecurityContextConstraints){setToSecurityContextConstraintsObjects(index, (io.fabric8.openshift.api.model.SecurityContextConstraints)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Console){setToConsoleObjects(index, (io.fabric8.openshift.api.model.Console)item);}
 else if (item instanceof io.fabric8.openshift.api.model.BuildRequest){setToBuildRequestObjects(index, (io.fabric8.openshift.api.model.BuildRequest)item);}
 else if (item instanceof io.fabric8.openshift.api.model.EgressNetworkPolicy){setToEgressNetworkPolicyObjects(index, (io.fabric8.openshift.api.model.EgressNetworkPolicy)item);}
 else if (item instanceof io.fabric8.openshift.api.model.NetNamespace){setToNetNamespaceObjects(index, (io.fabric8.openshift.api.model.NetNamespace)item);}
 else if (item instanceof io.fabric8.openshift.api.model.UserIdentityMapping){setToUserIdentityMappingObjects(index, (io.fabric8.openshift.api.model.UserIdentityMapping)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ImageStream){setToImageStreamObjects(index, (io.fabric8.openshift.api.model.ImageStream)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Network){setToNetworkObjects(index, (io.fabric8.openshift.api.model.Network)item);}
 else if (item instanceof io.fabric8.openshift.api.model.OAuthClient){setToOAuthClientObjects(index, (io.fabric8.openshift.api.model.OAuthClient)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Identity){setToIdentityObjects(index, (io.fabric8.openshift.api.model.Identity)item);}

    return (A)this;
  }
  public A addToObjects(io.fabric8.kubernetes.api.model.HasMetadata... items) {
     if (items != null && items.length > 0 && this.objects== null) {this.objects = new ArrayList<VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.kubernetes.api.model.HasMetadata item : items) { 
    if (item instanceof io.fabric8.openshift.api.model.ClusterVersion){addToClusterVersionObjects((io.fabric8.openshift.api.model.ClusterVersion)item);}
 else if (item instanceof io.fabric8.openshift.api.model.DNS){addToDNSObjects((io.fabric8.openshift.api.model.DNS)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ImageStreamImport){addToImageStreamImportObjects((io.fabric8.openshift.api.model.ImageStreamImport)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Proxy){addToProxyObjects((io.fabric8.openshift.api.model.Proxy)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Project){addToProjectObjects((io.fabric8.openshift.api.model.Project)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ClusterOperator){addToClusterOperatorObjects((io.fabric8.openshift.api.model.ClusterOperator)item);}
 else if (item instanceof io.fabric8.openshift.api.model.BuildConfig){addToBuildConfigObjects((io.fabric8.openshift.api.model.BuildConfig)item);}
 else if (item instanceof io.fabric8.openshift.api.model.HelmChartRepository){addToHelmChartRepositoryObjects((io.fabric8.openshift.api.model.HelmChartRepository)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Infrastructure){addToInfrastructureObjects((io.fabric8.openshift.api.model.Infrastructure)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Scheduler){addToSchedulerObjects((io.fabric8.openshift.api.model.Scheduler)item);}
 else if (item instanceof io.fabric8.openshift.api.model.RangeAllocation){addToRangeAllocationObjects((io.fabric8.openshift.api.model.RangeAllocation)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Route){addToRouteObjects((io.fabric8.openshift.api.model.Route)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ClusterNetwork){addToClusterNetworkObjects((io.fabric8.openshift.api.model.ClusterNetwork)item);}
 else if (item instanceof io.fabric8.openshift.api.model.OAuthAuthorizeToken){addToOAuthAuthorizeTokenObjects((io.fabric8.openshift.api.model.OAuthAuthorizeToken)item);}
 else if (item instanceof io.fabric8.openshift.api.model.UserOAuthAccessToken){addToUserOAuthAccessTokenObjects((io.fabric8.openshift.api.model.UserOAuthAccessToken)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Ingress){addToIngressObjects((io.fabric8.openshift.api.model.Ingress)item);}
 else if (item instanceof io.fabric8.openshift.api.model.OAuth){addToOAuthObjects((io.fabric8.openshift.api.model.OAuth)item);}
 else if (item instanceof io.fabric8.openshift.api.model.OperatorHub){addToOperatorHubObjects((io.fabric8.openshift.api.model.OperatorHub)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ClusterRoleBinding){addToClusterRoleBindingObjects((io.fabric8.openshift.api.model.ClusterRoleBinding)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ClusterResourceQuota){addToClusterResourceQuotaObjects((io.fabric8.openshift.api.model.ClusterResourceQuota)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ProjectRequest){addToProjectRequestObjects((io.fabric8.openshift.api.model.ProjectRequest)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Template){addToTemplateObjects((io.fabric8.openshift.api.model.Template)item);}
 else if (item instanceof io.fabric8.openshift.api.model.OAuthClientAuthorization){addToOAuthClientAuthorizationObjects((io.fabric8.openshift.api.model.OAuthClientAuthorization)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ClusterRole){addToClusterRoleObjects((io.fabric8.openshift.api.model.ClusterRole)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Authentication){addToAuthenticationObjects((io.fabric8.openshift.api.model.Authentication)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ImageTag){addToImageTagObjects((io.fabric8.openshift.api.model.ImageTag)item);}
 else if (item instanceof io.fabric8.openshift.api.model.OAuthAccessToken){addToOAuthAccessTokenObjects((io.fabric8.openshift.api.model.OAuthAccessToken)item);}
 else if (item instanceof io.fabric8.openshift.api.model.DeploymentConfig){addToDeploymentConfigObjects((io.fabric8.openshift.api.model.DeploymentConfig)item);}
 else if (item instanceof io.fabric8.openshift.api.model.RoleBinding){addToRoleBindingObjects((io.fabric8.openshift.api.model.RoleBinding)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Image){addToImageObjects((io.fabric8.openshift.api.model.Image)item);}
 else if (item instanceof io.fabric8.openshift.api.model.APIServer){addToAPIServerObjects((io.fabric8.openshift.api.model.APIServer)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.PersistentVolumeClaim){addToPersistentVolumeClaimObjects((io.fabric8.kubernetes.api.model.PersistentVolumeClaim)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ImageStreamMapping){addToImageStreamMappingObjects((io.fabric8.openshift.api.model.ImageStreamMapping)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Role){addToRoleObjects((io.fabric8.openshift.api.model.Role)item);}
 else if (item instanceof io.fabric8.openshift.api.model.BrokerTemplateInstance){addToBrokerTemplateInstanceObjects((io.fabric8.openshift.api.model.BrokerTemplateInstance)item);}
 else if (item instanceof io.fabric8.openshift.api.model.FeatureGate){addToFeatureGateObjects((io.fabric8.openshift.api.model.FeatureGate)item);}
 else if (item instanceof io.fabric8.openshift.api.model.User){addToUserObjects((io.fabric8.openshift.api.model.User)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ImageStreamImage){addToImageStreamImageObjects((io.fabric8.openshift.api.model.ImageStreamImage)item);}
 else if (item instanceof io.fabric8.openshift.api.model.TemplateInstance){addToTemplateInstanceObjects((io.fabric8.openshift.api.model.TemplateInstance)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Build){addToBuildObjects((io.fabric8.openshift.api.model.Build)item);}
 else if (item instanceof io.fabric8.openshift.api.model.RoleBindingRestriction){addToRoleBindingRestrictionObjects((io.fabric8.openshift.api.model.RoleBindingRestriction)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ImageStreamTag){addToImageStreamTagObjects((io.fabric8.openshift.api.model.ImageStreamTag)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Group){addToGroupObjects((io.fabric8.openshift.api.model.Group)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ImageSignature){addToImageSignatureObjects((io.fabric8.openshift.api.model.ImageSignature)item);}
 else if (item instanceof io.fabric8.openshift.api.model.HostSubnet){addToHostSubnetObjects((io.fabric8.openshift.api.model.HostSubnet)item);}
 else if (item instanceof io.fabric8.openshift.api.model.AppliedClusterResourceQuota){addToAppliedClusterResourceQuotaObjects((io.fabric8.openshift.api.model.AppliedClusterResourceQuota)item);}
 else if (item instanceof io.fabric8.openshift.api.model.SecurityContextConstraints){addToSecurityContextConstraintsObjects((io.fabric8.openshift.api.model.SecurityContextConstraints)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Console){addToConsoleObjects((io.fabric8.openshift.api.model.Console)item);}
 else if (item instanceof io.fabric8.openshift.api.model.BuildRequest){addToBuildRequestObjects((io.fabric8.openshift.api.model.BuildRequest)item);}
 else if (item instanceof io.fabric8.openshift.api.model.EgressNetworkPolicy){addToEgressNetworkPolicyObjects((io.fabric8.openshift.api.model.EgressNetworkPolicy)item);}
 else if (item instanceof io.fabric8.openshift.api.model.NetNamespace){addToNetNamespaceObjects((io.fabric8.openshift.api.model.NetNamespace)item);}
 else if (item instanceof io.fabric8.openshift.api.model.UserIdentityMapping){addToUserIdentityMappingObjects((io.fabric8.openshift.api.model.UserIdentityMapping)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ImageStream){addToImageStreamObjects((io.fabric8.openshift.api.model.ImageStream)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Network){addToNetworkObjects((io.fabric8.openshift.api.model.Network)item);}
 else if (item instanceof io.fabric8.openshift.api.model.OAuthClient){addToOAuthClientObjects((io.fabric8.openshift.api.model.OAuthClient)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Identity){addToIdentityObjects((io.fabric8.openshift.api.model.Identity)item);}

    else {  VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = builderOf(item); _visitables.get("objects").add(builder);this.objects.add(builder); }
    } return (A)this;
  }
  public A addAllToObjects(java.util.Collection<io.fabric8.kubernetes.api.model.HasMetadata> items) {
     if (items != null && items.size() > 0 && this.objects== null) {this.objects = new ArrayList<VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.kubernetes.api.model.HasMetadata item : items) { 
    if (item instanceof io.fabric8.openshift.api.model.ClusterVersion){addToClusterVersionObjects((io.fabric8.openshift.api.model.ClusterVersion)item);}
 else if (item instanceof io.fabric8.openshift.api.model.DNS){addToDNSObjects((io.fabric8.openshift.api.model.DNS)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ImageStreamImport){addToImageStreamImportObjects((io.fabric8.openshift.api.model.ImageStreamImport)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Proxy){addToProxyObjects((io.fabric8.openshift.api.model.Proxy)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Project){addToProjectObjects((io.fabric8.openshift.api.model.Project)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ClusterOperator){addToClusterOperatorObjects((io.fabric8.openshift.api.model.ClusterOperator)item);}
 else if (item instanceof io.fabric8.openshift.api.model.BuildConfig){addToBuildConfigObjects((io.fabric8.openshift.api.model.BuildConfig)item);}
 else if (item instanceof io.fabric8.openshift.api.model.HelmChartRepository){addToHelmChartRepositoryObjects((io.fabric8.openshift.api.model.HelmChartRepository)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Infrastructure){addToInfrastructureObjects((io.fabric8.openshift.api.model.Infrastructure)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Scheduler){addToSchedulerObjects((io.fabric8.openshift.api.model.Scheduler)item);}
 else if (item instanceof io.fabric8.openshift.api.model.RangeAllocation){addToRangeAllocationObjects((io.fabric8.openshift.api.model.RangeAllocation)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Route){addToRouteObjects((io.fabric8.openshift.api.model.Route)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ClusterNetwork){addToClusterNetworkObjects((io.fabric8.openshift.api.model.ClusterNetwork)item);}
 else if (item instanceof io.fabric8.openshift.api.model.OAuthAuthorizeToken){addToOAuthAuthorizeTokenObjects((io.fabric8.openshift.api.model.OAuthAuthorizeToken)item);}
 else if (item instanceof io.fabric8.openshift.api.model.UserOAuthAccessToken){addToUserOAuthAccessTokenObjects((io.fabric8.openshift.api.model.UserOAuthAccessToken)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Ingress){addToIngressObjects((io.fabric8.openshift.api.model.Ingress)item);}
 else if (item instanceof io.fabric8.openshift.api.model.OAuth){addToOAuthObjects((io.fabric8.openshift.api.model.OAuth)item);}
 else if (item instanceof io.fabric8.openshift.api.model.OperatorHub){addToOperatorHubObjects((io.fabric8.openshift.api.model.OperatorHub)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ClusterRoleBinding){addToClusterRoleBindingObjects((io.fabric8.openshift.api.model.ClusterRoleBinding)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ClusterResourceQuota){addToClusterResourceQuotaObjects((io.fabric8.openshift.api.model.ClusterResourceQuota)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ProjectRequest){addToProjectRequestObjects((io.fabric8.openshift.api.model.ProjectRequest)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Template){addToTemplateObjects((io.fabric8.openshift.api.model.Template)item);}
 else if (item instanceof io.fabric8.openshift.api.model.OAuthClientAuthorization){addToOAuthClientAuthorizationObjects((io.fabric8.openshift.api.model.OAuthClientAuthorization)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ClusterRole){addToClusterRoleObjects((io.fabric8.openshift.api.model.ClusterRole)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Authentication){addToAuthenticationObjects((io.fabric8.openshift.api.model.Authentication)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ImageTag){addToImageTagObjects((io.fabric8.openshift.api.model.ImageTag)item);}
 else if (item instanceof io.fabric8.openshift.api.model.OAuthAccessToken){addToOAuthAccessTokenObjects((io.fabric8.openshift.api.model.OAuthAccessToken)item);}
 else if (item instanceof io.fabric8.openshift.api.model.DeploymentConfig){addToDeploymentConfigObjects((io.fabric8.openshift.api.model.DeploymentConfig)item);}
 else if (item instanceof io.fabric8.openshift.api.model.RoleBinding){addToRoleBindingObjects((io.fabric8.openshift.api.model.RoleBinding)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Image){addToImageObjects((io.fabric8.openshift.api.model.Image)item);}
 else if (item instanceof io.fabric8.openshift.api.model.APIServer){addToAPIServerObjects((io.fabric8.openshift.api.model.APIServer)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.PersistentVolumeClaim){addToPersistentVolumeClaimObjects((io.fabric8.kubernetes.api.model.PersistentVolumeClaim)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ImageStreamMapping){addToImageStreamMappingObjects((io.fabric8.openshift.api.model.ImageStreamMapping)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Role){addToRoleObjects((io.fabric8.openshift.api.model.Role)item);}
 else if (item instanceof io.fabric8.openshift.api.model.BrokerTemplateInstance){addToBrokerTemplateInstanceObjects((io.fabric8.openshift.api.model.BrokerTemplateInstance)item);}
 else if (item instanceof io.fabric8.openshift.api.model.FeatureGate){addToFeatureGateObjects((io.fabric8.openshift.api.model.FeatureGate)item);}
 else if (item instanceof io.fabric8.openshift.api.model.User){addToUserObjects((io.fabric8.openshift.api.model.User)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ImageStreamImage){addToImageStreamImageObjects((io.fabric8.openshift.api.model.ImageStreamImage)item);}
 else if (item instanceof io.fabric8.openshift.api.model.TemplateInstance){addToTemplateInstanceObjects((io.fabric8.openshift.api.model.TemplateInstance)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Build){addToBuildObjects((io.fabric8.openshift.api.model.Build)item);}
 else if (item instanceof io.fabric8.openshift.api.model.RoleBindingRestriction){addToRoleBindingRestrictionObjects((io.fabric8.openshift.api.model.RoleBindingRestriction)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ImageStreamTag){addToImageStreamTagObjects((io.fabric8.openshift.api.model.ImageStreamTag)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Group){addToGroupObjects((io.fabric8.openshift.api.model.Group)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ImageSignature){addToImageSignatureObjects((io.fabric8.openshift.api.model.ImageSignature)item);}
 else if (item instanceof io.fabric8.openshift.api.model.HostSubnet){addToHostSubnetObjects((io.fabric8.openshift.api.model.HostSubnet)item);}
 else if (item instanceof io.fabric8.openshift.api.model.AppliedClusterResourceQuota){addToAppliedClusterResourceQuotaObjects((io.fabric8.openshift.api.model.AppliedClusterResourceQuota)item);}
 else if (item instanceof io.fabric8.openshift.api.model.SecurityContextConstraints){addToSecurityContextConstraintsObjects((io.fabric8.openshift.api.model.SecurityContextConstraints)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Console){addToConsoleObjects((io.fabric8.openshift.api.model.Console)item);}
 else if (item instanceof io.fabric8.openshift.api.model.BuildRequest){addToBuildRequestObjects((io.fabric8.openshift.api.model.BuildRequest)item);}
 else if (item instanceof io.fabric8.openshift.api.model.EgressNetworkPolicy){addToEgressNetworkPolicyObjects((io.fabric8.openshift.api.model.EgressNetworkPolicy)item);}
 else if (item instanceof io.fabric8.openshift.api.model.NetNamespace){addToNetNamespaceObjects((io.fabric8.openshift.api.model.NetNamespace)item);}
 else if (item instanceof io.fabric8.openshift.api.model.UserIdentityMapping){addToUserIdentityMappingObjects((io.fabric8.openshift.api.model.UserIdentityMapping)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ImageStream){addToImageStreamObjects((io.fabric8.openshift.api.model.ImageStream)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Network){addToNetworkObjects((io.fabric8.openshift.api.model.Network)item);}
 else if (item instanceof io.fabric8.openshift.api.model.OAuthClient){addToOAuthClientObjects((io.fabric8.openshift.api.model.OAuthClient)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Identity){addToIdentityObjects((io.fabric8.openshift.api.model.Identity)item);}

    else {  VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = builderOf(item); _visitables.get("objects").add(builder);this.objects.add(builder); }
    } return (A)this;
  }
  public A removeFromObjects(io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    _visitables.get("objects").remove(builder);this.objects.remove(builder); return (A)this;
  }
  public A removeFromObjects(io.fabric8.kubernetes.api.model.HasMetadata... items) {
    for (io.fabric8.kubernetes.api.model.HasMetadata item : items) {if (item instanceof io.fabric8.openshift.api.model.ClusterVersion){removeFromClusterVersionObjects((io.fabric8.openshift.api.model.ClusterVersion)item);}
 else if (item instanceof io.fabric8.openshift.api.model.DNS){removeFromDNSObjects((io.fabric8.openshift.api.model.DNS)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ImageStreamImport){removeFromImageStreamImportObjects((io.fabric8.openshift.api.model.ImageStreamImport)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Proxy){removeFromProxyObjects((io.fabric8.openshift.api.model.Proxy)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Project){removeFromProjectObjects((io.fabric8.openshift.api.model.Project)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ClusterOperator){removeFromClusterOperatorObjects((io.fabric8.openshift.api.model.ClusterOperator)item);}
 else if (item instanceof io.fabric8.openshift.api.model.BuildConfig){removeFromBuildConfigObjects((io.fabric8.openshift.api.model.BuildConfig)item);}
 else if (item instanceof io.fabric8.openshift.api.model.HelmChartRepository){removeFromHelmChartRepositoryObjects((io.fabric8.openshift.api.model.HelmChartRepository)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Infrastructure){removeFromInfrastructureObjects((io.fabric8.openshift.api.model.Infrastructure)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Scheduler){removeFromSchedulerObjects((io.fabric8.openshift.api.model.Scheduler)item);}
 else if (item instanceof io.fabric8.openshift.api.model.RangeAllocation){removeFromRangeAllocationObjects((io.fabric8.openshift.api.model.RangeAllocation)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Route){removeFromRouteObjects((io.fabric8.openshift.api.model.Route)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ClusterNetwork){removeFromClusterNetworkObjects((io.fabric8.openshift.api.model.ClusterNetwork)item);}
 else if (item instanceof io.fabric8.openshift.api.model.OAuthAuthorizeToken){removeFromOAuthAuthorizeTokenObjects((io.fabric8.openshift.api.model.OAuthAuthorizeToken)item);}
 else if (item instanceof io.fabric8.openshift.api.model.UserOAuthAccessToken){removeFromUserOAuthAccessTokenObjects((io.fabric8.openshift.api.model.UserOAuthAccessToken)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Ingress){removeFromIngressObjects((io.fabric8.openshift.api.model.Ingress)item);}
 else if (item instanceof io.fabric8.openshift.api.model.OAuth){removeFromOAuthObjects((io.fabric8.openshift.api.model.OAuth)item);}
 else if (item instanceof io.fabric8.openshift.api.model.OperatorHub){removeFromOperatorHubObjects((io.fabric8.openshift.api.model.OperatorHub)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ClusterRoleBinding){removeFromClusterRoleBindingObjects((io.fabric8.openshift.api.model.ClusterRoleBinding)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ClusterResourceQuota){removeFromClusterResourceQuotaObjects((io.fabric8.openshift.api.model.ClusterResourceQuota)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ProjectRequest){removeFromProjectRequestObjects((io.fabric8.openshift.api.model.ProjectRequest)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Template){removeFromTemplateObjects((io.fabric8.openshift.api.model.Template)item);}
 else if (item instanceof io.fabric8.openshift.api.model.OAuthClientAuthorization){removeFromOAuthClientAuthorizationObjects((io.fabric8.openshift.api.model.OAuthClientAuthorization)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ClusterRole){removeFromClusterRoleObjects((io.fabric8.openshift.api.model.ClusterRole)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Authentication){removeFromAuthenticationObjects((io.fabric8.openshift.api.model.Authentication)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ImageTag){removeFromImageTagObjects((io.fabric8.openshift.api.model.ImageTag)item);}
 else if (item instanceof io.fabric8.openshift.api.model.OAuthAccessToken){removeFromOAuthAccessTokenObjects((io.fabric8.openshift.api.model.OAuthAccessToken)item);}
 else if (item instanceof io.fabric8.openshift.api.model.DeploymentConfig){removeFromDeploymentConfigObjects((io.fabric8.openshift.api.model.DeploymentConfig)item);}
 else if (item instanceof io.fabric8.openshift.api.model.RoleBinding){removeFromRoleBindingObjects((io.fabric8.openshift.api.model.RoleBinding)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Image){removeFromImageObjects((io.fabric8.openshift.api.model.Image)item);}
 else if (item instanceof io.fabric8.openshift.api.model.APIServer){removeFromAPIServerObjects((io.fabric8.openshift.api.model.APIServer)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.PersistentVolumeClaim){removeFromPersistentVolumeClaimObjects((io.fabric8.kubernetes.api.model.PersistentVolumeClaim)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ImageStreamMapping){removeFromImageStreamMappingObjects((io.fabric8.openshift.api.model.ImageStreamMapping)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Role){removeFromRoleObjects((io.fabric8.openshift.api.model.Role)item);}
 else if (item instanceof io.fabric8.openshift.api.model.BrokerTemplateInstance){removeFromBrokerTemplateInstanceObjects((io.fabric8.openshift.api.model.BrokerTemplateInstance)item);}
 else if (item instanceof io.fabric8.openshift.api.model.FeatureGate){removeFromFeatureGateObjects((io.fabric8.openshift.api.model.FeatureGate)item);}
 else if (item instanceof io.fabric8.openshift.api.model.User){removeFromUserObjects((io.fabric8.openshift.api.model.User)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ImageStreamImage){removeFromImageStreamImageObjects((io.fabric8.openshift.api.model.ImageStreamImage)item);}
 else if (item instanceof io.fabric8.openshift.api.model.TemplateInstance){removeFromTemplateInstanceObjects((io.fabric8.openshift.api.model.TemplateInstance)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Build){removeFromBuildObjects((io.fabric8.openshift.api.model.Build)item);}
 else if (item instanceof io.fabric8.openshift.api.model.RoleBindingRestriction){removeFromRoleBindingRestrictionObjects((io.fabric8.openshift.api.model.RoleBindingRestriction)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ImageStreamTag){removeFromImageStreamTagObjects((io.fabric8.openshift.api.model.ImageStreamTag)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Group){removeFromGroupObjects((io.fabric8.openshift.api.model.Group)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ImageSignature){removeFromImageSignatureObjects((io.fabric8.openshift.api.model.ImageSignature)item);}
 else if (item instanceof io.fabric8.openshift.api.model.HostSubnet){removeFromHostSubnetObjects((io.fabric8.openshift.api.model.HostSubnet)item);}
 else if (item instanceof io.fabric8.openshift.api.model.AppliedClusterResourceQuota){removeFromAppliedClusterResourceQuotaObjects((io.fabric8.openshift.api.model.AppliedClusterResourceQuota)item);}
 else if (item instanceof io.fabric8.openshift.api.model.SecurityContextConstraints){removeFromSecurityContextConstraintsObjects((io.fabric8.openshift.api.model.SecurityContextConstraints)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Console){removeFromConsoleObjects((io.fabric8.openshift.api.model.Console)item);}
 else if (item instanceof io.fabric8.openshift.api.model.BuildRequest){removeFromBuildRequestObjects((io.fabric8.openshift.api.model.BuildRequest)item);}
 else if (item instanceof io.fabric8.openshift.api.model.EgressNetworkPolicy){removeFromEgressNetworkPolicyObjects((io.fabric8.openshift.api.model.EgressNetworkPolicy)item);}
 else if (item instanceof io.fabric8.openshift.api.model.NetNamespace){removeFromNetNamespaceObjects((io.fabric8.openshift.api.model.NetNamespace)item);}
 else if (item instanceof io.fabric8.openshift.api.model.UserIdentityMapping){removeFromUserIdentityMappingObjects((io.fabric8.openshift.api.model.UserIdentityMapping)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ImageStream){removeFromImageStreamObjects((io.fabric8.openshift.api.model.ImageStream)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Network){removeFromNetworkObjects((io.fabric8.openshift.api.model.Network)item);}
 else if (item instanceof io.fabric8.openshift.api.model.OAuthClient){removeFromOAuthClientObjects((io.fabric8.openshift.api.model.OAuthClient)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Identity){removeFromIdentityObjects((io.fabric8.openshift.api.model.Identity)item);}

    else {  VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = builderOf(item); _visitables.get("objects").remove(builder);this.objects.remove(builder); }
    } return (A)this;
  }
  public A removeAllFromObjects(java.util.Collection<io.fabric8.kubernetes.api.model.HasMetadata> items) {
    for (io.fabric8.kubernetes.api.model.HasMetadata item : items) {if (item instanceof io.fabric8.openshift.api.model.ClusterVersion){removeFromClusterVersionObjects((io.fabric8.openshift.api.model.ClusterVersion)item);}
 else if (item instanceof io.fabric8.openshift.api.model.DNS){removeFromDNSObjects((io.fabric8.openshift.api.model.DNS)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ImageStreamImport){removeFromImageStreamImportObjects((io.fabric8.openshift.api.model.ImageStreamImport)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Proxy){removeFromProxyObjects((io.fabric8.openshift.api.model.Proxy)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Project){removeFromProjectObjects((io.fabric8.openshift.api.model.Project)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ClusterOperator){removeFromClusterOperatorObjects((io.fabric8.openshift.api.model.ClusterOperator)item);}
 else if (item instanceof io.fabric8.openshift.api.model.BuildConfig){removeFromBuildConfigObjects((io.fabric8.openshift.api.model.BuildConfig)item);}
 else if (item instanceof io.fabric8.openshift.api.model.HelmChartRepository){removeFromHelmChartRepositoryObjects((io.fabric8.openshift.api.model.HelmChartRepository)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Infrastructure){removeFromInfrastructureObjects((io.fabric8.openshift.api.model.Infrastructure)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Scheduler){removeFromSchedulerObjects((io.fabric8.openshift.api.model.Scheduler)item);}
 else if (item instanceof io.fabric8.openshift.api.model.RangeAllocation){removeFromRangeAllocationObjects((io.fabric8.openshift.api.model.RangeAllocation)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Route){removeFromRouteObjects((io.fabric8.openshift.api.model.Route)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ClusterNetwork){removeFromClusterNetworkObjects((io.fabric8.openshift.api.model.ClusterNetwork)item);}
 else if (item instanceof io.fabric8.openshift.api.model.OAuthAuthorizeToken){removeFromOAuthAuthorizeTokenObjects((io.fabric8.openshift.api.model.OAuthAuthorizeToken)item);}
 else if (item instanceof io.fabric8.openshift.api.model.UserOAuthAccessToken){removeFromUserOAuthAccessTokenObjects((io.fabric8.openshift.api.model.UserOAuthAccessToken)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Ingress){removeFromIngressObjects((io.fabric8.openshift.api.model.Ingress)item);}
 else if (item instanceof io.fabric8.openshift.api.model.OAuth){removeFromOAuthObjects((io.fabric8.openshift.api.model.OAuth)item);}
 else if (item instanceof io.fabric8.openshift.api.model.OperatorHub){removeFromOperatorHubObjects((io.fabric8.openshift.api.model.OperatorHub)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ClusterRoleBinding){removeFromClusterRoleBindingObjects((io.fabric8.openshift.api.model.ClusterRoleBinding)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ClusterResourceQuota){removeFromClusterResourceQuotaObjects((io.fabric8.openshift.api.model.ClusterResourceQuota)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ProjectRequest){removeFromProjectRequestObjects((io.fabric8.openshift.api.model.ProjectRequest)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Template){removeFromTemplateObjects((io.fabric8.openshift.api.model.Template)item);}
 else if (item instanceof io.fabric8.openshift.api.model.OAuthClientAuthorization){removeFromOAuthClientAuthorizationObjects((io.fabric8.openshift.api.model.OAuthClientAuthorization)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ClusterRole){removeFromClusterRoleObjects((io.fabric8.openshift.api.model.ClusterRole)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Authentication){removeFromAuthenticationObjects((io.fabric8.openshift.api.model.Authentication)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ImageTag){removeFromImageTagObjects((io.fabric8.openshift.api.model.ImageTag)item);}
 else if (item instanceof io.fabric8.openshift.api.model.OAuthAccessToken){removeFromOAuthAccessTokenObjects((io.fabric8.openshift.api.model.OAuthAccessToken)item);}
 else if (item instanceof io.fabric8.openshift.api.model.DeploymentConfig){removeFromDeploymentConfigObjects((io.fabric8.openshift.api.model.DeploymentConfig)item);}
 else if (item instanceof io.fabric8.openshift.api.model.RoleBinding){removeFromRoleBindingObjects((io.fabric8.openshift.api.model.RoleBinding)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Image){removeFromImageObjects((io.fabric8.openshift.api.model.Image)item);}
 else if (item instanceof io.fabric8.openshift.api.model.APIServer){removeFromAPIServerObjects((io.fabric8.openshift.api.model.APIServer)item);}
 else if (item instanceof io.fabric8.kubernetes.api.model.PersistentVolumeClaim){removeFromPersistentVolumeClaimObjects((io.fabric8.kubernetes.api.model.PersistentVolumeClaim)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ImageStreamMapping){removeFromImageStreamMappingObjects((io.fabric8.openshift.api.model.ImageStreamMapping)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Role){removeFromRoleObjects((io.fabric8.openshift.api.model.Role)item);}
 else if (item instanceof io.fabric8.openshift.api.model.BrokerTemplateInstance){removeFromBrokerTemplateInstanceObjects((io.fabric8.openshift.api.model.BrokerTemplateInstance)item);}
 else if (item instanceof io.fabric8.openshift.api.model.FeatureGate){removeFromFeatureGateObjects((io.fabric8.openshift.api.model.FeatureGate)item);}
 else if (item instanceof io.fabric8.openshift.api.model.User){removeFromUserObjects((io.fabric8.openshift.api.model.User)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ImageStreamImage){removeFromImageStreamImageObjects((io.fabric8.openshift.api.model.ImageStreamImage)item);}
 else if (item instanceof io.fabric8.openshift.api.model.TemplateInstance){removeFromTemplateInstanceObjects((io.fabric8.openshift.api.model.TemplateInstance)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Build){removeFromBuildObjects((io.fabric8.openshift.api.model.Build)item);}
 else if (item instanceof io.fabric8.openshift.api.model.RoleBindingRestriction){removeFromRoleBindingRestrictionObjects((io.fabric8.openshift.api.model.RoleBindingRestriction)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ImageStreamTag){removeFromImageStreamTagObjects((io.fabric8.openshift.api.model.ImageStreamTag)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Group){removeFromGroupObjects((io.fabric8.openshift.api.model.Group)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ImageSignature){removeFromImageSignatureObjects((io.fabric8.openshift.api.model.ImageSignature)item);}
 else if (item instanceof io.fabric8.openshift.api.model.HostSubnet){removeFromHostSubnetObjects((io.fabric8.openshift.api.model.HostSubnet)item);}
 else if (item instanceof io.fabric8.openshift.api.model.AppliedClusterResourceQuota){removeFromAppliedClusterResourceQuotaObjects((io.fabric8.openshift.api.model.AppliedClusterResourceQuota)item);}
 else if (item instanceof io.fabric8.openshift.api.model.SecurityContextConstraints){removeFromSecurityContextConstraintsObjects((io.fabric8.openshift.api.model.SecurityContextConstraints)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Console){removeFromConsoleObjects((io.fabric8.openshift.api.model.Console)item);}
 else if (item instanceof io.fabric8.openshift.api.model.BuildRequest){removeFromBuildRequestObjects((io.fabric8.openshift.api.model.BuildRequest)item);}
 else if (item instanceof io.fabric8.openshift.api.model.EgressNetworkPolicy){removeFromEgressNetworkPolicyObjects((io.fabric8.openshift.api.model.EgressNetworkPolicy)item);}
 else if (item instanceof io.fabric8.openshift.api.model.NetNamespace){removeFromNetNamespaceObjects((io.fabric8.openshift.api.model.NetNamespace)item);}
 else if (item instanceof io.fabric8.openshift.api.model.UserIdentityMapping){removeFromUserIdentityMappingObjects((io.fabric8.openshift.api.model.UserIdentityMapping)item);}
 else if (item instanceof io.fabric8.openshift.api.model.ImageStream){removeFromImageStreamObjects((io.fabric8.openshift.api.model.ImageStream)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Network){removeFromNetworkObjects((io.fabric8.openshift.api.model.Network)item);}
 else if (item instanceof io.fabric8.openshift.api.model.OAuthClient){removeFromOAuthClientObjects((io.fabric8.openshift.api.model.OAuthClient)item);}
 else if (item instanceof io.fabric8.openshift.api.model.Identity){removeFromIdentityObjects((io.fabric8.openshift.api.model.Identity)item);}

    else {  VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = builderOf(item); _visitables.get("objects").remove(builder);this.objects.remove(builder); }
    } return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildObjects instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.HasMetadata> getObjects() {
    return build(objects);
  }
  public java.util.List<io.fabric8.kubernetes.api.model.HasMetadata> buildObjects() {
    return build(objects);
  }
  public io.fabric8.kubernetes.api.model.HasMetadata buildObject(java.lang.Integer index) {
    return this.objects.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.HasMetadata buildFirstObject() {
    return this.objects.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.HasMetadata buildLastObject() {
    return this.objects.get(objects.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.HasMetadata buildMatchingObject(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    for (io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> item: objects) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingObject(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    for (io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> item: objects) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withObjects(java.util.List<io.fabric8.kubernetes.api.model.HasMetadata> objects) {
    if (objects != null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>(); for (io.fabric8.kubernetes.api.model.HasMetadata item : objects){this.addToObjects(item);}} else { this.objects = null;} return (A) this;
  }
  public A withObjects(io.fabric8.kubernetes.api.model.HasMetadata... objects) {
    if (this.objects != null) {this.objects.clear();}
    if (objects != null) {for (io.fabric8.kubernetes.api.model.HasMetadata item :objects){ this.addToObjects(item);}} return (A) this;
  }
  public java.lang.Boolean hasObjects() {
    return objects != null && !objects.isEmpty();
  }
  public A addToClusterVersionObjects(java.lang.Integer index,io.fabric8.openshift.api.model.ClusterVersion item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.ClusterVersionBuilder builder = new io.fabric8.openshift.api.model.ClusterVersionBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToClusterVersionObjects(java.lang.Integer index,io.fabric8.openshift.api.model.ClusterVersion item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.ClusterVersionBuilder builder = new io.fabric8.openshift.api.model.ClusterVersionBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToClusterVersionObjects(io.fabric8.openshift.api.model.ClusterVersion... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.ClusterVersion item : items) {io.fabric8.openshift.api.model.ClusterVersionBuilder builder = new io.fabric8.openshift.api.model.ClusterVersionBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToClusterVersionObjects(java.util.Collection<io.fabric8.openshift.api.model.ClusterVersion> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.ClusterVersion item : items) {io.fabric8.openshift.api.model.ClusterVersionBuilder builder = new io.fabric8.openshift.api.model.ClusterVersionBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromClusterVersionObjects(io.fabric8.openshift.api.model.ClusterVersion... items) {
    for (io.fabric8.openshift.api.model.ClusterVersion item : items) {io.fabric8.openshift.api.model.ClusterVersionBuilder builder = new io.fabric8.openshift.api.model.ClusterVersionBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromClusterVersionObjects(java.util.Collection<io.fabric8.openshift.api.model.ClusterVersion> items) {
    for (io.fabric8.openshift.api.model.ClusterVersion item : items) {io.fabric8.openshift.api.model.ClusterVersionBuilder builder = new io.fabric8.openshift.api.model.ClusterVersionBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromClusterVersionObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ClusterVersionObjectsNested<A> addNewClusterVersionObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ClusterVersionObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ClusterVersionObjectsNested<A> addNewClusterVersionObjectLike(io.fabric8.openshift.api.model.ClusterVersion item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ClusterVersionObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ClusterVersionObjectsNested<A> setNewClusterVersionObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.ClusterVersion item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ClusterVersionObjectsNestedImpl(index, item);
  }
  public A addToDNSObjects(java.lang.Integer index,io.fabric8.openshift.api.model.DNS item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.DNSBuilder builder = new io.fabric8.openshift.api.model.DNSBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToDNSObjects(java.lang.Integer index,io.fabric8.openshift.api.model.DNS item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.DNSBuilder builder = new io.fabric8.openshift.api.model.DNSBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToDNSObjects(io.fabric8.openshift.api.model.DNS... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.DNS item : items) {io.fabric8.openshift.api.model.DNSBuilder builder = new io.fabric8.openshift.api.model.DNSBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToDNSObjects(java.util.Collection<io.fabric8.openshift.api.model.DNS> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.DNS item : items) {io.fabric8.openshift.api.model.DNSBuilder builder = new io.fabric8.openshift.api.model.DNSBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromDNSObjects(io.fabric8.openshift.api.model.DNS... items) {
    for (io.fabric8.openshift.api.model.DNS item : items) {io.fabric8.openshift.api.model.DNSBuilder builder = new io.fabric8.openshift.api.model.DNSBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromDNSObjects(java.util.Collection<io.fabric8.openshift.api.model.DNS> items) {
    for (io.fabric8.openshift.api.model.DNS item : items) {io.fabric8.openshift.api.model.DNSBuilder builder = new io.fabric8.openshift.api.model.DNSBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromDNSObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.DNSObjectsNested<A> addNewDNSObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.DNSObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.DNSObjectsNested<A> addNewDNSObjectLike(io.fabric8.openshift.api.model.DNS item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.DNSObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.DNSObjectsNested<A> setNewDNSObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.DNS item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.DNSObjectsNestedImpl(index, item);
  }
  public A addToImageStreamImportObjects(java.lang.Integer index,io.fabric8.openshift.api.model.ImageStreamImport item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.ImageStreamImportBuilder builder = new io.fabric8.openshift.api.model.ImageStreamImportBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToImageStreamImportObjects(java.lang.Integer index,io.fabric8.openshift.api.model.ImageStreamImport item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.ImageStreamImportBuilder builder = new io.fabric8.openshift.api.model.ImageStreamImportBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToImageStreamImportObjects(io.fabric8.openshift.api.model.ImageStreamImport... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.ImageStreamImport item : items) {io.fabric8.openshift.api.model.ImageStreamImportBuilder builder = new io.fabric8.openshift.api.model.ImageStreamImportBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToImageStreamImportObjects(java.util.Collection<io.fabric8.openshift.api.model.ImageStreamImport> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.ImageStreamImport item : items) {io.fabric8.openshift.api.model.ImageStreamImportBuilder builder = new io.fabric8.openshift.api.model.ImageStreamImportBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromImageStreamImportObjects(io.fabric8.openshift.api.model.ImageStreamImport... items) {
    for (io.fabric8.openshift.api.model.ImageStreamImport item : items) {io.fabric8.openshift.api.model.ImageStreamImportBuilder builder = new io.fabric8.openshift.api.model.ImageStreamImportBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromImageStreamImportObjects(java.util.Collection<io.fabric8.openshift.api.model.ImageStreamImport> items) {
    for (io.fabric8.openshift.api.model.ImageStreamImport item : items) {io.fabric8.openshift.api.model.ImageStreamImportBuilder builder = new io.fabric8.openshift.api.model.ImageStreamImportBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromImageStreamImportObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ImageStreamImportObjectsNested<A> addNewImageStreamImportObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ImageStreamImportObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ImageStreamImportObjectsNested<A> addNewImageStreamImportObjectLike(io.fabric8.openshift.api.model.ImageStreamImport item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ImageStreamImportObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ImageStreamImportObjectsNested<A> setNewImageStreamImportObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.ImageStreamImport item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ImageStreamImportObjectsNestedImpl(index, item);
  }
  public A addToProxyObjects(java.lang.Integer index,io.fabric8.openshift.api.model.Proxy item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.ProxyBuilder builder = new io.fabric8.openshift.api.model.ProxyBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToProxyObjects(java.lang.Integer index,io.fabric8.openshift.api.model.Proxy item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.ProxyBuilder builder = new io.fabric8.openshift.api.model.ProxyBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToProxyObjects(io.fabric8.openshift.api.model.Proxy... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.Proxy item : items) {io.fabric8.openshift.api.model.ProxyBuilder builder = new io.fabric8.openshift.api.model.ProxyBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToProxyObjects(java.util.Collection<io.fabric8.openshift.api.model.Proxy> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.Proxy item : items) {io.fabric8.openshift.api.model.ProxyBuilder builder = new io.fabric8.openshift.api.model.ProxyBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromProxyObjects(io.fabric8.openshift.api.model.Proxy... items) {
    for (io.fabric8.openshift.api.model.Proxy item : items) {io.fabric8.openshift.api.model.ProxyBuilder builder = new io.fabric8.openshift.api.model.ProxyBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromProxyObjects(java.util.Collection<io.fabric8.openshift.api.model.Proxy> items) {
    for (io.fabric8.openshift.api.model.Proxy item : items) {io.fabric8.openshift.api.model.ProxyBuilder builder = new io.fabric8.openshift.api.model.ProxyBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromProxyObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ProxyObjectsNested<A> addNewProxyObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ProxyObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ProxyObjectsNested<A> addNewProxyObjectLike(io.fabric8.openshift.api.model.Proxy item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ProxyObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ProxyObjectsNested<A> setNewProxyObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.Proxy item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ProxyObjectsNestedImpl(index, item);
  }
  public A addToProjectObjects(java.lang.Integer index,io.fabric8.openshift.api.model.Project item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.ProjectBuilder builder = new io.fabric8.openshift.api.model.ProjectBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToProjectObjects(java.lang.Integer index,io.fabric8.openshift.api.model.Project item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.ProjectBuilder builder = new io.fabric8.openshift.api.model.ProjectBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToProjectObjects(io.fabric8.openshift.api.model.Project... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.Project item : items) {io.fabric8.openshift.api.model.ProjectBuilder builder = new io.fabric8.openshift.api.model.ProjectBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToProjectObjects(java.util.Collection<io.fabric8.openshift.api.model.Project> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.Project item : items) {io.fabric8.openshift.api.model.ProjectBuilder builder = new io.fabric8.openshift.api.model.ProjectBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromProjectObjects(io.fabric8.openshift.api.model.Project... items) {
    for (io.fabric8.openshift.api.model.Project item : items) {io.fabric8.openshift.api.model.ProjectBuilder builder = new io.fabric8.openshift.api.model.ProjectBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromProjectObjects(java.util.Collection<io.fabric8.openshift.api.model.Project> items) {
    for (io.fabric8.openshift.api.model.Project item : items) {io.fabric8.openshift.api.model.ProjectBuilder builder = new io.fabric8.openshift.api.model.ProjectBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromProjectObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ProjectObjectsNested<A> addNewProjectObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ProjectObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ProjectObjectsNested<A> addNewProjectObjectLike(io.fabric8.openshift.api.model.Project item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ProjectObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ProjectObjectsNested<A> setNewProjectObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.Project item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ProjectObjectsNestedImpl(index, item);
  }
  public A addToClusterOperatorObjects(java.lang.Integer index,io.fabric8.openshift.api.model.ClusterOperator item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.ClusterOperatorBuilder builder = new io.fabric8.openshift.api.model.ClusterOperatorBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToClusterOperatorObjects(java.lang.Integer index,io.fabric8.openshift.api.model.ClusterOperator item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.ClusterOperatorBuilder builder = new io.fabric8.openshift.api.model.ClusterOperatorBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToClusterOperatorObjects(io.fabric8.openshift.api.model.ClusterOperator... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.ClusterOperator item : items) {io.fabric8.openshift.api.model.ClusterOperatorBuilder builder = new io.fabric8.openshift.api.model.ClusterOperatorBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToClusterOperatorObjects(java.util.Collection<io.fabric8.openshift.api.model.ClusterOperator> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.ClusterOperator item : items) {io.fabric8.openshift.api.model.ClusterOperatorBuilder builder = new io.fabric8.openshift.api.model.ClusterOperatorBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromClusterOperatorObjects(io.fabric8.openshift.api.model.ClusterOperator... items) {
    for (io.fabric8.openshift.api.model.ClusterOperator item : items) {io.fabric8.openshift.api.model.ClusterOperatorBuilder builder = new io.fabric8.openshift.api.model.ClusterOperatorBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromClusterOperatorObjects(java.util.Collection<io.fabric8.openshift.api.model.ClusterOperator> items) {
    for (io.fabric8.openshift.api.model.ClusterOperator item : items) {io.fabric8.openshift.api.model.ClusterOperatorBuilder builder = new io.fabric8.openshift.api.model.ClusterOperatorBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromClusterOperatorObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ClusterOperatorObjectsNested<A> addNewClusterOperatorObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ClusterOperatorObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ClusterOperatorObjectsNested<A> addNewClusterOperatorObjectLike(io.fabric8.openshift.api.model.ClusterOperator item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ClusterOperatorObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ClusterOperatorObjectsNested<A> setNewClusterOperatorObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.ClusterOperator item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ClusterOperatorObjectsNestedImpl(index, item);
  }
  public A addToBuildConfigObjects(java.lang.Integer index,io.fabric8.openshift.api.model.BuildConfig item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.BuildConfigBuilder builder = new io.fabric8.openshift.api.model.BuildConfigBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToBuildConfigObjects(java.lang.Integer index,io.fabric8.openshift.api.model.BuildConfig item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.BuildConfigBuilder builder = new io.fabric8.openshift.api.model.BuildConfigBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToBuildConfigObjects(io.fabric8.openshift.api.model.BuildConfig... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.BuildConfig item : items) {io.fabric8.openshift.api.model.BuildConfigBuilder builder = new io.fabric8.openshift.api.model.BuildConfigBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToBuildConfigObjects(java.util.Collection<io.fabric8.openshift.api.model.BuildConfig> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.BuildConfig item : items) {io.fabric8.openshift.api.model.BuildConfigBuilder builder = new io.fabric8.openshift.api.model.BuildConfigBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromBuildConfigObjects(io.fabric8.openshift.api.model.BuildConfig... items) {
    for (io.fabric8.openshift.api.model.BuildConfig item : items) {io.fabric8.openshift.api.model.BuildConfigBuilder builder = new io.fabric8.openshift.api.model.BuildConfigBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromBuildConfigObjects(java.util.Collection<io.fabric8.openshift.api.model.BuildConfig> items) {
    for (io.fabric8.openshift.api.model.BuildConfig item : items) {io.fabric8.openshift.api.model.BuildConfigBuilder builder = new io.fabric8.openshift.api.model.BuildConfigBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromBuildConfigObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.BuildConfigObjectsNested<A> addNewBuildConfigObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.BuildConfigObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.BuildConfigObjectsNested<A> addNewBuildConfigObjectLike(io.fabric8.openshift.api.model.BuildConfig item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.BuildConfigObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.BuildConfigObjectsNested<A> setNewBuildConfigObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.BuildConfig item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.BuildConfigObjectsNestedImpl(index, item);
  }
  public A addToHelmChartRepositoryObjects(java.lang.Integer index,io.fabric8.openshift.api.model.HelmChartRepository item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.HelmChartRepositoryBuilder builder = new io.fabric8.openshift.api.model.HelmChartRepositoryBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToHelmChartRepositoryObjects(java.lang.Integer index,io.fabric8.openshift.api.model.HelmChartRepository item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.HelmChartRepositoryBuilder builder = new io.fabric8.openshift.api.model.HelmChartRepositoryBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToHelmChartRepositoryObjects(io.fabric8.openshift.api.model.HelmChartRepository... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.HelmChartRepository item : items) {io.fabric8.openshift.api.model.HelmChartRepositoryBuilder builder = new io.fabric8.openshift.api.model.HelmChartRepositoryBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToHelmChartRepositoryObjects(java.util.Collection<io.fabric8.openshift.api.model.HelmChartRepository> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.HelmChartRepository item : items) {io.fabric8.openshift.api.model.HelmChartRepositoryBuilder builder = new io.fabric8.openshift.api.model.HelmChartRepositoryBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromHelmChartRepositoryObjects(io.fabric8.openshift.api.model.HelmChartRepository... items) {
    for (io.fabric8.openshift.api.model.HelmChartRepository item : items) {io.fabric8.openshift.api.model.HelmChartRepositoryBuilder builder = new io.fabric8.openshift.api.model.HelmChartRepositoryBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromHelmChartRepositoryObjects(java.util.Collection<io.fabric8.openshift.api.model.HelmChartRepository> items) {
    for (io.fabric8.openshift.api.model.HelmChartRepository item : items) {io.fabric8.openshift.api.model.HelmChartRepositoryBuilder builder = new io.fabric8.openshift.api.model.HelmChartRepositoryBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromHelmChartRepositoryObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.HelmChartRepositoryObjectsNested<A> addNewHelmChartRepositoryObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.HelmChartRepositoryObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.HelmChartRepositoryObjectsNested<A> addNewHelmChartRepositoryObjectLike(io.fabric8.openshift.api.model.HelmChartRepository item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.HelmChartRepositoryObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.HelmChartRepositoryObjectsNested<A> setNewHelmChartRepositoryObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.HelmChartRepository item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.HelmChartRepositoryObjectsNestedImpl(index, item);
  }
  public A addToInfrastructureObjects(java.lang.Integer index,io.fabric8.openshift.api.model.Infrastructure item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.InfrastructureBuilder builder = new io.fabric8.openshift.api.model.InfrastructureBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToInfrastructureObjects(java.lang.Integer index,io.fabric8.openshift.api.model.Infrastructure item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.InfrastructureBuilder builder = new io.fabric8.openshift.api.model.InfrastructureBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToInfrastructureObjects(io.fabric8.openshift.api.model.Infrastructure... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.Infrastructure item : items) {io.fabric8.openshift.api.model.InfrastructureBuilder builder = new io.fabric8.openshift.api.model.InfrastructureBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToInfrastructureObjects(java.util.Collection<io.fabric8.openshift.api.model.Infrastructure> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.Infrastructure item : items) {io.fabric8.openshift.api.model.InfrastructureBuilder builder = new io.fabric8.openshift.api.model.InfrastructureBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromInfrastructureObjects(io.fabric8.openshift.api.model.Infrastructure... items) {
    for (io.fabric8.openshift.api.model.Infrastructure item : items) {io.fabric8.openshift.api.model.InfrastructureBuilder builder = new io.fabric8.openshift.api.model.InfrastructureBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromInfrastructureObjects(java.util.Collection<io.fabric8.openshift.api.model.Infrastructure> items) {
    for (io.fabric8.openshift.api.model.Infrastructure item : items) {io.fabric8.openshift.api.model.InfrastructureBuilder builder = new io.fabric8.openshift.api.model.InfrastructureBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromInfrastructureObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.InfrastructureObjectsNested<A> addNewInfrastructureObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.InfrastructureObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.InfrastructureObjectsNested<A> addNewInfrastructureObjectLike(io.fabric8.openshift.api.model.Infrastructure item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.InfrastructureObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.InfrastructureObjectsNested<A> setNewInfrastructureObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.Infrastructure item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.InfrastructureObjectsNestedImpl(index, item);
  }
  public A addToSchedulerObjects(java.lang.Integer index,io.fabric8.openshift.api.model.Scheduler item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.SchedulerBuilder builder = new io.fabric8.openshift.api.model.SchedulerBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToSchedulerObjects(java.lang.Integer index,io.fabric8.openshift.api.model.Scheduler item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.SchedulerBuilder builder = new io.fabric8.openshift.api.model.SchedulerBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToSchedulerObjects(io.fabric8.openshift.api.model.Scheduler... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.Scheduler item : items) {io.fabric8.openshift.api.model.SchedulerBuilder builder = new io.fabric8.openshift.api.model.SchedulerBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToSchedulerObjects(java.util.Collection<io.fabric8.openshift.api.model.Scheduler> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.Scheduler item : items) {io.fabric8.openshift.api.model.SchedulerBuilder builder = new io.fabric8.openshift.api.model.SchedulerBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromSchedulerObjects(io.fabric8.openshift.api.model.Scheduler... items) {
    for (io.fabric8.openshift.api.model.Scheduler item : items) {io.fabric8.openshift.api.model.SchedulerBuilder builder = new io.fabric8.openshift.api.model.SchedulerBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromSchedulerObjects(java.util.Collection<io.fabric8.openshift.api.model.Scheduler> items) {
    for (io.fabric8.openshift.api.model.Scheduler item : items) {io.fabric8.openshift.api.model.SchedulerBuilder builder = new io.fabric8.openshift.api.model.SchedulerBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromSchedulerObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.SchedulerObjectsNested<A> addNewSchedulerObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.SchedulerObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.SchedulerObjectsNested<A> addNewSchedulerObjectLike(io.fabric8.openshift.api.model.Scheduler item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.SchedulerObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.SchedulerObjectsNested<A> setNewSchedulerObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.Scheduler item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.SchedulerObjectsNestedImpl(index, item);
  }
  public A addToRangeAllocationObjects(java.lang.Integer index,io.fabric8.openshift.api.model.RangeAllocation item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.RangeAllocationBuilder builder = new io.fabric8.openshift.api.model.RangeAllocationBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToRangeAllocationObjects(java.lang.Integer index,io.fabric8.openshift.api.model.RangeAllocation item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.RangeAllocationBuilder builder = new io.fabric8.openshift.api.model.RangeAllocationBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToRangeAllocationObjects(io.fabric8.openshift.api.model.RangeAllocation... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.RangeAllocation item : items) {io.fabric8.openshift.api.model.RangeAllocationBuilder builder = new io.fabric8.openshift.api.model.RangeAllocationBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToRangeAllocationObjects(java.util.Collection<io.fabric8.openshift.api.model.RangeAllocation> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.RangeAllocation item : items) {io.fabric8.openshift.api.model.RangeAllocationBuilder builder = new io.fabric8.openshift.api.model.RangeAllocationBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromRangeAllocationObjects(io.fabric8.openshift.api.model.RangeAllocation... items) {
    for (io.fabric8.openshift.api.model.RangeAllocation item : items) {io.fabric8.openshift.api.model.RangeAllocationBuilder builder = new io.fabric8.openshift.api.model.RangeAllocationBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromRangeAllocationObjects(java.util.Collection<io.fabric8.openshift.api.model.RangeAllocation> items) {
    for (io.fabric8.openshift.api.model.RangeAllocation item : items) {io.fabric8.openshift.api.model.RangeAllocationBuilder builder = new io.fabric8.openshift.api.model.RangeAllocationBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromRangeAllocationObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.RangeAllocationObjectsNested<A> addNewRangeAllocationObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.RangeAllocationObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.RangeAllocationObjectsNested<A> addNewRangeAllocationObjectLike(io.fabric8.openshift.api.model.RangeAllocation item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.RangeAllocationObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.RangeAllocationObjectsNested<A> setNewRangeAllocationObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.RangeAllocation item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.RangeAllocationObjectsNestedImpl(index, item);
  }
  public A addToRouteObjects(java.lang.Integer index,io.fabric8.openshift.api.model.Route item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.RouteBuilder builder = new io.fabric8.openshift.api.model.RouteBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToRouteObjects(java.lang.Integer index,io.fabric8.openshift.api.model.Route item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.RouteBuilder builder = new io.fabric8.openshift.api.model.RouteBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToRouteObjects(io.fabric8.openshift.api.model.Route... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.Route item : items) {io.fabric8.openshift.api.model.RouteBuilder builder = new io.fabric8.openshift.api.model.RouteBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToRouteObjects(java.util.Collection<io.fabric8.openshift.api.model.Route> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.Route item : items) {io.fabric8.openshift.api.model.RouteBuilder builder = new io.fabric8.openshift.api.model.RouteBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromRouteObjects(io.fabric8.openshift.api.model.Route... items) {
    for (io.fabric8.openshift.api.model.Route item : items) {io.fabric8.openshift.api.model.RouteBuilder builder = new io.fabric8.openshift.api.model.RouteBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromRouteObjects(java.util.Collection<io.fabric8.openshift.api.model.Route> items) {
    for (io.fabric8.openshift.api.model.Route item : items) {io.fabric8.openshift.api.model.RouteBuilder builder = new io.fabric8.openshift.api.model.RouteBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromRouteObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.RouteObjectsNested<A> addNewRouteObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.RouteObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.RouteObjectsNested<A> addNewRouteObjectLike(io.fabric8.openshift.api.model.Route item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.RouteObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.RouteObjectsNested<A> setNewRouteObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.Route item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.RouteObjectsNestedImpl(index, item);
  }
  public A addToClusterNetworkObjects(java.lang.Integer index,io.fabric8.openshift.api.model.ClusterNetwork item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.ClusterNetworkBuilder builder = new io.fabric8.openshift.api.model.ClusterNetworkBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToClusterNetworkObjects(java.lang.Integer index,io.fabric8.openshift.api.model.ClusterNetwork item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.ClusterNetworkBuilder builder = new io.fabric8.openshift.api.model.ClusterNetworkBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToClusterNetworkObjects(io.fabric8.openshift.api.model.ClusterNetwork... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.ClusterNetwork item : items) {io.fabric8.openshift.api.model.ClusterNetworkBuilder builder = new io.fabric8.openshift.api.model.ClusterNetworkBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToClusterNetworkObjects(java.util.Collection<io.fabric8.openshift.api.model.ClusterNetwork> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.ClusterNetwork item : items) {io.fabric8.openshift.api.model.ClusterNetworkBuilder builder = new io.fabric8.openshift.api.model.ClusterNetworkBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromClusterNetworkObjects(io.fabric8.openshift.api.model.ClusterNetwork... items) {
    for (io.fabric8.openshift.api.model.ClusterNetwork item : items) {io.fabric8.openshift.api.model.ClusterNetworkBuilder builder = new io.fabric8.openshift.api.model.ClusterNetworkBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromClusterNetworkObjects(java.util.Collection<io.fabric8.openshift.api.model.ClusterNetwork> items) {
    for (io.fabric8.openshift.api.model.ClusterNetwork item : items) {io.fabric8.openshift.api.model.ClusterNetworkBuilder builder = new io.fabric8.openshift.api.model.ClusterNetworkBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromClusterNetworkObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ClusterNetworkObjectsNested<A> addNewClusterNetworkObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ClusterNetworkObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ClusterNetworkObjectsNested<A> addNewClusterNetworkObjectLike(io.fabric8.openshift.api.model.ClusterNetwork item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ClusterNetworkObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ClusterNetworkObjectsNested<A> setNewClusterNetworkObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.ClusterNetwork item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ClusterNetworkObjectsNestedImpl(index, item);
  }
  public A addToOAuthAuthorizeTokenObjects(java.lang.Integer index,io.fabric8.openshift.api.model.OAuthAuthorizeToken item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.OAuthAuthorizeTokenBuilder builder = new io.fabric8.openshift.api.model.OAuthAuthorizeTokenBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToOAuthAuthorizeTokenObjects(java.lang.Integer index,io.fabric8.openshift.api.model.OAuthAuthorizeToken item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.OAuthAuthorizeTokenBuilder builder = new io.fabric8.openshift.api.model.OAuthAuthorizeTokenBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToOAuthAuthorizeTokenObjects(io.fabric8.openshift.api.model.OAuthAuthorizeToken... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.OAuthAuthorizeToken item : items) {io.fabric8.openshift.api.model.OAuthAuthorizeTokenBuilder builder = new io.fabric8.openshift.api.model.OAuthAuthorizeTokenBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToOAuthAuthorizeTokenObjects(java.util.Collection<io.fabric8.openshift.api.model.OAuthAuthorizeToken> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.OAuthAuthorizeToken item : items) {io.fabric8.openshift.api.model.OAuthAuthorizeTokenBuilder builder = new io.fabric8.openshift.api.model.OAuthAuthorizeTokenBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromOAuthAuthorizeTokenObjects(io.fabric8.openshift.api.model.OAuthAuthorizeToken... items) {
    for (io.fabric8.openshift.api.model.OAuthAuthorizeToken item : items) {io.fabric8.openshift.api.model.OAuthAuthorizeTokenBuilder builder = new io.fabric8.openshift.api.model.OAuthAuthorizeTokenBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromOAuthAuthorizeTokenObjects(java.util.Collection<io.fabric8.openshift.api.model.OAuthAuthorizeToken> items) {
    for (io.fabric8.openshift.api.model.OAuthAuthorizeToken item : items) {io.fabric8.openshift.api.model.OAuthAuthorizeTokenBuilder builder = new io.fabric8.openshift.api.model.OAuthAuthorizeTokenBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromOAuthAuthorizeTokenObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.OAuthAuthorizeTokenObjectsNested<A> addNewOAuthAuthorizeTokenObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.OAuthAuthorizeTokenObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.OAuthAuthorizeTokenObjectsNested<A> addNewOAuthAuthorizeTokenObjectLike(io.fabric8.openshift.api.model.OAuthAuthorizeToken item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.OAuthAuthorizeTokenObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.OAuthAuthorizeTokenObjectsNested<A> setNewOAuthAuthorizeTokenObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.OAuthAuthorizeToken item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.OAuthAuthorizeTokenObjectsNestedImpl(index, item);
  }
  public A addToUserOAuthAccessTokenObjects(java.lang.Integer index,io.fabric8.openshift.api.model.UserOAuthAccessToken item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.UserOAuthAccessTokenBuilder builder = new io.fabric8.openshift.api.model.UserOAuthAccessTokenBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToUserOAuthAccessTokenObjects(java.lang.Integer index,io.fabric8.openshift.api.model.UserOAuthAccessToken item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.UserOAuthAccessTokenBuilder builder = new io.fabric8.openshift.api.model.UserOAuthAccessTokenBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToUserOAuthAccessTokenObjects(io.fabric8.openshift.api.model.UserOAuthAccessToken... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.UserOAuthAccessToken item : items) {io.fabric8.openshift.api.model.UserOAuthAccessTokenBuilder builder = new io.fabric8.openshift.api.model.UserOAuthAccessTokenBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToUserOAuthAccessTokenObjects(java.util.Collection<io.fabric8.openshift.api.model.UserOAuthAccessToken> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.UserOAuthAccessToken item : items) {io.fabric8.openshift.api.model.UserOAuthAccessTokenBuilder builder = new io.fabric8.openshift.api.model.UserOAuthAccessTokenBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromUserOAuthAccessTokenObjects(io.fabric8.openshift.api.model.UserOAuthAccessToken... items) {
    for (io.fabric8.openshift.api.model.UserOAuthAccessToken item : items) {io.fabric8.openshift.api.model.UserOAuthAccessTokenBuilder builder = new io.fabric8.openshift.api.model.UserOAuthAccessTokenBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromUserOAuthAccessTokenObjects(java.util.Collection<io.fabric8.openshift.api.model.UserOAuthAccessToken> items) {
    for (io.fabric8.openshift.api.model.UserOAuthAccessToken item : items) {io.fabric8.openshift.api.model.UserOAuthAccessTokenBuilder builder = new io.fabric8.openshift.api.model.UserOAuthAccessTokenBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromUserOAuthAccessTokenObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.UserOAuthAccessTokenObjectsNested<A> addNewUserOAuthAccessTokenObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.UserOAuthAccessTokenObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.UserOAuthAccessTokenObjectsNested<A> addNewUserOAuthAccessTokenObjectLike(io.fabric8.openshift.api.model.UserOAuthAccessToken item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.UserOAuthAccessTokenObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.UserOAuthAccessTokenObjectsNested<A> setNewUserOAuthAccessTokenObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.UserOAuthAccessToken item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.UserOAuthAccessTokenObjectsNestedImpl(index, item);
  }
  public A addToIngressObjects(java.lang.Integer index,io.fabric8.openshift.api.model.Ingress item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.IngressBuilder builder = new io.fabric8.openshift.api.model.IngressBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToIngressObjects(java.lang.Integer index,io.fabric8.openshift.api.model.Ingress item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.IngressBuilder builder = new io.fabric8.openshift.api.model.IngressBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToIngressObjects(io.fabric8.openshift.api.model.Ingress... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.Ingress item : items) {io.fabric8.openshift.api.model.IngressBuilder builder = new io.fabric8.openshift.api.model.IngressBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToIngressObjects(java.util.Collection<io.fabric8.openshift.api.model.Ingress> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.Ingress item : items) {io.fabric8.openshift.api.model.IngressBuilder builder = new io.fabric8.openshift.api.model.IngressBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromIngressObjects(io.fabric8.openshift.api.model.Ingress... items) {
    for (io.fabric8.openshift.api.model.Ingress item : items) {io.fabric8.openshift.api.model.IngressBuilder builder = new io.fabric8.openshift.api.model.IngressBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromIngressObjects(java.util.Collection<io.fabric8.openshift.api.model.Ingress> items) {
    for (io.fabric8.openshift.api.model.Ingress item : items) {io.fabric8.openshift.api.model.IngressBuilder builder = new io.fabric8.openshift.api.model.IngressBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromIngressObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.IngressObjectsNested<A> addNewIngressObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.IngressObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.IngressObjectsNested<A> addNewIngressObjectLike(io.fabric8.openshift.api.model.Ingress item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.IngressObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.IngressObjectsNested<A> setNewIngressObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.Ingress item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.IngressObjectsNestedImpl(index, item);
  }
  public A addToOAuthObjects(java.lang.Integer index,io.fabric8.openshift.api.model.OAuth item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.OAuthBuilder builder = new io.fabric8.openshift.api.model.OAuthBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToOAuthObjects(java.lang.Integer index,io.fabric8.openshift.api.model.OAuth item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.OAuthBuilder builder = new io.fabric8.openshift.api.model.OAuthBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToOAuthObjects(io.fabric8.openshift.api.model.OAuth... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.OAuth item : items) {io.fabric8.openshift.api.model.OAuthBuilder builder = new io.fabric8.openshift.api.model.OAuthBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToOAuthObjects(java.util.Collection<io.fabric8.openshift.api.model.OAuth> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.OAuth item : items) {io.fabric8.openshift.api.model.OAuthBuilder builder = new io.fabric8.openshift.api.model.OAuthBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromOAuthObjects(io.fabric8.openshift.api.model.OAuth... items) {
    for (io.fabric8.openshift.api.model.OAuth item : items) {io.fabric8.openshift.api.model.OAuthBuilder builder = new io.fabric8.openshift.api.model.OAuthBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromOAuthObjects(java.util.Collection<io.fabric8.openshift.api.model.OAuth> items) {
    for (io.fabric8.openshift.api.model.OAuth item : items) {io.fabric8.openshift.api.model.OAuthBuilder builder = new io.fabric8.openshift.api.model.OAuthBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromOAuthObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.OAuthObjectsNested<A> addNewOAuthObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.OAuthObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.OAuthObjectsNested<A> addNewOAuthObjectLike(io.fabric8.openshift.api.model.OAuth item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.OAuthObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.OAuthObjectsNested<A> setNewOAuthObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.OAuth item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.OAuthObjectsNestedImpl(index, item);
  }
  public A addToOperatorHubObjects(java.lang.Integer index,io.fabric8.openshift.api.model.OperatorHub item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.OperatorHubBuilder builder = new io.fabric8.openshift.api.model.OperatorHubBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToOperatorHubObjects(java.lang.Integer index,io.fabric8.openshift.api.model.OperatorHub item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.OperatorHubBuilder builder = new io.fabric8.openshift.api.model.OperatorHubBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToOperatorHubObjects(io.fabric8.openshift.api.model.OperatorHub... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.OperatorHub item : items) {io.fabric8.openshift.api.model.OperatorHubBuilder builder = new io.fabric8.openshift.api.model.OperatorHubBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToOperatorHubObjects(java.util.Collection<io.fabric8.openshift.api.model.OperatorHub> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.OperatorHub item : items) {io.fabric8.openshift.api.model.OperatorHubBuilder builder = new io.fabric8.openshift.api.model.OperatorHubBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromOperatorHubObjects(io.fabric8.openshift.api.model.OperatorHub... items) {
    for (io.fabric8.openshift.api.model.OperatorHub item : items) {io.fabric8.openshift.api.model.OperatorHubBuilder builder = new io.fabric8.openshift.api.model.OperatorHubBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromOperatorHubObjects(java.util.Collection<io.fabric8.openshift.api.model.OperatorHub> items) {
    for (io.fabric8.openshift.api.model.OperatorHub item : items) {io.fabric8.openshift.api.model.OperatorHubBuilder builder = new io.fabric8.openshift.api.model.OperatorHubBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromOperatorHubObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.OperatorHubObjectsNested<A> addNewOperatorHubObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.OperatorHubObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.OperatorHubObjectsNested<A> addNewOperatorHubObjectLike(io.fabric8.openshift.api.model.OperatorHub item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.OperatorHubObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.OperatorHubObjectsNested<A> setNewOperatorHubObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.OperatorHub item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.OperatorHubObjectsNestedImpl(index, item);
  }
  public A addToClusterRoleBindingObjects(java.lang.Integer index,io.fabric8.openshift.api.model.ClusterRoleBinding item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.ClusterRoleBindingBuilder builder = new io.fabric8.openshift.api.model.ClusterRoleBindingBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToClusterRoleBindingObjects(java.lang.Integer index,io.fabric8.openshift.api.model.ClusterRoleBinding item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.ClusterRoleBindingBuilder builder = new io.fabric8.openshift.api.model.ClusterRoleBindingBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToClusterRoleBindingObjects(io.fabric8.openshift.api.model.ClusterRoleBinding... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.ClusterRoleBinding item : items) {io.fabric8.openshift.api.model.ClusterRoleBindingBuilder builder = new io.fabric8.openshift.api.model.ClusterRoleBindingBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToClusterRoleBindingObjects(java.util.Collection<io.fabric8.openshift.api.model.ClusterRoleBinding> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.ClusterRoleBinding item : items) {io.fabric8.openshift.api.model.ClusterRoleBindingBuilder builder = new io.fabric8.openshift.api.model.ClusterRoleBindingBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromClusterRoleBindingObjects(io.fabric8.openshift.api.model.ClusterRoleBinding... items) {
    for (io.fabric8.openshift.api.model.ClusterRoleBinding item : items) {io.fabric8.openshift.api.model.ClusterRoleBindingBuilder builder = new io.fabric8.openshift.api.model.ClusterRoleBindingBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromClusterRoleBindingObjects(java.util.Collection<io.fabric8.openshift.api.model.ClusterRoleBinding> items) {
    for (io.fabric8.openshift.api.model.ClusterRoleBinding item : items) {io.fabric8.openshift.api.model.ClusterRoleBindingBuilder builder = new io.fabric8.openshift.api.model.ClusterRoleBindingBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromClusterRoleBindingObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ClusterRoleBindingObjectsNested<A> addNewClusterRoleBindingObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ClusterRoleBindingObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ClusterRoleBindingObjectsNested<A> addNewClusterRoleBindingObjectLike(io.fabric8.openshift.api.model.ClusterRoleBinding item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ClusterRoleBindingObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ClusterRoleBindingObjectsNested<A> setNewClusterRoleBindingObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.ClusterRoleBinding item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ClusterRoleBindingObjectsNestedImpl(index, item);
  }
  public A addToClusterResourceQuotaObjects(java.lang.Integer index,io.fabric8.openshift.api.model.ClusterResourceQuota item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.ClusterResourceQuotaBuilder builder = new io.fabric8.openshift.api.model.ClusterResourceQuotaBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToClusterResourceQuotaObjects(java.lang.Integer index,io.fabric8.openshift.api.model.ClusterResourceQuota item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.ClusterResourceQuotaBuilder builder = new io.fabric8.openshift.api.model.ClusterResourceQuotaBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToClusterResourceQuotaObjects(io.fabric8.openshift.api.model.ClusterResourceQuota... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.ClusterResourceQuota item : items) {io.fabric8.openshift.api.model.ClusterResourceQuotaBuilder builder = new io.fabric8.openshift.api.model.ClusterResourceQuotaBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToClusterResourceQuotaObjects(java.util.Collection<io.fabric8.openshift.api.model.ClusterResourceQuota> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.ClusterResourceQuota item : items) {io.fabric8.openshift.api.model.ClusterResourceQuotaBuilder builder = new io.fabric8.openshift.api.model.ClusterResourceQuotaBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromClusterResourceQuotaObjects(io.fabric8.openshift.api.model.ClusterResourceQuota... items) {
    for (io.fabric8.openshift.api.model.ClusterResourceQuota item : items) {io.fabric8.openshift.api.model.ClusterResourceQuotaBuilder builder = new io.fabric8.openshift.api.model.ClusterResourceQuotaBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromClusterResourceQuotaObjects(java.util.Collection<io.fabric8.openshift.api.model.ClusterResourceQuota> items) {
    for (io.fabric8.openshift.api.model.ClusterResourceQuota item : items) {io.fabric8.openshift.api.model.ClusterResourceQuotaBuilder builder = new io.fabric8.openshift.api.model.ClusterResourceQuotaBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromClusterResourceQuotaObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ClusterResourceQuotaObjectsNested<A> addNewClusterResourceQuotaObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ClusterResourceQuotaObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ClusterResourceQuotaObjectsNested<A> addNewClusterResourceQuotaObjectLike(io.fabric8.openshift.api.model.ClusterResourceQuota item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ClusterResourceQuotaObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ClusterResourceQuotaObjectsNested<A> setNewClusterResourceQuotaObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.ClusterResourceQuota item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ClusterResourceQuotaObjectsNestedImpl(index, item);
  }
  public A addToProjectRequestObjects(java.lang.Integer index,io.fabric8.openshift.api.model.ProjectRequest item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.ProjectRequestBuilder builder = new io.fabric8.openshift.api.model.ProjectRequestBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToProjectRequestObjects(java.lang.Integer index,io.fabric8.openshift.api.model.ProjectRequest item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.ProjectRequestBuilder builder = new io.fabric8.openshift.api.model.ProjectRequestBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToProjectRequestObjects(io.fabric8.openshift.api.model.ProjectRequest... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.ProjectRequest item : items) {io.fabric8.openshift.api.model.ProjectRequestBuilder builder = new io.fabric8.openshift.api.model.ProjectRequestBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToProjectRequestObjects(java.util.Collection<io.fabric8.openshift.api.model.ProjectRequest> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.ProjectRequest item : items) {io.fabric8.openshift.api.model.ProjectRequestBuilder builder = new io.fabric8.openshift.api.model.ProjectRequestBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromProjectRequestObjects(io.fabric8.openshift.api.model.ProjectRequest... items) {
    for (io.fabric8.openshift.api.model.ProjectRequest item : items) {io.fabric8.openshift.api.model.ProjectRequestBuilder builder = new io.fabric8.openshift.api.model.ProjectRequestBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromProjectRequestObjects(java.util.Collection<io.fabric8.openshift.api.model.ProjectRequest> items) {
    for (io.fabric8.openshift.api.model.ProjectRequest item : items) {io.fabric8.openshift.api.model.ProjectRequestBuilder builder = new io.fabric8.openshift.api.model.ProjectRequestBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromProjectRequestObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ProjectRequestObjectsNested<A> addNewProjectRequestObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ProjectRequestObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ProjectRequestObjectsNested<A> addNewProjectRequestObjectLike(io.fabric8.openshift.api.model.ProjectRequest item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ProjectRequestObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ProjectRequestObjectsNested<A> setNewProjectRequestObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.ProjectRequest item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ProjectRequestObjectsNestedImpl(index, item);
  }
  public A addToTemplateObjects(java.lang.Integer index,io.fabric8.openshift.api.model.Template item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.TemplateBuilder builder = new io.fabric8.openshift.api.model.TemplateBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToTemplateObjects(java.lang.Integer index,io.fabric8.openshift.api.model.Template item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.TemplateBuilder builder = new io.fabric8.openshift.api.model.TemplateBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToTemplateObjects(io.fabric8.openshift.api.model.Template... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.Template item : items) {io.fabric8.openshift.api.model.TemplateBuilder builder = new io.fabric8.openshift.api.model.TemplateBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToTemplateObjects(java.util.Collection<io.fabric8.openshift.api.model.Template> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.Template item : items) {io.fabric8.openshift.api.model.TemplateBuilder builder = new io.fabric8.openshift.api.model.TemplateBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromTemplateObjects(io.fabric8.openshift.api.model.Template... items) {
    for (io.fabric8.openshift.api.model.Template item : items) {io.fabric8.openshift.api.model.TemplateBuilder builder = new io.fabric8.openshift.api.model.TemplateBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromTemplateObjects(java.util.Collection<io.fabric8.openshift.api.model.Template> items) {
    for (io.fabric8.openshift.api.model.Template item : items) {io.fabric8.openshift.api.model.TemplateBuilder builder = new io.fabric8.openshift.api.model.TemplateBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromTemplateObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.TemplateObjectsNested<A> addNewTemplateObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.TemplateObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.TemplateObjectsNested<A> addNewTemplateObjectLike(io.fabric8.openshift.api.model.Template item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.TemplateObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.TemplateObjectsNested<A> setNewTemplateObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.Template item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.TemplateObjectsNestedImpl(index, item);
  }
  public A addToOAuthClientAuthorizationObjects(java.lang.Integer index,io.fabric8.openshift.api.model.OAuthClientAuthorization item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.OAuthClientAuthorizationBuilder builder = new io.fabric8.openshift.api.model.OAuthClientAuthorizationBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToOAuthClientAuthorizationObjects(java.lang.Integer index,io.fabric8.openshift.api.model.OAuthClientAuthorization item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.OAuthClientAuthorizationBuilder builder = new io.fabric8.openshift.api.model.OAuthClientAuthorizationBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToOAuthClientAuthorizationObjects(io.fabric8.openshift.api.model.OAuthClientAuthorization... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.OAuthClientAuthorization item : items) {io.fabric8.openshift.api.model.OAuthClientAuthorizationBuilder builder = new io.fabric8.openshift.api.model.OAuthClientAuthorizationBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToOAuthClientAuthorizationObjects(java.util.Collection<io.fabric8.openshift.api.model.OAuthClientAuthorization> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.OAuthClientAuthorization item : items) {io.fabric8.openshift.api.model.OAuthClientAuthorizationBuilder builder = new io.fabric8.openshift.api.model.OAuthClientAuthorizationBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromOAuthClientAuthorizationObjects(io.fabric8.openshift.api.model.OAuthClientAuthorization... items) {
    for (io.fabric8.openshift.api.model.OAuthClientAuthorization item : items) {io.fabric8.openshift.api.model.OAuthClientAuthorizationBuilder builder = new io.fabric8.openshift.api.model.OAuthClientAuthorizationBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromOAuthClientAuthorizationObjects(java.util.Collection<io.fabric8.openshift.api.model.OAuthClientAuthorization> items) {
    for (io.fabric8.openshift.api.model.OAuthClientAuthorization item : items) {io.fabric8.openshift.api.model.OAuthClientAuthorizationBuilder builder = new io.fabric8.openshift.api.model.OAuthClientAuthorizationBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromOAuthClientAuthorizationObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.OAuthClientAuthorizationObjectsNested<A> addNewOAuthClientAuthorizationObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.OAuthClientAuthorizationObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.OAuthClientAuthorizationObjectsNested<A> addNewOAuthClientAuthorizationObjectLike(io.fabric8.openshift.api.model.OAuthClientAuthorization item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.OAuthClientAuthorizationObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.OAuthClientAuthorizationObjectsNested<A> setNewOAuthClientAuthorizationObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.OAuthClientAuthorization item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.OAuthClientAuthorizationObjectsNestedImpl(index, item);
  }
  public A addToClusterRoleObjects(java.lang.Integer index,io.fabric8.openshift.api.model.ClusterRole item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.ClusterRoleBuilder builder = new io.fabric8.openshift.api.model.ClusterRoleBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToClusterRoleObjects(java.lang.Integer index,io.fabric8.openshift.api.model.ClusterRole item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.ClusterRoleBuilder builder = new io.fabric8.openshift.api.model.ClusterRoleBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToClusterRoleObjects(io.fabric8.openshift.api.model.ClusterRole... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.ClusterRole item : items) {io.fabric8.openshift.api.model.ClusterRoleBuilder builder = new io.fabric8.openshift.api.model.ClusterRoleBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToClusterRoleObjects(java.util.Collection<io.fabric8.openshift.api.model.ClusterRole> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.ClusterRole item : items) {io.fabric8.openshift.api.model.ClusterRoleBuilder builder = new io.fabric8.openshift.api.model.ClusterRoleBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromClusterRoleObjects(io.fabric8.openshift.api.model.ClusterRole... items) {
    for (io.fabric8.openshift.api.model.ClusterRole item : items) {io.fabric8.openshift.api.model.ClusterRoleBuilder builder = new io.fabric8.openshift.api.model.ClusterRoleBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromClusterRoleObjects(java.util.Collection<io.fabric8.openshift.api.model.ClusterRole> items) {
    for (io.fabric8.openshift.api.model.ClusterRole item : items) {io.fabric8.openshift.api.model.ClusterRoleBuilder builder = new io.fabric8.openshift.api.model.ClusterRoleBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromClusterRoleObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ClusterRoleObjectsNested<A> addNewClusterRoleObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ClusterRoleObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ClusterRoleObjectsNested<A> addNewClusterRoleObjectLike(io.fabric8.openshift.api.model.ClusterRole item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ClusterRoleObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ClusterRoleObjectsNested<A> setNewClusterRoleObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.ClusterRole item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ClusterRoleObjectsNestedImpl(index, item);
  }
  public A addToAuthenticationObjects(java.lang.Integer index,io.fabric8.openshift.api.model.Authentication item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.AuthenticationBuilder builder = new io.fabric8.openshift.api.model.AuthenticationBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToAuthenticationObjects(java.lang.Integer index,io.fabric8.openshift.api.model.Authentication item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.AuthenticationBuilder builder = new io.fabric8.openshift.api.model.AuthenticationBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToAuthenticationObjects(io.fabric8.openshift.api.model.Authentication... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.Authentication item : items) {io.fabric8.openshift.api.model.AuthenticationBuilder builder = new io.fabric8.openshift.api.model.AuthenticationBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToAuthenticationObjects(java.util.Collection<io.fabric8.openshift.api.model.Authentication> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.Authentication item : items) {io.fabric8.openshift.api.model.AuthenticationBuilder builder = new io.fabric8.openshift.api.model.AuthenticationBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromAuthenticationObjects(io.fabric8.openshift.api.model.Authentication... items) {
    for (io.fabric8.openshift.api.model.Authentication item : items) {io.fabric8.openshift.api.model.AuthenticationBuilder builder = new io.fabric8.openshift.api.model.AuthenticationBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromAuthenticationObjects(java.util.Collection<io.fabric8.openshift.api.model.Authentication> items) {
    for (io.fabric8.openshift.api.model.Authentication item : items) {io.fabric8.openshift.api.model.AuthenticationBuilder builder = new io.fabric8.openshift.api.model.AuthenticationBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromAuthenticationObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.AuthenticationObjectsNested<A> addNewAuthenticationObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.AuthenticationObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.AuthenticationObjectsNested<A> addNewAuthenticationObjectLike(io.fabric8.openshift.api.model.Authentication item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.AuthenticationObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.AuthenticationObjectsNested<A> setNewAuthenticationObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.Authentication item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.AuthenticationObjectsNestedImpl(index, item);
  }
  public A addToImageTagObjects(java.lang.Integer index,io.fabric8.openshift.api.model.ImageTag item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.ImageTagBuilder builder = new io.fabric8.openshift.api.model.ImageTagBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToImageTagObjects(java.lang.Integer index,io.fabric8.openshift.api.model.ImageTag item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.ImageTagBuilder builder = new io.fabric8.openshift.api.model.ImageTagBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToImageTagObjects(io.fabric8.openshift.api.model.ImageTag... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.ImageTag item : items) {io.fabric8.openshift.api.model.ImageTagBuilder builder = new io.fabric8.openshift.api.model.ImageTagBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToImageTagObjects(java.util.Collection<io.fabric8.openshift.api.model.ImageTag> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.ImageTag item : items) {io.fabric8.openshift.api.model.ImageTagBuilder builder = new io.fabric8.openshift.api.model.ImageTagBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromImageTagObjects(io.fabric8.openshift.api.model.ImageTag... items) {
    for (io.fabric8.openshift.api.model.ImageTag item : items) {io.fabric8.openshift.api.model.ImageTagBuilder builder = new io.fabric8.openshift.api.model.ImageTagBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromImageTagObjects(java.util.Collection<io.fabric8.openshift.api.model.ImageTag> items) {
    for (io.fabric8.openshift.api.model.ImageTag item : items) {io.fabric8.openshift.api.model.ImageTagBuilder builder = new io.fabric8.openshift.api.model.ImageTagBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromImageTagObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ImageTagObjectsNested<A> addNewImageTagObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ImageTagObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ImageTagObjectsNested<A> addNewImageTagObjectLike(io.fabric8.openshift.api.model.ImageTag item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ImageTagObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ImageTagObjectsNested<A> setNewImageTagObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.ImageTag item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ImageTagObjectsNestedImpl(index, item);
  }
  public A addToOAuthAccessTokenObjects(java.lang.Integer index,io.fabric8.openshift.api.model.OAuthAccessToken item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.OAuthAccessTokenBuilder builder = new io.fabric8.openshift.api.model.OAuthAccessTokenBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToOAuthAccessTokenObjects(java.lang.Integer index,io.fabric8.openshift.api.model.OAuthAccessToken item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.OAuthAccessTokenBuilder builder = new io.fabric8.openshift.api.model.OAuthAccessTokenBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToOAuthAccessTokenObjects(io.fabric8.openshift.api.model.OAuthAccessToken... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.OAuthAccessToken item : items) {io.fabric8.openshift.api.model.OAuthAccessTokenBuilder builder = new io.fabric8.openshift.api.model.OAuthAccessTokenBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToOAuthAccessTokenObjects(java.util.Collection<io.fabric8.openshift.api.model.OAuthAccessToken> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.OAuthAccessToken item : items) {io.fabric8.openshift.api.model.OAuthAccessTokenBuilder builder = new io.fabric8.openshift.api.model.OAuthAccessTokenBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromOAuthAccessTokenObjects(io.fabric8.openshift.api.model.OAuthAccessToken... items) {
    for (io.fabric8.openshift.api.model.OAuthAccessToken item : items) {io.fabric8.openshift.api.model.OAuthAccessTokenBuilder builder = new io.fabric8.openshift.api.model.OAuthAccessTokenBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromOAuthAccessTokenObjects(java.util.Collection<io.fabric8.openshift.api.model.OAuthAccessToken> items) {
    for (io.fabric8.openshift.api.model.OAuthAccessToken item : items) {io.fabric8.openshift.api.model.OAuthAccessTokenBuilder builder = new io.fabric8.openshift.api.model.OAuthAccessTokenBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromOAuthAccessTokenObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.OAuthAccessTokenObjectsNested<A> addNewOAuthAccessTokenObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.OAuthAccessTokenObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.OAuthAccessTokenObjectsNested<A> addNewOAuthAccessTokenObjectLike(io.fabric8.openshift.api.model.OAuthAccessToken item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.OAuthAccessTokenObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.OAuthAccessTokenObjectsNested<A> setNewOAuthAccessTokenObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.OAuthAccessToken item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.OAuthAccessTokenObjectsNestedImpl(index, item);
  }
  public A addToDeploymentConfigObjects(java.lang.Integer index,io.fabric8.openshift.api.model.DeploymentConfig item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.DeploymentConfigBuilder builder = new io.fabric8.openshift.api.model.DeploymentConfigBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToDeploymentConfigObjects(java.lang.Integer index,io.fabric8.openshift.api.model.DeploymentConfig item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.DeploymentConfigBuilder builder = new io.fabric8.openshift.api.model.DeploymentConfigBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToDeploymentConfigObjects(io.fabric8.openshift.api.model.DeploymentConfig... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.DeploymentConfig item : items) {io.fabric8.openshift.api.model.DeploymentConfigBuilder builder = new io.fabric8.openshift.api.model.DeploymentConfigBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToDeploymentConfigObjects(java.util.Collection<io.fabric8.openshift.api.model.DeploymentConfig> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.DeploymentConfig item : items) {io.fabric8.openshift.api.model.DeploymentConfigBuilder builder = new io.fabric8.openshift.api.model.DeploymentConfigBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromDeploymentConfigObjects(io.fabric8.openshift.api.model.DeploymentConfig... items) {
    for (io.fabric8.openshift.api.model.DeploymentConfig item : items) {io.fabric8.openshift.api.model.DeploymentConfigBuilder builder = new io.fabric8.openshift.api.model.DeploymentConfigBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromDeploymentConfigObjects(java.util.Collection<io.fabric8.openshift.api.model.DeploymentConfig> items) {
    for (io.fabric8.openshift.api.model.DeploymentConfig item : items) {io.fabric8.openshift.api.model.DeploymentConfigBuilder builder = new io.fabric8.openshift.api.model.DeploymentConfigBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromDeploymentConfigObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.DeploymentConfigObjectsNested<A> addNewDeploymentConfigObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.DeploymentConfigObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.DeploymentConfigObjectsNested<A> addNewDeploymentConfigObjectLike(io.fabric8.openshift.api.model.DeploymentConfig item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.DeploymentConfigObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.DeploymentConfigObjectsNested<A> setNewDeploymentConfigObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.DeploymentConfig item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.DeploymentConfigObjectsNestedImpl(index, item);
  }
  public A addToRoleBindingObjects(java.lang.Integer index,io.fabric8.openshift.api.model.RoleBinding item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.RoleBindingBuilder builder = new io.fabric8.openshift.api.model.RoleBindingBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToRoleBindingObjects(java.lang.Integer index,io.fabric8.openshift.api.model.RoleBinding item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.RoleBindingBuilder builder = new io.fabric8.openshift.api.model.RoleBindingBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToRoleBindingObjects(io.fabric8.openshift.api.model.RoleBinding... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.RoleBinding item : items) {io.fabric8.openshift.api.model.RoleBindingBuilder builder = new io.fabric8.openshift.api.model.RoleBindingBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToRoleBindingObjects(java.util.Collection<io.fabric8.openshift.api.model.RoleBinding> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.RoleBinding item : items) {io.fabric8.openshift.api.model.RoleBindingBuilder builder = new io.fabric8.openshift.api.model.RoleBindingBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromRoleBindingObjects(io.fabric8.openshift.api.model.RoleBinding... items) {
    for (io.fabric8.openshift.api.model.RoleBinding item : items) {io.fabric8.openshift.api.model.RoleBindingBuilder builder = new io.fabric8.openshift.api.model.RoleBindingBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromRoleBindingObjects(java.util.Collection<io.fabric8.openshift.api.model.RoleBinding> items) {
    for (io.fabric8.openshift.api.model.RoleBinding item : items) {io.fabric8.openshift.api.model.RoleBindingBuilder builder = new io.fabric8.openshift.api.model.RoleBindingBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromRoleBindingObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.RoleBindingObjectsNested<A> addNewRoleBindingObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.RoleBindingObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.RoleBindingObjectsNested<A> addNewRoleBindingObjectLike(io.fabric8.openshift.api.model.RoleBinding item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.RoleBindingObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.RoleBindingObjectsNested<A> setNewRoleBindingObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.RoleBinding item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.RoleBindingObjectsNestedImpl(index, item);
  }
  public A addToImageObjects(java.lang.Integer index,io.fabric8.openshift.api.model.Image item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.ImageBuilder builder = new io.fabric8.openshift.api.model.ImageBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToImageObjects(java.lang.Integer index,io.fabric8.openshift.api.model.Image item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.ImageBuilder builder = new io.fabric8.openshift.api.model.ImageBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToImageObjects(io.fabric8.openshift.api.model.Image... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.Image item : items) {io.fabric8.openshift.api.model.ImageBuilder builder = new io.fabric8.openshift.api.model.ImageBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToImageObjects(java.util.Collection<io.fabric8.openshift.api.model.Image> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.Image item : items) {io.fabric8.openshift.api.model.ImageBuilder builder = new io.fabric8.openshift.api.model.ImageBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromImageObjects(io.fabric8.openshift.api.model.Image... items) {
    for (io.fabric8.openshift.api.model.Image item : items) {io.fabric8.openshift.api.model.ImageBuilder builder = new io.fabric8.openshift.api.model.ImageBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromImageObjects(java.util.Collection<io.fabric8.openshift.api.model.Image> items) {
    for (io.fabric8.openshift.api.model.Image item : items) {io.fabric8.openshift.api.model.ImageBuilder builder = new io.fabric8.openshift.api.model.ImageBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromImageObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ImageObjectsNested<A> addNewImageObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ImageObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ImageObjectsNested<A> addNewImageObjectLike(io.fabric8.openshift.api.model.Image item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ImageObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ImageObjectsNested<A> setNewImageObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.Image item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ImageObjectsNestedImpl(index, item);
  }
  public A addToAPIServerObjects(java.lang.Integer index,io.fabric8.openshift.api.model.APIServer item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.APIServerBuilder builder = new io.fabric8.openshift.api.model.APIServerBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToAPIServerObjects(java.lang.Integer index,io.fabric8.openshift.api.model.APIServer item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.APIServerBuilder builder = new io.fabric8.openshift.api.model.APIServerBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToAPIServerObjects(io.fabric8.openshift.api.model.APIServer... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.APIServer item : items) {io.fabric8.openshift.api.model.APIServerBuilder builder = new io.fabric8.openshift.api.model.APIServerBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToAPIServerObjects(java.util.Collection<io.fabric8.openshift.api.model.APIServer> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.APIServer item : items) {io.fabric8.openshift.api.model.APIServerBuilder builder = new io.fabric8.openshift.api.model.APIServerBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromAPIServerObjects(io.fabric8.openshift.api.model.APIServer... items) {
    for (io.fabric8.openshift.api.model.APIServer item : items) {io.fabric8.openshift.api.model.APIServerBuilder builder = new io.fabric8.openshift.api.model.APIServerBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromAPIServerObjects(java.util.Collection<io.fabric8.openshift.api.model.APIServer> items) {
    for (io.fabric8.openshift.api.model.APIServer item : items) {io.fabric8.openshift.api.model.APIServerBuilder builder = new io.fabric8.openshift.api.model.APIServerBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromAPIServerObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.APIServerObjectsNested<A> addNewAPIServerObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.APIServerObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.APIServerObjectsNested<A> addNewAPIServerObjectLike(io.fabric8.openshift.api.model.APIServer item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.APIServerObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.APIServerObjectsNested<A> setNewAPIServerObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.APIServer item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.APIServerObjectsNestedImpl(index, item);
  }
  public A addToPersistentVolumeClaimObjects(java.lang.Integer index,io.fabric8.kubernetes.api.model.PersistentVolumeClaim item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToPersistentVolumeClaimObjects(java.lang.Integer index,io.fabric8.kubernetes.api.model.PersistentVolumeClaim item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToPersistentVolumeClaimObjects(io.fabric8.kubernetes.api.model.PersistentVolumeClaim... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.kubernetes.api.model.PersistentVolumeClaim item : items) {io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToPersistentVolumeClaimObjects(java.util.Collection<io.fabric8.kubernetes.api.model.PersistentVolumeClaim> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.kubernetes.api.model.PersistentVolumeClaim item : items) {io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromPersistentVolumeClaimObjects(io.fabric8.kubernetes.api.model.PersistentVolumeClaim... items) {
    for (io.fabric8.kubernetes.api.model.PersistentVolumeClaim item : items) {io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromPersistentVolumeClaimObjects(java.util.Collection<io.fabric8.kubernetes.api.model.PersistentVolumeClaim> items) {
    for (io.fabric8.kubernetes.api.model.PersistentVolumeClaim item : items) {io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromPersistentVolumeClaimObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.PersistentVolumeClaimObjectsNested<A> addNewPersistentVolumeClaimObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.PersistentVolumeClaimObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.PersistentVolumeClaimObjectsNested<A> addNewPersistentVolumeClaimObjectLike(io.fabric8.kubernetes.api.model.PersistentVolumeClaim item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.PersistentVolumeClaimObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.PersistentVolumeClaimObjectsNested<A> setNewPersistentVolumeClaimObjectLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.PersistentVolumeClaim item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.PersistentVolumeClaimObjectsNestedImpl(index, item);
  }
  public A addToImageStreamMappingObjects(java.lang.Integer index,io.fabric8.openshift.api.model.ImageStreamMapping item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.ImageStreamMappingBuilder builder = new io.fabric8.openshift.api.model.ImageStreamMappingBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToImageStreamMappingObjects(java.lang.Integer index,io.fabric8.openshift.api.model.ImageStreamMapping item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.ImageStreamMappingBuilder builder = new io.fabric8.openshift.api.model.ImageStreamMappingBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToImageStreamMappingObjects(io.fabric8.openshift.api.model.ImageStreamMapping... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.ImageStreamMapping item : items) {io.fabric8.openshift.api.model.ImageStreamMappingBuilder builder = new io.fabric8.openshift.api.model.ImageStreamMappingBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToImageStreamMappingObjects(java.util.Collection<io.fabric8.openshift.api.model.ImageStreamMapping> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.ImageStreamMapping item : items) {io.fabric8.openshift.api.model.ImageStreamMappingBuilder builder = new io.fabric8.openshift.api.model.ImageStreamMappingBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromImageStreamMappingObjects(io.fabric8.openshift.api.model.ImageStreamMapping... items) {
    for (io.fabric8.openshift.api.model.ImageStreamMapping item : items) {io.fabric8.openshift.api.model.ImageStreamMappingBuilder builder = new io.fabric8.openshift.api.model.ImageStreamMappingBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromImageStreamMappingObjects(java.util.Collection<io.fabric8.openshift.api.model.ImageStreamMapping> items) {
    for (io.fabric8.openshift.api.model.ImageStreamMapping item : items) {io.fabric8.openshift.api.model.ImageStreamMappingBuilder builder = new io.fabric8.openshift.api.model.ImageStreamMappingBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromImageStreamMappingObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ImageStreamMappingObjectsNested<A> addNewImageStreamMappingObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ImageStreamMappingObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ImageStreamMappingObjectsNested<A> addNewImageStreamMappingObjectLike(io.fabric8.openshift.api.model.ImageStreamMapping item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ImageStreamMappingObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ImageStreamMappingObjectsNested<A> setNewImageStreamMappingObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.ImageStreamMapping item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ImageStreamMappingObjectsNestedImpl(index, item);
  }
  public A addToRoleObjects(java.lang.Integer index,io.fabric8.openshift.api.model.Role item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.RoleBuilder builder = new io.fabric8.openshift.api.model.RoleBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToRoleObjects(java.lang.Integer index,io.fabric8.openshift.api.model.Role item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.RoleBuilder builder = new io.fabric8.openshift.api.model.RoleBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToRoleObjects(io.fabric8.openshift.api.model.Role... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.Role item : items) {io.fabric8.openshift.api.model.RoleBuilder builder = new io.fabric8.openshift.api.model.RoleBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToRoleObjects(java.util.Collection<io.fabric8.openshift.api.model.Role> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.Role item : items) {io.fabric8.openshift.api.model.RoleBuilder builder = new io.fabric8.openshift.api.model.RoleBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromRoleObjects(io.fabric8.openshift.api.model.Role... items) {
    for (io.fabric8.openshift.api.model.Role item : items) {io.fabric8.openshift.api.model.RoleBuilder builder = new io.fabric8.openshift.api.model.RoleBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromRoleObjects(java.util.Collection<io.fabric8.openshift.api.model.Role> items) {
    for (io.fabric8.openshift.api.model.Role item : items) {io.fabric8.openshift.api.model.RoleBuilder builder = new io.fabric8.openshift.api.model.RoleBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromRoleObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.RoleObjectsNested<A> addNewRoleObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.RoleObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.RoleObjectsNested<A> addNewRoleObjectLike(io.fabric8.openshift.api.model.Role item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.RoleObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.RoleObjectsNested<A> setNewRoleObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.Role item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.RoleObjectsNestedImpl(index, item);
  }
  public A addToBrokerTemplateInstanceObjects(java.lang.Integer index,io.fabric8.openshift.api.model.BrokerTemplateInstance item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.BrokerTemplateInstanceBuilder builder = new io.fabric8.openshift.api.model.BrokerTemplateInstanceBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToBrokerTemplateInstanceObjects(java.lang.Integer index,io.fabric8.openshift.api.model.BrokerTemplateInstance item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.BrokerTemplateInstanceBuilder builder = new io.fabric8.openshift.api.model.BrokerTemplateInstanceBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToBrokerTemplateInstanceObjects(io.fabric8.openshift.api.model.BrokerTemplateInstance... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.BrokerTemplateInstance item : items) {io.fabric8.openshift.api.model.BrokerTemplateInstanceBuilder builder = new io.fabric8.openshift.api.model.BrokerTemplateInstanceBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToBrokerTemplateInstanceObjects(java.util.Collection<io.fabric8.openshift.api.model.BrokerTemplateInstance> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.BrokerTemplateInstance item : items) {io.fabric8.openshift.api.model.BrokerTemplateInstanceBuilder builder = new io.fabric8.openshift.api.model.BrokerTemplateInstanceBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromBrokerTemplateInstanceObjects(io.fabric8.openshift.api.model.BrokerTemplateInstance... items) {
    for (io.fabric8.openshift.api.model.BrokerTemplateInstance item : items) {io.fabric8.openshift.api.model.BrokerTemplateInstanceBuilder builder = new io.fabric8.openshift.api.model.BrokerTemplateInstanceBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromBrokerTemplateInstanceObjects(java.util.Collection<io.fabric8.openshift.api.model.BrokerTemplateInstance> items) {
    for (io.fabric8.openshift.api.model.BrokerTemplateInstance item : items) {io.fabric8.openshift.api.model.BrokerTemplateInstanceBuilder builder = new io.fabric8.openshift.api.model.BrokerTemplateInstanceBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromBrokerTemplateInstanceObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.BrokerTemplateInstanceObjectsNested<A> addNewBrokerTemplateInstanceObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.BrokerTemplateInstanceObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.BrokerTemplateInstanceObjectsNested<A> addNewBrokerTemplateInstanceObjectLike(io.fabric8.openshift.api.model.BrokerTemplateInstance item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.BrokerTemplateInstanceObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.BrokerTemplateInstanceObjectsNested<A> setNewBrokerTemplateInstanceObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.BrokerTemplateInstance item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.BrokerTemplateInstanceObjectsNestedImpl(index, item);
  }
  public A addToFeatureGateObjects(java.lang.Integer index,io.fabric8.openshift.api.model.FeatureGate item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.FeatureGateBuilder builder = new io.fabric8.openshift.api.model.FeatureGateBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToFeatureGateObjects(java.lang.Integer index,io.fabric8.openshift.api.model.FeatureGate item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.FeatureGateBuilder builder = new io.fabric8.openshift.api.model.FeatureGateBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToFeatureGateObjects(io.fabric8.openshift.api.model.FeatureGate... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.FeatureGate item : items) {io.fabric8.openshift.api.model.FeatureGateBuilder builder = new io.fabric8.openshift.api.model.FeatureGateBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToFeatureGateObjects(java.util.Collection<io.fabric8.openshift.api.model.FeatureGate> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.FeatureGate item : items) {io.fabric8.openshift.api.model.FeatureGateBuilder builder = new io.fabric8.openshift.api.model.FeatureGateBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromFeatureGateObjects(io.fabric8.openshift.api.model.FeatureGate... items) {
    for (io.fabric8.openshift.api.model.FeatureGate item : items) {io.fabric8.openshift.api.model.FeatureGateBuilder builder = new io.fabric8.openshift.api.model.FeatureGateBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromFeatureGateObjects(java.util.Collection<io.fabric8.openshift.api.model.FeatureGate> items) {
    for (io.fabric8.openshift.api.model.FeatureGate item : items) {io.fabric8.openshift.api.model.FeatureGateBuilder builder = new io.fabric8.openshift.api.model.FeatureGateBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromFeatureGateObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.FeatureGateObjectsNested<A> addNewFeatureGateObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.FeatureGateObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.FeatureGateObjectsNested<A> addNewFeatureGateObjectLike(io.fabric8.openshift.api.model.FeatureGate item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.FeatureGateObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.FeatureGateObjectsNested<A> setNewFeatureGateObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.FeatureGate item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.FeatureGateObjectsNestedImpl(index, item);
  }
  public A addToUserObjects(java.lang.Integer index,io.fabric8.openshift.api.model.User item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.UserBuilder builder = new io.fabric8.openshift.api.model.UserBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToUserObjects(java.lang.Integer index,io.fabric8.openshift.api.model.User item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.UserBuilder builder = new io.fabric8.openshift.api.model.UserBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToUserObjects(io.fabric8.openshift.api.model.User... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.User item : items) {io.fabric8.openshift.api.model.UserBuilder builder = new io.fabric8.openshift.api.model.UserBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToUserObjects(java.util.Collection<io.fabric8.openshift.api.model.User> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.User item : items) {io.fabric8.openshift.api.model.UserBuilder builder = new io.fabric8.openshift.api.model.UserBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromUserObjects(io.fabric8.openshift.api.model.User... items) {
    for (io.fabric8.openshift.api.model.User item : items) {io.fabric8.openshift.api.model.UserBuilder builder = new io.fabric8.openshift.api.model.UserBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromUserObjects(java.util.Collection<io.fabric8.openshift.api.model.User> items) {
    for (io.fabric8.openshift.api.model.User item : items) {io.fabric8.openshift.api.model.UserBuilder builder = new io.fabric8.openshift.api.model.UserBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromUserObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.UserObjectsNested<A> addNewUserObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.UserObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.UserObjectsNested<A> addNewUserObjectLike(io.fabric8.openshift.api.model.User item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.UserObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.UserObjectsNested<A> setNewUserObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.User item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.UserObjectsNestedImpl(index, item);
  }
  public A addToImageStreamImageObjects(java.lang.Integer index,io.fabric8.openshift.api.model.ImageStreamImage item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.ImageStreamImageBuilder builder = new io.fabric8.openshift.api.model.ImageStreamImageBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToImageStreamImageObjects(java.lang.Integer index,io.fabric8.openshift.api.model.ImageStreamImage item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.ImageStreamImageBuilder builder = new io.fabric8.openshift.api.model.ImageStreamImageBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToImageStreamImageObjects(io.fabric8.openshift.api.model.ImageStreamImage... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.ImageStreamImage item : items) {io.fabric8.openshift.api.model.ImageStreamImageBuilder builder = new io.fabric8.openshift.api.model.ImageStreamImageBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToImageStreamImageObjects(java.util.Collection<io.fabric8.openshift.api.model.ImageStreamImage> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.ImageStreamImage item : items) {io.fabric8.openshift.api.model.ImageStreamImageBuilder builder = new io.fabric8.openshift.api.model.ImageStreamImageBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromImageStreamImageObjects(io.fabric8.openshift.api.model.ImageStreamImage... items) {
    for (io.fabric8.openshift.api.model.ImageStreamImage item : items) {io.fabric8.openshift.api.model.ImageStreamImageBuilder builder = new io.fabric8.openshift.api.model.ImageStreamImageBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromImageStreamImageObjects(java.util.Collection<io.fabric8.openshift.api.model.ImageStreamImage> items) {
    for (io.fabric8.openshift.api.model.ImageStreamImage item : items) {io.fabric8.openshift.api.model.ImageStreamImageBuilder builder = new io.fabric8.openshift.api.model.ImageStreamImageBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromImageStreamImageObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ImageStreamImageObjectsNested<A> addNewImageStreamImageObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ImageStreamImageObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ImageStreamImageObjectsNested<A> addNewImageStreamImageObjectLike(io.fabric8.openshift.api.model.ImageStreamImage item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ImageStreamImageObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ImageStreamImageObjectsNested<A> setNewImageStreamImageObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.ImageStreamImage item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ImageStreamImageObjectsNestedImpl(index, item);
  }
  public A addToTemplateInstanceObjects(java.lang.Integer index,io.fabric8.openshift.api.model.TemplateInstance item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.TemplateInstanceBuilder builder = new io.fabric8.openshift.api.model.TemplateInstanceBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToTemplateInstanceObjects(java.lang.Integer index,io.fabric8.openshift.api.model.TemplateInstance item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.TemplateInstanceBuilder builder = new io.fabric8.openshift.api.model.TemplateInstanceBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToTemplateInstanceObjects(io.fabric8.openshift.api.model.TemplateInstance... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.TemplateInstance item : items) {io.fabric8.openshift.api.model.TemplateInstanceBuilder builder = new io.fabric8.openshift.api.model.TemplateInstanceBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToTemplateInstanceObjects(java.util.Collection<io.fabric8.openshift.api.model.TemplateInstance> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.TemplateInstance item : items) {io.fabric8.openshift.api.model.TemplateInstanceBuilder builder = new io.fabric8.openshift.api.model.TemplateInstanceBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromTemplateInstanceObjects(io.fabric8.openshift.api.model.TemplateInstance... items) {
    for (io.fabric8.openshift.api.model.TemplateInstance item : items) {io.fabric8.openshift.api.model.TemplateInstanceBuilder builder = new io.fabric8.openshift.api.model.TemplateInstanceBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromTemplateInstanceObjects(java.util.Collection<io.fabric8.openshift.api.model.TemplateInstance> items) {
    for (io.fabric8.openshift.api.model.TemplateInstance item : items) {io.fabric8.openshift.api.model.TemplateInstanceBuilder builder = new io.fabric8.openshift.api.model.TemplateInstanceBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromTemplateInstanceObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.TemplateInstanceObjectsNested<A> addNewTemplateInstanceObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.TemplateInstanceObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.TemplateInstanceObjectsNested<A> addNewTemplateInstanceObjectLike(io.fabric8.openshift.api.model.TemplateInstance item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.TemplateInstanceObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.TemplateInstanceObjectsNested<A> setNewTemplateInstanceObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.TemplateInstance item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.TemplateInstanceObjectsNestedImpl(index, item);
  }
  public A addToBuildObjects(java.lang.Integer index,io.fabric8.openshift.api.model.Build item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.BuildBuilder builder = new io.fabric8.openshift.api.model.BuildBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToBuildObjects(java.lang.Integer index,io.fabric8.openshift.api.model.Build item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.BuildBuilder builder = new io.fabric8.openshift.api.model.BuildBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToBuildObjects(io.fabric8.openshift.api.model.Build... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.Build item : items) {io.fabric8.openshift.api.model.BuildBuilder builder = new io.fabric8.openshift.api.model.BuildBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToBuildObjects(java.util.Collection<io.fabric8.openshift.api.model.Build> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.Build item : items) {io.fabric8.openshift.api.model.BuildBuilder builder = new io.fabric8.openshift.api.model.BuildBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromBuildObjects(io.fabric8.openshift.api.model.Build... items) {
    for (io.fabric8.openshift.api.model.Build item : items) {io.fabric8.openshift.api.model.BuildBuilder builder = new io.fabric8.openshift.api.model.BuildBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromBuildObjects(java.util.Collection<io.fabric8.openshift.api.model.Build> items) {
    for (io.fabric8.openshift.api.model.Build item : items) {io.fabric8.openshift.api.model.BuildBuilder builder = new io.fabric8.openshift.api.model.BuildBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromBuildObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.BuildObjectsNested<A> addNewBuildObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.BuildObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.BuildObjectsNested<A> addNewBuildObjectLike(io.fabric8.openshift.api.model.Build item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.BuildObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.BuildObjectsNested<A> setNewBuildObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.Build item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.BuildObjectsNestedImpl(index, item);
  }
  public A addToRoleBindingRestrictionObjects(java.lang.Integer index,io.fabric8.openshift.api.model.RoleBindingRestriction item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.RoleBindingRestrictionBuilder builder = new io.fabric8.openshift.api.model.RoleBindingRestrictionBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToRoleBindingRestrictionObjects(java.lang.Integer index,io.fabric8.openshift.api.model.RoleBindingRestriction item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.RoleBindingRestrictionBuilder builder = new io.fabric8.openshift.api.model.RoleBindingRestrictionBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToRoleBindingRestrictionObjects(io.fabric8.openshift.api.model.RoleBindingRestriction... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.RoleBindingRestriction item : items) {io.fabric8.openshift.api.model.RoleBindingRestrictionBuilder builder = new io.fabric8.openshift.api.model.RoleBindingRestrictionBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToRoleBindingRestrictionObjects(java.util.Collection<io.fabric8.openshift.api.model.RoleBindingRestriction> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.RoleBindingRestriction item : items) {io.fabric8.openshift.api.model.RoleBindingRestrictionBuilder builder = new io.fabric8.openshift.api.model.RoleBindingRestrictionBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromRoleBindingRestrictionObjects(io.fabric8.openshift.api.model.RoleBindingRestriction... items) {
    for (io.fabric8.openshift.api.model.RoleBindingRestriction item : items) {io.fabric8.openshift.api.model.RoleBindingRestrictionBuilder builder = new io.fabric8.openshift.api.model.RoleBindingRestrictionBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromRoleBindingRestrictionObjects(java.util.Collection<io.fabric8.openshift.api.model.RoleBindingRestriction> items) {
    for (io.fabric8.openshift.api.model.RoleBindingRestriction item : items) {io.fabric8.openshift.api.model.RoleBindingRestrictionBuilder builder = new io.fabric8.openshift.api.model.RoleBindingRestrictionBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromRoleBindingRestrictionObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.RoleBindingRestrictionObjectsNested<A> addNewRoleBindingRestrictionObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.RoleBindingRestrictionObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.RoleBindingRestrictionObjectsNested<A> addNewRoleBindingRestrictionObjectLike(io.fabric8.openshift.api.model.RoleBindingRestriction item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.RoleBindingRestrictionObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.RoleBindingRestrictionObjectsNested<A> setNewRoleBindingRestrictionObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.RoleBindingRestriction item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.RoleBindingRestrictionObjectsNestedImpl(index, item);
  }
  public A addToImageStreamTagObjects(java.lang.Integer index,io.fabric8.openshift.api.model.ImageStreamTag item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.ImageStreamTagBuilder builder = new io.fabric8.openshift.api.model.ImageStreamTagBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToImageStreamTagObjects(java.lang.Integer index,io.fabric8.openshift.api.model.ImageStreamTag item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.ImageStreamTagBuilder builder = new io.fabric8.openshift.api.model.ImageStreamTagBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToImageStreamTagObjects(io.fabric8.openshift.api.model.ImageStreamTag... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.ImageStreamTag item : items) {io.fabric8.openshift.api.model.ImageStreamTagBuilder builder = new io.fabric8.openshift.api.model.ImageStreamTagBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToImageStreamTagObjects(java.util.Collection<io.fabric8.openshift.api.model.ImageStreamTag> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.ImageStreamTag item : items) {io.fabric8.openshift.api.model.ImageStreamTagBuilder builder = new io.fabric8.openshift.api.model.ImageStreamTagBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromImageStreamTagObjects(io.fabric8.openshift.api.model.ImageStreamTag... items) {
    for (io.fabric8.openshift.api.model.ImageStreamTag item : items) {io.fabric8.openshift.api.model.ImageStreamTagBuilder builder = new io.fabric8.openshift.api.model.ImageStreamTagBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromImageStreamTagObjects(java.util.Collection<io.fabric8.openshift.api.model.ImageStreamTag> items) {
    for (io.fabric8.openshift.api.model.ImageStreamTag item : items) {io.fabric8.openshift.api.model.ImageStreamTagBuilder builder = new io.fabric8.openshift.api.model.ImageStreamTagBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromImageStreamTagObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ImageStreamTagObjectsNested<A> addNewImageStreamTagObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ImageStreamTagObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ImageStreamTagObjectsNested<A> addNewImageStreamTagObjectLike(io.fabric8.openshift.api.model.ImageStreamTag item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ImageStreamTagObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ImageStreamTagObjectsNested<A> setNewImageStreamTagObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.ImageStreamTag item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ImageStreamTagObjectsNestedImpl(index, item);
  }
  public A addToGroupObjects(java.lang.Integer index,io.fabric8.openshift.api.model.Group item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.GroupBuilder builder = new io.fabric8.openshift.api.model.GroupBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToGroupObjects(java.lang.Integer index,io.fabric8.openshift.api.model.Group item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.GroupBuilder builder = new io.fabric8.openshift.api.model.GroupBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToGroupObjects(io.fabric8.openshift.api.model.Group... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.Group item : items) {io.fabric8.openshift.api.model.GroupBuilder builder = new io.fabric8.openshift.api.model.GroupBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToGroupObjects(java.util.Collection<io.fabric8.openshift.api.model.Group> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.Group item : items) {io.fabric8.openshift.api.model.GroupBuilder builder = new io.fabric8.openshift.api.model.GroupBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromGroupObjects(io.fabric8.openshift.api.model.Group... items) {
    for (io.fabric8.openshift.api.model.Group item : items) {io.fabric8.openshift.api.model.GroupBuilder builder = new io.fabric8.openshift.api.model.GroupBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromGroupObjects(java.util.Collection<io.fabric8.openshift.api.model.Group> items) {
    for (io.fabric8.openshift.api.model.Group item : items) {io.fabric8.openshift.api.model.GroupBuilder builder = new io.fabric8.openshift.api.model.GroupBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromGroupObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.GroupObjectsNested<A> addNewGroupObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.GroupObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.GroupObjectsNested<A> addNewGroupObjectLike(io.fabric8.openshift.api.model.Group item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.GroupObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.GroupObjectsNested<A> setNewGroupObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.Group item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.GroupObjectsNestedImpl(index, item);
  }
  public A addToImageSignatureObjects(java.lang.Integer index,io.fabric8.openshift.api.model.ImageSignature item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.ImageSignatureBuilder builder = new io.fabric8.openshift.api.model.ImageSignatureBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToImageSignatureObjects(java.lang.Integer index,io.fabric8.openshift.api.model.ImageSignature item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.ImageSignatureBuilder builder = new io.fabric8.openshift.api.model.ImageSignatureBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToImageSignatureObjects(io.fabric8.openshift.api.model.ImageSignature... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.ImageSignature item : items) {io.fabric8.openshift.api.model.ImageSignatureBuilder builder = new io.fabric8.openshift.api.model.ImageSignatureBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToImageSignatureObjects(java.util.Collection<io.fabric8.openshift.api.model.ImageSignature> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.ImageSignature item : items) {io.fabric8.openshift.api.model.ImageSignatureBuilder builder = new io.fabric8.openshift.api.model.ImageSignatureBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromImageSignatureObjects(io.fabric8.openshift.api.model.ImageSignature... items) {
    for (io.fabric8.openshift.api.model.ImageSignature item : items) {io.fabric8.openshift.api.model.ImageSignatureBuilder builder = new io.fabric8.openshift.api.model.ImageSignatureBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromImageSignatureObjects(java.util.Collection<io.fabric8.openshift.api.model.ImageSignature> items) {
    for (io.fabric8.openshift.api.model.ImageSignature item : items) {io.fabric8.openshift.api.model.ImageSignatureBuilder builder = new io.fabric8.openshift.api.model.ImageSignatureBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromImageSignatureObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ImageSignatureObjectsNested<A> addNewImageSignatureObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ImageSignatureObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ImageSignatureObjectsNested<A> addNewImageSignatureObjectLike(io.fabric8.openshift.api.model.ImageSignature item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ImageSignatureObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ImageSignatureObjectsNested<A> setNewImageSignatureObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.ImageSignature item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ImageSignatureObjectsNestedImpl(index, item);
  }
  public A addToHostSubnetObjects(java.lang.Integer index,io.fabric8.openshift.api.model.HostSubnet item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.HostSubnetBuilder builder = new io.fabric8.openshift.api.model.HostSubnetBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToHostSubnetObjects(java.lang.Integer index,io.fabric8.openshift.api.model.HostSubnet item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.HostSubnetBuilder builder = new io.fabric8.openshift.api.model.HostSubnetBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToHostSubnetObjects(io.fabric8.openshift.api.model.HostSubnet... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.HostSubnet item : items) {io.fabric8.openshift.api.model.HostSubnetBuilder builder = new io.fabric8.openshift.api.model.HostSubnetBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToHostSubnetObjects(java.util.Collection<io.fabric8.openshift.api.model.HostSubnet> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.HostSubnet item : items) {io.fabric8.openshift.api.model.HostSubnetBuilder builder = new io.fabric8.openshift.api.model.HostSubnetBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromHostSubnetObjects(io.fabric8.openshift.api.model.HostSubnet... items) {
    for (io.fabric8.openshift.api.model.HostSubnet item : items) {io.fabric8.openshift.api.model.HostSubnetBuilder builder = new io.fabric8.openshift.api.model.HostSubnetBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromHostSubnetObjects(java.util.Collection<io.fabric8.openshift.api.model.HostSubnet> items) {
    for (io.fabric8.openshift.api.model.HostSubnet item : items) {io.fabric8.openshift.api.model.HostSubnetBuilder builder = new io.fabric8.openshift.api.model.HostSubnetBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromHostSubnetObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.HostSubnetObjectsNested<A> addNewHostSubnetObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.HostSubnetObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.HostSubnetObjectsNested<A> addNewHostSubnetObjectLike(io.fabric8.openshift.api.model.HostSubnet item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.HostSubnetObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.HostSubnetObjectsNested<A> setNewHostSubnetObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.HostSubnet item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.HostSubnetObjectsNestedImpl(index, item);
  }
  public A addToAppliedClusterResourceQuotaObjects(java.lang.Integer index,io.fabric8.openshift.api.model.AppliedClusterResourceQuota item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.AppliedClusterResourceQuotaBuilder builder = new io.fabric8.openshift.api.model.AppliedClusterResourceQuotaBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToAppliedClusterResourceQuotaObjects(java.lang.Integer index,io.fabric8.openshift.api.model.AppliedClusterResourceQuota item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.AppliedClusterResourceQuotaBuilder builder = new io.fabric8.openshift.api.model.AppliedClusterResourceQuotaBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToAppliedClusterResourceQuotaObjects(io.fabric8.openshift.api.model.AppliedClusterResourceQuota... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.AppliedClusterResourceQuota item : items) {io.fabric8.openshift.api.model.AppliedClusterResourceQuotaBuilder builder = new io.fabric8.openshift.api.model.AppliedClusterResourceQuotaBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToAppliedClusterResourceQuotaObjects(java.util.Collection<io.fabric8.openshift.api.model.AppliedClusterResourceQuota> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.AppliedClusterResourceQuota item : items) {io.fabric8.openshift.api.model.AppliedClusterResourceQuotaBuilder builder = new io.fabric8.openshift.api.model.AppliedClusterResourceQuotaBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromAppliedClusterResourceQuotaObjects(io.fabric8.openshift.api.model.AppliedClusterResourceQuota... items) {
    for (io.fabric8.openshift.api.model.AppliedClusterResourceQuota item : items) {io.fabric8.openshift.api.model.AppliedClusterResourceQuotaBuilder builder = new io.fabric8.openshift.api.model.AppliedClusterResourceQuotaBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromAppliedClusterResourceQuotaObjects(java.util.Collection<io.fabric8.openshift.api.model.AppliedClusterResourceQuota> items) {
    for (io.fabric8.openshift.api.model.AppliedClusterResourceQuota item : items) {io.fabric8.openshift.api.model.AppliedClusterResourceQuotaBuilder builder = new io.fabric8.openshift.api.model.AppliedClusterResourceQuotaBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromAppliedClusterResourceQuotaObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.AppliedClusterResourceQuotaObjectsNested<A> addNewAppliedClusterResourceQuotaObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.AppliedClusterResourceQuotaObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.AppliedClusterResourceQuotaObjectsNested<A> addNewAppliedClusterResourceQuotaObjectLike(io.fabric8.openshift.api.model.AppliedClusterResourceQuota item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.AppliedClusterResourceQuotaObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.AppliedClusterResourceQuotaObjectsNested<A> setNewAppliedClusterResourceQuotaObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.AppliedClusterResourceQuota item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.AppliedClusterResourceQuotaObjectsNestedImpl(index, item);
  }
  public A addToSecurityContextConstraintsObjects(java.lang.Integer index,io.fabric8.openshift.api.model.SecurityContextConstraints item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.SecurityContextConstraintsBuilder builder = new io.fabric8.openshift.api.model.SecurityContextConstraintsBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToSecurityContextConstraintsObjects(java.lang.Integer index,io.fabric8.openshift.api.model.SecurityContextConstraints item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.SecurityContextConstraintsBuilder builder = new io.fabric8.openshift.api.model.SecurityContextConstraintsBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToSecurityContextConstraintsObjects(io.fabric8.openshift.api.model.SecurityContextConstraints... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.SecurityContextConstraints item : items) {io.fabric8.openshift.api.model.SecurityContextConstraintsBuilder builder = new io.fabric8.openshift.api.model.SecurityContextConstraintsBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToSecurityContextConstraintsObjects(java.util.Collection<io.fabric8.openshift.api.model.SecurityContextConstraints> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.SecurityContextConstraints item : items) {io.fabric8.openshift.api.model.SecurityContextConstraintsBuilder builder = new io.fabric8.openshift.api.model.SecurityContextConstraintsBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromSecurityContextConstraintsObjects(io.fabric8.openshift.api.model.SecurityContextConstraints... items) {
    for (io.fabric8.openshift.api.model.SecurityContextConstraints item : items) {io.fabric8.openshift.api.model.SecurityContextConstraintsBuilder builder = new io.fabric8.openshift.api.model.SecurityContextConstraintsBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromSecurityContextConstraintsObjects(java.util.Collection<io.fabric8.openshift.api.model.SecurityContextConstraints> items) {
    for (io.fabric8.openshift.api.model.SecurityContextConstraints item : items) {io.fabric8.openshift.api.model.SecurityContextConstraintsBuilder builder = new io.fabric8.openshift.api.model.SecurityContextConstraintsBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromSecurityContextConstraintsObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.SecurityContextConstraintsObjectsNested<A> addNewSecurityContextConstraintsObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.SecurityContextConstraintsObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.SecurityContextConstraintsObjectsNested<A> addNewSecurityContextConstraintsObjectLike(io.fabric8.openshift.api.model.SecurityContextConstraints item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.SecurityContextConstraintsObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.SecurityContextConstraintsObjectsNested<A> setNewSecurityContextConstraintsObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.SecurityContextConstraints item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.SecurityContextConstraintsObjectsNestedImpl(index, item);
  }
  public A addToConsoleObjects(java.lang.Integer index,io.fabric8.openshift.api.model.Console item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.ConsoleBuilder builder = new io.fabric8.openshift.api.model.ConsoleBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToConsoleObjects(java.lang.Integer index,io.fabric8.openshift.api.model.Console item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.ConsoleBuilder builder = new io.fabric8.openshift.api.model.ConsoleBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToConsoleObjects(io.fabric8.openshift.api.model.Console... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.Console item : items) {io.fabric8.openshift.api.model.ConsoleBuilder builder = new io.fabric8.openshift.api.model.ConsoleBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToConsoleObjects(java.util.Collection<io.fabric8.openshift.api.model.Console> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.Console item : items) {io.fabric8.openshift.api.model.ConsoleBuilder builder = new io.fabric8.openshift.api.model.ConsoleBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromConsoleObjects(io.fabric8.openshift.api.model.Console... items) {
    for (io.fabric8.openshift.api.model.Console item : items) {io.fabric8.openshift.api.model.ConsoleBuilder builder = new io.fabric8.openshift.api.model.ConsoleBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromConsoleObjects(java.util.Collection<io.fabric8.openshift.api.model.Console> items) {
    for (io.fabric8.openshift.api.model.Console item : items) {io.fabric8.openshift.api.model.ConsoleBuilder builder = new io.fabric8.openshift.api.model.ConsoleBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConsoleObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ConsoleObjectsNested<A> addNewConsoleObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ConsoleObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ConsoleObjectsNested<A> addNewConsoleObjectLike(io.fabric8.openshift.api.model.Console item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ConsoleObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ConsoleObjectsNested<A> setNewConsoleObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.Console item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ConsoleObjectsNestedImpl(index, item);
  }
  public A addToBuildRequestObjects(java.lang.Integer index,io.fabric8.openshift.api.model.BuildRequest item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.BuildRequestBuilder builder = new io.fabric8.openshift.api.model.BuildRequestBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToBuildRequestObjects(java.lang.Integer index,io.fabric8.openshift.api.model.BuildRequest item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.BuildRequestBuilder builder = new io.fabric8.openshift.api.model.BuildRequestBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToBuildRequestObjects(io.fabric8.openshift.api.model.BuildRequest... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.BuildRequest item : items) {io.fabric8.openshift.api.model.BuildRequestBuilder builder = new io.fabric8.openshift.api.model.BuildRequestBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToBuildRequestObjects(java.util.Collection<io.fabric8.openshift.api.model.BuildRequest> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.BuildRequest item : items) {io.fabric8.openshift.api.model.BuildRequestBuilder builder = new io.fabric8.openshift.api.model.BuildRequestBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromBuildRequestObjects(io.fabric8.openshift.api.model.BuildRequest... items) {
    for (io.fabric8.openshift.api.model.BuildRequest item : items) {io.fabric8.openshift.api.model.BuildRequestBuilder builder = new io.fabric8.openshift.api.model.BuildRequestBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromBuildRequestObjects(java.util.Collection<io.fabric8.openshift.api.model.BuildRequest> items) {
    for (io.fabric8.openshift.api.model.BuildRequest item : items) {io.fabric8.openshift.api.model.BuildRequestBuilder builder = new io.fabric8.openshift.api.model.BuildRequestBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromBuildRequestObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.BuildRequestObjectsNested<A> addNewBuildRequestObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.BuildRequestObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.BuildRequestObjectsNested<A> addNewBuildRequestObjectLike(io.fabric8.openshift.api.model.BuildRequest item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.BuildRequestObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.BuildRequestObjectsNested<A> setNewBuildRequestObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.BuildRequest item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.BuildRequestObjectsNestedImpl(index, item);
  }
  public A addToEgressNetworkPolicyObjects(java.lang.Integer index,io.fabric8.openshift.api.model.EgressNetworkPolicy item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.EgressNetworkPolicyBuilder builder = new io.fabric8.openshift.api.model.EgressNetworkPolicyBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToEgressNetworkPolicyObjects(java.lang.Integer index,io.fabric8.openshift.api.model.EgressNetworkPolicy item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.EgressNetworkPolicyBuilder builder = new io.fabric8.openshift.api.model.EgressNetworkPolicyBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToEgressNetworkPolicyObjects(io.fabric8.openshift.api.model.EgressNetworkPolicy... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.EgressNetworkPolicy item : items) {io.fabric8.openshift.api.model.EgressNetworkPolicyBuilder builder = new io.fabric8.openshift.api.model.EgressNetworkPolicyBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToEgressNetworkPolicyObjects(java.util.Collection<io.fabric8.openshift.api.model.EgressNetworkPolicy> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.EgressNetworkPolicy item : items) {io.fabric8.openshift.api.model.EgressNetworkPolicyBuilder builder = new io.fabric8.openshift.api.model.EgressNetworkPolicyBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromEgressNetworkPolicyObjects(io.fabric8.openshift.api.model.EgressNetworkPolicy... items) {
    for (io.fabric8.openshift.api.model.EgressNetworkPolicy item : items) {io.fabric8.openshift.api.model.EgressNetworkPolicyBuilder builder = new io.fabric8.openshift.api.model.EgressNetworkPolicyBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromEgressNetworkPolicyObjects(java.util.Collection<io.fabric8.openshift.api.model.EgressNetworkPolicy> items) {
    for (io.fabric8.openshift.api.model.EgressNetworkPolicy item : items) {io.fabric8.openshift.api.model.EgressNetworkPolicyBuilder builder = new io.fabric8.openshift.api.model.EgressNetworkPolicyBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromEgressNetworkPolicyObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.EgressNetworkPolicyObjectsNested<A> addNewEgressNetworkPolicyObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.EgressNetworkPolicyObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.EgressNetworkPolicyObjectsNested<A> addNewEgressNetworkPolicyObjectLike(io.fabric8.openshift.api.model.EgressNetworkPolicy item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.EgressNetworkPolicyObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.EgressNetworkPolicyObjectsNested<A> setNewEgressNetworkPolicyObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.EgressNetworkPolicy item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.EgressNetworkPolicyObjectsNestedImpl(index, item);
  }
  public A addToNetNamespaceObjects(java.lang.Integer index,io.fabric8.openshift.api.model.NetNamespace item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.NetNamespaceBuilder builder = new io.fabric8.openshift.api.model.NetNamespaceBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToNetNamespaceObjects(java.lang.Integer index,io.fabric8.openshift.api.model.NetNamespace item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.NetNamespaceBuilder builder = new io.fabric8.openshift.api.model.NetNamespaceBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToNetNamespaceObjects(io.fabric8.openshift.api.model.NetNamespace... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.NetNamespace item : items) {io.fabric8.openshift.api.model.NetNamespaceBuilder builder = new io.fabric8.openshift.api.model.NetNamespaceBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToNetNamespaceObjects(java.util.Collection<io.fabric8.openshift.api.model.NetNamespace> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.NetNamespace item : items) {io.fabric8.openshift.api.model.NetNamespaceBuilder builder = new io.fabric8.openshift.api.model.NetNamespaceBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromNetNamespaceObjects(io.fabric8.openshift.api.model.NetNamespace... items) {
    for (io.fabric8.openshift.api.model.NetNamespace item : items) {io.fabric8.openshift.api.model.NetNamespaceBuilder builder = new io.fabric8.openshift.api.model.NetNamespaceBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromNetNamespaceObjects(java.util.Collection<io.fabric8.openshift.api.model.NetNamespace> items) {
    for (io.fabric8.openshift.api.model.NetNamespace item : items) {io.fabric8.openshift.api.model.NetNamespaceBuilder builder = new io.fabric8.openshift.api.model.NetNamespaceBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromNetNamespaceObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.NetNamespaceObjectsNested<A> addNewNetNamespaceObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.NetNamespaceObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.NetNamespaceObjectsNested<A> addNewNetNamespaceObjectLike(io.fabric8.openshift.api.model.NetNamespace item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.NetNamespaceObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.NetNamespaceObjectsNested<A> setNewNetNamespaceObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.NetNamespace item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.NetNamespaceObjectsNestedImpl(index, item);
  }
  public A addToUserIdentityMappingObjects(java.lang.Integer index,io.fabric8.openshift.api.model.UserIdentityMapping item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.UserIdentityMappingBuilder builder = new io.fabric8.openshift.api.model.UserIdentityMappingBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToUserIdentityMappingObjects(java.lang.Integer index,io.fabric8.openshift.api.model.UserIdentityMapping item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.UserIdentityMappingBuilder builder = new io.fabric8.openshift.api.model.UserIdentityMappingBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToUserIdentityMappingObjects(io.fabric8.openshift.api.model.UserIdentityMapping... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.UserIdentityMapping item : items) {io.fabric8.openshift.api.model.UserIdentityMappingBuilder builder = new io.fabric8.openshift.api.model.UserIdentityMappingBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToUserIdentityMappingObjects(java.util.Collection<io.fabric8.openshift.api.model.UserIdentityMapping> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.UserIdentityMapping item : items) {io.fabric8.openshift.api.model.UserIdentityMappingBuilder builder = new io.fabric8.openshift.api.model.UserIdentityMappingBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromUserIdentityMappingObjects(io.fabric8.openshift.api.model.UserIdentityMapping... items) {
    for (io.fabric8.openshift.api.model.UserIdentityMapping item : items) {io.fabric8.openshift.api.model.UserIdentityMappingBuilder builder = new io.fabric8.openshift.api.model.UserIdentityMappingBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromUserIdentityMappingObjects(java.util.Collection<io.fabric8.openshift.api.model.UserIdentityMapping> items) {
    for (io.fabric8.openshift.api.model.UserIdentityMapping item : items) {io.fabric8.openshift.api.model.UserIdentityMappingBuilder builder = new io.fabric8.openshift.api.model.UserIdentityMappingBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromUserIdentityMappingObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.UserIdentityMappingObjectsNested<A> addNewUserIdentityMappingObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.UserIdentityMappingObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.UserIdentityMappingObjectsNested<A> addNewUserIdentityMappingObjectLike(io.fabric8.openshift.api.model.UserIdentityMapping item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.UserIdentityMappingObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.UserIdentityMappingObjectsNested<A> setNewUserIdentityMappingObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.UserIdentityMapping item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.UserIdentityMappingObjectsNestedImpl(index, item);
  }
  public A addToImageStreamObjects(java.lang.Integer index,io.fabric8.openshift.api.model.ImageStream item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.ImageStreamBuilder builder = new io.fabric8.openshift.api.model.ImageStreamBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToImageStreamObjects(java.lang.Integer index,io.fabric8.openshift.api.model.ImageStream item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.ImageStreamBuilder builder = new io.fabric8.openshift.api.model.ImageStreamBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToImageStreamObjects(io.fabric8.openshift.api.model.ImageStream... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.ImageStream item : items) {io.fabric8.openshift.api.model.ImageStreamBuilder builder = new io.fabric8.openshift.api.model.ImageStreamBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToImageStreamObjects(java.util.Collection<io.fabric8.openshift.api.model.ImageStream> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.ImageStream item : items) {io.fabric8.openshift.api.model.ImageStreamBuilder builder = new io.fabric8.openshift.api.model.ImageStreamBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromImageStreamObjects(io.fabric8.openshift.api.model.ImageStream... items) {
    for (io.fabric8.openshift.api.model.ImageStream item : items) {io.fabric8.openshift.api.model.ImageStreamBuilder builder = new io.fabric8.openshift.api.model.ImageStreamBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromImageStreamObjects(java.util.Collection<io.fabric8.openshift.api.model.ImageStream> items) {
    for (io.fabric8.openshift.api.model.ImageStream item : items) {io.fabric8.openshift.api.model.ImageStreamBuilder builder = new io.fabric8.openshift.api.model.ImageStreamBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromImageStreamObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ImageStreamObjectsNested<A> addNewImageStreamObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ImageStreamObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ImageStreamObjectsNested<A> addNewImageStreamObjectLike(io.fabric8.openshift.api.model.ImageStream item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ImageStreamObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ImageStreamObjectsNested<A> setNewImageStreamObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.ImageStream item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ImageStreamObjectsNestedImpl(index, item);
  }
  public A addToNetworkObjects(java.lang.Integer index,io.fabric8.openshift.api.model.Network item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.NetworkBuilder builder = new io.fabric8.openshift.api.model.NetworkBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToNetworkObjects(java.lang.Integer index,io.fabric8.openshift.api.model.Network item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.NetworkBuilder builder = new io.fabric8.openshift.api.model.NetworkBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToNetworkObjects(io.fabric8.openshift.api.model.Network... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.Network item : items) {io.fabric8.openshift.api.model.NetworkBuilder builder = new io.fabric8.openshift.api.model.NetworkBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToNetworkObjects(java.util.Collection<io.fabric8.openshift.api.model.Network> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.Network item : items) {io.fabric8.openshift.api.model.NetworkBuilder builder = new io.fabric8.openshift.api.model.NetworkBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromNetworkObjects(io.fabric8.openshift.api.model.Network... items) {
    for (io.fabric8.openshift.api.model.Network item : items) {io.fabric8.openshift.api.model.NetworkBuilder builder = new io.fabric8.openshift.api.model.NetworkBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromNetworkObjects(java.util.Collection<io.fabric8.openshift.api.model.Network> items) {
    for (io.fabric8.openshift.api.model.Network item : items) {io.fabric8.openshift.api.model.NetworkBuilder builder = new io.fabric8.openshift.api.model.NetworkBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromNetworkObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.NetworkObjectsNested<A> addNewNetworkObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.NetworkObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.NetworkObjectsNested<A> addNewNetworkObjectLike(io.fabric8.openshift.api.model.Network item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.NetworkObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.NetworkObjectsNested<A> setNewNetworkObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.Network item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.NetworkObjectsNestedImpl(index, item);
  }
  public A addToOAuthClientObjects(java.lang.Integer index,io.fabric8.openshift.api.model.OAuthClient item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.OAuthClientBuilder builder = new io.fabric8.openshift.api.model.OAuthClientBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToOAuthClientObjects(java.lang.Integer index,io.fabric8.openshift.api.model.OAuthClient item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.OAuthClientBuilder builder = new io.fabric8.openshift.api.model.OAuthClientBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToOAuthClientObjects(io.fabric8.openshift.api.model.OAuthClient... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.OAuthClient item : items) {io.fabric8.openshift.api.model.OAuthClientBuilder builder = new io.fabric8.openshift.api.model.OAuthClientBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToOAuthClientObjects(java.util.Collection<io.fabric8.openshift.api.model.OAuthClient> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.OAuthClient item : items) {io.fabric8.openshift.api.model.OAuthClientBuilder builder = new io.fabric8.openshift.api.model.OAuthClientBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromOAuthClientObjects(io.fabric8.openshift.api.model.OAuthClient... items) {
    for (io.fabric8.openshift.api.model.OAuthClient item : items) {io.fabric8.openshift.api.model.OAuthClientBuilder builder = new io.fabric8.openshift.api.model.OAuthClientBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromOAuthClientObjects(java.util.Collection<io.fabric8.openshift.api.model.OAuthClient> items) {
    for (io.fabric8.openshift.api.model.OAuthClient item : items) {io.fabric8.openshift.api.model.OAuthClientBuilder builder = new io.fabric8.openshift.api.model.OAuthClientBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromOAuthClientObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.OAuthClientObjectsNested<A> addNewOAuthClientObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.OAuthClientObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.OAuthClientObjectsNested<A> addNewOAuthClientObjectLike(io.fabric8.openshift.api.model.OAuthClient item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.OAuthClientObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.OAuthClientObjectsNested<A> setNewOAuthClientObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.OAuthClient item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.OAuthClientObjectsNestedImpl(index, item);
  }
  public A addToIdentityObjects(java.lang.Integer index,io.fabric8.openshift.api.model.Identity item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.IdentityBuilder builder = new io.fabric8.openshift.api.model.IdentityBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
  }
  public A setToIdentityObjects(java.lang.Integer index,io.fabric8.openshift.api.model.Identity item) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    io.fabric8.openshift.api.model.IdentityBuilder builder = new io.fabric8.openshift.api.model.IdentityBuilder(item);
    if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
    if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
     return (A)this;
  }
  public A addToIdentityObjects(io.fabric8.openshift.api.model.Identity... items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.Identity item : items) {io.fabric8.openshift.api.model.IdentityBuilder builder = new io.fabric8.openshift.api.model.IdentityBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToIdentityObjects(java.util.Collection<io.fabric8.openshift.api.model.Identity> items) {
    if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
    for (io.fabric8.openshift.api.model.Identity item : items) {io.fabric8.openshift.api.model.IdentityBuilder builder = new io.fabric8.openshift.api.model.IdentityBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromIdentityObjects(io.fabric8.openshift.api.model.Identity... items) {
    for (io.fabric8.openshift.api.model.Identity item : items) {io.fabric8.openshift.api.model.IdentityBuilder builder = new io.fabric8.openshift.api.model.IdentityBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromIdentityObjects(java.util.Collection<io.fabric8.openshift.api.model.Identity> items) {
    for (io.fabric8.openshift.api.model.Identity item : items) {io.fabric8.openshift.api.model.IdentityBuilder builder = new io.fabric8.openshift.api.model.IdentityBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromIdentityObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public io.fabric8.openshift.api.model.TemplateFluent.IdentityObjectsNested<A> addNewIdentityObject() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.IdentityObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.IdentityObjectsNested<A> addNewIdentityObjectLike(io.fabric8.openshift.api.model.Identity item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.IdentityObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.IdentityObjectsNested<A> setNewIdentityObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.Identity item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.IdentityObjectsNestedImpl(index, item);
  }
  public A addToParameters(java.lang.Integer index,io.fabric8.openshift.api.model.Parameter item) {
    if (this.parameters == null) {this.parameters = new java.util.ArrayList<io.fabric8.openshift.api.model.ParameterBuilder>();}
    io.fabric8.openshift.api.model.ParameterBuilder builder = new io.fabric8.openshift.api.model.ParameterBuilder(item);_visitables.get("parameters").add(index >= 0 ? index : _visitables.get("parameters").size(), builder);this.parameters.add(index >= 0 ? index : parameters.size(), builder); return (A)this;
  }
  public A setToParameters(java.lang.Integer index,io.fabric8.openshift.api.model.Parameter item) {
    if (this.parameters == null) {this.parameters = new java.util.ArrayList<io.fabric8.openshift.api.model.ParameterBuilder>();}
    io.fabric8.openshift.api.model.ParameterBuilder builder = new io.fabric8.openshift.api.model.ParameterBuilder(item);
    if (index < 0 || index >= _visitables.get("parameters").size()) { _visitables.get("parameters").add(builder); } else { _visitables.get("parameters").set(index, builder);}
    if (index < 0 || index >= parameters.size()) { parameters.add(builder); } else { parameters.set(index, builder);}
     return (A)this;
  }
  public A addToParameters(io.fabric8.openshift.api.model.Parameter... items) {
    if (this.parameters == null) {this.parameters = new java.util.ArrayList<io.fabric8.openshift.api.model.ParameterBuilder>();}
    for (io.fabric8.openshift.api.model.Parameter item : items) {io.fabric8.openshift.api.model.ParameterBuilder builder = new io.fabric8.openshift.api.model.ParameterBuilder(item);_visitables.get("parameters").add(builder);this.parameters.add(builder);} return (A)this;
  }
  public A addAllToParameters(java.util.Collection<io.fabric8.openshift.api.model.Parameter> items) {
    if (this.parameters == null) {this.parameters = new java.util.ArrayList<io.fabric8.openshift.api.model.ParameterBuilder>();}
    for (io.fabric8.openshift.api.model.Parameter item : items) {io.fabric8.openshift.api.model.ParameterBuilder builder = new io.fabric8.openshift.api.model.ParameterBuilder(item);_visitables.get("parameters").add(builder);this.parameters.add(builder);} return (A)this;
  }
  public A removeFromParameters(io.fabric8.openshift.api.model.Parameter... items) {
    for (io.fabric8.openshift.api.model.Parameter item : items) {io.fabric8.openshift.api.model.ParameterBuilder builder = new io.fabric8.openshift.api.model.ParameterBuilder(item);_visitables.get("parameters").remove(builder);if (this.parameters != null) {this.parameters.remove(builder);}} return (A)this;
  }
  public A removeAllFromParameters(java.util.Collection<io.fabric8.openshift.api.model.Parameter> items) {
    for (io.fabric8.openshift.api.model.Parameter item : items) {io.fabric8.openshift.api.model.ParameterBuilder builder = new io.fabric8.openshift.api.model.ParameterBuilder(item);_visitables.get("parameters").remove(builder);if (this.parameters != null) {this.parameters.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromParameters(java.util.function.Predicate<io.fabric8.openshift.api.model.ParameterBuilder> predicate) {
    if (parameters == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.ParameterBuilder> each = parameters.iterator();
    final List visitables = _visitables.get("parameters");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.ParameterBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildParameters instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.openshift.api.model.Parameter> getParameters() {
    return build(parameters);
  }
  public java.util.List<io.fabric8.openshift.api.model.Parameter> buildParameters() {
    return build(parameters);
  }
  public io.fabric8.openshift.api.model.Parameter buildParameter(java.lang.Integer index) {
    return this.parameters.get(index).build();
  }
  public io.fabric8.openshift.api.model.Parameter buildFirstParameter() {
    return this.parameters.get(0).build();
  }
  public io.fabric8.openshift.api.model.Parameter buildLastParameter() {
    return this.parameters.get(parameters.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.Parameter buildMatchingParameter(java.util.function.Predicate<io.fabric8.openshift.api.model.ParameterBuilder> predicate) {
    for (io.fabric8.openshift.api.model.ParameterBuilder item: parameters) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingParameter(java.util.function.Predicate<io.fabric8.openshift.api.model.ParameterBuilder> predicate) {
    for (io.fabric8.openshift.api.model.ParameterBuilder item: parameters) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withParameters(java.util.List<io.fabric8.openshift.api.model.Parameter> parameters) {
    if (this.parameters != null) { _visitables.get("parameters").removeAll(this.parameters);}
    if (parameters != null) {this.parameters = new java.util.ArrayList<io.fabric8.openshift.api.model.ParameterBuilder>(); for (io.fabric8.openshift.api.model.Parameter item : parameters){this.addToParameters(item);}} else { this.parameters = null;} return (A) this;
  }
  public A withParameters(io.fabric8.openshift.api.model.Parameter... parameters) {
    if (this.parameters != null) {this.parameters.clear();}
    if (parameters != null) {for (io.fabric8.openshift.api.model.Parameter item :parameters){ this.addToParameters(item);}} return (A) this;
  }
  public java.lang.Boolean hasParameters() {
    return parameters != null && !parameters.isEmpty();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ParametersNested<A> addNewParameter() {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ParametersNestedImpl();
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ParametersNested<A> addNewParameterLike(io.fabric8.openshift.api.model.Parameter item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ParametersNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ParametersNested<A> setNewParameterLike(java.lang.Integer index,io.fabric8.openshift.api.model.Parameter item) {
    return new io.fabric8.openshift.api.model.TemplateFluentImpl.ParametersNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ParametersNested<A> editParameter(java.lang.Integer index) {
    if (parameters.size() <= index) throw new RuntimeException("Can't edit parameters. Index exceeds size.");
    return setNewParameterLike(index, buildParameter(index));
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ParametersNested<A> editFirstParameter() {
    if (parameters.size() == 0) throw new RuntimeException("Can't edit first parameters. The list is empty.");
    return setNewParameterLike(0, buildParameter(0));
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ParametersNested<A> editLastParameter() {
    int index = parameters.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last parameters. The list is empty.");
    return setNewParameterLike(index, buildParameter(index));
  }
  public io.fabric8.openshift.api.model.TemplateFluent.ParametersNested<A> editMatchingParameter(java.util.function.Predicate<io.fabric8.openshift.api.model.ParameterBuilder> predicate) {
    int index = -1;
    for (int i=0;i<parameters.size();i++) { 
    if (predicate.test(parameters.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching parameters. No match found.");
    return setNewParameterLike(index, buildParameter(index));
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TemplateFluentImpl that = (TemplateFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (labels != null ? !labels.equals(that.labels) :that.labels != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (objects != null ? !objects.equals(that.objects) :that.objects != null) return false;
    if (parameters != null ? !parameters.equals(that.parameters) :that.parameters != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  labels,  metadata,  objects,  parameters,  additionalProperties,  super.hashCode());
  }
  public class MetadataNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.MetadataNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    MetadataNestedImpl(io.fabric8.kubernetes.api.model.ObjectMeta item) {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ObjectMetaBuilder builder;
    public N and() {
      return (N) TemplateFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  public class ClusterVersionObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.ClusterVersionFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.ClusterVersionObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.ClusterVersionObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ClusterVersionObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.ClusterVersion item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.ClusterVersionBuilder(this, item);
    }
    ClusterVersionObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.ClusterVersionBuilder(this);
    }
    io.fabric8.openshift.api.model.ClusterVersionBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endClusterVersionObject() {
      return and();
    }
    
  }
  public class DNSObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.DNSFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.DNSObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.DNSObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    DNSObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.DNS item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.DNSBuilder(this, item);
    }
    DNSObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.DNSBuilder(this);
    }
    io.fabric8.openshift.api.model.DNSBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endDNSObject() {
      return and();
    }
    
  }
  public class ImageStreamImportObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.ImageStreamImportFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.ImageStreamImportObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.ImageStreamImportObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ImageStreamImportObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.ImageStreamImport item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.ImageStreamImportBuilder(this, item);
    }
    ImageStreamImportObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.ImageStreamImportBuilder(this);
    }
    io.fabric8.openshift.api.model.ImageStreamImportBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endImageStreamImportObject() {
      return and();
    }
    
  }
  public class ProxyObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.ProxyFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.ProxyObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.ProxyObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ProxyObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.Proxy item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.ProxyBuilder(this, item);
    }
    ProxyObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.ProxyBuilder(this);
    }
    io.fabric8.openshift.api.model.ProxyBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endProxyObject() {
      return and();
    }
    
  }
  public class ProjectObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.ProjectFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.ProjectObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.ProjectObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ProjectObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.Project item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.ProjectBuilder(this, item);
    }
    ProjectObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.ProjectBuilder(this);
    }
    io.fabric8.openshift.api.model.ProjectBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endProjectObject() {
      return and();
    }
    
  }
  public class ClusterOperatorObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.ClusterOperatorFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.ClusterOperatorObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.ClusterOperatorObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ClusterOperatorObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.ClusterOperator item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.ClusterOperatorBuilder(this, item);
    }
    ClusterOperatorObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.ClusterOperatorBuilder(this);
    }
    io.fabric8.openshift.api.model.ClusterOperatorBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endClusterOperatorObject() {
      return and();
    }
    
  }
  public class BuildConfigObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.BuildConfigFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.BuildConfigObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.BuildConfigObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    BuildConfigObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.BuildConfig item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.BuildConfigBuilder(this, item);
    }
    BuildConfigObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.BuildConfigBuilder(this);
    }
    io.fabric8.openshift.api.model.BuildConfigBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endBuildConfigObject() {
      return and();
    }
    
  }
  public class HelmChartRepositoryObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.HelmChartRepositoryFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.HelmChartRepositoryObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.HelmChartRepositoryObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    HelmChartRepositoryObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.HelmChartRepository item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.HelmChartRepositoryBuilder(this, item);
    }
    HelmChartRepositoryObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.HelmChartRepositoryBuilder(this);
    }
    io.fabric8.openshift.api.model.HelmChartRepositoryBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endHelmChartRepositoryObject() {
      return and();
    }
    
  }
  public class InfrastructureObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.InfrastructureFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.InfrastructureObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.InfrastructureObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    InfrastructureObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.Infrastructure item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.InfrastructureBuilder(this, item);
    }
    InfrastructureObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.InfrastructureBuilder(this);
    }
    io.fabric8.openshift.api.model.InfrastructureBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endInfrastructureObject() {
      return and();
    }
    
  }
  public class SchedulerObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.SchedulerFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.SchedulerObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.SchedulerObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    SchedulerObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.Scheduler item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.SchedulerBuilder(this, item);
    }
    SchedulerObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.SchedulerBuilder(this);
    }
    io.fabric8.openshift.api.model.SchedulerBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endSchedulerObject() {
      return and();
    }
    
  }
  public class RangeAllocationObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.RangeAllocationFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.RangeAllocationObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.RangeAllocationObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    RangeAllocationObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.RangeAllocation item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.RangeAllocationBuilder(this, item);
    }
    RangeAllocationObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.RangeAllocationBuilder(this);
    }
    io.fabric8.openshift.api.model.RangeAllocationBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endRangeAllocationObject() {
      return and();
    }
    
  }
  public class RouteObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.RouteFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.RouteObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.RouteObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    RouteObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.Route item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.RouteBuilder(this, item);
    }
    RouteObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.RouteBuilder(this);
    }
    io.fabric8.openshift.api.model.RouteBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endRouteObject() {
      return and();
    }
    
  }
  public class ClusterNetworkObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.ClusterNetworkFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.ClusterNetworkObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.ClusterNetworkObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ClusterNetworkObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.ClusterNetwork item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.ClusterNetworkBuilder(this, item);
    }
    ClusterNetworkObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.ClusterNetworkBuilder(this);
    }
    io.fabric8.openshift.api.model.ClusterNetworkBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endClusterNetworkObject() {
      return and();
    }
    
  }
  public class OAuthAuthorizeTokenObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.OAuthAuthorizeTokenFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.OAuthAuthorizeTokenObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.OAuthAuthorizeTokenObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    OAuthAuthorizeTokenObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.OAuthAuthorizeToken item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.OAuthAuthorizeTokenBuilder(this, item);
    }
    OAuthAuthorizeTokenObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.OAuthAuthorizeTokenBuilder(this);
    }
    io.fabric8.openshift.api.model.OAuthAuthorizeTokenBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endOAuthAuthorizeTokenObject() {
      return and();
    }
    
  }
  public class UserOAuthAccessTokenObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.UserOAuthAccessTokenFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.UserOAuthAccessTokenObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.UserOAuthAccessTokenObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    UserOAuthAccessTokenObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.UserOAuthAccessToken item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.UserOAuthAccessTokenBuilder(this, item);
    }
    UserOAuthAccessTokenObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.UserOAuthAccessTokenBuilder(this);
    }
    io.fabric8.openshift.api.model.UserOAuthAccessTokenBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endUserOAuthAccessTokenObject() {
      return and();
    }
    
  }
  public class IngressObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.IngressFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.IngressObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.IngressObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    IngressObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.Ingress item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.IngressBuilder(this, item);
    }
    IngressObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.IngressBuilder(this);
    }
    io.fabric8.openshift.api.model.IngressBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endIngressObject() {
      return and();
    }
    
  }
  public class OAuthObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.OAuthFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.OAuthObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.OAuthObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    OAuthObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.OAuth item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.OAuthBuilder(this, item);
    }
    OAuthObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.OAuthBuilder(this);
    }
    io.fabric8.openshift.api.model.OAuthBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endOAuthObject() {
      return and();
    }
    
  }
  public class OperatorHubObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.OperatorHubFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.OperatorHubObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.OperatorHubObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    OperatorHubObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.OperatorHub item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.OperatorHubBuilder(this, item);
    }
    OperatorHubObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.OperatorHubBuilder(this);
    }
    io.fabric8.openshift.api.model.OperatorHubBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endOperatorHubObject() {
      return and();
    }
    
  }
  public class ClusterRoleBindingObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.ClusterRoleBindingFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.ClusterRoleBindingObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.ClusterRoleBindingObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ClusterRoleBindingObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.ClusterRoleBinding item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.ClusterRoleBindingBuilder(this, item);
    }
    ClusterRoleBindingObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.ClusterRoleBindingBuilder(this);
    }
    io.fabric8.openshift.api.model.ClusterRoleBindingBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endClusterRoleBindingObject() {
      return and();
    }
    
  }
  public class ClusterResourceQuotaObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.ClusterResourceQuotaFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.ClusterResourceQuotaObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.ClusterResourceQuotaObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ClusterResourceQuotaObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.ClusterResourceQuota item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.ClusterResourceQuotaBuilder(this, item);
    }
    ClusterResourceQuotaObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.ClusterResourceQuotaBuilder(this);
    }
    io.fabric8.openshift.api.model.ClusterResourceQuotaBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endClusterResourceQuotaObject() {
      return and();
    }
    
  }
  public class ProjectRequestObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.ProjectRequestFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.ProjectRequestObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.ProjectRequestObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ProjectRequestObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.ProjectRequest item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.ProjectRequestBuilder(this, item);
    }
    ProjectRequestObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.ProjectRequestBuilder(this);
    }
    io.fabric8.openshift.api.model.ProjectRequestBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endProjectRequestObject() {
      return and();
    }
    
  }
  public class TemplateObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.TemplateFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.TemplateObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.TemplateObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    TemplateObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.Template item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.TemplateBuilder(this, item);
    }
    TemplateObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.TemplateBuilder(this);
    }
    io.fabric8.openshift.api.model.TemplateBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endTemplateObject() {
      return and();
    }
    
  }
  public class OAuthClientAuthorizationObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.OAuthClientAuthorizationFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.OAuthClientAuthorizationObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.OAuthClientAuthorizationObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    OAuthClientAuthorizationObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.OAuthClientAuthorization item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.OAuthClientAuthorizationBuilder(this, item);
    }
    OAuthClientAuthorizationObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.OAuthClientAuthorizationBuilder(this);
    }
    io.fabric8.openshift.api.model.OAuthClientAuthorizationBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endOAuthClientAuthorizationObject() {
      return and();
    }
    
  }
  public class ClusterRoleObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.ClusterRoleFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.ClusterRoleObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.ClusterRoleObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ClusterRoleObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.ClusterRole item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.ClusterRoleBuilder(this, item);
    }
    ClusterRoleObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.ClusterRoleBuilder(this);
    }
    io.fabric8.openshift.api.model.ClusterRoleBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endClusterRoleObject() {
      return and();
    }
    
  }
  public class AuthenticationObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.AuthenticationFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.AuthenticationObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.AuthenticationObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    AuthenticationObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.Authentication item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.AuthenticationBuilder(this, item);
    }
    AuthenticationObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.AuthenticationBuilder(this);
    }
    io.fabric8.openshift.api.model.AuthenticationBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endAuthenticationObject() {
      return and();
    }
    
  }
  public class ImageTagObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.ImageTagFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.ImageTagObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.ImageTagObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ImageTagObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.ImageTag item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.ImageTagBuilder(this, item);
    }
    ImageTagObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.ImageTagBuilder(this);
    }
    io.fabric8.openshift.api.model.ImageTagBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endImageTagObject() {
      return and();
    }
    
  }
  public class OAuthAccessTokenObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.OAuthAccessTokenFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.OAuthAccessTokenObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.OAuthAccessTokenObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    OAuthAccessTokenObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.OAuthAccessToken item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.OAuthAccessTokenBuilder(this, item);
    }
    OAuthAccessTokenObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.OAuthAccessTokenBuilder(this);
    }
    io.fabric8.openshift.api.model.OAuthAccessTokenBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endOAuthAccessTokenObject() {
      return and();
    }
    
  }
  public class DeploymentConfigObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.DeploymentConfigFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.DeploymentConfigObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.DeploymentConfigObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    DeploymentConfigObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.DeploymentConfig item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.DeploymentConfigBuilder(this, item);
    }
    DeploymentConfigObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.DeploymentConfigBuilder(this);
    }
    io.fabric8.openshift.api.model.DeploymentConfigBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endDeploymentConfigObject() {
      return and();
    }
    
  }
  public class RoleBindingObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.RoleBindingFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.RoleBindingObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.RoleBindingObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    RoleBindingObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.RoleBinding item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.RoleBindingBuilder(this, item);
    }
    RoleBindingObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.RoleBindingBuilder(this);
    }
    io.fabric8.openshift.api.model.RoleBindingBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endRoleBindingObject() {
      return and();
    }
    
  }
  public class ImageObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.ImageFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.ImageObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.ImageObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ImageObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.Image item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.ImageBuilder(this, item);
    }
    ImageObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.ImageBuilder(this);
    }
    io.fabric8.openshift.api.model.ImageBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endImageObject() {
      return and();
    }
    
  }
  public class APIServerObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.APIServerFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.APIServerObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.APIServerObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    APIServerObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.APIServer item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.APIServerBuilder(this, item);
    }
    APIServerObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.APIServerBuilder(this);
    }
    io.fabric8.openshift.api.model.APIServerBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endAPIServerObject() {
      return and();
    }
    
  }
  public class PersistentVolumeClaimObjectsNestedImpl<N> extends io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.PersistentVolumeClaimObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.PersistentVolumeClaimObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    PersistentVolumeClaimObjectsNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.PersistentVolumeClaim item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(this, item);
    }
    PersistentVolumeClaimObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(this);
    }
    io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endPersistentVolumeClaimObject() {
      return and();
    }
    
  }
  public class ImageStreamMappingObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.ImageStreamMappingFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.ImageStreamMappingObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.ImageStreamMappingObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ImageStreamMappingObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.ImageStreamMapping item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.ImageStreamMappingBuilder(this, item);
    }
    ImageStreamMappingObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.ImageStreamMappingBuilder(this);
    }
    io.fabric8.openshift.api.model.ImageStreamMappingBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endImageStreamMappingObject() {
      return and();
    }
    
  }
  public class RoleObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.RoleFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.RoleObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.RoleObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    RoleObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.Role item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.RoleBuilder(this, item);
    }
    RoleObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.RoleBuilder(this);
    }
    io.fabric8.openshift.api.model.RoleBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endRoleObject() {
      return and();
    }
    
  }
  public class BrokerTemplateInstanceObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.BrokerTemplateInstanceFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.BrokerTemplateInstanceObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.BrokerTemplateInstanceObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    BrokerTemplateInstanceObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.BrokerTemplateInstance item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.BrokerTemplateInstanceBuilder(this, item);
    }
    BrokerTemplateInstanceObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.BrokerTemplateInstanceBuilder(this);
    }
    io.fabric8.openshift.api.model.BrokerTemplateInstanceBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endBrokerTemplateInstanceObject() {
      return and();
    }
    
  }
  public class FeatureGateObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.FeatureGateFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.FeatureGateObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.FeatureGateObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    FeatureGateObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.FeatureGate item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.FeatureGateBuilder(this, item);
    }
    FeatureGateObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.FeatureGateBuilder(this);
    }
    io.fabric8.openshift.api.model.FeatureGateBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endFeatureGateObject() {
      return and();
    }
    
  }
  public class UserObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.UserFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.UserObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.UserObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    UserObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.User item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.UserBuilder(this, item);
    }
    UserObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.UserBuilder(this);
    }
    io.fabric8.openshift.api.model.UserBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endUserObject() {
      return and();
    }
    
  }
  public class ImageStreamImageObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.ImageStreamImageFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.ImageStreamImageObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.ImageStreamImageObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ImageStreamImageObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.ImageStreamImage item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.ImageStreamImageBuilder(this, item);
    }
    ImageStreamImageObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.ImageStreamImageBuilder(this);
    }
    io.fabric8.openshift.api.model.ImageStreamImageBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endImageStreamImageObject() {
      return and();
    }
    
  }
  public class TemplateInstanceObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.TemplateInstanceFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.TemplateInstanceObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.TemplateInstanceObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    TemplateInstanceObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.TemplateInstance item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.TemplateInstanceBuilder(this, item);
    }
    TemplateInstanceObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.TemplateInstanceBuilder(this);
    }
    io.fabric8.openshift.api.model.TemplateInstanceBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endTemplateInstanceObject() {
      return and();
    }
    
  }
  public class BuildObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.BuildFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.BuildObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.BuildObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    BuildObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.Build item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.BuildBuilder(this, item);
    }
    BuildObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.BuildBuilder(this);
    }
    io.fabric8.openshift.api.model.BuildBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endBuildObject() {
      return and();
    }
    
  }
  public class RoleBindingRestrictionObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.RoleBindingRestrictionFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.RoleBindingRestrictionObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.RoleBindingRestrictionObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    RoleBindingRestrictionObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.RoleBindingRestriction item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.RoleBindingRestrictionBuilder(this, item);
    }
    RoleBindingRestrictionObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.RoleBindingRestrictionBuilder(this);
    }
    io.fabric8.openshift.api.model.RoleBindingRestrictionBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endRoleBindingRestrictionObject() {
      return and();
    }
    
  }
  public class ImageStreamTagObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.ImageStreamTagFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.ImageStreamTagObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.ImageStreamTagObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ImageStreamTagObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.ImageStreamTag item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.ImageStreamTagBuilder(this, item);
    }
    ImageStreamTagObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.ImageStreamTagBuilder(this);
    }
    io.fabric8.openshift.api.model.ImageStreamTagBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endImageStreamTagObject() {
      return and();
    }
    
  }
  public class GroupObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.GroupFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.GroupObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.GroupObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    GroupObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.Group item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.GroupBuilder(this, item);
    }
    GroupObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.GroupBuilder(this);
    }
    io.fabric8.openshift.api.model.GroupBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endGroupObject() {
      return and();
    }
    
  }
  public class ImageSignatureObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.ImageSignatureFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.ImageSignatureObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.ImageSignatureObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ImageSignatureObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.ImageSignature item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.ImageSignatureBuilder(this, item);
    }
    ImageSignatureObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.ImageSignatureBuilder(this);
    }
    io.fabric8.openshift.api.model.ImageSignatureBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endImageSignatureObject() {
      return and();
    }
    
  }
  public class HostSubnetObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.HostSubnetFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.HostSubnetObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.HostSubnetObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    HostSubnetObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.HostSubnet item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.HostSubnetBuilder(this, item);
    }
    HostSubnetObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.HostSubnetBuilder(this);
    }
    io.fabric8.openshift.api.model.HostSubnetBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endHostSubnetObject() {
      return and();
    }
    
  }
  public class AppliedClusterResourceQuotaObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.AppliedClusterResourceQuotaFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.AppliedClusterResourceQuotaObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.AppliedClusterResourceQuotaObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    AppliedClusterResourceQuotaObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.AppliedClusterResourceQuota item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.AppliedClusterResourceQuotaBuilder(this, item);
    }
    AppliedClusterResourceQuotaObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.AppliedClusterResourceQuotaBuilder(this);
    }
    io.fabric8.openshift.api.model.AppliedClusterResourceQuotaBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endAppliedClusterResourceQuotaObject() {
      return and();
    }
    
  }
  public class SecurityContextConstraintsObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.SecurityContextConstraintsFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.SecurityContextConstraintsObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.SecurityContextConstraintsObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    SecurityContextConstraintsObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.SecurityContextConstraints item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.SecurityContextConstraintsBuilder(this, item);
    }
    SecurityContextConstraintsObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.SecurityContextConstraintsBuilder(this);
    }
    io.fabric8.openshift.api.model.SecurityContextConstraintsBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endSecurityContextConstraintsObject() {
      return and();
    }
    
  }
  public class ConsoleObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.ConsoleFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.ConsoleObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.ConsoleObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ConsoleObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.Console item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.ConsoleBuilder(this, item);
    }
    ConsoleObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.ConsoleBuilder(this);
    }
    io.fabric8.openshift.api.model.ConsoleBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endConsoleObject() {
      return and();
    }
    
  }
  public class BuildRequestObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.BuildRequestFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.BuildRequestObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.BuildRequestObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    BuildRequestObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.BuildRequest item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.BuildRequestBuilder(this, item);
    }
    BuildRequestObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.BuildRequestBuilder(this);
    }
    io.fabric8.openshift.api.model.BuildRequestBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endBuildRequestObject() {
      return and();
    }
    
  }
  public class EgressNetworkPolicyObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.EgressNetworkPolicyFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.EgressNetworkPolicyObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.EgressNetworkPolicyObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    EgressNetworkPolicyObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.EgressNetworkPolicy item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.EgressNetworkPolicyBuilder(this, item);
    }
    EgressNetworkPolicyObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.EgressNetworkPolicyBuilder(this);
    }
    io.fabric8.openshift.api.model.EgressNetworkPolicyBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endEgressNetworkPolicyObject() {
      return and();
    }
    
  }
  public class NetNamespaceObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.NetNamespaceFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.NetNamespaceObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.NetNamespaceObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    NetNamespaceObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.NetNamespace item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.NetNamespaceBuilder(this, item);
    }
    NetNamespaceObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.NetNamespaceBuilder(this);
    }
    io.fabric8.openshift.api.model.NetNamespaceBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endNetNamespaceObject() {
      return and();
    }
    
  }
  public class UserIdentityMappingObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.UserIdentityMappingFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.UserIdentityMappingObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.UserIdentityMappingObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    UserIdentityMappingObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.UserIdentityMapping item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.UserIdentityMappingBuilder(this, item);
    }
    UserIdentityMappingObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.UserIdentityMappingBuilder(this);
    }
    io.fabric8.openshift.api.model.UserIdentityMappingBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endUserIdentityMappingObject() {
      return and();
    }
    
  }
  public class ImageStreamObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.ImageStreamFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.ImageStreamObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.ImageStreamObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ImageStreamObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.ImageStream item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.ImageStreamBuilder(this, item);
    }
    ImageStreamObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.ImageStreamBuilder(this);
    }
    io.fabric8.openshift.api.model.ImageStreamBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endImageStreamObject() {
      return and();
    }
    
  }
  public class NetworkObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.NetworkFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.NetworkObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.NetworkObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    NetworkObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.Network item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.NetworkBuilder(this, item);
    }
    NetworkObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.NetworkBuilder(this);
    }
    io.fabric8.openshift.api.model.NetworkBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endNetworkObject() {
      return and();
    }
    
  }
  public class OAuthClientObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.OAuthClientFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.OAuthClientObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.OAuthClientObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    OAuthClientObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.OAuthClient item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.OAuthClientBuilder(this, item);
    }
    OAuthClientObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.OAuthClientBuilder(this);
    }
    io.fabric8.openshift.api.model.OAuthClientBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endOAuthClientObject() {
      return and();
    }
    
  }
  public class IdentityObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.IdentityFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.IdentityObjectsNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.IdentityObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    IdentityObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.Identity item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.IdentityBuilder(this, item);
    }
    IdentityObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.IdentityBuilder(this);
    }
    io.fabric8.openshift.api.model.IdentityBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endIdentityObject() {
      return and();
    }
    
  }
  public class ParametersNestedImpl<N> extends io.fabric8.openshift.api.model.ParameterFluentImpl<io.fabric8.openshift.api.model.TemplateFluent.ParametersNested<N>> implements io.fabric8.openshift.api.model.TemplateFluent.ParametersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ParametersNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.Parameter item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.ParameterBuilder(this, item);
    }
    ParametersNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.ParameterBuilder(this);
    }
    io.fabric8.openshift.api.model.ParameterBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToParameters(index,builder.build());
    }
    public N endParameter() {
      return and();
    }
    
  }
  
}