package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import java.lang.Integer;

 /**
  * Generated
  */
public class BuildRequestFluentImpl<A extends io.fabric8.openshift.api.model.BuildRequestFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.BuildRequestFluent<A>{
  public BuildRequestFluentImpl() {
  }
  public BuildRequestFluentImpl(io.fabric8.openshift.api.model.BuildRequest instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withBinary(instance.getBinary()); 
    this.withDockerStrategyOptions(instance.getDockerStrategyOptions()); 
    this.withEnv(instance.getEnv()); 
    this.withFrom(instance.getFrom()); 
    this.withKind(instance.getKind()); 
    this.withLastVersion(instance.getLastVersion()); 
    this.withMetadata(instance.getMetadata()); 
    this.withRevision(instance.getRevision()); 
    this.withSourceStrategyOptions(instance.getSourceStrategyOptions()); 
    this.withTriggeredBy(instance.getTriggeredBy()); 
    this.withTriggeredByImage(instance.getTriggeredByImage()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private java.lang.String apiVersion;
  private io.fabric8.openshift.api.model.BinaryBuildSourceBuilder binary;
  private io.fabric8.openshift.api.model.DockerStrategyOptionsBuilder dockerStrategyOptions;
  private java.util.List<io.fabric8.kubernetes.api.model.EnvVar> env = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EnvVar>();
  private io.fabric8.kubernetes.api.model.ObjectReferenceBuilder from;
  private java.lang.String kind;
  private java.lang.Long lastVersion;
  private io.fabric8.kubernetes.api.model.ObjectMetaBuilder metadata;
  private io.fabric8.openshift.api.model.SourceRevisionBuilder revision;
  private io.fabric8.openshift.api.model.SourceStrategyOptionsBuilder sourceStrategyOptions;
  private java.util.List<io.fabric8.openshift.api.model.BuildTriggerCauseBuilder> triggeredBy =  new java.util.ArrayList<io.fabric8.openshift.api.model.BuildTriggerCauseBuilder>();
  private io.fabric8.kubernetes.api.model.ObjectReferenceBuilder triggeredByImage;
  private java.util.Map<java.lang.String,java.lang.Object> additionalProperties;
  public java.lang.String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(java.lang.String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public java.lang.Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  /**
   * Method is deprecated. use withApiVersion instead.
   */
  @java.lang.Deprecated
  public A withNewApiVersion(java.lang.String arg0) {
    return (A)withApiVersion(new String(arg0));
  }
  
  /**
   * This method has been deprecated, please use method buildBinary instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.openshift.api.model.BinaryBuildSource getBinary() {
    return this.binary!=null?this.binary.build():null;
  }
  public io.fabric8.openshift.api.model.BinaryBuildSource buildBinary() {
    return this.binary!=null?this.binary.build():null;
  }
  public A withBinary(io.fabric8.openshift.api.model.BinaryBuildSource binary) {
    _visitables.get("binary").remove(this.binary);
    if (binary!=null){ this.binary= new io.fabric8.openshift.api.model.BinaryBuildSourceBuilder(binary); _visitables.get("binary").add(this.binary);} return (A) this;
  }
  public java.lang.Boolean hasBinary() {
    return this.binary != null;
  }
  public A withNewBinary(java.lang.String asFile) {
    return (A)withBinary(new BinaryBuildSource(asFile));
  }
  public io.fabric8.openshift.api.model.BuildRequestFluent.BinaryNested<A> withNewBinary() {
    return new io.fabric8.openshift.api.model.BuildRequestFluentImpl.BinaryNestedImpl();
  }
  public io.fabric8.openshift.api.model.BuildRequestFluent.BinaryNested<A> withNewBinaryLike(io.fabric8.openshift.api.model.BinaryBuildSource item) {
    return new io.fabric8.openshift.api.model.BuildRequestFluentImpl.BinaryNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.BuildRequestFluent.BinaryNested<A> editBinary() {
    return withNewBinaryLike(getBinary());
  }
  public io.fabric8.openshift.api.model.BuildRequestFluent.BinaryNested<A> editOrNewBinary() {
    return withNewBinaryLike(getBinary() != null ? getBinary(): new io.fabric8.openshift.api.model.BinaryBuildSourceBuilder().build());
  }
  public io.fabric8.openshift.api.model.BuildRequestFluent.BinaryNested<A> editOrNewBinaryLike(io.fabric8.openshift.api.model.BinaryBuildSource item) {
    return withNewBinaryLike(getBinary() != null ? getBinary(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildDockerStrategyOptions instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.openshift.api.model.DockerStrategyOptions getDockerStrategyOptions() {
    return this.dockerStrategyOptions!=null?this.dockerStrategyOptions.build():null;
  }
  public io.fabric8.openshift.api.model.DockerStrategyOptions buildDockerStrategyOptions() {
    return this.dockerStrategyOptions!=null?this.dockerStrategyOptions.build():null;
  }
  public A withDockerStrategyOptions(io.fabric8.openshift.api.model.DockerStrategyOptions dockerStrategyOptions) {
    _visitables.get("dockerStrategyOptions").remove(this.dockerStrategyOptions);
    if (dockerStrategyOptions!=null){ this.dockerStrategyOptions= new io.fabric8.openshift.api.model.DockerStrategyOptionsBuilder(dockerStrategyOptions); _visitables.get("dockerStrategyOptions").add(this.dockerStrategyOptions);} return (A) this;
  }
  public java.lang.Boolean hasDockerStrategyOptions() {
    return this.dockerStrategyOptions != null;
  }
  public io.fabric8.openshift.api.model.BuildRequestFluent.DockerStrategyOptionsNested<A> withNewDockerStrategyOptions() {
    return new io.fabric8.openshift.api.model.BuildRequestFluentImpl.DockerStrategyOptionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.BuildRequestFluent.DockerStrategyOptionsNested<A> withNewDockerStrategyOptionsLike(io.fabric8.openshift.api.model.DockerStrategyOptions item) {
    return new io.fabric8.openshift.api.model.BuildRequestFluentImpl.DockerStrategyOptionsNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.BuildRequestFluent.DockerStrategyOptionsNested<A> editDockerStrategyOptions() {
    return withNewDockerStrategyOptionsLike(getDockerStrategyOptions());
  }
  public io.fabric8.openshift.api.model.BuildRequestFluent.DockerStrategyOptionsNested<A> editOrNewDockerStrategyOptions() {
    return withNewDockerStrategyOptionsLike(getDockerStrategyOptions() != null ? getDockerStrategyOptions(): new io.fabric8.openshift.api.model.DockerStrategyOptionsBuilder().build());
  }
  public io.fabric8.openshift.api.model.BuildRequestFluent.DockerStrategyOptionsNested<A> editOrNewDockerStrategyOptionsLike(io.fabric8.openshift.api.model.DockerStrategyOptions item) {
    return withNewDockerStrategyOptionsLike(getDockerStrategyOptions() != null ? getDockerStrategyOptions(): item);
  }
  public A addToEnv(java.lang.Integer index,io.fabric8.kubernetes.api.model.EnvVar item) {
    if (this.env == null) {this.env = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EnvVar>();}
    this.env.add(index, item);
    return (A)this;
  }
  public A setToEnv(java.lang.Integer index,io.fabric8.kubernetes.api.model.EnvVar item) {
    if (this.env == null) {this.env = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EnvVar>();}
    this.env.set(index, item); return (A)this;
  }
  public A addToEnv(io.fabric8.kubernetes.api.model.EnvVar... items) {
    if (this.env == null) {this.env = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EnvVar>();}
    for (io.fabric8.kubernetes.api.model.EnvVar item : items) {this.env.add(item);} return (A)this;
  }
  public A addAllToEnv(java.util.Collection<io.fabric8.kubernetes.api.model.EnvVar> items) {
    if (this.env == null) {this.env = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EnvVar>();}
    for (io.fabric8.kubernetes.api.model.EnvVar item : items) {this.env.add(item);} return (A)this;
  }
  public A removeFromEnv(io.fabric8.kubernetes.api.model.EnvVar... items) {
    for (io.fabric8.kubernetes.api.model.EnvVar item : items) {if (this.env!= null){ this.env.remove(item);}} return (A)this;
  }
  public A removeAllFromEnv(java.util.Collection<io.fabric8.kubernetes.api.model.EnvVar> items) {
    for (io.fabric8.kubernetes.api.model.EnvVar item : items) {if (this.env!= null){ this.env.remove(item);}} return (A)this;
  }
  public java.util.List<io.fabric8.kubernetes.api.model.EnvVar> getEnv() {
    return this.env;
  }
  public io.fabric8.kubernetes.api.model.EnvVar getEnv(java.lang.Integer index) {
    return this.env.get(index);
  }
  public io.fabric8.kubernetes.api.model.EnvVar getFirstEnv() {
    return this.env.get(0);
  }
  public io.fabric8.kubernetes.api.model.EnvVar getLastEnv() {
    return this.env.get(env.size() - 1);
  }
  public io.fabric8.kubernetes.api.model.EnvVar getMatchingEnv(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EnvVar> predicate) {
    for (io.fabric8.kubernetes.api.model.EnvVar item: env) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingEnv(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EnvVar> predicate) {
    for (io.fabric8.kubernetes.api.model.EnvVar item: env) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withEnv(java.util.List<io.fabric8.kubernetes.api.model.EnvVar> env) {
    if (env != null) {this.env = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.EnvVar item : env){this.addToEnv(item);}} else { this.env = null;} return (A) this;
  }
  public A withEnv(io.fabric8.kubernetes.api.model.EnvVar... env) {
    if (this.env != null) {this.env.clear();}
    if (env != null) {for (io.fabric8.kubernetes.api.model.EnvVar item :env){ this.addToEnv(item);}} return (A) this;
  }
  public java.lang.Boolean hasEnv() {
    return env != null && !env.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildFrom instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.ObjectReference getFrom() {
    return this.from!=null?this.from.build():null;
  }
  public io.fabric8.kubernetes.api.model.ObjectReference buildFrom() {
    return this.from!=null?this.from.build():null;
  }
  public A withFrom(io.fabric8.kubernetes.api.model.ObjectReference from) {
    _visitables.get("from").remove(this.from);
    if (from!=null){ this.from= new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(from); _visitables.get("from").add(this.from);} return (A) this;
  }
  public java.lang.Boolean hasFrom() {
    return this.from != null;
  }
  public io.fabric8.openshift.api.model.BuildRequestFluent.FromNested<A> withNewFrom() {
    return new io.fabric8.openshift.api.model.BuildRequestFluentImpl.FromNestedImpl();
  }
  public io.fabric8.openshift.api.model.BuildRequestFluent.FromNested<A> withNewFromLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
    return new io.fabric8.openshift.api.model.BuildRequestFluentImpl.FromNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.BuildRequestFluent.FromNested<A> editFrom() {
    return withNewFromLike(getFrom());
  }
  public io.fabric8.openshift.api.model.BuildRequestFluent.FromNested<A> editOrNewFrom() {
    return withNewFromLike(getFrom() != null ? getFrom(): new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder().build());
  }
  public io.fabric8.openshift.api.model.BuildRequestFluent.FromNested<A> editOrNewFromLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
    return withNewFromLike(getFrom() != null ? getFrom(): item);
  }
  public java.lang.String getKind() {
    return this.kind;
  }
  public A withKind(java.lang.String kind) {
    this.kind=kind; return (A) this;
  }
  public java.lang.Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * Method is deprecated. use withKind instead.
   */
  @java.lang.Deprecated
  public A withNewKind(java.lang.String arg0) {
    return (A)withKind(new String(arg0));
  }
  public java.lang.Long getLastVersion() {
    return this.lastVersion;
  }
  public A withLastVersion(java.lang.Long lastVersion) {
    this.lastVersion=lastVersion; return (A) this;
  }
  public java.lang.Boolean hasLastVersion() {
    return this.lastVersion != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.ObjectMeta getMetadata() {
    return this.metadata!=null?this.metadata.build():null;
  }
  public io.fabric8.kubernetes.api.model.ObjectMeta buildMetadata() {
    return this.metadata!=null?this.metadata.build():null;
  }
  public A withMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
  }
  public java.lang.Boolean hasMetadata() {
    return this.metadata != null;
  }
  public io.fabric8.openshift.api.model.BuildRequestFluent.MetadataNested<A> withNewMetadata() {
    return new io.fabric8.openshift.api.model.BuildRequestFluentImpl.MetadataNestedImpl();
  }
  public io.fabric8.openshift.api.model.BuildRequestFluent.MetadataNested<A> withNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
    return new io.fabric8.openshift.api.model.BuildRequestFluentImpl.MetadataNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.BuildRequestFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public io.fabric8.openshift.api.model.BuildRequestFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new io.fabric8.kubernetes.api.model.ObjectMetaBuilder().build());
  }
  public io.fabric8.openshift.api.model.BuildRequestFluent.MetadataNested<A> editOrNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildRevision instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.openshift.api.model.SourceRevision getRevision() {
    return this.revision!=null?this.revision.build():null;
  }
  public io.fabric8.openshift.api.model.SourceRevision buildRevision() {
    return this.revision!=null?this.revision.build():null;
  }
  public A withRevision(io.fabric8.openshift.api.model.SourceRevision revision) {
    _visitables.get("revision").remove(this.revision);
    if (revision!=null){ this.revision= new io.fabric8.openshift.api.model.SourceRevisionBuilder(revision); _visitables.get("revision").add(this.revision);} return (A) this;
  }
  public java.lang.Boolean hasRevision() {
    return this.revision != null;
  }
  public io.fabric8.openshift.api.model.BuildRequestFluent.RevisionNested<A> withNewRevision() {
    return new io.fabric8.openshift.api.model.BuildRequestFluentImpl.RevisionNestedImpl();
  }
  public io.fabric8.openshift.api.model.BuildRequestFluent.RevisionNested<A> withNewRevisionLike(io.fabric8.openshift.api.model.SourceRevision item) {
    return new io.fabric8.openshift.api.model.BuildRequestFluentImpl.RevisionNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.BuildRequestFluent.RevisionNested<A> editRevision() {
    return withNewRevisionLike(getRevision());
  }
  public io.fabric8.openshift.api.model.BuildRequestFluent.RevisionNested<A> editOrNewRevision() {
    return withNewRevisionLike(getRevision() != null ? getRevision(): new io.fabric8.openshift.api.model.SourceRevisionBuilder().build());
  }
  public io.fabric8.openshift.api.model.BuildRequestFluent.RevisionNested<A> editOrNewRevisionLike(io.fabric8.openshift.api.model.SourceRevision item) {
    return withNewRevisionLike(getRevision() != null ? getRevision(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSourceStrategyOptions instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.openshift.api.model.SourceStrategyOptions getSourceStrategyOptions() {
    return this.sourceStrategyOptions!=null?this.sourceStrategyOptions.build():null;
  }
  public io.fabric8.openshift.api.model.SourceStrategyOptions buildSourceStrategyOptions() {
    return this.sourceStrategyOptions!=null?this.sourceStrategyOptions.build():null;
  }
  public A withSourceStrategyOptions(io.fabric8.openshift.api.model.SourceStrategyOptions sourceStrategyOptions) {
    _visitables.get("sourceStrategyOptions").remove(this.sourceStrategyOptions);
    if (sourceStrategyOptions!=null){ this.sourceStrategyOptions= new io.fabric8.openshift.api.model.SourceStrategyOptionsBuilder(sourceStrategyOptions); _visitables.get("sourceStrategyOptions").add(this.sourceStrategyOptions);} return (A) this;
  }
  public java.lang.Boolean hasSourceStrategyOptions() {
    return this.sourceStrategyOptions != null;
  }
  public A withNewSourceStrategyOptions(java.lang.Boolean incremental) {
    return (A)withSourceStrategyOptions(new SourceStrategyOptions(incremental));
  }
  public io.fabric8.openshift.api.model.BuildRequestFluent.SourceStrategyOptionsNested<A> withNewSourceStrategyOptions() {
    return new io.fabric8.openshift.api.model.BuildRequestFluentImpl.SourceStrategyOptionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.BuildRequestFluent.SourceStrategyOptionsNested<A> withNewSourceStrategyOptionsLike(io.fabric8.openshift.api.model.SourceStrategyOptions item) {
    return new io.fabric8.openshift.api.model.BuildRequestFluentImpl.SourceStrategyOptionsNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.BuildRequestFluent.SourceStrategyOptionsNested<A> editSourceStrategyOptions() {
    return withNewSourceStrategyOptionsLike(getSourceStrategyOptions());
  }
  public io.fabric8.openshift.api.model.BuildRequestFluent.SourceStrategyOptionsNested<A> editOrNewSourceStrategyOptions() {
    return withNewSourceStrategyOptionsLike(getSourceStrategyOptions() != null ? getSourceStrategyOptions(): new io.fabric8.openshift.api.model.SourceStrategyOptionsBuilder().build());
  }
  public io.fabric8.openshift.api.model.BuildRequestFluent.SourceStrategyOptionsNested<A> editOrNewSourceStrategyOptionsLike(io.fabric8.openshift.api.model.SourceStrategyOptions item) {
    return withNewSourceStrategyOptionsLike(getSourceStrategyOptions() != null ? getSourceStrategyOptions(): item);
  }
  public A addToTriggeredBy(java.lang.Integer index,io.fabric8.openshift.api.model.BuildTriggerCause item) {
    if (this.triggeredBy == null) {this.triggeredBy = new java.util.ArrayList<io.fabric8.openshift.api.model.BuildTriggerCauseBuilder>();}
    io.fabric8.openshift.api.model.BuildTriggerCauseBuilder builder = new io.fabric8.openshift.api.model.BuildTriggerCauseBuilder(item);_visitables.get("triggeredBy").add(index >= 0 ? index : _visitables.get("triggeredBy").size(), builder);this.triggeredBy.add(index >= 0 ? index : triggeredBy.size(), builder); return (A)this;
  }
  public A setToTriggeredBy(java.lang.Integer index,io.fabric8.openshift.api.model.BuildTriggerCause item) {
    if (this.triggeredBy == null) {this.triggeredBy = new java.util.ArrayList<io.fabric8.openshift.api.model.BuildTriggerCauseBuilder>();}
    io.fabric8.openshift.api.model.BuildTriggerCauseBuilder builder = new io.fabric8.openshift.api.model.BuildTriggerCauseBuilder(item);
    if (index < 0 || index >= _visitables.get("triggeredBy").size()) { _visitables.get("triggeredBy").add(builder); } else { _visitables.get("triggeredBy").set(index, builder);}
    if (index < 0 || index >= triggeredBy.size()) { triggeredBy.add(builder); } else { triggeredBy.set(index, builder);}
     return (A)this;
  }
  public A addToTriggeredBy(io.fabric8.openshift.api.model.BuildTriggerCause... items) {
    if (this.triggeredBy == null) {this.triggeredBy = new java.util.ArrayList<io.fabric8.openshift.api.model.BuildTriggerCauseBuilder>();}
    for (io.fabric8.openshift.api.model.BuildTriggerCause item : items) {io.fabric8.openshift.api.model.BuildTriggerCauseBuilder builder = new io.fabric8.openshift.api.model.BuildTriggerCauseBuilder(item);_visitables.get("triggeredBy").add(builder);this.triggeredBy.add(builder);} return (A)this;
  }
  public A addAllToTriggeredBy(java.util.Collection<io.fabric8.openshift.api.model.BuildTriggerCause> items) {
    if (this.triggeredBy == null) {this.triggeredBy = new java.util.ArrayList<io.fabric8.openshift.api.model.BuildTriggerCauseBuilder>();}
    for (io.fabric8.openshift.api.model.BuildTriggerCause item : items) {io.fabric8.openshift.api.model.BuildTriggerCauseBuilder builder = new io.fabric8.openshift.api.model.BuildTriggerCauseBuilder(item);_visitables.get("triggeredBy").add(builder);this.triggeredBy.add(builder);} return (A)this;
  }
  public A removeFromTriggeredBy(io.fabric8.openshift.api.model.BuildTriggerCause... items) {
    for (io.fabric8.openshift.api.model.BuildTriggerCause item : items) {io.fabric8.openshift.api.model.BuildTriggerCauseBuilder builder = new io.fabric8.openshift.api.model.BuildTriggerCauseBuilder(item);_visitables.get("triggeredBy").remove(builder);if (this.triggeredBy != null) {this.triggeredBy.remove(builder);}} return (A)this;
  }
  public A removeAllFromTriggeredBy(java.util.Collection<io.fabric8.openshift.api.model.BuildTriggerCause> items) {
    for (io.fabric8.openshift.api.model.BuildTriggerCause item : items) {io.fabric8.openshift.api.model.BuildTriggerCauseBuilder builder = new io.fabric8.openshift.api.model.BuildTriggerCauseBuilder(item);_visitables.get("triggeredBy").remove(builder);if (this.triggeredBy != null) {this.triggeredBy.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromTriggeredBy(java.util.function.Predicate<io.fabric8.openshift.api.model.BuildTriggerCauseBuilder> predicate) {
    if (triggeredBy == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.BuildTriggerCauseBuilder> each = triggeredBy.iterator();
    final List visitables = _visitables.get("triggeredBy");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.BuildTriggerCauseBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildTriggeredBy instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.openshift.api.model.BuildTriggerCause> getTriggeredBy() {
    return build(triggeredBy);
  }
  public java.util.List<io.fabric8.openshift.api.model.BuildTriggerCause> buildTriggeredBy() {
    return build(triggeredBy);
  }
  public io.fabric8.openshift.api.model.BuildTriggerCause buildTriggeredBy(java.lang.Integer index) {
    return this.triggeredBy.get(index).build();
  }
  public io.fabric8.openshift.api.model.BuildTriggerCause buildFirstTriggeredBy() {
    return this.triggeredBy.get(0).build();
  }
  public io.fabric8.openshift.api.model.BuildTriggerCause buildLastTriggeredBy() {
    return this.triggeredBy.get(triggeredBy.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.BuildTriggerCause buildMatchingTriggeredBy(java.util.function.Predicate<io.fabric8.openshift.api.model.BuildTriggerCauseBuilder> predicate) {
    for (io.fabric8.openshift.api.model.BuildTriggerCauseBuilder item: triggeredBy) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingTriggeredBy(java.util.function.Predicate<io.fabric8.openshift.api.model.BuildTriggerCauseBuilder> predicate) {
    for (io.fabric8.openshift.api.model.BuildTriggerCauseBuilder item: triggeredBy) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTriggeredBy(java.util.List<io.fabric8.openshift.api.model.BuildTriggerCause> triggeredBy) {
    if (this.triggeredBy != null) { _visitables.get("triggeredBy").removeAll(this.triggeredBy);}
    if (triggeredBy != null) {this.triggeredBy = new java.util.ArrayList(); for (io.fabric8.openshift.api.model.BuildTriggerCause item : triggeredBy){this.addToTriggeredBy(item);}} else { this.triggeredBy = null;} return (A) this;
  }
  public A withTriggeredBy(io.fabric8.openshift.api.model.BuildTriggerCause... triggeredBy) {
    if (this.triggeredBy != null) {this.triggeredBy.clear();}
    if (triggeredBy != null) {for (io.fabric8.openshift.api.model.BuildTriggerCause item :triggeredBy){ this.addToTriggeredBy(item);}} return (A) this;
  }
  public java.lang.Boolean hasTriggeredBy() {
    return triggeredBy != null && !triggeredBy.isEmpty();
  }
  public io.fabric8.openshift.api.model.BuildRequestFluent.TriggeredByNested<A> addNewTriggeredBy() {
    return new io.fabric8.openshift.api.model.BuildRequestFluentImpl.TriggeredByNestedImpl();
  }
  public io.fabric8.openshift.api.model.BuildRequestFluent.TriggeredByNested<A> addNewTriggeredByLike(io.fabric8.openshift.api.model.BuildTriggerCause item) {
    return new io.fabric8.openshift.api.model.BuildRequestFluentImpl.TriggeredByNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.BuildRequestFluent.TriggeredByNested<A> setNewTriggeredByLike(java.lang.Integer index,io.fabric8.openshift.api.model.BuildTriggerCause item) {
    return new io.fabric8.openshift.api.model.BuildRequestFluentImpl.TriggeredByNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.BuildRequestFluent.TriggeredByNested<A> editTriggeredBy(java.lang.Integer index) {
    if (triggeredBy.size() <= index) throw new RuntimeException("Can't edit triggeredBy. Index exceeds size.");
    return setNewTriggeredByLike(index, buildTriggeredBy(index));
  }
  public io.fabric8.openshift.api.model.BuildRequestFluent.TriggeredByNested<A> editFirstTriggeredBy() {
    if (triggeredBy.size() == 0) throw new RuntimeException("Can't edit first triggeredBy. The list is empty.");
    return setNewTriggeredByLike(0, buildTriggeredBy(0));
  }
  public io.fabric8.openshift.api.model.BuildRequestFluent.TriggeredByNested<A> editLastTriggeredBy() {
    int index = triggeredBy.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last triggeredBy. The list is empty.");
    return setNewTriggeredByLike(index, buildTriggeredBy(index));
  }
  public io.fabric8.openshift.api.model.BuildRequestFluent.TriggeredByNested<A> editMatchingTriggeredBy(java.util.function.Predicate<io.fabric8.openshift.api.model.BuildTriggerCauseBuilder> predicate) {
    int index = -1;
    for (int i=0;i<triggeredBy.size();i++) { 
    if (predicate.test(triggeredBy.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching triggeredBy. No match found.");
    return setNewTriggeredByLike(index, buildTriggeredBy(index));
  }
  
  /**
   * This method has been deprecated, please use method buildTriggeredByImage instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.ObjectReference getTriggeredByImage() {
    return this.triggeredByImage!=null?this.triggeredByImage.build():null;
  }
  public io.fabric8.kubernetes.api.model.ObjectReference buildTriggeredByImage() {
    return this.triggeredByImage!=null?this.triggeredByImage.build():null;
  }
  public A withTriggeredByImage(io.fabric8.kubernetes.api.model.ObjectReference triggeredByImage) {
    _visitables.get("triggeredByImage").remove(this.triggeredByImage);
    if (triggeredByImage!=null){ this.triggeredByImage= new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(triggeredByImage); _visitables.get("triggeredByImage").add(this.triggeredByImage);} return (A) this;
  }
  public java.lang.Boolean hasTriggeredByImage() {
    return this.triggeredByImage != null;
  }
  public io.fabric8.openshift.api.model.BuildRequestFluent.TriggeredByImageNested<A> withNewTriggeredByImage() {
    return new io.fabric8.openshift.api.model.BuildRequestFluentImpl.TriggeredByImageNestedImpl();
  }
  public io.fabric8.openshift.api.model.BuildRequestFluent.TriggeredByImageNested<A> withNewTriggeredByImageLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
    return new io.fabric8.openshift.api.model.BuildRequestFluentImpl.TriggeredByImageNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.BuildRequestFluent.TriggeredByImageNested<A> editTriggeredByImage() {
    return withNewTriggeredByImageLike(getTriggeredByImage());
  }
  public io.fabric8.openshift.api.model.BuildRequestFluent.TriggeredByImageNested<A> editOrNewTriggeredByImage() {
    return withNewTriggeredByImageLike(getTriggeredByImage() != null ? getTriggeredByImage(): new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder().build());
  }
  public io.fabric8.openshift.api.model.BuildRequestFluent.TriggeredByImageNested<A> editOrNewTriggeredByImageLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
    return withNewTriggeredByImageLike(getTriggeredByImage() != null ? getTriggeredByImage(): item);
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BuildRequestFluentImpl that = (BuildRequestFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (binary != null ? !binary.equals(that.binary) :that.binary != null) return false;
    if (dockerStrategyOptions != null ? !dockerStrategyOptions.equals(that.dockerStrategyOptions) :that.dockerStrategyOptions != null) return false;
    if (env != null ? !env.equals(that.env) :that.env != null) return false;
    if (from != null ? !from.equals(that.from) :that.from != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (lastVersion != null ? !lastVersion.equals(that.lastVersion) :that.lastVersion != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (revision != null ? !revision.equals(that.revision) :that.revision != null) return false;
    if (sourceStrategyOptions != null ? !sourceStrategyOptions.equals(that.sourceStrategyOptions) :that.sourceStrategyOptions != null) return false;
    if (triggeredBy != null ? !triggeredBy.equals(that.triggeredBy) :that.triggeredBy != null) return false;
    if (triggeredByImage != null ? !triggeredByImage.equals(that.triggeredByImage) :that.triggeredByImage != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  binary,  dockerStrategyOptions,  env,  from,  kind,  lastVersion,  metadata,  revision,  sourceStrategyOptions,  triggeredBy,  triggeredByImage,  additionalProperties,  super.hashCode());
  }
  public class BinaryNestedImpl<N> extends io.fabric8.openshift.api.model.BinaryBuildSourceFluentImpl<io.fabric8.openshift.api.model.BuildRequestFluent.BinaryNested<N>> implements io.fabric8.openshift.api.model.BuildRequestFluent.BinaryNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    BinaryNestedImpl(io.fabric8.openshift.api.model.BinaryBuildSource item) {
      this.builder = new io.fabric8.openshift.api.model.BinaryBuildSourceBuilder(this, item);
    }
    BinaryNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.BinaryBuildSourceBuilder(this);
    }
    io.fabric8.openshift.api.model.BinaryBuildSourceBuilder builder;
    public N and() {
      return (N) BuildRequestFluentImpl.this.withBinary(builder.build());
    }
    public N endBinary() {
      return and();
    }
    
  }
  public class DockerStrategyOptionsNestedImpl<N> extends io.fabric8.openshift.api.model.DockerStrategyOptionsFluentImpl<io.fabric8.openshift.api.model.BuildRequestFluent.DockerStrategyOptionsNested<N>> implements io.fabric8.openshift.api.model.BuildRequestFluent.DockerStrategyOptionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    DockerStrategyOptionsNestedImpl(io.fabric8.openshift.api.model.DockerStrategyOptions item) {
      this.builder = new io.fabric8.openshift.api.model.DockerStrategyOptionsBuilder(this, item);
    }
    DockerStrategyOptionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.DockerStrategyOptionsBuilder(this);
    }
    io.fabric8.openshift.api.model.DockerStrategyOptionsBuilder builder;
    public N and() {
      return (N) BuildRequestFluentImpl.this.withDockerStrategyOptions(builder.build());
    }
    public N endDockerStrategyOptions() {
      return and();
    }
    
  }
  public class FromNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl<io.fabric8.openshift.api.model.BuildRequestFluent.FromNested<N>> implements io.fabric8.openshift.api.model.BuildRequestFluent.FromNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    FromNestedImpl(io.fabric8.kubernetes.api.model.ObjectReference item) {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this, item);
    }
    FromNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder;
    public N and() {
      return (N) BuildRequestFluentImpl.this.withFrom(builder.build());
    }
    public N endFrom() {
      return and();
    }
    
  }
  public class MetadataNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl<io.fabric8.openshift.api.model.BuildRequestFluent.MetadataNested<N>> implements io.fabric8.openshift.api.model.BuildRequestFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    MetadataNestedImpl(io.fabric8.kubernetes.api.model.ObjectMeta item) {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ObjectMetaBuilder builder;
    public N and() {
      return (N) BuildRequestFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  public class RevisionNestedImpl<N> extends io.fabric8.openshift.api.model.SourceRevisionFluentImpl<io.fabric8.openshift.api.model.BuildRequestFluent.RevisionNested<N>> implements io.fabric8.openshift.api.model.BuildRequestFluent.RevisionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    RevisionNestedImpl(io.fabric8.openshift.api.model.SourceRevision item) {
      this.builder = new io.fabric8.openshift.api.model.SourceRevisionBuilder(this, item);
    }
    RevisionNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.SourceRevisionBuilder(this);
    }
    io.fabric8.openshift.api.model.SourceRevisionBuilder builder;
    public N and() {
      return (N) BuildRequestFluentImpl.this.withRevision(builder.build());
    }
    public N endRevision() {
      return and();
    }
    
  }
  public class SourceStrategyOptionsNestedImpl<N> extends io.fabric8.openshift.api.model.SourceStrategyOptionsFluentImpl<io.fabric8.openshift.api.model.BuildRequestFluent.SourceStrategyOptionsNested<N>> implements io.fabric8.openshift.api.model.BuildRequestFluent.SourceStrategyOptionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    SourceStrategyOptionsNestedImpl(io.fabric8.openshift.api.model.SourceStrategyOptions item) {
      this.builder = new io.fabric8.openshift.api.model.SourceStrategyOptionsBuilder(this, item);
    }
    SourceStrategyOptionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.SourceStrategyOptionsBuilder(this);
    }
    io.fabric8.openshift.api.model.SourceStrategyOptionsBuilder builder;
    public N and() {
      return (N) BuildRequestFluentImpl.this.withSourceStrategyOptions(builder.build());
    }
    public N endSourceStrategyOptions() {
      return and();
    }
    
  }
  public class TriggeredByNestedImpl<N> extends io.fabric8.openshift.api.model.BuildTriggerCauseFluentImpl<io.fabric8.openshift.api.model.BuildRequestFluent.TriggeredByNested<N>> implements io.fabric8.openshift.api.model.BuildRequestFluent.TriggeredByNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    TriggeredByNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.BuildTriggerCause item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.BuildTriggerCauseBuilder(this, item);
    }
    TriggeredByNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.BuildTriggerCauseBuilder(this);
    }
    io.fabric8.openshift.api.model.BuildTriggerCauseBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) BuildRequestFluentImpl.this.setToTriggeredBy(index,builder.build());
    }
    public N endTriggeredBy() {
      return and();
    }
    
  }
  public class TriggeredByImageNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl<io.fabric8.openshift.api.model.BuildRequestFluent.TriggeredByImageNested<N>> implements io.fabric8.openshift.api.model.BuildRequestFluent.TriggeredByImageNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    TriggeredByImageNestedImpl(io.fabric8.kubernetes.api.model.ObjectReference item) {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this, item);
    }
    TriggeredByImageNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder;
    public N and() {
      return (N) BuildRequestFluentImpl.this.withTriggeredByImage(builder.build());
    }
    public N endTriggeredByImage() {
      return and();
    }
    
  }
  
}