package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class APIServerListBuilder extends io.fabric8.openshift.api.model.APIServerListFluentImpl<io.fabric8.openshift.api.model.APIServerListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.APIServerList,io.fabric8.openshift.api.model.APIServerListBuilder> {

    io.fabric8.openshift.api.model.APIServerListFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public APIServerListBuilder() {
        this(true);
    }

    public APIServerListBuilder(java.lang.Boolean validationEnabled) {
        this(new APIServerList(), validationEnabled);
    }

    public APIServerListBuilder(io.fabric8.openshift.api.model.APIServerListFluent<?> fluent) {
        this(fluent, true);
    }

    public APIServerListBuilder(io.fabric8.openshift.api.model.APIServerListFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new APIServerList(), validationEnabled);
    }

    public APIServerListBuilder(io.fabric8.openshift.api.model.APIServerListFluent<?> fluent,io.fabric8.openshift.api.model.APIServerList instance) {
        this(fluent, instance, true);
    }

    public APIServerListBuilder(io.fabric8.openshift.api.model.APIServerListFluent<?> fluent,io.fabric8.openshift.api.model.APIServerList instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public APIServerListBuilder(io.fabric8.openshift.api.model.APIServerList instance) {
        this(instance,true);
    }

    public APIServerListBuilder(io.fabric8.openshift.api.model.APIServerList instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.APIServerList build() {
        APIServerList buildable = new APIServerList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        APIServerListBuilder that = (APIServerListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
