package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class APIServerServingCertsBuilder extends io.fabric8.openshift.api.model.APIServerServingCertsFluentImpl<io.fabric8.openshift.api.model.APIServerServingCertsBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.APIServerServingCerts,io.fabric8.openshift.api.model.APIServerServingCertsBuilder> {

    io.fabric8.openshift.api.model.APIServerServingCertsFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public APIServerServingCertsBuilder() {
        this(true);
    }

    public APIServerServingCertsBuilder(java.lang.Boolean validationEnabled) {
        this(new APIServerServingCerts(), validationEnabled);
    }

    public APIServerServingCertsBuilder(io.fabric8.openshift.api.model.APIServerServingCertsFluent<?> fluent) {
        this(fluent, true);
    }

    public APIServerServingCertsBuilder(io.fabric8.openshift.api.model.APIServerServingCertsFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new APIServerServingCerts(), validationEnabled);
    }

    public APIServerServingCertsBuilder(io.fabric8.openshift.api.model.APIServerServingCertsFluent<?> fluent,io.fabric8.openshift.api.model.APIServerServingCerts instance) {
        this(fluent, instance, true);
    }

    public APIServerServingCertsBuilder(io.fabric8.openshift.api.model.APIServerServingCertsFluent<?> fluent,io.fabric8.openshift.api.model.APIServerServingCerts instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withNamedCertificates(instance.getNamedCertificates()); 
        this.validationEnabled = validationEnabled; 
    }

    public APIServerServingCertsBuilder(io.fabric8.openshift.api.model.APIServerServingCerts instance) {
        this(instance,true);
    }

    public APIServerServingCertsBuilder(io.fabric8.openshift.api.model.APIServerServingCerts instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withNamedCertificates(instance.getNamedCertificates()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.APIServerServingCerts build() {
        APIServerServingCerts buildable = new APIServerServingCerts(fluent.getNamedCertificates());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        APIServerServingCertsBuilder that = (APIServerServingCertsBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
