package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class BuildStatusBuilder extends io.fabric8.openshift.api.model.BuildStatusFluentImpl<io.fabric8.openshift.api.model.BuildStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.BuildStatus,io.fabric8.openshift.api.model.BuildStatusBuilder> {

    io.fabric8.openshift.api.model.BuildStatusFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public BuildStatusBuilder() {
        this(true);
    }

    public BuildStatusBuilder(java.lang.Boolean validationEnabled) {
        this(new BuildStatus(), validationEnabled);
    }

    public BuildStatusBuilder(io.fabric8.openshift.api.model.BuildStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public BuildStatusBuilder(io.fabric8.openshift.api.model.BuildStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new BuildStatus(), validationEnabled);
    }

    public BuildStatusBuilder(io.fabric8.openshift.api.model.BuildStatusFluent<?> fluent,io.fabric8.openshift.api.model.BuildStatus instance) {
        this(fluent, instance, true);
    }

    public BuildStatusBuilder(io.fabric8.openshift.api.model.BuildStatusFluent<?> fluent,io.fabric8.openshift.api.model.BuildStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withCancelled(instance.getCancelled()); 
        fluent.withCompletionTimestamp(instance.getCompletionTimestamp()); 
        fluent.withConditions(instance.getConditions()); 
        fluent.withConfig(instance.getConfig()); 
        fluent.withDuration(instance.getDuration()); 
        fluent.withLogSnippet(instance.getLogSnippet()); 
        fluent.withMessage(instance.getMessage()); 
        fluent.withOutput(instance.getOutput()); 
        fluent.withOutputDockerImageReference(instance.getOutputDockerImageReference()); 
        fluent.withPhase(instance.getPhase()); 
        fluent.withReason(instance.getReason()); 
        fluent.withStages(instance.getStages()); 
        fluent.withStartTimestamp(instance.getStartTimestamp()); 
        this.validationEnabled = validationEnabled; 
    }

    public BuildStatusBuilder(io.fabric8.openshift.api.model.BuildStatus instance) {
        this(instance,true);
    }

    public BuildStatusBuilder(io.fabric8.openshift.api.model.BuildStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withCancelled(instance.getCancelled()); 
        this.withCompletionTimestamp(instance.getCompletionTimestamp()); 
        this.withConditions(instance.getConditions()); 
        this.withConfig(instance.getConfig()); 
        this.withDuration(instance.getDuration()); 
        this.withLogSnippet(instance.getLogSnippet()); 
        this.withMessage(instance.getMessage()); 
        this.withOutput(instance.getOutput()); 
        this.withOutputDockerImageReference(instance.getOutputDockerImageReference()); 
        this.withPhase(instance.getPhase()); 
        this.withReason(instance.getReason()); 
        this.withStages(instance.getStages()); 
        this.withStartTimestamp(instance.getStartTimestamp()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.BuildStatus build() {
        BuildStatus buildable = new BuildStatus(fluent.getCancelled(),fluent.getCompletionTimestamp(),fluent.getConditions(),fluent.getConfig(),fluent.getDuration(),fluent.getLogSnippet(),fluent.getMessage(),fluent.getOutput(),fluent.getOutputDockerImageReference(),fluent.getPhase(),fluent.getReason(),fluent.getStages(),fluent.getStartTimestamp());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        BuildStatusBuilder that = (BuildStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
