package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ExternalIPConfigBuilder extends io.fabric8.openshift.api.model.ExternalIPConfigFluentImpl<io.fabric8.openshift.api.model.ExternalIPConfigBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.ExternalIPConfig,io.fabric8.openshift.api.model.ExternalIPConfigBuilder> {

    io.fabric8.openshift.api.model.ExternalIPConfigFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ExternalIPConfigBuilder() {
        this(true);
    }

    public ExternalIPConfigBuilder(java.lang.Boolean validationEnabled) {
        this(new ExternalIPConfig(), validationEnabled);
    }

    public ExternalIPConfigBuilder(io.fabric8.openshift.api.model.ExternalIPConfigFluent<?> fluent) {
        this(fluent, true);
    }

    public ExternalIPConfigBuilder(io.fabric8.openshift.api.model.ExternalIPConfigFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ExternalIPConfig(), validationEnabled);
    }

    public ExternalIPConfigBuilder(io.fabric8.openshift.api.model.ExternalIPConfigFluent<?> fluent,io.fabric8.openshift.api.model.ExternalIPConfig instance) {
        this(fluent, instance, true);
    }

    public ExternalIPConfigBuilder(io.fabric8.openshift.api.model.ExternalIPConfigFluent<?> fluent,io.fabric8.openshift.api.model.ExternalIPConfig instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAutoAssignCIDRs(instance.getAutoAssignCIDRs()); 
        fluent.withPolicy(instance.getPolicy()); 
        this.validationEnabled = validationEnabled; 
    }

    public ExternalIPConfigBuilder(io.fabric8.openshift.api.model.ExternalIPConfig instance) {
        this(instance,true);
    }

    public ExternalIPConfigBuilder(io.fabric8.openshift.api.model.ExternalIPConfig instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withAutoAssignCIDRs(instance.getAutoAssignCIDRs()); 
        this.withPolicy(instance.getPolicy()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.ExternalIPConfig build() {
        ExternalIPConfig buildable = new ExternalIPConfig(fluent.getAutoAssignCIDRs(),fluent.getPolicy());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ExternalIPConfigBuilder that = (ExternalIPConfigBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
