package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class FeatureGateListBuilder extends io.fabric8.openshift.api.model.FeatureGateListFluentImpl<io.fabric8.openshift.api.model.FeatureGateListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.FeatureGateList,io.fabric8.openshift.api.model.FeatureGateListBuilder> {

    io.fabric8.openshift.api.model.FeatureGateListFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public FeatureGateListBuilder() {
        this(true);
    }

    public FeatureGateListBuilder(java.lang.Boolean validationEnabled) {
        this(new FeatureGateList(), validationEnabled);
    }

    public FeatureGateListBuilder(io.fabric8.openshift.api.model.FeatureGateListFluent<?> fluent) {
        this(fluent, true);
    }

    public FeatureGateListBuilder(io.fabric8.openshift.api.model.FeatureGateListFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new FeatureGateList(), validationEnabled);
    }

    public FeatureGateListBuilder(io.fabric8.openshift.api.model.FeatureGateListFluent<?> fluent,io.fabric8.openshift.api.model.FeatureGateList instance) {
        this(fluent, instance, true);
    }

    public FeatureGateListBuilder(io.fabric8.openshift.api.model.FeatureGateListFluent<?> fluent,io.fabric8.openshift.api.model.FeatureGateList instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public FeatureGateListBuilder(io.fabric8.openshift.api.model.FeatureGateList instance) {
        this(instance,true);
    }

    public FeatureGateListBuilder(io.fabric8.openshift.api.model.FeatureGateList instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.FeatureGateList build() {
        FeatureGateList buildable = new FeatureGateList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        FeatureGateListBuilder that = (FeatureGateListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
