package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class GitLabIdentityProviderFluentImpl<A extends io.fabric8.openshift.api.model.GitLabIdentityProviderFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.GitLabIdentityProviderFluent<A> {

    private io.fabric8.openshift.api.model.ConfigMapNameReferenceBuilder ca;
    private java.lang.String clientID;
    private io.fabric8.openshift.api.model.SecretNameReferenceBuilder clientSecret;
    private java.lang.String url;

    public GitLabIdentityProviderFluentImpl() {
    }

    public GitLabIdentityProviderFluentImpl(io.fabric8.openshift.api.model.GitLabIdentityProvider instance) {
        this.withCa(instance.getCa()); 
        this.withClientID(instance.getClientID()); 
        this.withClientSecret(instance.getClientSecret()); 
        this.withUrl(instance.getUrl()); 
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildCa instead.
     * @return The buildable object.
     */
        public io.fabric8.openshift.api.model.ConfigMapNameReference getCa() {
        return this.ca!=null?this.ca.build():null;
    }

    public io.fabric8.openshift.api.model.ConfigMapNameReference buildCa() {
        return this.ca!=null?this.ca.build():null;
    }

    public A withCa(io.fabric8.openshift.api.model.ConfigMapNameReference ca) {
        _visitables.get("ca").remove(this.ca);
        if (ca!=null){ this.ca= new io.fabric8.openshift.api.model.ConfigMapNameReferenceBuilder(ca); _visitables.get("ca").add(this.ca);} return (A) this;
    }

    public java.lang.Boolean hasCa() {
        return this.ca != null;
    }

    public A withNewCa(java.lang.String name) {
        return (A)withCa(new ConfigMapNameReference(name));
    }

    public io.fabric8.openshift.api.model.GitLabIdentityProviderFluent.CaNested<A> withNewCa() {
        return new io.fabric8.openshift.api.model.GitLabIdentityProviderFluentImpl.CaNestedImpl();
    }

    public io.fabric8.openshift.api.model.GitLabIdentityProviderFluent.CaNested<A> withNewCaLike(io.fabric8.openshift.api.model.ConfigMapNameReference item) {
        return new io.fabric8.openshift.api.model.GitLabIdentityProviderFluentImpl.CaNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.GitLabIdentityProviderFluent.CaNested<A> editCa() {
        return withNewCaLike(getCa());
    }

    public io.fabric8.openshift.api.model.GitLabIdentityProviderFluent.CaNested<A> editOrNewCa() {
        return withNewCaLike(getCa() != null ? getCa(): new io.fabric8.openshift.api.model.ConfigMapNameReferenceBuilder().build());
    }

    public io.fabric8.openshift.api.model.GitLabIdentityProviderFluent.CaNested<A> editOrNewCaLike(io.fabric8.openshift.api.model.ConfigMapNameReference item) {
        return withNewCaLike(getCa() != null ? getCa(): item);
    }

    public java.lang.String getClientID() {
        return this.clientID;
    }

    public A withClientID(java.lang.String clientID) {
        this.clientID=clientID; return (A) this;
    }

    public java.lang.Boolean hasClientID() {
        return this.clientID != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withClientID instead.
     */
        public A withNewClientID(java.lang.String arg0) {
        return (A)withClientID(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildClientSecret instead.
     * @return The buildable object.
     */
        public io.fabric8.openshift.api.model.SecretNameReference getClientSecret() {
        return this.clientSecret!=null?this.clientSecret.build():null;
    }

    public io.fabric8.openshift.api.model.SecretNameReference buildClientSecret() {
        return this.clientSecret!=null?this.clientSecret.build():null;
    }

    public A withClientSecret(io.fabric8.openshift.api.model.SecretNameReference clientSecret) {
        _visitables.get("clientSecret").remove(this.clientSecret);
        if (clientSecret!=null){ this.clientSecret= new io.fabric8.openshift.api.model.SecretNameReferenceBuilder(clientSecret); _visitables.get("clientSecret").add(this.clientSecret);} return (A) this;
    }

    public java.lang.Boolean hasClientSecret() {
        return this.clientSecret != null;
    }

    public A withNewClientSecret(java.lang.String name) {
        return (A)withClientSecret(new SecretNameReference(name));
    }

    public io.fabric8.openshift.api.model.GitLabIdentityProviderFluent.ClientSecretNested<A> withNewClientSecret() {
        return new io.fabric8.openshift.api.model.GitLabIdentityProviderFluentImpl.ClientSecretNestedImpl();
    }

    public io.fabric8.openshift.api.model.GitLabIdentityProviderFluent.ClientSecretNested<A> withNewClientSecretLike(io.fabric8.openshift.api.model.SecretNameReference item) {
        return new io.fabric8.openshift.api.model.GitLabIdentityProviderFluentImpl.ClientSecretNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.GitLabIdentityProviderFluent.ClientSecretNested<A> editClientSecret() {
        return withNewClientSecretLike(getClientSecret());
    }

    public io.fabric8.openshift.api.model.GitLabIdentityProviderFluent.ClientSecretNested<A> editOrNewClientSecret() {
        return withNewClientSecretLike(getClientSecret() != null ? getClientSecret(): new io.fabric8.openshift.api.model.SecretNameReferenceBuilder().build());
    }

    public io.fabric8.openshift.api.model.GitLabIdentityProviderFluent.ClientSecretNested<A> editOrNewClientSecretLike(io.fabric8.openshift.api.model.SecretNameReference item) {
        return withNewClientSecretLike(getClientSecret() != null ? getClientSecret(): item);
    }

    public java.lang.String getUrl() {
        return this.url;
    }

    public A withUrl(java.lang.String url) {
        this.url=url; return (A) this;
    }

    public java.lang.Boolean hasUrl() {
        return this.url != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withUrl instead.
     */
        public A withNewUrl(java.lang.String arg0) {
        return (A)withUrl(new String(arg0));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GitLabIdentityProviderFluentImpl that = (GitLabIdentityProviderFluentImpl) o;
        if (ca != null ? !ca.equals(that.ca) :that.ca != null) return false;
        if (clientID != null ? !clientID.equals(that.clientID) :that.clientID != null) return false;
        if (clientSecret != null ? !clientSecret.equals(that.clientSecret) :that.clientSecret != null) return false;
        if (url != null ? !url.equals(that.url) :that.url != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(ca,  clientID,  clientSecret,  url,  super.hashCode());
    }

    public class CaNestedImpl<N> extends io.fabric8.openshift.api.model.ConfigMapNameReferenceFluentImpl<io.fabric8.openshift.api.model.GitLabIdentityProviderFluent.CaNested<N>> implements io.fabric8.openshift.api.model.GitLabIdentityProviderFluent.CaNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.ConfigMapNameReferenceBuilder builder;

            CaNestedImpl(io.fabric8.openshift.api.model.ConfigMapNameReference item) {
                this.builder = new io.fabric8.openshift.api.model.ConfigMapNameReferenceBuilder(this, item);
                        
            }

            CaNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.ConfigMapNameReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) GitLabIdentityProviderFluentImpl.this.withCa(builder.build());
            }

            public N endCa() {
                return and();
            }
    }


    public class ClientSecretNestedImpl<N> extends io.fabric8.openshift.api.model.SecretNameReferenceFluentImpl<io.fabric8.openshift.api.model.GitLabIdentityProviderFluent.ClientSecretNested<N>> implements io.fabric8.openshift.api.model.GitLabIdentityProviderFluent.ClientSecretNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.SecretNameReferenceBuilder builder;

            ClientSecretNestedImpl(io.fabric8.openshift.api.model.SecretNameReference item) {
                this.builder = new io.fabric8.openshift.api.model.SecretNameReferenceBuilder(this, item);
                        
            }

            ClientSecretNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.SecretNameReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) GitLabIdentityProviderFluentImpl.this.withClientSecret(builder.build());
            }

            public N endClientSecret() {
                return and();
            }
    }


}
