package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class GroupListBuilder extends io.fabric8.openshift.api.model.GroupListFluentImpl<io.fabric8.openshift.api.model.GroupListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.GroupList,io.fabric8.openshift.api.model.GroupListBuilder> {

    io.fabric8.openshift.api.model.GroupListFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public GroupListBuilder() {
        this(true);
    }

    public GroupListBuilder(java.lang.Boolean validationEnabled) {
        this(new GroupList(), validationEnabled);
    }

    public GroupListBuilder(io.fabric8.openshift.api.model.GroupListFluent<?> fluent) {
        this(fluent, true);
    }

    public GroupListBuilder(io.fabric8.openshift.api.model.GroupListFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new GroupList(), validationEnabled);
    }

    public GroupListBuilder(io.fabric8.openshift.api.model.GroupListFluent<?> fluent,io.fabric8.openshift.api.model.GroupList instance) {
        this(fluent, instance, true);
    }

    public GroupListBuilder(io.fabric8.openshift.api.model.GroupListFluent<?> fluent,io.fabric8.openshift.api.model.GroupList instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public GroupListBuilder(io.fabric8.openshift.api.model.GroupList instance) {
        this(instance,true);
    }

    public GroupListBuilder(io.fabric8.openshift.api.model.GroupList instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.GroupList build() {
        GroupList buildable = new GroupList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        GroupListBuilder that = (GroupListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
