package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.lang.Object;

public class ImageImportSpecFluentImpl<A extends io.fabric8.openshift.api.model.ImageImportSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.ImageImportSpecFluent<A> {

    private io.fabric8.kubernetes.api.model.ObjectReferenceBuilder from;
    private io.fabric8.openshift.api.model.TagImportPolicyBuilder importPolicy;
    private java.lang.Boolean includeManifest;
    private io.fabric8.openshift.api.model.TagReferencePolicyBuilder referencePolicy;
    private io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder to;

    public ImageImportSpecFluentImpl() {
    }

    public ImageImportSpecFluentImpl(io.fabric8.openshift.api.model.ImageImportSpec instance) {
        this.withFrom(instance.getFrom()); 
        this.withImportPolicy(instance.getImportPolicy()); 
        this.withIncludeManifest(instance.getIncludeManifest()); 
        this.withReferencePolicy(instance.getReferencePolicy()); 
        this.withTo(instance.getTo()); 
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildFrom instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.ObjectReference getFrom() {
        return this.from!=null?this.from.build():null;
    }

    public io.fabric8.kubernetes.api.model.ObjectReference buildFrom() {
        return this.from!=null?this.from.build():null;
    }

    public A withFrom(io.fabric8.kubernetes.api.model.ObjectReference from) {
        _visitables.get("from").remove(this.from);
        if (from!=null){ this.from= new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(from); _visitables.get("from").add(this.from);} return (A) this;
    }

    public java.lang.Boolean hasFrom() {
        return this.from != null;
    }

    public io.fabric8.openshift.api.model.ImageImportSpecFluent.FromNested<A> withNewFrom() {
        return new io.fabric8.openshift.api.model.ImageImportSpecFluentImpl.FromNestedImpl();
    }

    public io.fabric8.openshift.api.model.ImageImportSpecFluent.FromNested<A> withNewFromLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
        return new io.fabric8.openshift.api.model.ImageImportSpecFluentImpl.FromNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.ImageImportSpecFluent.FromNested<A> editFrom() {
        return withNewFromLike(getFrom());
    }

    public io.fabric8.openshift.api.model.ImageImportSpecFluent.FromNested<A> editOrNewFrom() {
        return withNewFromLike(getFrom() != null ? getFrom(): new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder().build());
    }

    public io.fabric8.openshift.api.model.ImageImportSpecFluent.FromNested<A> editOrNewFromLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
        return withNewFromLike(getFrom() != null ? getFrom(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildImportPolicy instead.
     * @return The buildable object.
     */
        public io.fabric8.openshift.api.model.TagImportPolicy getImportPolicy() {
        return this.importPolicy!=null?this.importPolicy.build():null;
    }

    public io.fabric8.openshift.api.model.TagImportPolicy buildImportPolicy() {
        return this.importPolicy!=null?this.importPolicy.build():null;
    }

    public A withImportPolicy(io.fabric8.openshift.api.model.TagImportPolicy importPolicy) {
        _visitables.get("importPolicy").remove(this.importPolicy);
        if (importPolicy!=null){ this.importPolicy= new io.fabric8.openshift.api.model.TagImportPolicyBuilder(importPolicy); _visitables.get("importPolicy").add(this.importPolicy);} return (A) this;
    }

    public java.lang.Boolean hasImportPolicy() {
        return this.importPolicy != null;
    }

    public A withNewImportPolicy(java.lang.Boolean insecure,java.lang.Boolean scheduled) {
        return (A)withImportPolicy(new TagImportPolicy(insecure, scheduled));
    }

    public io.fabric8.openshift.api.model.ImageImportSpecFluent.ImportPolicyNested<A> withNewImportPolicy() {
        return new io.fabric8.openshift.api.model.ImageImportSpecFluentImpl.ImportPolicyNestedImpl();
    }

    public io.fabric8.openshift.api.model.ImageImportSpecFluent.ImportPolicyNested<A> withNewImportPolicyLike(io.fabric8.openshift.api.model.TagImportPolicy item) {
        return new io.fabric8.openshift.api.model.ImageImportSpecFluentImpl.ImportPolicyNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.ImageImportSpecFluent.ImportPolicyNested<A> editImportPolicy() {
        return withNewImportPolicyLike(getImportPolicy());
    }

    public io.fabric8.openshift.api.model.ImageImportSpecFluent.ImportPolicyNested<A> editOrNewImportPolicy() {
        return withNewImportPolicyLike(getImportPolicy() != null ? getImportPolicy(): new io.fabric8.openshift.api.model.TagImportPolicyBuilder().build());
    }

    public io.fabric8.openshift.api.model.ImageImportSpecFluent.ImportPolicyNested<A> editOrNewImportPolicyLike(io.fabric8.openshift.api.model.TagImportPolicy item) {
        return withNewImportPolicyLike(getImportPolicy() != null ? getImportPolicy(): item);
    }

    public java.lang.Boolean getIncludeManifest() {
        return this.includeManifest;
    }

    public A withIncludeManifest(java.lang.Boolean includeManifest) {
        this.includeManifest=includeManifest; return (A) this;
    }

    public java.lang.Boolean hasIncludeManifest() {
        return this.includeManifest != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildReferencePolicy instead.
     * @return The buildable object.
     */
        public io.fabric8.openshift.api.model.TagReferencePolicy getReferencePolicy() {
        return this.referencePolicy!=null?this.referencePolicy.build():null;
    }

    public io.fabric8.openshift.api.model.TagReferencePolicy buildReferencePolicy() {
        return this.referencePolicy!=null?this.referencePolicy.build():null;
    }

    public A withReferencePolicy(io.fabric8.openshift.api.model.TagReferencePolicy referencePolicy) {
        _visitables.get("referencePolicy").remove(this.referencePolicy);
        if (referencePolicy!=null){ this.referencePolicy= new io.fabric8.openshift.api.model.TagReferencePolicyBuilder(referencePolicy); _visitables.get("referencePolicy").add(this.referencePolicy);} return (A) this;
    }

    public java.lang.Boolean hasReferencePolicy() {
        return this.referencePolicy != null;
    }

    public A withNewReferencePolicy(java.lang.String type) {
        return (A)withReferencePolicy(new TagReferencePolicy(type));
    }

    public io.fabric8.openshift.api.model.ImageImportSpecFluent.ReferencePolicyNested<A> withNewReferencePolicy() {
        return new io.fabric8.openshift.api.model.ImageImportSpecFluentImpl.ReferencePolicyNestedImpl();
    }

    public io.fabric8.openshift.api.model.ImageImportSpecFluent.ReferencePolicyNested<A> withNewReferencePolicyLike(io.fabric8.openshift.api.model.TagReferencePolicy item) {
        return new io.fabric8.openshift.api.model.ImageImportSpecFluentImpl.ReferencePolicyNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.ImageImportSpecFluent.ReferencePolicyNested<A> editReferencePolicy() {
        return withNewReferencePolicyLike(getReferencePolicy());
    }

    public io.fabric8.openshift.api.model.ImageImportSpecFluent.ReferencePolicyNested<A> editOrNewReferencePolicy() {
        return withNewReferencePolicyLike(getReferencePolicy() != null ? getReferencePolicy(): new io.fabric8.openshift.api.model.TagReferencePolicyBuilder().build());
    }

    public io.fabric8.openshift.api.model.ImageImportSpecFluent.ReferencePolicyNested<A> editOrNewReferencePolicyLike(io.fabric8.openshift.api.model.TagReferencePolicy item) {
        return withNewReferencePolicyLike(getReferencePolicy() != null ? getReferencePolicy(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTo instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.LocalObjectReference getTo() {
        return this.to!=null?this.to.build():null;
    }

    public io.fabric8.kubernetes.api.model.LocalObjectReference buildTo() {
        return this.to!=null?this.to.build():null;
    }

    public A withTo(io.fabric8.kubernetes.api.model.LocalObjectReference to) {
        _visitables.get("to").remove(this.to);
        if (to!=null){ this.to= new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(to); _visitables.get("to").add(this.to);} return (A) this;
    }

    public java.lang.Boolean hasTo() {
        return this.to != null;
    }

    public A withNewTo(java.lang.String name) {
        return (A)withTo(new LocalObjectReference(name));
    }

    public io.fabric8.openshift.api.model.ImageImportSpecFluent.ToNested<A> withNewTo() {
        return new io.fabric8.openshift.api.model.ImageImportSpecFluentImpl.ToNestedImpl();
    }

    public io.fabric8.openshift.api.model.ImageImportSpecFluent.ToNested<A> withNewToLike(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
        return new io.fabric8.openshift.api.model.ImageImportSpecFluentImpl.ToNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.ImageImportSpecFluent.ToNested<A> editTo() {
        return withNewToLike(getTo());
    }

    public io.fabric8.openshift.api.model.ImageImportSpecFluent.ToNested<A> editOrNewTo() {
        return withNewToLike(getTo() != null ? getTo(): new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder().build());
    }

    public io.fabric8.openshift.api.model.ImageImportSpecFluent.ToNested<A> editOrNewToLike(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
        return withNewToLike(getTo() != null ? getTo(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ImageImportSpecFluentImpl that = (ImageImportSpecFluentImpl) o;
        if (from != null ? !from.equals(that.from) :that.from != null) return false;
        if (importPolicy != null ? !importPolicy.equals(that.importPolicy) :that.importPolicy != null) return false;
        if (includeManifest != null ? !includeManifest.equals(that.includeManifest) :that.includeManifest != null) return false;
        if (referencePolicy != null ? !referencePolicy.equals(that.referencePolicy) :that.referencePolicy != null) return false;
        if (to != null ? !to.equals(that.to) :that.to != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(from,  importPolicy,  includeManifest,  referencePolicy,  to,  super.hashCode());
    }

    public class FromNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl<io.fabric8.openshift.api.model.ImageImportSpecFluent.FromNested<N>> implements io.fabric8.openshift.api.model.ImageImportSpecFluent.FromNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder;

            FromNestedImpl(io.fabric8.kubernetes.api.model.ObjectReference item) {
                this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this, item);
                        
            }

            FromNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) ImageImportSpecFluentImpl.this.withFrom(builder.build());
            }

            public N endFrom() {
                return and();
            }
    }


    public class ImportPolicyNestedImpl<N> extends io.fabric8.openshift.api.model.TagImportPolicyFluentImpl<io.fabric8.openshift.api.model.ImageImportSpecFluent.ImportPolicyNested<N>> implements io.fabric8.openshift.api.model.ImageImportSpecFluent.ImportPolicyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.TagImportPolicyBuilder builder;

            ImportPolicyNestedImpl(io.fabric8.openshift.api.model.TagImportPolicy item) {
                this.builder = new io.fabric8.openshift.api.model.TagImportPolicyBuilder(this, item);
                        
            }

            ImportPolicyNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.TagImportPolicyBuilder(this);
                        
            }

            public N and() {
                return (N) ImageImportSpecFluentImpl.this.withImportPolicy(builder.build());
            }

            public N endImportPolicy() {
                return and();
            }
    }


    public class ReferencePolicyNestedImpl<N> extends io.fabric8.openshift.api.model.TagReferencePolicyFluentImpl<io.fabric8.openshift.api.model.ImageImportSpecFluent.ReferencePolicyNested<N>> implements io.fabric8.openshift.api.model.ImageImportSpecFluent.ReferencePolicyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.TagReferencePolicyBuilder builder;

            ReferencePolicyNestedImpl(io.fabric8.openshift.api.model.TagReferencePolicy item) {
                this.builder = new io.fabric8.openshift.api.model.TagReferencePolicyBuilder(this, item);
                        
            }

            ReferencePolicyNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.TagReferencePolicyBuilder(this);
                        
            }

            public N and() {
                return (N) ImageImportSpecFluentImpl.this.withReferencePolicy(builder.build());
            }

            public N endReferencePolicy() {
                return and();
            }
    }


    public class ToNestedImpl<N> extends io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl<io.fabric8.openshift.api.model.ImageImportSpecFluent.ToNested<N>> implements io.fabric8.openshift.api.model.ImageImportSpecFluent.ToNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder builder;

            ToNestedImpl(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
                this.builder = new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(this, item);
                        
            }

            ToNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) ImageImportSpecFluentImpl.this.withTo(builder.build());
            }

            public N endTo() {
                return and();
            }
    }


}
